/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Jul  5 21:30:32 EDT 2003 */

#include "codelet_dft.h"

/* Generated by: /homee/stevenj/cvs/fftw3.0.1/genfft/gen_twiddle -compact -variables 4 -twiddle-log3 -n 64 -name t2_64 -include t.h */

/*
 * This function contains 1154 FP additions, 660 FP multiplications,
 * (or, 880 additions, 386 multiplications, 274 fused multiply/add),
 * 382 stack variables, and 256 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: t2_64.c,v 1.2 2006/06/14 10:56:05 glass Exp $
 * $Id: t2_64.c,v 1.2 2006/06/14 10:56:05 glass Exp $
 * $Id: t2_64.c,v 1.2 2006/06/14 10:56:05 glass Exp $
 */

#include "t.h"

static const R *t2_64(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DK(KP290284677, +0.290284677254462367636192375817395274691476278);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP471396736, +0.471396736825997648556387625905254377657460319);
     DK(KP098017140, +0.098017140329560601994195563888641845861136673);
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP634393284, +0.634393284163645498215171613225493370675687095);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     int i;
     for (i = m; i > 0; i = i - 1, ri = ri + dist, ii = ii + dist, W = W + 10) {
	  E T1, Ti1, Tp, Tt, TH, TL, T6a, T6c, T4J, T4H, T1g, T91, T7W, T7m, T2O;
	  E T4j, T7P, T4P, T8y, T2w, T8t, T2Z, T8e, T48, T1z, T7s, T1I, T7t, T8p, Ten;
	  E T1Y, T7D, T2t, T7O, T7L, Te6, T3N, T8E, T7A, Te0, T4C, TeA, T8S, T9v, T65;
	  E Tfi, T9J, Taq, T6K, Tf6, Ta2, Ta5, T73, Tfc, Tad, Tag, T3z, T83, T3u, T82;
	  E T81, T84, T15, T9K, T68, T7j, T43, T9w, T4F, T8G, T5l, TeL, T9k, T9n, T6o;
	  E Tf2, T9Q, T9R, T6z, Tf3, T9T, T9W, To, Ts, T4o, T8u, T4U, T92, T5a, TeT;
	  E T8V, T8Y, T5G, TeG, T97, T9e, T27, T7X, T2T, T7E, T7b, Tai, T6T, Ta3, Tf7;
	  E Ta8, T7Q, T2H, T2c, T76, Tah, T7F, T4d, T8z, TG, TK, T69, T6b, T3b, T87;
	  E T5u, T9l, TeM, T9q, T88, T89, T3o, T86, T5P, T9f, TeH, T9a, T34, T8f, T1r;
	  E T7n, T3S, T8F, T4G, T4I;
	  T1 = ri[0];
	  Ti1 = ii[0];
	  Tp = ri[WS(ios, 32)];
	  Tt = ii[WS(ios, 32)];
	  TH = ri[WS(ios, 16)];
	  TL = ii[WS(ios, 16)];
	  T6a = ri[WS(ios, 47)];
	  T6c = ii[WS(ios, 47)];
	  T4J = ii[WS(ios, 49)];
	  T4H = ri[WS(ios, 49)];
	  {
	       E T12, T14, T1b, T1f, T1q, T1m, T1w, T1y, T1D, T1H, T1S, T1M, T1N, T1W, T2M;
	       E T2g, T2b, T29, T26, T22, T2i, T2E, T2G, T2v, T2u, T2r, T2n, T2N, T3a, T38;
	       E T3l, T3n, T3r, T3t, T33, T31, T2Y, T2W, T4g, T2S, T2Q, T3w, T3y, T3E, T3G;
	       E T3P, T3J, T3L, T3R, T4a, T4c, T47, T46, T42, T40, T4i, T6P, T6R, T6M, T6L;
	       E T6I, T6G, T6W, T6Y, T74, T75, T5I, T78, T7a, T6x, T6v, T6s, T6q, T6h, T6m;
	       E T6k, T6g, T5N, T5L, T5Z, T63, T66, T67, T5H, T54, T4D, T4A, T4y, T4n, T4l;
	       E T4E, T4X, T4Z, T4T, T4R, T4O, T4N, T58, T5s, T5q, T5x, T5z, T5C, T5E, T5n;
	       E T5m, T5j, T5h, T5d, T5e, Ta, Ty, Tf, Tw, T2, Tj, T3, Tc, T1E, T1B;
	       E T1F, T1A, T1R, T3x, T2m, T3K, T61, T1V, T60, T3I, T51, T52, T2V, T56, T5X;
	       E T3v, T55, T2X, T2q, T5W, T4w, T6E, Ta0, T8Q, Tac, T72, Tb, Tg, Th, T3e;
	       E T3f, T3h, T1a, T2x, T2B, TU, TV, TY, T1e, T2y, T2A, TC, TD, T1u, Tk;
	       E Tl, Tm, T39, T3U, T3W, T37, T3T, T3X, TQ, TR, TZ, T3c, T3d, T3i, Tx;
	       E Tz, T1t, TN, TX, T2f, T5V, Tao, T2h, T3D, T4f, T4h, T3F, T3q, T3s;
	       T12 = ri[WS(ios, 48)];
	       T14 = ii[WS(ios, 48)];
	       T1b = ri[WS(ios, 8)];
	       T1f = ii[WS(ios, 8)];
	       T1q = ii[WS(ios, 40)];
	       T1m = ri[WS(ios, 40)];
	       T1w = ri[WS(ios, 56)];
	       T1y = ii[WS(ios, 56)];
	       T1D = ri[WS(ios, 24)];
	       T1H = ii[WS(ios, 24)];
	       T1S = ri[WS(ios, 36)];
	       T1M = ri[WS(ios, 4)];
	       T1N = ii[WS(ios, 4)];
	       T1W = ii[WS(ios, 36)];
	       T2M = ri[WS(ios, 2)];
	       T2g = ri[WS(ios, 60)];
	       T2b = ii[WS(ios, 52)];
	       T29 = ri[WS(ios, 52)];
	       T26 = ii[WS(ios, 20)];
	       T22 = ri[WS(ios, 20)];
	       T2i = ii[WS(ios, 60)];
	       T2E = ri[WS(ios, 44)];
	       T2G = ii[WS(ios, 44)];
	       T2v = ii[WS(ios, 12)];
	       T2u = ri[WS(ios, 12)];
	       T2r = ii[WS(ios, 28)];
	       T2n = ri[WS(ios, 28)];
	       T2N = ii[WS(ios, 2)];
	       T3a = ii[WS(ios, 10)];
	       T38 = ri[WS(ios, 10)];
	       T3l = ri[WS(ios, 42)];
	       T3n = ii[WS(ios, 42)];
	       T3r = ri[WS(ios, 58)];
	       T3t = ii[WS(ios, 58)];
	       T33 = ii[WS(ios, 50)];
	       T31 = ri[WS(ios, 50)];
	       T2Y = ii[WS(ios, 18)];
	       T2W = ri[WS(ios, 18)];
	       T4g = ri[WS(ios, 54)];
	       T2S = ii[WS(ios, 34)];
	       T2Q = ri[WS(ios, 34)];
	       T3w = ri[WS(ios, 26)];
	       T3y = ii[WS(ios, 26)];
	       T3E = ri[WS(ios, 62)];
	       T3G = ii[WS(ios, 62)];
	       T3P = ri[WS(ios, 14)];
	       T3J = ri[WS(ios, 30)];
	       T3L = ii[WS(ios, 30)];
	       T3R = ii[WS(ios, 14)];
	       T4a = ri[WS(ios, 38)];
	       T4c = ii[WS(ios, 38)];
	       T47 = ii[WS(ios, 6)];
	       T46 = ri[WS(ios, 6)];
	       T42 = ii[WS(ios, 46)];
	       T40 = ri[WS(ios, 46)];
	       T4i = ii[WS(ios, 54)];
	       T6P = ri[WS(ios, 51)];
	       T6R = ii[WS(ios, 51)];
	       T6M = ii[WS(ios, 19)];
	       T6L = ri[WS(ios, 19)];
	       T6I = ii[WS(ios, 35)];
	       T6G = ri[WS(ios, 35)];
	       T6W = ri[WS(ios, 59)];
	       T6Y = ii[WS(ios, 59)];
	       T74 = ri[WS(ios, 11)];
	       T75 = ii[WS(ios, 11)];
	       T5I = ii[WS(ios, 13)];
	       T78 = ri[WS(ios, 43)];
	       T7a = ii[WS(ios, 43)];
	       T6x = ii[WS(ios, 23)];
	       T6v = ri[WS(ios, 23)];
	       T6s = ii[WS(ios, 55)];
	       T6q = ri[WS(ios, 55)];
	       T6h = ii[WS(ios, 7)];
	       T6m = ii[WS(ios, 39)];
	       T6k = ri[WS(ios, 39)];
	       T6g = ri[WS(ios, 7)];
	       T5N = ii[WS(ios, 45)];
	       T5L = ri[WS(ios, 45)];
	       T5Z = ri[WS(ios, 31)];
	       T63 = ii[WS(ios, 31)];
	       T66 = ri[WS(ios, 15)];
	       T67 = ii[WS(ios, 15)];
	       T5H = ri[WS(ios, 13)];
	       T54 = ri[WS(ios, 25)];
	       T4D = ri[WS(ios, 17)];
	       T4A = ii[WS(ios, 33)];
	       T4y = ri[WS(ios, 33)];
	       T4n = ii[WS(ios, 22)];
	       T4l = ri[WS(ios, 22)];
	       T4E = ii[WS(ios, 17)];
	       T4X = ri[WS(ios, 57)];
	       T4Z = ii[WS(ios, 57)];
	       T4T = ii[WS(ios, 41)];
	       T4R = ri[WS(ios, 41)];
	       T4O = ii[WS(ios, 9)];
	       T4N = ri[WS(ios, 9)];
	       T58 = ii[WS(ios, 25)];
	       T5s = ii[WS(ios, 53)];
	       T5q = ri[WS(ios, 53)];
	       T5x = ri[WS(ios, 61)];
	       T5z = ii[WS(ios, 61)];
	       T5C = ri[WS(ios, 29)];
	       T5E = ii[WS(ios, 29)];
	       T5n = ii[WS(ios, 21)];
	       T5m = ri[WS(ios, 21)];
	       T5j = ii[WS(ios, 37)];
	       T5h = ri[WS(ios, 37)];
	       T5d = ri[WS(ios, 5)];
	       T5e = ii[WS(ios, 5)];
	       {
		    E T4u, T4v, T5T, T5U, T6C, T6D, T70, T71, T4, T7, T5, T8, TO, TP, T1U;
		    E T2p, T18, T2k, T2l, T2o, TT, TS, T19, T1c, T1T, T1P, T1Q, T1d;
		    T4u = ri[WS(ios, 1)];
		    T4v = ii[WS(ios, 1)];
		    T5T = ri[WS(ios, 63)];
		    T5U = ii[WS(ios, 63)];
		    T6C = ri[WS(ios, 3)];
		    T6D = ii[WS(ios, 3)];
		    T70 = ri[WS(ios, 27)];
		    T71 = ii[WS(ios, 27)];
		    {
			 E T6, Te, T9, Td;
			 T4 = W[2];
			 T7 = W[3];
			 T5 = W[0];
			 T8 = W[1];
			 T6 = T4 * T5;
			 Te = T7 * T5;
			 T9 = T7 * T8;
			 Td = T4 * T8;
			 Ta = T6 - T9;
			 Ty = Td - Te;
			 Tf = Td + Te;
			 Tw = T6 + T9;
			 T2 = W[6];
			 Tj = W[7];
			 T3 = W[4];
			 Tc = W[5];
			 TO = T3 * T4;
			 TP = Tc * T7;
			 T1U = Tj * T3;
			 T2p = Tj * T5;
			 T18 = T3 * T5;
			 T2k = T2 * T5;
			 T2l = Tj * T8;
			 T2o = T2 * T8;
			 TT = Tc * T4;
			 TS = T3 * T7;
			 T19 = Tc * T8;
			 T1c = T3 * T8;
			 T1E = T2 * T7;
			 T1T = T2 * Tc;
			 T1B = Tj * T7;
			 T1F = Tj * T4;
			 T1P = T2 * T3;
			 T1Q = Tj * Tc;
			 T1A = T2 * T4;
			 T1d = Tc * T5;
		    }
		    T1R = T1P - T1Q;
		    T3x = T2o - T2p;
		    T2m = T2k - T2l;
		    T3K = T1E + T1F;
		    T61 = Tj * Ta;
		    T1V = T1T + T1U;
		    T60 = T2 * Tf;
		    T3I = T1A - T1B;
		    T51 = T2 * Tw;
		    T52 = Tj * Ty;
		    T2V = T1P + T1Q;
		    T56 = Tj * Tw;
		    T5X = Tj * Tf;
		    T3v = T2k + T2l;
		    T55 = T2 * Ty;
		    T2X = T1T - T1U;
		    T2q = T2o + T2p;
		    T5W = T2 * Ta;
		    T4w = FMA(T5, T4u, T8 * T4v);
		    T6E = FMA(T4, T6C, T7 * T6D);
		    Ta0 = FNMS(T7, T6C, T4 * T6D);
		    T8Q = FNMS(T8, T4u, T5 * T4v);
		    Tac = FNMS(Tj, T70, T2 * T71);
		    T72 = FMA(T2, T70, Tj * T71);
		    Tb = T3 * Ta;
		    Tg = Tc * Tf;
		    Th = Tb + Tg;
		    T3e = TS - TT;
		    T3f = Tj * T3e;
		    T3h = T2 * T3e;
		    T1a = T18 + T19;
		    T2x = T2 * T1a;
		    T2B = Tj * T1a;
		    TU = TS + TT;
		    TV = Tj * TU;
		    TY = T2 * TU;
		    T1e = T1c - T1d;
		    T2y = Tj * T1e;
		    T2A = T2 * T1e;
		    TC = T3 * Ty;
		    TD = Tc * Tw;
		    T1u = TC + TD;
		    Tk = T3 * Tf;
		    Tl = Tc * Ta;
		    Tm = Tk - Tl;
		    T39 = T1c + T1d;
		    T3U = Tj * T39;
		    T3W = T2 * T39;
		    T37 = T18 - T19;
		    T3T = T2 * T37;
		    T3X = Tj * T37;
		    TQ = TO - TP;
		    TR = T2 * TQ;
		    TZ = Tj * TQ;
		    T3c = TO + TP;
		    T3d = T2 * T3c;
		    T3i = Tj * T3c;
		    Tx = T3 * Tw;
		    Tz = Tc * Ty;
		    T1t = Tx - Tz;
		    TN = W[8];
		    TX = W[9];
		    T2f = FMA(TN, T4, TX * T7);
		    T5V = FMA(TN, T5T, TX * T5U);
		    Tao = FNMS(TX, T5T, TN * T5U);
		    T2h = FNMS(TX, T4, TN * T7);
		    T3D = FMA(TN, T5, TX * T8);
		    T4f = FMA(TN, T3, TX * Tc);
		    T4h = FNMS(TX, T3, TN * Tc);
		    T3F = FNMS(TX, T5, TN * T8);
	       }
	       T1g = FNMS(T1e, T1f, T1a * T1b);
	       T91 = FNMS(Tc, T4N, T3 * T4O);
	       T7W = FMA(Ty, T2M, Tw * T2N);
	       T7m = FMA(T1e, T1b, T1a * T1f);
	       T2O = FNMS(Ty, T2N, Tw * T2M);
	       T4j = FNMS(T4h, T4i, T4f * T4g);
	       T7P = FNMS(TU, T2u, TQ * T2v);
	       T4P = FMA(T3, T4N, Tc * T4O);
	       T8y = FMA(T3e, T46, T3c * T47);
	       T2w = FMA(TQ, T2u, TU * T2v);
	       {
		    E T1v, T1x, T1O, T1X;
		    T8t = FMA(T4h, T4g, T4f * T4i);
		    T2Z = FNMS(T2X, T2Y, T2V * T2W);
		    T8e = FMA(T2X, T2W, T2V * T2Y);
		    T48 = FNMS(T3e, T47, T3c * T46);
		    T1v = FMA(TN, T1t, TX * T1u);
		    T1x = FNMS(TX, T1t, TN * T1u);
		    T1z = FNMS(T1x, T1y, T1v * T1w);
		    T7s = FMA(T1x, T1w, T1v * T1y);
		    {
			 E T1C, T1G, T8n, T8o;
			 T1C = T1A + T1B;
			 T1G = T1E - T1F;
			 T1I = FNMS(T1G, T1H, T1C * T1D);
			 T7t = FMA(T1G, T1D, T1C * T1H);
			 T8n = FMA(T3F, T3E, T3D * T3G);
			 T8o = FNMS(T3K, T3J, T3I * T3L);
			 T8p = T8n - T8o;
			 Ten = T8n + T8o;
		    }
		    T1O = FMA(Ta, T1M, Tf * T1N);
		    T1X = FMA(T1R, T1S, T1V * T1W);
		    T1Y = T1O + T1X;
		    T7D = T1O - T1X;
		    {
			 E T2j, T2s, T7J, T7K;
			 T2j = FNMS(T2h, T2i, T2f * T2g);
			 T2s = FMA(T2m, T2n, T2q * T2r);
			 T2t = T2j + T2s;
			 T7O = T2j - T2s;
			 T7J = FMA(T2h, T2g, T2f * T2i);
			 T7K = FNMS(T2q, T2n, T2m * T2r);
			 T7L = T7J - T7K;
			 Te6 = T7J + T7K;
		    }
	       }
	       {
		    E T3H, T3M, T7y, T7z;
		    T3H = FNMS(T3F, T3G, T3D * T3E);
		    T3M = FMA(T3I, T3J, T3K * T3L);
		    T3N = T3H + T3M;
		    T8E = T3H - T3M;
		    T7y = FNMS(Tf, T1M, Ta * T1N);
		    T7z = FNMS(T1V, T1S, T1R * T1W);
		    T7A = T7y - T7z;
		    Te0 = T7y + T7z;
	       }
	       {
		    E T4B, T8R, T4x, T4z;
		    T4x = T3d + T3f;
		    T4z = T3h - T3i;
		    T4B = FNMS(T4z, T4A, T4x * T4y);
		    T8R = FMA(T4z, T4y, T4x * T4A);
		    T4C = T4w + T4B;
		    TeA = T8Q + T8R;
		    T8S = T8Q - T8R;
		    T9v = T4w - T4B;
	       }
	       {
		    E T64, Tap, T5Y, T62;
		    T5Y = T5W - T5X;
		    T62 = T60 + T61;
		    T64 = FMA(T5Y, T5Z, T62 * T63);
		    Tap = FNMS(T62, T5Z, T5Y * T63);
		    T65 = T5V + T64;
		    Tfi = Tao + Tap;
		    T9J = T5V - T64;
		    Taq = Tao - Tap;
	       }
	       {
		    E T6J, Ta1, T6F, T6H;
		    T6F = T2x + T2y;
		    T6H = T2A - T2B;
		    T6J = FNMS(T6H, T6I, T6F * T6G);
		    Ta1 = FMA(T6H, T6G, T6F * T6I);
		    T6K = T6E + T6J;
		    Tf6 = Ta0 + Ta1;
		    Ta2 = Ta0 - Ta1;
		    Ta5 = T6E - T6J;
	       }
	       {
		    E T6Z, Tab, T6V, T6X;
		    T6V = FMA(TN, Ta, TX * Tf);
		    T6X = FNMS(TX, Ta, TN * Tf);
		    T6Z = FNMS(T6X, T6Y, T6V * T6W);
		    Tab = FMA(T6X, T6W, T6V * T6Y);
		    T73 = T6Z + T72;
		    Tfc = Tab + Tac;
		    Tad = Tab - Tac;
		    Tag = T6Z - T72;
	       }
	       T3z = FNMS(T3x, T3y, T3v * T3w);
	       T83 = FMA(T3x, T3w, T3v * T3y);
	       T3q = FNMS(TX, Tm, TN * Th);
	       T3s = FMA(TN, Tm, TX * Th);
	       T3u = FMA(T3q, T3r, T3s * T3t);
	       T82 = FNMS(T3s, T3r, T3q * T3t);
	       T81 = T3u - T3z;
	       T84 = T82 - T83;
	       {
		    E TW, T10, T11, T13;
		    TW = TR + TV;
		    T10 = TY - TZ;
		    T11 = FNMS(TX, T10, TN * TW);
		    T13 = FMA(TN, T10, TX * TW);
		    T15 = FMA(T11, T12, T13 * T14);
		    T9K = FMA(T10, T66, TW * T67);
		    T68 = FNMS(T10, T67, TW * T66);
		    T7j = FNMS(T13, T12, T11 * T14);
	       }
	       {
		    E T3V, T3Y, T3Z, T41;
		    T3V = T3T + T3U;
		    T3Y = T3W - T3X;
		    T3Z = FNMS(TX, T3Y, TN * T3V);
		    T41 = FMA(TN, T3Y, TX * T3V);
		    T43 = FMA(T3Z, T40, T41 * T42);
		    T9w = FMA(T3Y, T4D, T3V * T4E);
		    T4F = FNMS(T3Y, T4E, T3V * T4D);
		    T8G = FNMS(T41, T40, T3Z * T42);
	       }
	       {
		    E T5f, T9i, T5k, T9j, T5g, T5i;
		    T5f = FNMS(Tm, T5e, Th * T5d);
		    T9i = FMA(Tm, T5d, Th * T5e);
		    T5g = T3T - T3U;
		    T5i = T3W + T3X;
		    T5k = FMA(T5g, T5h, T5i * T5j);
		    T9j = FNMS(T5i, T5h, T5g * T5j);
		    T5l = T5f + T5k;
		    TeL = T9i + T9j;
		    T9k = T9i - T9j;
		    T9n = T5f - T5k;
	       }
	       {
		    E T6i, T9O, T6n, T9P, T6j, T6l;
		    T6i = FMA(T1t, T6g, T1u * T6h);
		    T9O = FNMS(T1u, T6g, T1t * T6h);
		    T6j = TR - TV;
		    T6l = TY + TZ;
		    T6n = FMA(T6j, T6k, T6l * T6m);
		    T9P = FNMS(T6l, T6k, T6j * T6m);
		    T6o = T6i + T6n;
		    Tf2 = T9O + T9P;
		    T9Q = T9O - T9P;
		    T9R = T6i - T6n;
	       }
	       {
		    E T6t, T9U, T6y, T9V;
		    {
			 E T6p, T6r, T6u, T6w;
			 T6p = FNMS(TX, T1e, TN * T1a);
			 T6r = FMA(TN, T1e, TX * T1a);
			 T6t = FMA(T6p, T6q, T6r * T6s);
			 T9U = FNMS(T6r, T6q, T6p * T6s);
			 T6u = T5W + T5X;
			 T6w = T60 - T61;
			 T6y = FNMS(T6w, T6x, T6u * T6v);
			 T9V = FMA(T6w, T6v, T6u * T6x);
		    }
		    T6z = T6t + T6y;
		    Tf3 = T9U + T9V;
		    T9T = T6t - T6y;
		    T9W = T9U - T9V;
	       }
	       {
		    E Ti, Tn, T4k, Tq, Tr, T4m, T4Q, T4S;
		    Ti = T2 * Th;
		    Tn = Tj * Tm;
		    T4k = Ti - Tn;
		    Tq = T2 * Tm;
		    Tr = Tj * Th;
		    T4m = Tq + Tr;
		    To = Ti + Tn;
		    Ts = Tq - Tr;
		    T4o = FMA(T4k, T4l, T4m * T4n);
		    T8u = FNMS(T4m, T4l, T4k * T4n);
		    T4Q = FMA(TN, T4k, TX * T4m);
		    T4S = FNMS(TX, T4k, TN * T4m);
		    T4U = FNMS(T4S, T4T, T4Q * T4R);
		    T92 = FMA(T4S, T4R, T4Q * T4T);
	       }
	       {
		    E T50, T8W, T59, T8X;
		    {
			 E T4W, T4Y, T53, T57;
			 T4W = FNMS(TX, T3e, TN * T3c);
			 T4Y = FMA(TN, T3e, TX * T3c);
			 T50 = FMA(T4W, T4X, T4Y * T4Z);
			 T8W = FNMS(T4Y, T4X, T4W * T4Z);
			 T53 = T51 - T52;
			 T57 = T55 + T56;
			 T59 = FMA(T53, T54, T57 * T58);
			 T8X = FNMS(T57, T54, T53 * T58);
		    }
		    T5a = T50 + T59;
		    TeT = T8W + T8X;
		    T8V = T50 - T59;
		    T8Y = T8W - T8X;
	       }
	       {
		    E T5A, T9c, T5F, T9d;
		    {
			 E T5w, T5y, T5B, T5D;
			 T5w = FNMS(TX, Ty, TN * Tw);
			 T5y = FMA(TN, Ty, TX * Tw);
			 T5A = FMA(T5w, T5x, T5y * T5z);
			 T9c = FNMS(T5y, T5x, T5w * T5z);
			 T5B = T51 + T52;
			 T5D = T55 - T56;
			 T5F = FNMS(T5D, T5E, T5B * T5C);
			 T9d = FMA(T5D, T5C, T5B * T5E);
		    }
		    T5G = T5A + T5F;
		    TeG = T9c + T9d;
		    T97 = T5A - T5F;
		    T9e = T9c - T9d;
	       }
	       {
		    E T21, T2P, T25, T2R, T77, T79;
		    {
			 E T1Z, T20, T23, T24;
			 T1Z = T2 * T1t;
			 T20 = Tj * T1u;
			 T21 = T1Z + T20;
			 T2P = T1Z - T20;
			 T23 = T2 * T1u;
			 T24 = Tj * T1t;
			 T25 = T23 - T24;
			 T2R = T23 + T24;
		    }
		    T27 = FNMS(T25, T26, T21 * T22);
		    T7X = FNMS(T2R, T2Q, T2P * T2S);
		    T2T = FMA(T2P, T2Q, T2R * T2S);
		    T7E = FMA(T25, T22, T21 * T26);
		    T77 = FNMS(TX, T25, TN * T21);
		    T79 = FMA(TN, T25, TX * T21);
		    T7b = FMA(T77, T78, T79 * T7a);
		    Tai = FNMS(T79, T78, T77 * T7a);
	       }
	       {
		    E T6S, Ta7, T2D, Ta6, T2F, T6N;
		    {
			 E T6O, T6Q, T2z, T2C;
			 T6O = FMA(TN, TQ, TX * TU);
			 T6Q = FNMS(TX, TQ, TN * TU);
			 T6S = FNMS(T6Q, T6R, T6O * T6P);
			 Ta7 = FMA(T6Q, T6P, T6O * T6R);
			 T2z = T2x - T2y;
			 T2C = T2A + T2B;
			 T2D = FMA(TN, T2z, TX * T2C);
			 Ta6 = FNMS(T2C, T6L, T2z * T6M);
			 T2F = FNMS(TX, T2z, TN * T2C);
			 T6N = FMA(T2z, T6L, T2C * T6M);
		    }
		    T6T = T6N + T6S;
		    Ta3 = T6N - T6S;
		    Tf7 = Ta6 + Ta7;
		    Ta8 = Ta6 - Ta7;
		    T7Q = FMA(T2F, T2E, T2D * T2G);
		    T2H = FNMS(T2F, T2G, T2D * T2E);
	       }
	       {
		    E TA, TE, TB, TF, TJ, TI, T2a, T28, T49, T4b;
		    TA = Tx + Tz;
		    TE = TC - TD;
		    TB = T2 * TA;
		    TF = Tj * TE;
		    TJ = Tj * TA;
		    TI = T2 * TE;
		    T2a = FMA(TN, TE, TX * TA);
		    T28 = FNMS(TX, TE, TN * TA);
		    T2c = FMA(T28, T29, T2a * T2b);
		    T76 = FNMS(TE, T75, TA * T74);
		    Tah = FMA(TE, T74, TA * T75);
		    T7F = FNMS(T2a, T29, T28 * T2b);
		    T49 = TB + TF;
		    T4b = TI - TJ;
		    T4d = FNMS(T4b, T4c, T49 * T4a);
		    T8z = FMA(T4b, T4a, T49 * T4c);
		    TG = TB - TF;
		    TK = TI + TJ;
		    T69 = FMA(TN, TG, TX * TK);
		    T6b = FNMS(TX, TG, TN * TK);
	       }
	       {
		    E T5t, T9p, T3k, T9o, T3m, T5o;
		    T3b = FMA(T37, T38, T39 * T3a);
		    T87 = FNMS(T39, T38, T37 * T3a);
		    {
			 E T5p, T5r, T3g, T3j;
			 T5p = FMA(TN, T37, TX * T39);
			 T5r = FNMS(TX, T37, TN * T39);
			 T5t = FNMS(T5r, T5s, T5p * T5q);
			 T9p = FMA(T5r, T5q, T5p * T5s);
			 T3g = T3d - T3f;
			 T3j = T3h + T3i;
			 T3k = FMA(TN, T3g, TX * T3j);
			 T9o = FNMS(T3j, T5m, T3g * T5n);
			 T3m = FNMS(TX, T3g, TN * T3j);
			 T5o = FMA(T3g, T5m, T3j * T5n);
		    }
		    T5u = T5o + T5t;
		    T9l = T5o - T5t;
		    TeM = T9o + T9p;
		    T9q = T9o - T9p;
		    T88 = FMA(T3m, T3l, T3k * T3n);
		    T89 = T87 - T88;
		    T3o = FNMS(T3m, T3n, T3k * T3l);
		    T86 = T3b - T3o;
	       }
	       {
		    E T5O, T99, T1i, T1n, T1o, T1k, T30, T5J, T98, T32;
		    {
			 E T5K, T5M, T1h, T1j;
			 T5K = FNMS(TX, T2X, TN * T2V);
			 T5M = FMA(TN, T2X, TX * T2V);
			 T5O = FMA(T5K, T5L, T5M * T5N);
			 T99 = FNMS(T5M, T5L, T5K * T5N);
			 T1h = Tb - Tg;
			 T1j = Tk + Tl;
			 T1i = T2 * T1h;
			 T1n = T2 * T1j;
			 T1o = Tj * T1h;
			 T1k = Tj * T1j;
			 T30 = FMA(TN, T1h, TX * T1j);
			 T5J = FMA(T1h, T5H, T1j * T5I);
			 T98 = FNMS(T1j, T5H, T1h * T5I);
			 T32 = FNMS(TX, T1h, TN * T1j);
		    }
		    T5P = T5J + T5O;
		    T9f = T5J - T5O;
		    TeH = T98 + T99;
		    T9a = T98 - T99;
		    T34 = FNMS(T32, T33, T30 * T31);
		    T8f = FMA(T32, T31, T30 * T33);
		    {
			 E T1l, T1p, T3O, T3Q;
			 T1l = T1i - T1k;
			 T1p = T1n + T1o;
			 T1r = FMA(T1l, T1m, T1p * T1q);
			 T7n = FNMS(T1p, T1m, T1l * T1q);
			 T3O = T1i + T1k;
			 T3Q = T1n - T1o;
			 T3S = FNMS(T3Q, T3R, T3O * T3P);
			 T8F = FMA(T3Q, T3P, T3O * T3R);
			 T4G = FNMS(TX, T3Q, TN * T3O);
			 T4I = FMA(TN, T3Q, TX * T3O);
		    }
	       }
	  }
	  {
	       E T5R, TgT, TgY, ThE, T9t, Tbe, T9G, Tbb, Tcl, Tdq, Tcs, Tdn, TeP, Tg4, TeY;
	       E Tg1, T7e, Th4, ThJ, Th9, Tfp, Tg8, Tfg, Tgb, T2K, TgC, Tih, ThX, TfQ, TiL;
	       E Tea, Tiv, Tam, Tbl, TcL, Tdu, Taz, Tbi, TcE, Tdx, T7U, Tjv, Tdc, Tjh, Tb0;
	       E TjL, TbU, TiZ, T8D, Tb5, Tc8, Tdi, T8M, Tb6, Tc5, Tdh, T4r, Thz, Tex, Tfz;
	       E TfX, Tgl, TgN, Thj, T8m, TaI, Tdg, TdG, Tb4, Tbu, Tc2, TcU, T3C, Thy, Tem;
	       E Tfy, TfU, Tgk, TgI, Thi, T6B, Th1, Tfm, Tga, Th8, ThI, T9Z, Tbh, Taw, Tbk;
	       E TcI, Tdw, Tf5, Tg7, Tcx, Tdt, T5c, TgV, TeV, Tg0, TgS, ThD, TeE, Tg3, T96;
	       E Tbd, Tce, Tdp, Tcp, Tdm, T9D, Tba, T1L, Tgz, Ti4, Tii, Tiy, TiM, TdZ, TfN;
	       E T7x, TaX, Tj4, Tji, Tjy, TjM, TbN, Td9;
	       {
		    E T5v, T5Q, TgW, TgX;
		    T5v = T5l + T5u;
		    T5Q = T5G + T5P;
		    T5R = T5v + T5Q;
		    TgT = T5Q - T5v;
		    TgW = TeL + TeM;
		    TgX = TeG + TeH;
		    TgY = TgW - TgX;
		    ThE = TgW + TgX;
	       }
	       {
		    E T9h, T9F, T9s, T9E;
		    {
			 E T9b, T9g, T9m, T9r;
			 T9b = T97 - T9a;
			 T9g = T9e + T9f;
			 T9h = FNMS(KP923879532, T9g, KP382683432 * T9b);
			 T9F = FMA(KP382683432, T9g, KP923879532 * T9b);
			 T9m = T9k + T9l;
			 T9r = T9n - T9q;
			 T9s = FMA(KP923879532, T9m, KP382683432 * T9r);
			 T9E = FNMS(KP923879532, T9r, KP382683432 * T9m);
		    }
		    T9t = T9h - T9s;
		    Tbe = T9E + T9F;
		    T9G = T9E - T9F;
		    Tbb = T9s + T9h;
	       }
	       {
		    E Tch, Tcr, Tck, Tcq;
		    {
			 E Tcf, Tcg, Tci, Tcj;
			 Tcf = T97 + T9a;
			 Tcg = T9e - T9f;
			 Tch = FNMS(KP382683432, Tcg, KP923879532 * Tcf);
			 Tcr = FMA(KP923879532, Tcg, KP382683432 * Tcf);
			 Tci = T9k - T9l;
			 Tcj = T9n + T9q;
			 Tck = FMA(KP382683432, Tci, KP923879532 * Tcj);
			 Tcq = FNMS(KP382683432, Tcj, KP923879532 * Tci);
		    }
		    Tcl = Tch - Tck;
		    Tdq = Tcq + Tcr;
		    Tcs = Tcq - Tcr;
		    Tdn = Tck + Tch;
	       }
	       {
		    E TeJ, TeX, TeO, TeW;
		    {
			 E TeF, TeI, TeK, TeN;
			 TeF = T5G - T5P;
			 TeI = TeG - TeH;
			 TeJ = TeF - TeI;
			 TeX = TeF + TeI;
			 TeK = T5l - T5u;
			 TeN = TeL - TeM;
			 TeO = TeK + TeN;
			 TeW = TeN - TeK;
		    }
		    TeP = KP707106781 * (TeJ - TeO);
		    Tg4 = KP707106781 * (TeW + TeX);
		    TeY = KP707106781 * (TeW - TeX);
		    Tg1 = KP707106781 * (TeO + TeJ);
	       }
	       {
		    E T6U, Th2, T7d, Tfb, Tfe, Th3, Tfa, Tfo, Tfn, Tff;
		    T6U = T6K + T6T;
		    Th2 = Tf6 + Tf7;
		    {
			 E T7c, Tfd, Tf8, Tf9;
			 T7c = T76 + T7b;
			 T7d = T73 + T7c;
			 Tfb = T73 - T7c;
			 Tfd = Tah + Tai;
			 Tfe = Tfc - Tfd;
			 Th3 = Tfc + Tfd;
			 Tf8 = Tf6 - Tf7;
			 Tf9 = T6K - T6T;
			 Tfa = Tf8 - Tf9;
			 Tfo = Tf9 + Tf8;
		    }
		    T7e = T6U + T7d;
		    Th4 = Th2 - Th3;
		    ThJ = Th2 + Th3;
		    Th9 = T7d - T6U;
		    Tfn = Tfb - Tfe;
		    Tfp = KP707106781 * (Tfn - Tfo);
		    Tg8 = KP707106781 * (Tfo + Tfn);
		    Tff = Tfb + Tfe;
		    Tfg = KP707106781 * (Tfa - Tff);
		    Tgb = KP707106781 * (Tfa + Tff);
	       }
	       {
		    E T2e, Te3, Te8, TgB, T2J, Te5, Te2, TgA;
		    {
			 E T2d, Te7, T2I, Te1;
			 T2d = T27 + T2c;
			 T2e = T1Y + T2d;
			 Te3 = T1Y - T2d;
			 Te7 = T7P + T7Q;
			 Te8 = Te6 - Te7;
			 TgB = Te6 + Te7;
			 T2I = T2w + T2H;
			 T2J = T2t + T2I;
			 Te5 = T2t - T2I;
			 Te1 = T7E + T7F;
			 Te2 = Te0 - Te1;
			 TgA = Te0 + Te1;
		    }
		    T2K = T2e + T2J;
		    TgC = TgA - TgB;
		    Tih = T2J - T2e;
		    ThX = TgA + TgB;
		    {
			 E TfO, TfP, Te4, Te9;
			 TfO = Te3 + Te2;
			 TfP = Te5 - Te8;
			 TfQ = KP707106781 * (TfO + TfP);
			 TiL = KP707106781 * (TfP - TfO);
			 Te4 = Te2 - Te3;
			 Te9 = Te5 + Te8;
			 Tea = KP707106781 * (Te4 - Te9);
			 Tiv = KP707106781 * (Te4 + Te9);
		    }
	       }
	       {
		    E Taf, TcB, Tak, TcC, Taa, Tay, TcA, TcK, Tae, Taj;
		    Tae = T76 - T7b;
		    Taf = Tad + Tae;
		    TcB = Tad - Tae;
		    Taj = Tah - Tai;
		    Tak = Tag - Taj;
		    TcC = Tag + Taj;
		    {
			 E Ta4, Ta9, Tcy, Tcz;
			 Ta4 = Ta2 + Ta3;
			 Ta9 = Ta5 - Ta8;
			 Taa = FNMS(KP923879532, Ta9, KP382683432 * Ta4);
			 Tay = FMA(KP923879532, Ta4, KP382683432 * Ta9);
			 Tcy = Ta2 - Ta3;
			 Tcz = Ta5 + Ta8;
			 TcA = FNMS(KP382683432, Tcz, KP923879532 * Tcy);
			 TcK = FMA(KP382683432, Tcy, KP923879532 * Tcz);
		    }
		    {
			 E Tal, TcJ, Tax, TcD;
			 Tal = FMA(KP382683432, Taf, KP923879532 * Tak);
			 Tam = Taa - Tal;
			 Tbl = Taa + Tal;
			 TcJ = FNMS(KP382683432, TcB, KP923879532 * TcC);
			 TcL = TcJ - TcK;
			 Tdu = TcK + TcJ;
			 Tax = FNMS(KP923879532, Taf, KP382683432 * Tak);
			 Taz = Tax - Tay;
			 Tbi = Tay + Tax;
			 TcD = FMA(KP923879532, TcB, KP382683432 * TcC);
			 TcE = TcA - TcD;
			 Tdx = TcA + TcD;
		    }
	       }
	       {
		    E T7C, TbO, T7S, TbS, T7H, TbP, T7N, TbR;
		    {
			 E T7B, T7R, T7G, T7M;
			 T7B = T27 - T2c;
			 T7C = T7A + T7B;
			 TbO = T7A - T7B;
			 T7R = T7P - T7Q;
			 T7S = T7O - T7R;
			 TbS = T7O + T7R;
			 T7G = T7E - T7F;
			 T7H = T7D - T7G;
			 TbP = T7D + T7G;
			 T7M = T2w - T2H;
			 T7N = T7L + T7M;
			 TbR = T7L - T7M;
		    }
		    {
			 E T7I, T7T, Tda, Tdb;
			 T7I = FNMS(KP923879532, T7H, KP382683432 * T7C);
			 T7T = FMA(KP382683432, T7N, KP923879532 * T7S);
			 T7U = T7I - T7T;
			 Tjv = T7I + T7T;
			 Tda = FMA(KP382683432, TbO, KP923879532 * TbP);
			 Tdb = FNMS(KP382683432, TbR, KP923879532 * TbS);
			 Tdc = Tda + Tdb;
			 Tjh = Tdb - Tda;
		    }
		    {
			 E TaY, TaZ, TbQ, TbT;
			 TaY = FMA(KP923879532, T7C, KP382683432 * T7H);
			 TaZ = FNMS(KP923879532, T7N, KP382683432 * T7S);
			 Tb0 = TaY + TaZ;
			 TjL = TaZ - TaY;
			 TbQ = FNMS(KP382683432, TbP, KP923879532 * TbO);
			 TbT = FMA(KP923879532, TbR, KP382683432 * TbS);
			 TbU = TbQ - TbT;
			 TiZ = TbQ + TbT;
		    }
	       }
	       {
		    E T8r, Tc6, T8I, Tc3, T8w, T8K, T8B, T8J, T8q, T8H;
		    T8q = T3S - T43;
		    T8r = T8p + T8q;
		    Tc6 = T8p - T8q;
		    T8H = T8F - T8G;
		    T8I = T8E - T8H;
		    Tc3 = T8E + T8H;
		    {
			 E T8s, T8v, T8x, T8A;
			 T8s = T4j - T4o;
			 T8v = T8t - T8u;
			 T8w = T8s - T8v;
			 T8K = T8s + T8v;
			 T8x = T48 - T4d;
			 T8A = T8y - T8z;
			 T8B = T8x + T8A;
			 T8J = T8A - T8x;
		    }
		    {
			 E T8C, Tc7, T8L, Tc4;
			 T8C = KP707106781 * (T8w - T8B);
			 T8D = T8r - T8C;
			 Tb5 = T8r + T8C;
			 Tc7 = KP707106781 * (T8J + T8K);
			 Tc8 = Tc6 - Tc7;
			 Tdi = Tc6 + Tc7;
			 T8L = KP707106781 * (T8J - T8K);
			 T8M = T8I - T8L;
			 Tb6 = T8I + T8L;
			 Tc4 = KP707106781 * (T8B + T8w);
			 Tc5 = Tc3 - Tc4;
			 Tdh = Tc3 + Tc4;
		    }
	       }
	       {
		    E T45, Tes, Tep, TgK, T4q, Teq, Tev, TgL, T44, Teo, Ter, Tew;
		    T44 = T3S + T43;
		    T45 = T3N + T44;
		    Tes = T3N - T44;
		    Teo = T8F + T8G;
		    Tep = Ten - Teo;
		    TgK = Ten + Teo;
		    {
			 E T4e, T4p, Tet, Teu;
			 T4e = T48 + T4d;
			 T4p = T4j + T4o;
			 T4q = T4e + T4p;
			 Teq = T4p - T4e;
			 Tet = T8y + T8z;
			 Teu = T8t + T8u;
			 Tev = Tet - Teu;
			 TgL = Tet + Teu;
		    }
		    T4r = T45 + T4q;
		    Thz = TgK + TgL;
		    Ter = Tep - Teq;
		    Tew = Tes - Tev;
		    Tex = FMA(KP382683432, Ter, KP923879532 * Tew);
		    Tfz = FNMS(KP923879532, Ter, KP382683432 * Tew);
		    {
			 E TfV, TfW, TgJ, TgM;
			 TfV = Tep + Teq;
			 TfW = Tes + Tev;
			 TfX = FMA(KP923879532, TfV, KP382683432 * TfW);
			 Tgl = FNMS(KP382683432, TfV, KP923879532 * TfW);
			 TgJ = T45 - T4q;
			 TgM = TgK - TgL;
			 TgN = TgJ + TgM;
			 Thj = TgJ - TgM;
		    }
	       }
	       {
		    E T80, TbW, T8k, TbX, T8b, Tc0, T8h, TbZ;
		    {
			 E T7Y, T7Z, T8i, T8j;
			 T7Y = T7W - T7X;
			 T7Z = T2Z - T34;
			 T80 = T7Y + T7Z;
			 TbW = T7Y - T7Z;
			 T8i = T89 - T86;
			 T8j = T81 + T84;
			 T8k = KP707106781 * (T8i - T8j);
			 TbX = KP707106781 * (T8i + T8j);
		    }
		    {
			 E T85, T8a, T8d, T8g;
			 T85 = T81 - T84;
			 T8a = T86 + T89;
			 T8b = KP707106781 * (T85 - T8a);
			 Tc0 = KP707106781 * (T8a + T85);
			 T8d = T2O - T2T;
			 T8g = T8e - T8f;
			 T8h = T8d - T8g;
			 TbZ = T8d + T8g;
		    }
		    {
			 E T8c, T8l, Tde, Tdf;
			 T8c = T80 - T8b;
			 T8l = T8h - T8k;
			 T8m = FNMS(KP980785280, T8l, KP195090322 * T8c);
			 TaI = FMA(KP980785280, T8c, KP195090322 * T8l);
			 Tde = TbW + TbX;
			 Tdf = TbZ + Tc0;
			 Tdg = FNMS(KP195090322, Tdf, KP980785280 * Tde);
			 TdG = FMA(KP980785280, Tdf, KP195090322 * Tde);
		    }
		    {
			 E Tb2, Tb3, TbY, Tc1;
			 Tb2 = T80 + T8b;
			 Tb3 = T8h + T8k;
			 Tb4 = FNMS(KP555570233, Tb3, KP831469612 * Tb2);
			 Tbu = FMA(KP555570233, Tb2, KP831469612 * Tb3);
			 TbY = TbW - TbX;
			 Tc1 = TbZ - Tc0;
			 Tc2 = FNMS(KP831469612, Tc1, KP555570233 * TbY);
			 TcU = FMA(KP555570233, Tc1, KP831469612 * TbY);
		    }
	       }
	       {
		    E T36, Teh, Tek, TgF, T3B, Tef, Tee, TgE, Teg, Tel;
		    {
			 E T2U, T35, Tei, Tej;
			 T2U = T2O + T2T;
			 T35 = T2Z + T34;
			 T36 = T2U + T35;
			 Teh = T2U - T35;
			 Tei = T87 + T88;
			 Tej = T82 + T83;
			 Tek = Tei - Tej;
			 TgF = Tei + Tej;
		    }
		    {
			 E T3p, T3A, Tec, Ted;
			 T3p = T3b + T3o;
			 T3A = T3u + T3z;
			 T3B = T3p + T3A;
			 Tef = T3A - T3p;
			 Tec = T7W + T7X;
			 Ted = T8e + T8f;
			 Tee = Tec - Ted;
			 TgE = Tec + Ted;
		    }
		    T3C = T36 + T3B;
		    Thy = TgE + TgF;
		    Teg = Tee - Tef;
		    Tel = Teh - Tek;
		    Tem = FNMS(KP923879532, Tel, KP382683432 * Teg);
		    Tfy = FMA(KP923879532, Teg, KP382683432 * Tel);
		    {
			 E TfS, TfT, TgG, TgH;
			 TfS = Tee + Tef;
			 TfT = Teh + Tek;
			 TfU = FNMS(KP382683432, TfT, KP923879532 * TfS);
			 Tgk = FMA(KP382683432, TfS, KP923879532 * TfT);
			 TgG = TgE - TgF;
			 TgH = T36 - T3B;
			 TgI = TgG - TgH;
			 Thi = TgH + TgG;
		    }
	       }
	       {
		    E T6A, Tfl, Th7, Tf4, T6e, Tar, T9Y, TcH, Tav, Tcw, T9M, Tfj;
		    T6A = T6o + T6z;
		    Tfl = T6z - T6o;
		    Th7 = Tf2 + Tf3;
		    Tf4 = Tf2 - Tf3;
		    {
			 E T6d, T9S, T9X, Tat, Tau, T9L;
			 T6d = FNMS(T6b, T6c, T69 * T6a);
			 T6e = T68 + T6d;
			 Tar = T68 - T6d;
			 T9S = T9Q - T9R;
			 T9X = T9T + T9W;
			 T9Y = KP707106781 * (T9S - T9X);
			 TcH = KP707106781 * (T9S + T9X);
			 Tat = T9T - T9W;
			 Tau = T9R + T9Q;
			 Tav = KP707106781 * (Tat - Tau);
			 Tcw = KP707106781 * (Tau + Tat);
			 T9L = FMA(T6b, T6a, T69 * T6c);
			 T9M = T9K - T9L;
			 Tfj = T9K + T9L;
		    }
		    {
			 E T6f, Tfk, Th6, T9N;
			 T6f = T65 + T6e;
			 T6B = T6f + T6A;
			 Th1 = T6f - T6A;
			 Tfk = Tfi - Tfj;
			 Tfm = Tfk - Tfl;
			 Tga = Tfk + Tfl;
			 Th6 = Tfi + Tfj;
			 Th8 = Th6 - Th7;
			 ThI = Th6 + Th7;
			 T9N = T9J - T9M;
			 T9Z = T9N - T9Y;
			 Tbh = T9N + T9Y;
		    }
		    {
			 E Tas, TcG, Tf1, Tcv;
			 Tas = Taq + Tar;
			 Taw = Tas - Tav;
			 Tbk = Tas + Tav;
			 TcG = Taq - Tar;
			 TcI = TcG - TcH;
			 Tdw = TcG + TcH;
			 Tf1 = T65 - T6e;
			 Tf5 = Tf1 - Tf4;
			 Tg7 = Tf1 + Tf4;
			 Tcv = T9J + T9M;
			 Tcx = Tcv - Tcw;
			 Tdt = Tcv + Tcw;
		    }
	       }
	       {
		    E T8Z, T9B, T5b, TeD, TeU, TgR, T94, T9A, T4L, T8T, T9y, TeB, T4V;
		    T8Z = T8V - T8Y;
		    T9B = T8V + T8Y;
		    T4V = T4P + T4U;
		    T5b = T4V + T5a;
		    TeD = T5a - T4V;
		    {
			 E TeS, T90, T93, T4K, T9x;
			 TeS = T91 + T92;
			 TeU = TeS - TeT;
			 TgR = TeS + TeT;
			 T90 = T4P - T4U;
			 T93 = T91 - T92;
			 T94 = T90 + T93;
			 T9A = T93 - T90;
			 T4K = FMA(T4G, T4H, T4I * T4J);
			 T4L = T4F + T4K;
			 T8T = T4F - T4K;
			 T9x = FNMS(T4I, T4H, T4G * T4J);
			 T9y = T9w - T9x;
			 TeB = T9w + T9x;
		    }
		    {
			 E T4M, TeR, TgQ, TeC;
			 T4M = T4C + T4L;
			 T5c = T4M + T5b;
			 TgV = T4M - T5b;
			 TeR = T4C - T4L;
			 TeV = TeR - TeU;
			 Tg0 = TeR + TeU;
			 TgQ = TeA + TeB;
			 TgS = TgQ - TgR;
			 ThD = TgQ + TgR;
			 TeC = TeA - TeB;
			 TeE = TeC - TeD;
			 Tg3 = TeC + TeD;
		    }
		    {
			 E T8U, T95, Tcc, Tcd;
			 T8U = T8S + T8T;
			 T95 = KP707106781 * (T8Z - T94);
			 T96 = T8U - T95;
			 Tbd = T8U + T95;
			 Tcc = T8S - T8T;
			 Tcd = KP707106781 * (T9A + T9B);
			 Tce = Tcc - Tcd;
			 Tdp = Tcc + Tcd;
		    }
		    {
			 E Tcn, Tco, T9z, T9C;
			 Tcn = T9v + T9y;
			 Tco = KP707106781 * (T94 + T8Z);
			 Tcp = Tcn - Tco;
			 Tdm = Tcn + Tco;
			 T9z = T9v - T9y;
			 T9C = KP707106781 * (T9A - T9B);
			 T9D = T9z - T9C;
			 Tba = T9z + T9C;
		    }
	       }
	       {
		    E Tv, T7h, TdY, ThY, Ti2, Tj1, T16, Tj2, T1K, Tiw, T7q, TbK, T7v, TbL, T7k;
		    E ThZ, T7r, T7u, T7i;
		    {
			 E Tu, TdW, TdX, Ti0, TM;
			 Tu = FNMS(Ts, Tt, To * Tp);
			 Tv = T1 + Tu;
			 T7h = T1 - Tu;
			 TdW = T7m + T7n;
			 TdX = T7s + T7t;
			 TdY = TdW - TdX;
			 ThY = TdW + TdX;
			 Ti0 = FMA(Ts, Tp, To * Tt);
			 Ti2 = Ti0 + Ti1;
			 Tj1 = Ti1 - Ti0;
			 TM = FMA(TG, TH, TK * TL);
			 T16 = TM + T15;
			 Tj2 = TM - T15;
		    }
		    {
			 E T1s, T1J, T7o, T7p;
			 T1s = T1g + T1r;
			 T1J = T1z + T1I;
			 T1K = T1s + T1J;
			 Tiw = T1J - T1s;
			 T7o = T7m - T7n;
			 T7p = T1g - T1r;
			 T7q = T7o - T7p;
			 TbK = T7p + T7o;
		    }
		    T7r = T1z - T1I;
		    T7u = T7s - T7t;
		    T7v = T7r + T7u;
		    TbL = T7r - T7u;
		    T7i = FNMS(TK, TH, TG * TL);
		    T7k = T7i - T7j;
		    ThZ = T7i + T7j;
		    {
			 E T17, Ti3, Tix, TdV;
			 T17 = Tv + T16;
			 T1L = T17 + T1K;
			 Tgz = T17 - T1K;
			 Ti3 = ThZ + Ti2;
			 Ti4 = ThY + Ti3;
			 Tii = Ti3 - ThY;
			 Tix = Ti2 - ThZ;
			 Tiy = Tiw + Tix;
			 TiM = Tix - Tiw;
			 TdV = Tv - T16;
			 TdZ = TdV - TdY;
			 TfN = TdV + TdY;
		    }
		    {
			 E T7l, T7w, Tj0, Tj3;
			 T7l = T7h - T7k;
			 T7w = KP707106781 * (T7q - T7v);
			 T7x = T7l - T7w;
			 TaX = T7l + T7w;
			 Tj0 = KP707106781 * (T7q + T7v);
			 Tj3 = Tj1 - Tj2;
			 Tj4 = Tj0 + Tj3;
			 Tji = Tj3 - Tj0;
		    }
		    {
			 E Tjw, Tjx, TbJ, TbM;
			 Tjw = KP707106781 * (TbL - TbK);
			 Tjx = Tj2 + Tj1;
			 Tjy = Tjw + Tjx;
			 TjM = Tjx - Tjw;
			 TbJ = T7h + T7k;
			 TbM = KP707106781 * (TbK + TbL);
			 TbN = TbJ - TbM;
			 Td9 = TbJ + TbM;
		    }
	       }
	       {
		    E T4t, ThR, Ti6, Ti8, T7g, Ti7, ThU, ThV;
		    {
			 E T2L, T4s, ThW, Ti5;
			 T2L = T1L + T2K;
			 T4s = T3C + T4r;
			 T4t = T2L + T4s;
			 ThR = T2L - T4s;
			 ThW = Thy + Thz;
			 Ti5 = ThX + Ti4;
			 Ti6 = ThW + Ti5;
			 Ti8 = Ti5 - ThW;
		    }
		    {
			 E T5S, T7f, ThS, ThT;
			 T5S = T5c + T5R;
			 T7f = T6B + T7e;
			 T7g = T5S + T7f;
			 Ti7 = T7f - T5S;
			 ThS = ThD + ThE;
			 ThT = ThI + ThJ;
			 ThU = ThS - ThT;
			 ThV = ThS + ThT;
		    }
		    ri[WS(ios, 32)] = T4t - T7g;
		    ii[WS(ios, 32)] = Ti6 - ThV;
		    ri[0] = T4t + T7g;
		    ii[0] = ThV + Ti6;
		    ri[WS(ios, 48)] = ThR - ThU;
		    ii[WS(ios, 48)] = Ti8 - Ti7;
		    ri[WS(ios, 16)] = ThR + ThU;
		    ii[WS(ios, 16)] = Ti7 + Ti8;
	       }
	       {
		    E ThB, ThN, Tic, Tie, ThG, ThO, ThL, ThP;
		    {
			 E Thx, ThA, Tia, Tib;
			 Thx = T1L - T2K;
			 ThA = Thy - Thz;
			 ThB = Thx + ThA;
			 ThN = Thx - ThA;
			 Tia = T4r - T3C;
			 Tib = Ti4 - ThX;
			 Tic = Tia + Tib;
			 Tie = Tib - Tia;
		    }
		    {
			 E ThC, ThF, ThH, ThK;
			 ThC = T5c - T5R;
			 ThF = ThD - ThE;
			 ThG = ThC + ThF;
			 ThO = ThF - ThC;
			 ThH = T6B - T7e;
			 ThK = ThI - ThJ;
			 ThL = ThH - ThK;
			 ThP = ThH + ThK;
		    }
		    {
			 E ThM, Ti9, ThQ, Tid;
			 ThM = KP707106781 * (ThG + ThL);
			 ri[WS(ios, 40)] = ThB - ThM;
			 ri[WS(ios, 8)] = ThB + ThM;
			 Ti9 = KP707106781 * (ThO + ThP);
			 ii[WS(ios, 8)] = Ti9 + Tic;
			 ii[WS(ios, 40)] = Tic - Ti9;
			 ThQ = KP707106781 * (ThO - ThP);
			 ri[WS(ios, 56)] = ThN - ThQ;
			 ri[WS(ios, 24)] = ThN + ThQ;
			 Tid = KP707106781 * (ThL - ThG);
			 ii[WS(ios, 24)] = Tid + Tie;
			 ii[WS(ios, 56)] = Tie - Tid;
		    }
	       }
	       {
		    E TgP, Thd, Tiq, Tis, Th0, The, Thb, Thf;
		    {
			 E TgD, TgO, Tio, Tip;
			 TgD = Tgz - TgC;
			 TgO = KP707106781 * (TgI - TgN);
			 TgP = TgD + TgO;
			 Thd = TgD - TgO;
			 Tio = KP707106781 * (Thj - Thi);
			 Tip = Tii - Tih;
			 Tiq = Tio + Tip;
			 Tis = Tip - Tio;
		    }
		    {
			 E TgU, TgZ, Th5, Tha;
			 TgU = TgS - TgT;
			 TgZ = TgV - TgY;
			 Th0 = FMA(KP923879532, TgU, KP382683432 * TgZ);
			 The = FNMS(KP923879532, TgZ, KP382683432 * TgU);
			 Th5 = Th1 - Th4;
			 Tha = Th8 - Th9;
			 Thb = FNMS(KP923879532, Tha, KP382683432 * Th5);
			 Thf = FMA(KP382683432, Tha, KP923879532 * Th5);
		    }
		    {
			 E Thc, Tin, Thg, Tir;
			 Thc = Th0 + Thb;
			 ri[WS(ios, 44)] = TgP - Thc;
			 ri[WS(ios, 12)] = TgP + Thc;
			 Tin = The + Thf;
			 ii[WS(ios, 12)] = Tin + Tiq;
			 ii[WS(ios, 44)] = Tiq - Tin;
			 Thg = The - Thf;
			 ri[WS(ios, 60)] = Thd - Thg;
			 ri[WS(ios, 28)] = Thd + Thg;
			 Tir = Thb - Th0;
			 ii[WS(ios, 28)] = Tir + Tis;
			 ii[WS(ios, 60)] = Tis - Tir;
		    }
	       }
	       {
		    E TfB, TfJ, TiO, TiQ, TfE, TfK, TfH, TfL;
		    {
			 E Tfx, TfA, TiK, TiN;
			 Tfx = TdZ + Tea;
			 TfA = Tfy + Tfz;
			 TfB = Tfx + TfA;
			 TfJ = Tfx - TfA;
			 TiK = Tem + Tex;
			 TiN = TiL + TiM;
			 TiO = TiK + TiN;
			 TiQ = TiN - TiK;
		    }
		    {
			 E TfC, TfD, TfF, TfG;
			 TfC = TeE + TeP;
			 TfD = TeV + TeY;
			 TfE = FMA(KP555570233, TfC, KP831469612 * TfD);
			 TfK = FNMS(KP555570233, TfD, KP831469612 * TfC);
			 TfF = Tf5 + Tfg;
			 TfG = Tfm + Tfp;
			 TfH = FNMS(KP555570233, TfG, KP831469612 * TfF);
			 TfL = FMA(KP831469612, TfG, KP555570233 * TfF);
		    }
		    {
			 E TfI, TiJ, TfM, TiP;
			 TfI = TfE + TfH;
			 ri[WS(ios, 38)] = TfB - TfI;
			 ri[WS(ios, 6)] = TfB + TfI;
			 TiJ = TfK + TfL;
			 ii[WS(ios, 6)] = TiJ + TiO;
			 ii[WS(ios, 38)] = TiO - TiJ;
			 TfM = TfK - TfL;
			 ri[WS(ios, 54)] = TfJ - TfM;
			 ri[WS(ios, 22)] = TfJ + TfM;
			 TiP = TfH - TfE;
			 ii[WS(ios, 22)] = TiP + TiQ;
			 ii[WS(ios, 54)] = TiQ - TiP;
		    }
	       }
	       {
		    E Thl, Tht, Tik, Tim, Tho, Thu, Thr, Thv;
		    {
			 E Thh, Thk, Tig, Tij;
			 Thh = Tgz + TgC;
			 Thk = KP707106781 * (Thi + Thj);
			 Thl = Thh + Thk;
			 Tht = Thh - Thk;
			 Tig = KP707106781 * (TgI + TgN);
			 Tij = Tih + Tii;
			 Tik = Tig + Tij;
			 Tim = Tij - Tig;
		    }
		    {
			 E Thm, Thn, Thp, Thq;
			 Thm = TgS + TgT;
			 Thn = TgV + TgY;
			 Tho = FMA(KP382683432, Thm, KP923879532 * Thn);
			 Thu = FNMS(KP382683432, Thn, KP923879532 * Thm);
			 Thp = Th1 + Th4;
			 Thq = Th8 + Th9;
			 Thr = FNMS(KP382683432, Thq, KP923879532 * Thp);
			 Thv = FMA(KP923879532, Thq, KP382683432 * Thp);
		    }
		    {
			 E Ths, Tif, Thw, Til;
			 Ths = Tho + Thr;
			 ri[WS(ios, 36)] = Thl - Ths;
			 ri[WS(ios, 4)] = Thl + Ths;
			 Tif = Thu + Thv;
			 ii[WS(ios, 4)] = Tif + Tik;
			 ii[WS(ios, 36)] = Tik - Tif;
			 Thw = Thu - Thv;
			 ri[WS(ios, 52)] = Tht - Thw;
			 ri[WS(ios, 20)] = Tht + Thw;
			 Til = Thr - Tho;
			 ii[WS(ios, 20)] = Til + Tim;
			 ii[WS(ios, 52)] = Tim - Til;
		    }
	       }
	       {
		    E Tez, Tft, TiU, TiW, Tf0, Tfu, Tfr, Tfv;
		    {
			 E Teb, Tey, TiS, TiT;
			 Teb = TdZ - Tea;
			 Tey = Tem - Tex;
			 Tez = Teb + Tey;
			 Tft = Teb - Tey;
			 TiS = Tfz - Tfy;
			 TiT = TiM - TiL;
			 TiU = TiS + TiT;
			 TiW = TiT - TiS;
		    }
		    {
			 E TeQ, TeZ, Tfh, Tfq;
			 TeQ = TeE - TeP;
			 TeZ = TeV - TeY;
			 Tf0 = FMA(KP980785280, TeQ, KP195090322 * TeZ);
			 Tfu = FNMS(KP980785280, TeZ, KP195090322 * TeQ);
			 Tfh = Tf5 - Tfg;
			 Tfq = Tfm - Tfp;
			 Tfr = FNMS(KP980785280, Tfq, KP195090322 * Tfh);
			 Tfv = FMA(KP195090322, Tfq, KP980785280 * Tfh);
		    }
		    {
			 E Tfs, TiR, Tfw, TiV;
			 Tfs = Tf0 + Tfr;
			 ri[WS(ios, 46)] = Tez - Tfs;
			 ri[WS(ios, 14)] = Tez + Tfs;
			 TiR = Tfu + Tfv;
			 ii[WS(ios, 14)] = TiR + TiU;
			 ii[WS(ios, 46)] = TiU - TiR;
			 Tfw = Tfu - Tfv;
			 ri[WS(ios, 62)] = Tft - Tfw;
			 ri[WS(ios, 30)] = Tft + Tfw;
			 TiV = Tfr - Tf0;
			 ii[WS(ios, 30)] = TiV + TiW;
			 ii[WS(ios, 62)] = TiW - TiV;
		    }
	       }
	       {
		    E TfZ, Tgf, TiG, TiI, Tg6, Tgg, Tgd, Tgh;
		    {
			 E TfR, TfY, TiE, TiF;
			 TfR = TfN - TfQ;
			 TfY = TfU - TfX;
			 TfZ = TfR + TfY;
			 Tgf = TfR - TfY;
			 TiE = Tgl - Tgk;
			 TiF = Tiy - Tiv;
			 TiG = TiE + TiF;
			 TiI = TiF - TiE;
		    }
		    {
			 E Tg2, Tg5, Tg9, Tgc;
			 Tg2 = Tg0 - Tg1;
			 Tg5 = Tg3 - Tg4;
			 Tg6 = FMA(KP555570233, Tg2, KP831469612 * Tg5);
			 Tgg = FNMS(KP831469612, Tg2, KP555570233 * Tg5);
			 Tg9 = Tg7 - Tg8;
			 Tgc = Tga - Tgb;
			 Tgd = FNMS(KP831469612, Tgc, KP555570233 * Tg9);
			 Tgh = FMA(KP831469612, Tg9, KP555570233 * Tgc);
		    }
		    {
			 E Tge, TiD, Tgi, TiH;
			 Tge = Tg6 + Tgd;
			 ri[WS(ios, 42)] = TfZ - Tge;
			 ri[WS(ios, 10)] = TfZ + Tge;
			 TiD = Tgg + Tgh;
			 ii[WS(ios, 10)] = TiD + TiG;
			 ii[WS(ios, 42)] = TiG - TiD;
			 Tgi = Tgg - Tgh;
			 ri[WS(ios, 58)] = Tgf - Tgi;
			 ri[WS(ios, 26)] = Tgf + Tgi;
			 TiH = Tgd - Tg6;
			 ii[WS(ios, 26)] = TiH + TiI;
			 ii[WS(ios, 58)] = TiI - TiH;
		    }
	       }
	       {
		    E Tgn, Tgv, TiA, TiC, Tgq, Tgw, Tgt, Tgx;
		    {
			 E Tgj, Tgm, Tiu, Tiz;
			 Tgj = TfN + TfQ;
			 Tgm = Tgk + Tgl;
			 Tgn = Tgj + Tgm;
			 Tgv = Tgj - Tgm;
			 Tiu = TfU + TfX;
			 Tiz = Tiv + Tiy;
			 TiA = Tiu + Tiz;
			 TiC = Tiz - Tiu;
		    }
		    {
			 E Tgo, Tgp, Tgr, Tgs;
			 Tgo = Tg0 + Tg1;
			 Tgp = Tg3 + Tg4;
			 Tgq = FMA(KP980785280, Tgo, KP195090322 * Tgp);
			 Tgw = FNMS(KP195090322, Tgo, KP980785280 * Tgp);
			 Tgr = Tg7 + Tg8;
			 Tgs = Tga + Tgb;
			 Tgt = FNMS(KP195090322, Tgs, KP980785280 * Tgr);
			 Tgx = FMA(KP195090322, Tgr, KP980785280 * Tgs);
		    }
		    {
			 E Tgu, Tit, Tgy, TiB;
			 Tgu = Tgq + Tgt;
			 ri[WS(ios, 34)] = Tgn - Tgu;
			 ri[WS(ios, 2)] = Tgn + Tgu;
			 Tit = Tgw + Tgx;
			 ii[WS(ios, 2)] = Tit + TiA;
			 ii[WS(ios, 34)] = TiA - Tit;
			 Tgy = Tgw - Tgx;
			 ri[WS(ios, 50)] = Tgv - Tgy;
			 ri[WS(ios, 18)] = Tgv + Tgy;
			 TiB = Tgt - Tgq;
			 ii[WS(ios, 18)] = TiB + TiC;
			 ii[WS(ios, 50)] = TiC - TiB;
		    }
	       }
	       {
		    E T7V, TjN, TjT, TaH, T8O, TjK, TaK, TjS, TaO, TaU, T9I, TaE, TaR, TaV, TaB;
		    E TaF, T8N;
		    T7V = T7x - T7U;
		    TjN = TjL + TjM;
		    TjT = TjM - TjL;
		    TaH = T7x + T7U;
		    T8N = FMA(KP195090322, T8D, KP980785280 * T8M);
		    T8O = T8m - T8N;
		    TjK = T8m + T8N;
		    {
			 E TaJ, TaM, TaN, T9u, T9H;
			 TaJ = FNMS(KP980785280, T8D, KP195090322 * T8M);
			 TaK = TaI + TaJ;
			 TjS = TaJ - TaI;
			 TaM = T96 + T9t;
			 TaN = T9D + T9G;
			 TaO = FMA(KP634393284, TaM, KP773010453 * TaN);
			 TaU = FNMS(KP634393284, TaN, KP773010453 * TaM);
			 T9u = T96 - T9t;
			 T9H = T9D - T9G;
			 T9I = FMA(KP995184726, T9u, KP098017140 * T9H);
			 TaE = FNMS(KP995184726, T9H, KP098017140 * T9u);
			 {
			      E TaP, TaQ, Tan, TaA;
			      TaP = T9Z + Tam;
			      TaQ = Taw + Taz;
			      TaR = FNMS(KP634393284, TaQ, KP773010453 * TaP);
			      TaV = FMA(KP773010453, TaQ, KP634393284 * TaP);
			      Tan = T9Z - Tam;
			      TaA = Taw - Taz;
			      TaB = FNMS(KP995184726, TaA, KP098017140 * Tan);
			      TaF = FMA(KP098017140, TaA, KP995184726 * Tan);
			 }
		    }
		    {
			 E T8P, TaC, TjR, TjU;
			 T8P = T7V + T8O;
			 TaC = T9I + TaB;
			 ri[WS(ios, 47)] = T8P - TaC;
			 ri[WS(ios, 15)] = T8P + TaC;
			 TjR = TaE + TaF;
			 TjU = TjS + TjT;
			 ii[WS(ios, 15)] = TjR + TjU;
			 ii[WS(ios, 47)] = TjU - TjR;
		    }
		    {
			 E TaD, TaG, TjV, TjW;
			 TaD = T7V - T8O;
			 TaG = TaE - TaF;
			 ri[WS(ios, 63)] = TaD - TaG;
			 ri[WS(ios, 31)] = TaD + TaG;
			 TjV = TaB - T9I;
			 TjW = TjT - TjS;
			 ii[WS(ios, 31)] = TjV + TjW;
			 ii[WS(ios, 63)] = TjW - TjV;
		    }
		    {
			 E TaL, TaS, TjJ, TjO;
			 TaL = TaH + TaK;
			 TaS = TaO + TaR;
			 ri[WS(ios, 39)] = TaL - TaS;
			 ri[WS(ios, 7)] = TaL + TaS;
			 TjJ = TaU + TaV;
			 TjO = TjK + TjN;
			 ii[WS(ios, 7)] = TjJ + TjO;
			 ii[WS(ios, 39)] = TjO - TjJ;
		    }
		    {
			 E TaT, TaW, TjP, TjQ;
			 TaT = TaH - TaK;
			 TaW = TaU - TaV;
			 ri[WS(ios, 55)] = TaT - TaW;
			 ri[WS(ios, 23)] = TaT + TaW;
			 TjP = TaR - TaO;
			 TjQ = TjN - TjK;
			 ii[WS(ios, 23)] = TjP + TjQ;
			 ii[WS(ios, 55)] = TjQ - TjP;
		    }
	       }
	       {
		    E TbV, Tjj, Tjp, TcT, Tca, Tjg, TcW, Tjo, Td0, Td6, Tcu, TcQ, Td3, Td7, TcN;
		    E TcR, Tc9;
		    TbV = TbN - TbU;
		    Tjj = Tjh + Tji;
		    Tjp = Tji - Tjh;
		    TcT = TbN + TbU;
		    Tc9 = FMA(KP831469612, Tc5, KP555570233 * Tc8);
		    Tca = Tc2 - Tc9;
		    Tjg = Tc2 + Tc9;
		    {
			 E TcV, TcY, TcZ, Tcm, Tct;
			 TcV = FNMS(KP831469612, Tc8, KP555570233 * Tc5);
			 TcW = TcU + TcV;
			 Tjo = TcV - TcU;
			 TcY = Tce + Tcl;
			 TcZ = Tcp + Tcs;
			 Td0 = FMA(KP471396736, TcY, KP881921264 * TcZ);
			 Td6 = FNMS(KP471396736, TcZ, KP881921264 * TcY);
			 Tcm = Tce - Tcl;
			 Tct = Tcp - Tcs;
			 Tcu = FMA(KP956940335, Tcm, KP290284677 * Tct);
			 TcQ = FNMS(KP956940335, Tct, KP290284677 * Tcm);
			 {
			      E Td1, Td2, TcF, TcM;
			      Td1 = Tcx + TcE;
			      Td2 = TcI + TcL;
			      Td3 = FNMS(KP471396736, Td2, KP881921264 * Td1);
			      Td7 = FMA(KP881921264, Td2, KP471396736 * Td1);
			      TcF = Tcx - TcE;
			      TcM = TcI - TcL;
			      TcN = FNMS(KP956940335, TcM, KP290284677 * TcF);
			      TcR = FMA(KP290284677, TcM, KP956940335 * TcF);
			 }
		    }
		    {
			 E Tcb, TcO, Tjn, Tjq;
			 Tcb = TbV + Tca;
			 TcO = Tcu + TcN;
			 ri[WS(ios, 45)] = Tcb - TcO;
			 ri[WS(ios, 13)] = Tcb + TcO;
			 Tjn = TcQ + TcR;
			 Tjq = Tjo + Tjp;
			 ii[WS(ios, 13)] = Tjn + Tjq;
			 ii[WS(ios, 45)] = Tjq - Tjn;
		    }
		    {
			 E TcP, TcS, Tjr, Tjs;
			 TcP = TbV - Tca;
			 TcS = TcQ - TcR;
			 ri[WS(ios, 61)] = TcP - TcS;
			 ri[WS(ios, 29)] = TcP + TcS;
			 Tjr = TcN - Tcu;
			 Tjs = Tjp - Tjo;
			 ii[WS(ios, 29)] = Tjr + Tjs;
			 ii[WS(ios, 61)] = Tjs - Tjr;
		    }
		    {
			 E TcX, Td4, Tjf, Tjk;
			 TcX = TcT + TcW;
			 Td4 = Td0 + Td3;
			 ri[WS(ios, 37)] = TcX - Td4;
			 ri[WS(ios, 5)] = TcX + Td4;
			 Tjf = Td6 + Td7;
			 Tjk = Tjg + Tjj;
			 ii[WS(ios, 5)] = Tjf + Tjk;
			 ii[WS(ios, 37)] = Tjk - Tjf;
		    }
		    {
			 E Td5, Td8, Tjl, Tjm;
			 Td5 = TcT - TcW;
			 Td8 = Td6 - Td7;
			 ri[WS(ios, 53)] = Td5 - Td8;
			 ri[WS(ios, 21)] = Td5 + Td8;
			 Tjl = Td3 - Td0;
			 Tjm = Tjj - Tjg;
			 ii[WS(ios, 21)] = Tjl + Tjm;
			 ii[WS(ios, 53)] = Tjm - Tjl;
		    }
	       }
	       {
		    E Tb1, Tjz, TjF, Tbt, Tb8, Tju, Tbw, TjE, TbA, TbG, Tbg, Tbq, TbD, TbH, Tbn;
		    E Tbr, Tb7;
		    Tb1 = TaX - Tb0;
		    Tjz = Tjv + Tjy;
		    TjF = Tjy - Tjv;
		    Tbt = TaX + Tb0;
		    Tb7 = FMA(KP831469612, Tb5, KP555570233 * Tb6);
		    Tb8 = Tb4 - Tb7;
		    Tju = Tb4 + Tb7;
		    {
			 E Tbv, Tby, Tbz, Tbc, Tbf;
			 Tbv = FNMS(KP555570233, Tb5, KP831469612 * Tb6);
			 Tbw = Tbu + Tbv;
			 TjE = Tbv - Tbu;
			 Tby = Tba + Tbb;
			 Tbz = Tbd + Tbe;
			 TbA = FMA(KP956940335, Tby, KP290284677 * Tbz);
			 TbG = FNMS(KP290284677, Tby, KP956940335 * Tbz);
			 Tbc = Tba - Tbb;
			 Tbf = Tbd - Tbe;
			 Tbg = FMA(KP471396736, Tbc, KP881921264 * Tbf);
			 Tbq = FNMS(KP881921264, Tbc, KP471396736 * Tbf);
			 {
			      E TbB, TbC, Tbj, Tbm;
			      TbB = Tbh + Tbi;
			      TbC = Tbk + Tbl;
			      TbD = FNMS(KP290284677, TbC, KP956940335 * TbB);
			      TbH = FMA(KP290284677, TbB, KP956940335 * TbC);
			      Tbj = Tbh - Tbi;
			      Tbm = Tbk - Tbl;
			      Tbn = FNMS(KP881921264, Tbm, KP471396736 * Tbj);
			      Tbr = FMA(KP881921264, Tbj, KP471396736 * Tbm);
			 }
		    }
		    {
			 E Tb9, Tbo, TjD, TjG;
			 Tb9 = Tb1 + Tb8;
			 Tbo = Tbg + Tbn;
			 ri[WS(ios, 43)] = Tb9 - Tbo;
			 ri[WS(ios, 11)] = Tb9 + Tbo;
			 TjD = Tbq + Tbr;
			 TjG = TjE + TjF;
			 ii[WS(ios, 11)] = TjD + TjG;
			 ii[WS(ios, 43)] = TjG - TjD;
		    }
		    {
			 E Tbp, Tbs, TjH, TjI;
			 Tbp = Tb1 - Tb8;
			 Tbs = Tbq - Tbr;
			 ri[WS(ios, 59)] = Tbp - Tbs;
			 ri[WS(ios, 27)] = Tbp + Tbs;
			 TjH = Tbn - Tbg;
			 TjI = TjF - TjE;
			 ii[WS(ios, 27)] = TjH + TjI;
			 ii[WS(ios, 59)] = TjI - TjH;
		    }
		    {
			 E Tbx, TbE, Tjt, TjA;
			 Tbx = Tbt + Tbw;
			 TbE = TbA + TbD;
			 ri[WS(ios, 35)] = Tbx - TbE;
			 ri[WS(ios, 3)] = Tbx + TbE;
			 Tjt = TbG + TbH;
			 TjA = Tju + Tjz;
			 ii[WS(ios, 3)] = Tjt + TjA;
			 ii[WS(ios, 35)] = TjA - Tjt;
		    }
		    {
			 E TbF, TbI, TjB, TjC;
			 TbF = Tbt - Tbw;
			 TbI = TbG - TbH;
			 ri[WS(ios, 51)] = TbF - TbI;
			 ri[WS(ios, 19)] = TbF + TbI;
			 TjB = TbD - TbA;
			 TjC = Tjz - Tju;
			 ii[WS(ios, 19)] = TjB + TjC;
			 ii[WS(ios, 51)] = TjC - TjB;
		    }
	       }
	       {
		    E Tdd, Tj5, Tjb, TdF, Tdk, TiY, TdI, Tja, TdM, TdS, Tds, TdC, TdP, TdT, Tdz;
		    E TdD, Tdj;
		    Tdd = Td9 - Tdc;
		    Tj5 = TiZ + Tj4;
		    Tjb = Tj4 - TiZ;
		    TdF = Td9 + Tdc;
		    Tdj = FMA(KP195090322, Tdh, KP980785280 * Tdi);
		    Tdk = Tdg - Tdj;
		    TiY = Tdg + Tdj;
		    {
			 E TdH, TdK, TdL, Tdo, Tdr;
			 TdH = FNMS(KP195090322, Tdi, KP980785280 * Tdh);
			 TdI = TdG + TdH;
			 Tja = TdH - TdG;
			 TdK = Tdm + Tdn;
			 TdL = Tdp + Tdq;
			 TdM = FMA(KP995184726, TdK, KP098017140 * TdL);
			 TdS = FNMS(KP098017140, TdK, KP995184726 * TdL);
			 Tdo = Tdm - Tdn;
			 Tdr = Tdp - Tdq;
			 Tds = FMA(KP634393284, Tdo, KP773010453 * Tdr);
			 TdC = FNMS(KP773010453, Tdo, KP634393284 * Tdr);
			 {
			      E TdN, TdO, Tdv, Tdy;
			      TdN = Tdt + Tdu;
			      TdO = Tdw + Tdx;
			      TdP = FNMS(KP098017140, TdO, KP995184726 * TdN);
			      TdT = FMA(KP098017140, TdN, KP995184726 * TdO);
			      Tdv = Tdt - Tdu;
			      Tdy = Tdw - Tdx;
			      Tdz = FNMS(KP773010453, Tdy, KP634393284 * Tdv);
			      TdD = FMA(KP773010453, Tdv, KP634393284 * Tdy);
			 }
		    }
		    {
			 E Tdl, TdA, Tj9, Tjc;
			 Tdl = Tdd + Tdk;
			 TdA = Tds + Tdz;
			 ri[WS(ios, 41)] = Tdl - TdA;
			 ri[WS(ios, 9)] = Tdl + TdA;
			 Tj9 = TdC + TdD;
			 Tjc = Tja + Tjb;
			 ii[WS(ios, 9)] = Tj9 + Tjc;
			 ii[WS(ios, 41)] = Tjc - Tj9;
		    }
		    {
			 E TdB, TdE, Tjd, Tje;
			 TdB = Tdd - Tdk;
			 TdE = TdC - TdD;
			 ri[WS(ios, 57)] = TdB - TdE;
			 ri[WS(ios, 25)] = TdB + TdE;
			 Tjd = Tdz - Tds;
			 Tje = Tjb - Tja;
			 ii[WS(ios, 25)] = Tjd + Tje;
			 ii[WS(ios, 57)] = Tje - Tjd;
		    }
		    {
			 E TdJ, TdQ, TiX, Tj6;
			 TdJ = TdF + TdI;
			 TdQ = TdM + TdP;
			 ri[WS(ios, 33)] = TdJ - TdQ;
			 ri[WS(ios, 1)] = TdJ + TdQ;
			 TiX = TdS + TdT;
			 Tj6 = TiY + Tj5;
			 ii[WS(ios, 1)] = TiX + Tj6;
			 ii[WS(ios, 33)] = Tj6 - TiX;
		    }
		    {
			 E TdR, TdU, Tj7, Tj8;
			 TdR = TdF - TdI;
			 TdU = TdS - TdT;
			 ri[WS(ios, 49)] = TdR - TdU;
			 ri[WS(ios, 17)] = TdR + TdU;
			 Tj7 = TdP - TdM;
			 Tj8 = Tj5 - TiY;
			 ii[WS(ios, 17)] = Tj7 + Tj8;
			 ii[WS(ios, 49)] = Tj8 - Tj7;
		    }
	       }
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_COS, 0, 1},
     {TW_SIN, 0, 1},
     {TW_COS, 0, 3},
     {TW_SIN, 0, 3},
     {TW_COS, 0, 9},
     {TW_SIN, 0, 9},
     {TW_COS, 0, 27},
     {TW_SIN, 0, 27},
     {TW_COS, 0, 63},
     {TW_SIN, 0, 63},
     {TW_NEXT, 1, 0}
};

static const ct_desc desc = { 64, "t2_64", twinstr, {880, 386, 274, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t2_64) (planner *p) {
     X(kdft_dit_register) (p, t2_64, &desc);
}
