/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Jul  5 21:44:46 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homee/stevenj/cvs/fftw3.0.1/genfft/gen_twidsq_c -simd -compact -variables 4 -n 8 -dif -name q1fv_8 -include q1f.h */

/*
 * This function contains 264 FP additions, 128 FP multiplications,
 * (or, 264 additions, 128 multiplications, 0 fused multiply/add),
 * 77 stack variables, and 128 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: q1fv_8.c,v 1.1 2005/07/26 17:36:59 glass Exp $
 * $Id: q1fv_8.c,v 1.1 2005/07/26 17:36:59 glass Exp $
 * $Id: q1fv_8.c,v 1.1 2005/07/26 17:36:59 glass Exp $
 */

#include "q1f.h"

static const R *q1fv_8(R *ri, R *ii, const R *W, stride is, stride vs, int m, int dist)
{
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     int i;
     R *x;
     x = ri;
     BEGIN_SIMD();
     for (i = 0; i < m; i = i + VL, x = x + (VL * dist), W = W + (TWVL * 14)) {
	  V T3, Tu, Tf, Tp, T1E, T25, T1Q, T20, T2b, T2C, T2n, T2x, T3M, T4d, T3Y;
	  V T48, TA, T11, TM, TW, T17, T1y, T1j, T1t, T2I, T39, T2U, T34, T3f, T3G;
	  V T3r, T3B, Ta, Tv, Tc, Ts, T1L, T26, T1N, T23, T2i, T2D, T2k, T2A, T3T;
	  V T4e, T3V, T4b, TH, T12, TJ, TZ, T1e, T1z, T1g, T1w, T2P, T3a, T2R, T37;
	  V T3m, T3H, T3o, T3E, T28, T14;
	  {
	       V T1, T2, Tn, Td, Te, To;
	       T1 = LD(&(x[0]), dist, &(x[0]));
	       T2 = LD(&(x[WS(is, 4)]), dist, &(x[0]));
	       Tn = VADD(T1, T2);
	       Td = LD(&(x[WS(is, 2)]), dist, &(x[0]));
	       Te = LD(&(x[WS(is, 6)]), dist, &(x[0]));
	       To = VADD(Td, Te);
	       T3 = VSUB(T1, T2);
	       Tu = VSUB(Tn, To);
	       Tf = VSUB(Td, Te);
	       Tp = VADD(Tn, To);
	  }
	  {
	       V T1C, T1D, T1Y, T1O, T1P, T1Z;
	       T1C = LD(&(x[WS(vs, 3)]), dist, &(x[WS(vs, 3)]));
	       T1D = LD(&(x[WS(vs, 3) + WS(is, 4)]), dist, &(x[WS(vs, 3)]));
	       T1Y = VADD(T1C, T1D);
	       T1O = LD(&(x[WS(vs, 3) + WS(is, 2)]), dist, &(x[WS(vs, 3)]));
	       T1P = LD(&(x[WS(vs, 3) + WS(is, 6)]), dist, &(x[WS(vs, 3)]));
	       T1Z = VADD(T1O, T1P);
	       T1E = VSUB(T1C, T1D);
	       T25 = VSUB(T1Y, T1Z);
	       T1Q = VSUB(T1O, T1P);
	       T20 = VADD(T1Y, T1Z);
	  }
	  {
	       V T29, T2a, T2v, T2l, T2m, T2w;
	       T29 = LD(&(x[WS(vs, 4)]), dist, &(x[WS(vs, 4)]));
	       T2a = LD(&(x[WS(vs, 4) + WS(is, 4)]), dist, &(x[WS(vs, 4)]));
	       T2v = VADD(T29, T2a);
	       T2l = LD(&(x[WS(vs, 4) + WS(is, 2)]), dist, &(x[WS(vs, 4)]));
	       T2m = LD(&(x[WS(vs, 4) + WS(is, 6)]), dist, &(x[WS(vs, 4)]));
	       T2w = VADD(T2l, T2m);
	       T2b = VSUB(T29, T2a);
	       T2C = VSUB(T2v, T2w);
	       T2n = VSUB(T2l, T2m);
	       T2x = VADD(T2v, T2w);
	  }
	  {
	       V T3K, T3L, T46, T3W, T3X, T47;
	       T3K = LD(&(x[WS(vs, 7)]), dist, &(x[WS(vs, 7)]));
	       T3L = LD(&(x[WS(vs, 7) + WS(is, 4)]), dist, &(x[WS(vs, 7)]));
	       T46 = VADD(T3K, T3L);
	       T3W = LD(&(x[WS(vs, 7) + WS(is, 2)]), dist, &(x[WS(vs, 7)]));
	       T3X = LD(&(x[WS(vs, 7) + WS(is, 6)]), dist, &(x[WS(vs, 7)]));
	       T47 = VADD(T3W, T3X);
	       T3M = VSUB(T3K, T3L);
	       T4d = VSUB(T46, T47);
	       T3Y = VSUB(T3W, T3X);
	       T48 = VADD(T46, T47);
	  }
	  {
	       V Ty, Tz, TU, TK, TL, TV;
	       Ty = LD(&(x[WS(vs, 1)]), dist, &(x[WS(vs, 1)]));
	       Tz = LD(&(x[WS(vs, 1) + WS(is, 4)]), dist, &(x[WS(vs, 1)]));
	       TU = VADD(Ty, Tz);
	       TK = LD(&(x[WS(vs, 1) + WS(is, 2)]), dist, &(x[WS(vs, 1)]));
	       TL = LD(&(x[WS(vs, 1) + WS(is, 6)]), dist, &(x[WS(vs, 1)]));
	       TV = VADD(TK, TL);
	       TA = VSUB(Ty, Tz);
	       T11 = VSUB(TU, TV);
	       TM = VSUB(TK, TL);
	       TW = VADD(TU, TV);
	  }
	  {
	       V T15, T16, T1r, T1h, T1i, T1s;
	       T15 = LD(&(x[WS(vs, 2)]), dist, &(x[WS(vs, 2)]));
	       T16 = LD(&(x[WS(vs, 2) + WS(is, 4)]), dist, &(x[WS(vs, 2)]));
	       T1r = VADD(T15, T16);
	       T1h = LD(&(x[WS(vs, 2) + WS(is, 2)]), dist, &(x[WS(vs, 2)]));
	       T1i = LD(&(x[WS(vs, 2) + WS(is, 6)]), dist, &(x[WS(vs, 2)]));
	       T1s = VADD(T1h, T1i);
	       T17 = VSUB(T15, T16);
	       T1y = VSUB(T1r, T1s);
	       T1j = VSUB(T1h, T1i);
	       T1t = VADD(T1r, T1s);
	  }
	  {
	       V T2G, T2H, T32, T2S, T2T, T33;
	       T2G = LD(&(x[WS(vs, 5)]), dist, &(x[WS(vs, 5)]));
	       T2H = LD(&(x[WS(vs, 5) + WS(is, 4)]), dist, &(x[WS(vs, 5)]));
	       T32 = VADD(T2G, T2H);
	       T2S = LD(&(x[WS(vs, 5) + WS(is, 2)]), dist, &(x[WS(vs, 5)]));
	       T2T = LD(&(x[WS(vs, 5) + WS(is, 6)]), dist, &(x[WS(vs, 5)]));
	       T33 = VADD(T2S, T2T);
	       T2I = VSUB(T2G, T2H);
	       T39 = VSUB(T32, T33);
	       T2U = VSUB(T2S, T2T);
	       T34 = VADD(T32, T33);
	  }
	  {
	       V T3d, T3e, T3z, T3p, T3q, T3A;
	       T3d = LD(&(x[WS(vs, 6)]), dist, &(x[WS(vs, 6)]));
	       T3e = LD(&(x[WS(vs, 6) + WS(is, 4)]), dist, &(x[WS(vs, 6)]));
	       T3z = VADD(T3d, T3e);
	       T3p = LD(&(x[WS(vs, 6) + WS(is, 2)]), dist, &(x[WS(vs, 6)]));
	       T3q = LD(&(x[WS(vs, 6) + WS(is, 6)]), dist, &(x[WS(vs, 6)]));
	       T3A = VADD(T3p, T3q);
	       T3f = VSUB(T3d, T3e);
	       T3G = VSUB(T3z, T3A);
	       T3r = VSUB(T3p, T3q);
	       T3B = VADD(T3z, T3A);
	  }
	  {
	       V T6, Tq, T9, Tr;
	       {
		    V T4, T5, T7, T8;
		    T4 = LD(&(x[WS(is, 1)]), dist, &(x[WS(is, 1)]));
		    T5 = LD(&(x[WS(is, 5)]), dist, &(x[WS(is, 1)]));
		    T6 = VSUB(T4, T5);
		    Tq = VADD(T4, T5);
		    T7 = LD(&(x[WS(is, 7)]), dist, &(x[WS(is, 1)]));
		    T8 = LD(&(x[WS(is, 3)]), dist, &(x[WS(is, 1)]));
		    T9 = VSUB(T7, T8);
		    Tr = VADD(T7, T8);
	       }
	       Ta = VMUL(LDK(KP707106781), VADD(T6, T9));
	       Tv = VBYI(VSUB(Tr, Tq));
	       Tc = VMUL(LDK(KP707106781), VSUB(T9, T6));
	       Ts = VADD(Tq, Tr);
	  }
	  {
	       V T1H, T21, T1K, T22;
	       {
		    V T1F, T1G, T1I, T1J;
		    T1F = LD(&(x[WS(vs, 3) + WS(is, 1)]), dist, &(x[WS(vs, 3) + WS(is, 1)]));
		    T1G = LD(&(x[WS(vs, 3) + WS(is, 5)]), dist, &(x[WS(vs, 3) + WS(is, 1)]));
		    T1H = VSUB(T1F, T1G);
		    T21 = VADD(T1F, T1G);
		    T1I = LD(&(x[WS(vs, 3) + WS(is, 7)]), dist, &(x[WS(vs, 3) + WS(is, 1)]));
		    T1J = LD(&(x[WS(vs, 3) + WS(is, 3)]), dist, &(x[WS(vs, 3) + WS(is, 1)]));
		    T1K = VSUB(T1I, T1J);
		    T22 = VADD(T1I, T1J);
	       }
	       T1L = VMUL(LDK(KP707106781), VADD(T1H, T1K));
	       T26 = VBYI(VSUB(T22, T21));
	       T1N = VMUL(LDK(KP707106781), VSUB(T1K, T1H));
	       T23 = VADD(T21, T22);
	  }
	  {
	       V T2e, T2y, T2h, T2z;
	       {
		    V T2c, T2d, T2f, T2g;
		    T2c = LD(&(x[WS(vs, 4) + WS(is, 1)]), dist, &(x[WS(vs, 4) + WS(is, 1)]));
		    T2d = LD(&(x[WS(vs, 4) + WS(is, 5)]), dist, &(x[WS(vs, 4) + WS(is, 1)]));
		    T2e = VSUB(T2c, T2d);
		    T2y = VADD(T2c, T2d);
		    T2f = LD(&(x[WS(vs, 4) + WS(is, 7)]), dist, &(x[WS(vs, 4) + WS(is, 1)]));
		    T2g = LD(&(x[WS(vs, 4) + WS(is, 3)]), dist, &(x[WS(vs, 4) + WS(is, 1)]));
		    T2h = VSUB(T2f, T2g);
		    T2z = VADD(T2f, T2g);
	       }
	       T2i = VMUL(LDK(KP707106781), VADD(T2e, T2h));
	       T2D = VBYI(VSUB(T2z, T2y));
	       T2k = VMUL(LDK(KP707106781), VSUB(T2h, T2e));
	       T2A = VADD(T2y, T2z);
	  }
	  {
	       V T3P, T49, T3S, T4a;
	       {
		    V T3N, T3O, T3Q, T3R;
		    T3N = LD(&(x[WS(vs, 7) + WS(is, 1)]), dist, &(x[WS(vs, 7) + WS(is, 1)]));
		    T3O = LD(&(x[WS(vs, 7) + WS(is, 5)]), dist, &(x[WS(vs, 7) + WS(is, 1)]));
		    T3P = VSUB(T3N, T3O);
		    T49 = VADD(T3N, T3O);
		    T3Q = LD(&(x[WS(vs, 7) + WS(is, 7)]), dist, &(x[WS(vs, 7) + WS(is, 1)]));
		    T3R = LD(&(x[WS(vs, 7) + WS(is, 3)]), dist, &(x[WS(vs, 7) + WS(is, 1)]));
		    T3S = VSUB(T3Q, T3R);
		    T4a = VADD(T3Q, T3R);
	       }
	       T3T = VMUL(LDK(KP707106781), VADD(T3P, T3S));
	       T4e = VBYI(VSUB(T4a, T49));
	       T3V = VMUL(LDK(KP707106781), VSUB(T3S, T3P));
	       T4b = VADD(T49, T4a);
	  }
	  {
	       V TD, TX, TG, TY;
	       {
		    V TB, TC, TE, TF;
		    TB = LD(&(x[WS(vs, 1) + WS(is, 1)]), dist, &(x[WS(vs, 1) + WS(is, 1)]));
		    TC = LD(&(x[WS(vs, 1) + WS(is, 5)]), dist, &(x[WS(vs, 1) + WS(is, 1)]));
		    TD = VSUB(TB, TC);
		    TX = VADD(TB, TC);
		    TE = LD(&(x[WS(vs, 1) + WS(is, 7)]), dist, &(x[WS(vs, 1) + WS(is, 1)]));
		    TF = LD(&(x[WS(vs, 1) + WS(is, 3)]), dist, &(x[WS(vs, 1) + WS(is, 1)]));
		    TG = VSUB(TE, TF);
		    TY = VADD(TE, TF);
	       }
	       TH = VMUL(LDK(KP707106781), VADD(TD, TG));
	       T12 = VBYI(VSUB(TY, TX));
	       TJ = VMUL(LDK(KP707106781), VSUB(TG, TD));
	       TZ = VADD(TX, TY);
	  }
	  {
	       V T1a, T1u, T1d, T1v;
	       {
		    V T18, T19, T1b, T1c;
		    T18 = LD(&(x[WS(vs, 2) + WS(is, 1)]), dist, &(x[WS(vs, 2) + WS(is, 1)]));
		    T19 = LD(&(x[WS(vs, 2) + WS(is, 5)]), dist, &(x[WS(vs, 2) + WS(is, 1)]));
		    T1a = VSUB(T18, T19);
		    T1u = VADD(T18, T19);
		    T1b = LD(&(x[WS(vs, 2) + WS(is, 7)]), dist, &(x[WS(vs, 2) + WS(is, 1)]));
		    T1c = LD(&(x[WS(vs, 2) + WS(is, 3)]), dist, &(x[WS(vs, 2) + WS(is, 1)]));
		    T1d = VSUB(T1b, T1c);
		    T1v = VADD(T1b, T1c);
	       }
	       T1e = VMUL(LDK(KP707106781), VADD(T1a, T1d));
	       T1z = VBYI(VSUB(T1v, T1u));
	       T1g = VMUL(LDK(KP707106781), VSUB(T1d, T1a));
	       T1w = VADD(T1u, T1v);
	  }
	  {
	       V T2L, T35, T2O, T36;
	       {
		    V T2J, T2K, T2M, T2N;
		    T2J = LD(&(x[WS(vs, 5) + WS(is, 1)]), dist, &(x[WS(vs, 5) + WS(is, 1)]));
		    T2K = LD(&(x[WS(vs, 5) + WS(is, 5)]), dist, &(x[WS(vs, 5) + WS(is, 1)]));
		    T2L = VSUB(T2J, T2K);
		    T35 = VADD(T2J, T2K);
		    T2M = LD(&(x[WS(vs, 5) + WS(is, 7)]), dist, &(x[WS(vs, 5) + WS(is, 1)]));
		    T2N = LD(&(x[WS(vs, 5) + WS(is, 3)]), dist, &(x[WS(vs, 5) + WS(is, 1)]));
		    T2O = VSUB(T2M, T2N);
		    T36 = VADD(T2M, T2N);
	       }
	       T2P = VMUL(LDK(KP707106781), VADD(T2L, T2O));
	       T3a = VBYI(VSUB(T36, T35));
	       T2R = VMUL(LDK(KP707106781), VSUB(T2O, T2L));
	       T37 = VADD(T35, T36);
	  }
	  {
	       V T3i, T3C, T3l, T3D;
	       {
		    V T3g, T3h, T3j, T3k;
		    T3g = LD(&(x[WS(vs, 6) + WS(is, 1)]), dist, &(x[WS(vs, 6) + WS(is, 1)]));
		    T3h = LD(&(x[WS(vs, 6) + WS(is, 5)]), dist, &(x[WS(vs, 6) + WS(is, 1)]));
		    T3i = VSUB(T3g, T3h);
		    T3C = VADD(T3g, T3h);
		    T3j = LD(&(x[WS(vs, 6) + WS(is, 7)]), dist, &(x[WS(vs, 6) + WS(is, 1)]));
		    T3k = LD(&(x[WS(vs, 6) + WS(is, 3)]), dist, &(x[WS(vs, 6) + WS(is, 1)]));
		    T3l = VSUB(T3j, T3k);
		    T3D = VADD(T3j, T3k);
	       }
	       T3m = VMUL(LDK(KP707106781), VADD(T3i, T3l));
	       T3H = VBYI(VSUB(T3D, T3C));
	       T3o = VMUL(LDK(KP707106781), VSUB(T3l, T3i));
	       T3E = VADD(T3C, T3D);
	  }
	  ST(&(x[0]), VADD(Tp, Ts), dist, &(x[0]));
	  ST(&(x[WS(is, 2)]), VADD(T1t, T1w), dist, &(x[0]));
	  ST(&(x[WS(is, 5)]), VADD(T34, T37), dist, &(x[WS(is, 1)]));
	  ST(&(x[WS(is, 7)]), VADD(T48, T4b), dist, &(x[WS(is, 1)]));
	  ST(&(x[WS(is, 6)]), VADD(T3B, T3E), dist, &(x[0]));
	  ST(&(x[WS(is, 4)]), VADD(T2x, T2A), dist, &(x[0]));
	  {
	       V Tt, T4c, T2B, T24;
	       ST(&(x[WS(is, 3)]), VADD(T20, T23), dist, &(x[WS(is, 1)]));
	       ST(&(x[WS(is, 1)]), VADD(TW, TZ), dist, &(x[WS(is, 1)]));
	       Tt = BYTWJ(&(W[TWVL * 6]), VSUB(Tp, Ts));
	       ST(&(x[WS(vs, 4)]), Tt, dist, &(x[WS(vs, 4)]));
	       T4c = BYTWJ(&(W[TWVL * 6]), VSUB(T48, T4b));
	       ST(&(x[WS(vs, 4) + WS(is, 7)]), T4c, dist, &(x[WS(vs, 4) + WS(is, 1)]));
	       T2B = BYTWJ(&(W[TWVL * 6]), VSUB(T2x, T2A));
	       ST(&(x[WS(vs, 4) + WS(is, 4)]), T2B, dist, &(x[WS(vs, 4)]));
	       T24 = BYTWJ(&(W[TWVL * 6]), VSUB(T20, T23));
	       ST(&(x[WS(vs, 4) + WS(is, 3)]), T24, dist, &(x[WS(vs, 4) + WS(is, 1)]));
	  }
	  {
	       V T10, T1x, T3F, T38, T1A, Tw;
	       T10 = BYTWJ(&(W[TWVL * 6]), VSUB(TW, TZ));
	       ST(&(x[WS(vs, 4) + WS(is, 1)]), T10, dist, &(x[WS(vs, 4) + WS(is, 1)]));
	       T1x = BYTWJ(&(W[TWVL * 6]), VSUB(T1t, T1w));
	       ST(&(x[WS(vs, 4) + WS(is, 2)]), T1x, dist, &(x[WS(vs, 4)]));
	       T3F = BYTWJ(&(W[TWVL * 6]), VSUB(T3B, T3E));
	       ST(&(x[WS(vs, 4) + WS(is, 6)]), T3F, dist, &(x[WS(vs, 4)]));
	       T38 = BYTWJ(&(W[TWVL * 6]), VSUB(T34, T37));
	       ST(&(x[WS(vs, 4) + WS(is, 5)]), T38, dist, &(x[WS(vs, 4) + WS(is, 1)]));
	       T1A = BYTWJ(&(W[TWVL * 10]), VSUB(T1y, T1z));
	       ST(&(x[WS(vs, 6) + WS(is, 2)]), T1A, dist, &(x[WS(vs, 6)]));
	       Tw = BYTWJ(&(W[TWVL * 10]), VSUB(Tu, Tv));
	       ST(&(x[WS(vs, 6)]), Tw, dist, &(x[WS(vs, 6)]));
	  }
	  {
	       V T2E, T3I, T13, T27, T3b, T4f;
	       T2E = BYTWJ(&(W[TWVL * 10]), VSUB(T2C, T2D));
	       ST(&(x[WS(vs, 6) + WS(is, 4)]), T2E, dist, &(x[WS(vs, 6)]));
	       T3I = BYTWJ(&(W[TWVL * 10]), VSUB(T3G, T3H));
	       ST(&(x[WS(vs, 6) + WS(is, 6)]), T3I, dist, &(x[WS(vs, 6)]));
	       T13 = BYTWJ(&(W[TWVL * 10]), VSUB(T11, T12));
	       ST(&(x[WS(vs, 6) + WS(is, 1)]), T13, dist, &(x[WS(vs, 6) + WS(is, 1)]));
	       T27 = BYTWJ(&(W[TWVL * 10]), VSUB(T25, T26));
	       ST(&(x[WS(vs, 6) + WS(is, 3)]), T27, dist, &(x[WS(vs, 6) + WS(is, 1)]));
	       T3b = BYTWJ(&(W[TWVL * 10]), VSUB(T39, T3a));
	       ST(&(x[WS(vs, 6) + WS(is, 5)]), T3b, dist, &(x[WS(vs, 6) + WS(is, 1)]));
	       T4f = BYTWJ(&(W[TWVL * 10]), VSUB(T4d, T4e));
	       ST(&(x[WS(vs, 6) + WS(is, 7)]), T4f, dist, &(x[WS(vs, 6) + WS(is, 1)]));
	  }
	  {
	       V Tx, T1B, T3c, T4g, T3J, T2F;
	       Tx = BYTWJ(&(W[TWVL * 2]), VADD(Tu, Tv));
	       ST(&(x[WS(vs, 2)]), Tx, dist, &(x[WS(vs, 2)]));
	       T1B = BYTWJ(&(W[TWVL * 2]), VADD(T1y, T1z));
	       ST(&(x[WS(vs, 2) + WS(is, 2)]), T1B, dist, &(x[WS(vs, 2)]));
	       T3c = BYTWJ(&(W[TWVL * 2]), VADD(T39, T3a));
	       ST(&(x[WS(vs, 2) + WS(is, 5)]), T3c, dist, &(x[WS(vs, 2) + WS(is, 1)]));
	       T4g = BYTWJ(&(W[TWVL * 2]), VADD(T4d, T4e));
	       ST(&(x[WS(vs, 2) + WS(is, 7)]), T4g, dist, &(x[WS(vs, 2) + WS(is, 1)]));
	       T3J = BYTWJ(&(W[TWVL * 2]), VADD(T3G, T3H));
	       ST(&(x[WS(vs, 2) + WS(is, 6)]), T3J, dist, &(x[WS(vs, 2)]));
	       T2F = BYTWJ(&(W[TWVL * 2]), VADD(T2C, T2D));
	       ST(&(x[WS(vs, 2) + WS(is, 4)]), T2F, dist, &(x[WS(vs, 2)]));
	  }
	  T28 = BYTWJ(&(W[TWVL * 2]), VADD(T25, T26));
	  ST(&(x[WS(vs, 2) + WS(is, 3)]), T28, dist, &(x[WS(vs, 2) + WS(is, 1)]));
	  T14 = BYTWJ(&(W[TWVL * 2]), VADD(T11, T12));
	  ST(&(x[WS(vs, 2) + WS(is, 1)]), T14, dist, &(x[WS(vs, 2) + WS(is, 1)]));
	  {
	       V Th, Ti, Tb, Tg;
	       Tb = VADD(T3, Ta);
	       Tg = VBYI(VSUB(Tc, Tf));
	       Th = BYTWJ(&(W[TWVL * 12]), VSUB(Tb, Tg));
	       Ti = BYTWJ(&(W[0]), VADD(Tb, Tg));
	       ST(&(x[WS(vs, 7)]), Th, dist, &(x[WS(vs, 7)]));
	       ST(&(x[WS(vs, 1)]), Ti, dist, &(x[WS(vs, 1)]));
	  }
	  {
	       V T40, T41, T3U, T3Z;
	       T3U = VADD(T3M, T3T);
	       T3Z = VBYI(VSUB(T3V, T3Y));
	       T40 = BYTWJ(&(W[TWVL * 12]), VSUB(T3U, T3Z));
	       T41 = BYTWJ(&(W[0]), VADD(T3U, T3Z));
	       ST(&(x[WS(vs, 7) + WS(is, 7)]), T40, dist, &(x[WS(vs, 7) + WS(is, 1)]));
	       ST(&(x[WS(vs, 1) + WS(is, 7)]), T41, dist, &(x[WS(vs, 1) + WS(is, 1)]));
	  }
	  {
	       V T2p, T2q, T2j, T2o;
	       T2j = VADD(T2b, T2i);
	       T2o = VBYI(VSUB(T2k, T2n));
	       T2p = BYTWJ(&(W[TWVL * 12]), VSUB(T2j, T2o));
	       T2q = BYTWJ(&(W[0]), VADD(T2j, T2o));
	       ST(&(x[WS(vs, 7) + WS(is, 4)]), T2p, dist, &(x[WS(vs, 7)]));
	       ST(&(x[WS(vs, 1) + WS(is, 4)]), T2q, dist, &(x[WS(vs, 1)]));
	  }
	  {
	       V T1S, T1T, T1M, T1R;
	       T1M = VADD(T1E, T1L);
	       T1R = VBYI(VSUB(T1N, T1Q));
	       T1S = BYTWJ(&(W[TWVL * 12]), VSUB(T1M, T1R));
	       T1T = BYTWJ(&(W[0]), VADD(T1M, T1R));
	       ST(&(x[WS(vs, 7) + WS(is, 3)]), T1S, dist, &(x[WS(vs, 7) + WS(is, 1)]));
	       ST(&(x[WS(vs, 1) + WS(is, 3)]), T1T, dist, &(x[WS(vs, 1) + WS(is, 1)]));
	  }
	  {
	       V TO, TP, TI, TN;
	       TI = VADD(TA, TH);
	       TN = VBYI(VSUB(TJ, TM));
	       TO = BYTWJ(&(W[TWVL * 12]), VSUB(TI, TN));
	       TP = BYTWJ(&(W[0]), VADD(TI, TN));
	       ST(&(x[WS(vs, 7) + WS(is, 1)]), TO, dist, &(x[WS(vs, 7) + WS(is, 1)]));
	       ST(&(x[WS(vs, 1) + WS(is, 1)]), TP, dist, &(x[WS(vs, 1) + WS(is, 1)]));
	  }
	  {
	       V T1l, T1m, T1f, T1k;
	       T1f = VADD(T17, T1e);
	       T1k = VBYI(VSUB(T1g, T1j));
	       T1l = BYTWJ(&(W[TWVL * 12]), VSUB(T1f, T1k));
	       T1m = BYTWJ(&(W[0]), VADD(T1f, T1k));
	       ST(&(x[WS(vs, 7) + WS(is, 2)]), T1l, dist, &(x[WS(vs, 7)]));
	       ST(&(x[WS(vs, 1) + WS(is, 2)]), T1m, dist, &(x[WS(vs, 1)]));
	  }
	  {
	       V T3t, T3u, T3n, T3s;
	       T3n = VADD(T3f, T3m);
	       T3s = VBYI(VSUB(T3o, T3r));
	       T3t = BYTWJ(&(W[TWVL * 12]), VSUB(T3n, T3s));
	       T3u = BYTWJ(&(W[0]), VADD(T3n, T3s));
	       ST(&(x[WS(vs, 7) + WS(is, 6)]), T3t, dist, &(x[WS(vs, 7)]));
	       ST(&(x[WS(vs, 1) + WS(is, 6)]), T3u, dist, &(x[WS(vs, 1)]));
	  }
	  {
	       V T2W, T2X, T2Q, T2V;
	       T2Q = VADD(T2I, T2P);
	       T2V = VBYI(VSUB(T2R, T2U));
	       T2W = BYTWJ(&(W[TWVL * 12]), VSUB(T2Q, T2V));
	       T2X = BYTWJ(&(W[0]), VADD(T2Q, T2V));
	       ST(&(x[WS(vs, 7) + WS(is, 5)]), T2W, dist, &(x[WS(vs, 7) + WS(is, 1)]));
	       ST(&(x[WS(vs, 1) + WS(is, 5)]), T2X, dist, &(x[WS(vs, 1) + WS(is, 1)]));
	  }
	  {
	       V T1p, T1q, T1n, T1o;
	       T1n = VSUB(T17, T1e);
	       T1o = VBYI(VADD(T1j, T1g));
	       T1p = BYTWJ(&(W[TWVL * 8]), VSUB(T1n, T1o));
	       T1q = BYTWJ(&(W[TWVL * 4]), VADD(T1n, T1o));
	       ST(&(x[WS(vs, 5) + WS(is, 2)]), T1p, dist, &(x[WS(vs, 5)]));
	       ST(&(x[WS(vs, 3) + WS(is, 2)]), T1q, dist, &(x[WS(vs, 3)]));
	  }
	  {
	       V Tl, Tm, Tj, Tk;
	       Tj = VSUB(T3, Ta);
	       Tk = VBYI(VADD(Tf, Tc));
	       Tl = BYTWJ(&(W[TWVL * 8]), VSUB(Tj, Tk));
	       Tm = BYTWJ(&(W[TWVL * 4]), VADD(Tj, Tk));
	       ST(&(x[WS(vs, 5)]), Tl, dist, &(x[WS(vs, 5)]));
	       ST(&(x[WS(vs, 3)]), Tm, dist, &(x[WS(vs, 3)]));
	  }
	  {
	       V T2t, T2u, T2r, T2s;
	       T2r = VSUB(T2b, T2i);
	       T2s = VBYI(VADD(T2n, T2k));
	       T2t = BYTWJ(&(W[TWVL * 8]), VSUB(T2r, T2s));
	       T2u = BYTWJ(&(W[TWVL * 4]), VADD(T2r, T2s));
	       ST(&(x[WS(vs, 5) + WS(is, 4)]), T2t, dist, &(x[WS(vs, 5)]));
	       ST(&(x[WS(vs, 3) + WS(is, 4)]), T2u, dist, &(x[WS(vs, 3)]));
	  }
	  {
	       V T3x, T3y, T3v, T3w;
	       T3v = VSUB(T3f, T3m);
	       T3w = VBYI(VADD(T3r, T3o));
	       T3x = BYTWJ(&(W[TWVL * 8]), VSUB(T3v, T3w));
	       T3y = BYTWJ(&(W[TWVL * 4]), VADD(T3v, T3w));
	       ST(&(x[WS(vs, 5) + WS(is, 6)]), T3x, dist, &(x[WS(vs, 5)]));
	       ST(&(x[WS(vs, 3) + WS(is, 6)]), T3y, dist, &(x[WS(vs, 3)]));
	  }
	  {
	       V TS, TT, TQ, TR;
	       TQ = VSUB(TA, TH);
	       TR = VBYI(VADD(TM, TJ));
	       TS = BYTWJ(&(W[TWVL * 8]), VSUB(TQ, TR));
	       TT = BYTWJ(&(W[TWVL * 4]), VADD(TQ, TR));
	       ST(&(x[WS(vs, 5) + WS(is, 1)]), TS, dist, &(x[WS(vs, 5) + WS(is, 1)]));
	       ST(&(x[WS(vs, 3) + WS(is, 1)]), TT, dist, &(x[WS(vs, 3) + WS(is, 1)]));
	  }
	  {
	       V T1W, T1X, T1U, T1V;
	       T1U = VSUB(T1E, T1L);
	       T1V = VBYI(VADD(T1Q, T1N));
	       T1W = BYTWJ(&(W[TWVL * 8]), VSUB(T1U, T1V));
	       T1X = BYTWJ(&(W[TWVL * 4]), VADD(T1U, T1V));
	       ST(&(x[WS(vs, 5) + WS(is, 3)]), T1W, dist, &(x[WS(vs, 5) + WS(is, 1)]));
	       ST(&(x[WS(vs, 3) + WS(is, 3)]), T1X, dist, &(x[WS(vs, 3) + WS(is, 1)]));
	  }
	  {
	       V T30, T31, T2Y, T2Z;
	       T2Y = VSUB(T2I, T2P);
	       T2Z = VBYI(VADD(T2U, T2R));
	       T30 = BYTWJ(&(W[TWVL * 8]), VSUB(T2Y, T2Z));
	       T31 = BYTWJ(&(W[TWVL * 4]), VADD(T2Y, T2Z));
	       ST(&(x[WS(vs, 5) + WS(is, 5)]), T30, dist, &(x[WS(vs, 5) + WS(is, 1)]));
	       ST(&(x[WS(vs, 3) + WS(is, 5)]), T31, dist, &(x[WS(vs, 3) + WS(is, 1)]));
	  }
	  {
	       V T44, T45, T42, T43;
	       T42 = VSUB(T3M, T3T);
	       T43 = VBYI(VADD(T3Y, T3V));
	       T44 = BYTWJ(&(W[TWVL * 8]), VSUB(T42, T43));
	       T45 = BYTWJ(&(W[TWVL * 4]), VADD(T42, T43));
	       ST(&(x[WS(vs, 5) + WS(is, 7)]), T44, dist, &(x[WS(vs, 5) + WS(is, 1)]));
	       ST(&(x[WS(vs, 3) + WS(is, 7)]), T45, dist, &(x[WS(vs, 3) + WS(is, 1)]));
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     VTW(6),
     VTW(7),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 8, "q1fv_8", twinstr, {264, 128, 0, 0}, &GENUS, 0, 0, 0 };

void X(codelet_q1fv_8) (planner *p) {
     X(kdft_difsq_register) (p, q1fv_8, &desc);
}
