/* Convert one or more BEPs into a single MID */
/* Parameters can be one of:
[MidiFileName] [BepFileName...]
@ScriptFileName

If no arguments passed, BEP2MID will prompt for all required information.

Sample script file: (the dashes aren't part of it)
--
MID=MidiFileName.MID
BEPS=BepFileName.BEP AnotherBepFileName.BEP
KEY=-2
USEPATCH=N
TEMPO=1.5
TEST=OFF
--
Explanation:
MID is simply the name of the output file (may include any path information required; anything allowed by the operating system (eg UNC name) should be OK).
BEPS is the list of input files. On both of these the extensions are immaterial but not assumed.
KEY indicates the key in which the tune is written - positive number = number of sharps, negative = flats.
USEPATCH is either Y or N; if Y, before each input file is processed the user is prompted for a patch (also known as voice) number to use for that track.
TEMPO is multiplied by each specified duration to obtain the target duration. In my experiments 1.5 has produced the "nicest" results; you may disagree.
TEST, if ON, triggers the auto-play feature (by calling on PLAY.CMD, which comes with OS/2 Warp 4 Multimedia). This is the only non-portable part of the program, I think.
*/
PARSE ARG MID BEPS
USEPATCH="Y"
TRANSPOSE=0
KEY=0
TEMPO=1.5
TESTMID="OFF"
IF LEFT(MID,1)="@" THEN DO
	F=SUBSTR(MID,2)
	DO WHILE CHARS(F)>0
		L=LINEIN(F)
		IF L="" THEN ITERATE
		IF POS("=",L)=0 THEN ITERATE
		PARSE VALUE L WITH VAR"="VAL
		IF VAR="" THEN ITERATE
		SELECT
			WHEN VAR="MID" THEN MID=VAL
			WHEN VAR="BEPS" THEN DO
				BEPS=VAL
				I=0
				DO WHILE BEPS\=""
					I=I+1
					PARSE VALUE BEPS WITH BEP.I BEPS
				END
				BEP.0=I
			END
			WHEN VAR="KEY" THEN KEY=VAL
			WHEN VAR="TRANSPOSE" THEN TRANSPOSE=VAL
			WHEN VAR="USEPATCH" THEN USEPATCH=VAL
			WHEN VAR="TEMPO" THEN TEMPO=VAL
			WHEN VAR="TEST" THEN TESTMID=VAL
			OTHERWISE NOP
		END
	END
	CALL STREAM F,"C","CLOSE"
	SIGNAL SCRIPT
END
IF MID="" THEN DO
	SAY "Enter name of output MIDI file:"
	MID=LINEIN()
	IF MID="" THEN EXIT
END
IF BEPS="" THEN DO
	SAY "Enter .BEP files, one to a line, blank to terminate:"
	DO I=1 BY 1
		BEP.I=LINEIN()
		IF BEP.I="" THEN LEAVE
	END
	BEP.0=I-1
END
ELSE DO
	I=0
	DO WHILE BEPS\=""
		I=I+1
		PARSE VALUE BEPS WITH BEP.I BEPS
	END
	BEP.0=I
END
SAY "Key signature:"
PULL KEY
IF DATATYPE(KEY,"N")=0 THEN KEY=0
SAY "Transpose dist:"
PULL TRANSPOSE
IF DATATYPE(TRANSPOSE,"N")=0 THEN TRANSPOSE=0
SCRIPT:
"@DEL "MID" >NUL 2>NUL"
J=1
DO I=1 TO BEP.0
	J=J+1
	CHUNK.J="MTrk"
	CHUNK.J.DATA=BEP2MIDCHUNK(BEP.I,I-1)
	CALL STREAM BEP.I,"C","CLOSE"
	IF CHUNK.J.DATA="" THEN J=J-1
END
CHUNK.0=J
CHUNK.1="MThd"
CHUNK.1.DATA="0001"x||RIGHT(D2C(J-1),2,"00"x)"E728"x

/******************************************/
/* Write MID                              */
/* MID defined in CHUNK.                  */
/* CHUNK.0 holds the number of chunks     */
/* CHUNK.n has four byte type for chunk n */
/* CHUNK.n.DATA holds the actual data     */
/* Length is calculated                   */
DO I=1 TO CHUNK.0
	CALL CHAROUT MID,CHUNK.I /* Header */
	CALL CHAROUT MID,RIGHT(D2C(LENGTH(CHUNK.I.DATA)),4,"00"x) /* Length */
	CALL CHAROUT MID,CHUNK.I.DATA /* Data */
END
CALL CHAROUT MID
/* Finished writing MID                   */
/******************************************/

IF TESTMID="ON" THEN CALL PLAY "FILE="MID
EXIT

BEP2MIDCHUNK: PROCEDURE EXPOSE KEY TRANSPOSE USEPATCH TEMPO
PARSE ARG BEP,CHANNEL
IF CHARS(BEP)=0 THEN RETURN ""
DATA=""
IF USEPATCH="Y" THEN DO
	SAY "Enter instrument/patch/program number to use:"
	PULL PATCH
	IF PATCH\="" THEN DATA=DATA"00C0"x||D2C(PATCH)
END
NEXTDELAY=0
DO WHILE CHARS(BEP)>0
	PARSE VALUE LINEIN(BEP) WITH FREQ","DUR
	IF FREQ="" THEN ITERATE
	IF LEFT(FREQ,1)="#" THEN DO
		/* Set variable - #var,<newval> */
		/* Useful variables include: KEY, TRANSPOSE, TEMPO */
		CALL VALUE SUBSTR(FREQ,2),DUR
		SAY SUBSTR(FREQ,2)" set to "DUR
		ITERATE
	END
	IF LEFT(FREQ,1)="$" THEN DO
		/* Hex Bytes - $byte[ byte...] */
		/* Output into MIDI unchanged */
		DATA=DATA||X2C(SUBSTR(FREQ,2))
		ITERATE
	END
	IF DUR="" THEN DUR=250
	DUR=TRUNC(DUR*TEMPO)
	IF FREQ=0 THEN NEXTDELAY=NEXTDELAY+DUR
	ELSE DO
		IF POS("*",FREQ)>0 THEN CALL PROCESSCHORD FREQ,CHANNEL /* Sets NOTEONDATA and NOTEOFFDATA */
		ELSE DO
			NOTE=D2C(FREQ2NOTE(FREQ))
			NOTEONDATA=X2C("9"CHANNEL)NOTE"@"
			NOTEOFFDATA=X2C("8"CHANNEL)NOTE"@"
		END
		DATA=DATA||INT2VARLEN(NEXTDELAY)NOTEONDATA||INT2VARLEN(DUR)NOTEOFFDATA
		NEXTDELAY=0
	END
END
CALL STREAM BEP,"C","CLOSE"
RETURN DATA"00FF2F00"x

PROCESSCHORD: PROCEDURE EXPOSE NOTE. KEY TRANSPOSE NOTEONDATA NOTEOFFDATA
PARSE ARG NOTE,CHANNEL
PARSE VALUE NOTE WITH NOTE"*"MODS
NOTES=FREQ2NOTE(NOTE)
NOTES=NOTES NOTES+4 NOTES+7
DO I=1 TO LENGTH(MODS)
	MOD=SUBSTR(MODS,I,1)
	SELECT
		WHEN MOD="7" THEN NOTES=NOTES WORD(NOTES,1)+10
		WHEN MOD="m" THEN DO
			PARSE VALUE NOTES WITH A B C
			NOTES=A B-1 C
		END
		WHEN MOD="I" THEN DO
			PARSE VALUE NOTES WITH A B C
			NOTES=C-12 A B
		END
		OTHERWISE NOP
	END
END
NOTEONDATA=X2C("9"CHANNEL)D2C(WORD(NOTES,1))"@"
NOTEOFFDATA=X2C("8"CHANNEL)D2C(WORD(NOTES,1))"@"
DO I=2 TO WORDS(NOTES)
	NOTEONDATA=NOTEONDATA"00"x||X2C("9"CHANNEL)D2C(WORD(NOTES,I))"@"
	NOTEOFFDATA=NOTEOFFDATA"00"x||X2C("8"CHANNEL)D2C(WORD(NOTES,I))"@"
END
RETURN 1

FREQ2NOTE: PROCEDURE EXPOSE NOTE. KEY TRANSPOSE
PARSE ARG F
IF POS(LEFT(F,1),"CDEFGAB")>0 THEN DO
	OCTAVEPOS=VERIFY(F,"0123456789","M")
	IF OCTAVEPOS=0 THEN DO; OCTAVEPOS=LENGTH(F)+1; F=F"5"; END
	USEKEY=POS(SUBSTR(F,2,1),"#-=")=0 /* # for sharp, - for flat, = for natural */
	IF SUBSTR(F,2,1)="-" THEN F=OVERLAY(PREVNOTE(LEFT(F,1))"#",F)
	IF SUBSTR(F,2,1)="=" THEN DO; F=DELSTR(F,2,1); OCTAVEPOS=OCTAVEPOS-1; END
	NOTE=POS(" "LEFT(F,OCTAVEPOS-1)" "," C  C# D  D# E  F  F# G  G# A  A# B ")
	IF NOTE\=0 THEN NOTE=(NOTE-1)/3
	IF USEKEY THEN NOTE=NOTE+KEYEFFECT(NOTE)
	OCTAVE=SUBSTR(F,OCTAVEPOS)
	RETURN OCTAVE*12+NOTE+TRANSPOSE
END
IF SYMBOL("NOTE.0")="LIT" THEN CALL LOADNOTES
DIFF=999999
RET=0
DO I=0 TO 127
	CUR=ABS(NOTE.I-F)
	IF CUR<DIFF THEN DO; DIFF=CUR; RET=I; END
END
RETURN RET+TRANSPOSE+KEYEFFECT(RET//12)

KEYTYPE: PROCEDURE
PARSE ARG K
/* Returns "CDEFGAB" */
SELECT
	WHEN K=-7 THEN RETURN "-------"
	WHEN K=-6 THEN RETURN "---*---"
	WHEN K=-5 THEN RETURN "*--*---"
	WHEN K=-4 THEN RETURN "*--**--"
	WHEN K=-3 THEN RETURN "**-**--"
	WHEN K=-2 THEN RETURN "**-***-"
	WHEN K=-1 THEN RETURN "******-"
	WHEN K=0  THEN RETURN "*******"
	WHEN K=+1 THEN RETURN "***#***"
	WHEN K=+2 THEN RETURN "#**#***"
	WHEN K=+3 THEN RETURN "#**##**"
	WHEN K=+4 THEN RETURN "##*##**"
	WHEN K=+5 THEN RETURN "##*###*"
	WHEN K=+6 THEN RETURN "######*"
	WHEN K=+7 THEN RETURN "#######"
	OTHERWISE RETURN "???????"
END
RETURN "!!!!!!!"

KEYEFFECT: PROCEDURE EXPOSE KEY MAXNOTE
PARSE ARG NOTE
POS=SUBSTR("1 2 34 5 6 7",NOTE+1,1)
IF POS=" " THEN RETURN 0
TYPE=SUBSTR(KEYTYPE(KEY),POS,1)
RETURN (TYPE="#")-(TYPE="-")

PREVNOTE: PROCEDURE
NOTES="CDEFGAB"
RETURN SUBSTR(NOTES,POS(ARG(1),NOTES)-1,1)

INT2VARLEN: PROCEDURE
PARSE ARG N
IF N<128 THEN RETURN D2C(N)
RET=""
BIN=STRIP(X2B(D2X(N)),"L","0")
BIN=RIGHT(BIN,TRUNC((LENGTH(BIN)+6)/7)*7,"0")
DO WHILE LENGTH(BIN)>7
	RET=RET||X2C(B2X("1"LEFT(BIN,7)))
	BIN=SUBSTR(BIN,8)
END
RETURN RET||X2C(B2X(BIN))

LOADNOTES:
NOTE.60=261.63
NOTE.61=277.18
NOTE.62=293.66
NOTE.63=311.13
NOTE.64=329.63
NOTE.65=349.23
NOTE.66=369.99
NOTE.67=392
NOTE.68=415.3
NOTE.69=440
NOTE.70=466.16
NOTE.71=493.88
DO O=0 TO 11
	DO I=0 TO 11
		OCT3=I+60
		CUR=I+O*12
		NOTE.CUR=NOTE.OCT3*2**(O-5)
	END
END
RETURN
