<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!--
	List of channels
-->

<xsl:template match="ui/channels">
  <xsl:apply-templates select="list"/>
  <xsl:apply-templates select="channel"/>
</xsl:template>

<xsl:template match="channels/list">
  <div class="part-content">
    <span class="control-title">
      <xsl:call-template name="btn">
        <xsl:with-param name="caption" select="$lang/buttons/refresh"/>
        <xsl:with-param name="hint" select="$lang/buttons/refresh/@hint"/>
        <xsl:with-param name="link">/ui/channels</xsl:with-param>
      </xsl:call-template>
    </span>
  </div>

  <table cellpadding="0" cellspacing="0" border="0" class="obj-list">
    <thead>
      <tr>
        <th> </th>
        <th><xsl:value-of select="$lang/labels/mount-point"/></th>
        <th><xsl:value-of select="$lang/labels/clients"/></th>
        <th><xsl:value-of select="$lang/labels/properties"/></th>
      </tr>
    </thead>
    <tbody>
      <xsl:apply-templates select="channel"/>
    </tbody>
  </table>
</xsl:template>

<xsl:template match="list/channel">
  <tr>
    <td class="btn" valign="middle" style="padding-bottom: 0.5em;">
      <xsl:choose>
        <xsl:when test="@check">
          <xsl:call-template name="delete-btn">
            <xsl:with-param name="link">?mp=<xsl:value-of select="mp"/>&amp;del=1#<xsl:value-of select="mp"/></xsl:with-param>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="delete-btn">
            <xsl:with-param name="link">?check=<xsl:value-of select="mp"/>#<xsl:value-of select="mp"/></xsl:with-param>
            <xsl:with-param name="check">1</xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td valign="middle" style="padding-bottom: 0.5em;">
      <a name="{mp}"></a>
      <a href="?mp={mp}" onclick="return locLoad();">
        <xsl:value-of select="mp"/>
      </a>
    </td>
    <td valign="middle" style="padding: 0 1em 0.5em 0; text-align: right;">
      <span>
        <xsl:if test="clients-num/@max and clients-num/@max = clients-num">
          <xsl:attribute name="style">color: red;</xsl:attribute>
        </xsl:if>
        <xsl:value-of select="clients-num"/>
        <xsl:if test="clients-num/@max">
          <xsl:text> / </xsl:text>
          <xsl:value-of select="clients-num/@max"/>
        </xsl:if>
      </span>
    </td>
    <td valign="middle" style="padding-bottom: 0.5em;">
      <span class="value">
        <xsl:choose>
          <xsl:when test="name">
            <xsl:value-of select="name"/>
          </xsl:when>
          <xsl:when test="description">
            <xsl:value-of select="description"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </span>
      <span class="value" style="font-size: 10pt;">
        <xsl:choose>
          <xsl:when test="@content-type='application/ogg'">OGG</xsl:when>
          <xsl:when test="@content-type='audio/mpeg'">MP3</xsl:when>
          <xsl:when test="@content-type">
            <xsl:value-of select="@content-type"/>
          </xsl:when>
        </xsl:choose>
        <xsl:if test="bitrate">
          <xsl:text> </xsl:text>
          <nobr>
            <xsl:value-of select="bitrate"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="$lang/labels/kbit-sec"/>
          </nobr>
        </xsl:if>
      </span>
<!--
      <xsl:if test="url">
        <nobr>
          <span class="value-title">
            <xsl:value-of select="$lang/labels/url"/>:
          </span>
          <span class="value"><xsl:value-of select="url"/></span>
        </nobr>
      </xsl:if>
      <xsl:if test="genre">
        <nobr>
          <span class="value-title">
            <xsl:value-of select="$lang/labels/prop-genre"/>:
          </span>
          <span class="value"><xsl:value-of select="genre"/></span>
        </nobr>
      </xsl:if>
-->
      <xsl:if test="metadata">
        <div>
          <span class="control-title">
            <xsl:call-template name="time-format">
              <xsl:with-param name="time" select="metadata/@timestamp"/>
            </xsl:call-template>
          </span>
          <span class="value">
            <xsl:value-of select="metadata"/>
          </span>
        </div>
      </xsl:if>
    </td>
  </tr>
</xsl:template>

<!--
	Channel's detail
-->

<xsl:template match="channels/channel">
  <div class="part-content">
    <span class="control-title">
      <xsl:call-template name="btn">
        <xsl:with-param name="caption" select="$lang/buttons/list"/>
        <xsl:with-param name="hint" select="$lang/buttons/list/@hint"/>
        <xsl:with-param name="link">/ui/channels#<xsl:value-of select="mp"/></xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="btn">
        <xsl:with-param name="caption" select="$lang/buttons/refresh"/>
        <xsl:with-param name="hint" select="$lang/buttons/refresh/@hint"/>
        <xsl:with-param name="link">/ui/channels?mp=<xsl:value-of select="mp"/></xsl:with-param>
      </xsl:call-template>
      <xsl:if test="@relay">
        <xsl:call-template name="btn">
          <xsl:with-param name="caption" select="$lang/buttons/relay"/>
          <xsl:with-param name="hint" select="$lang/buttons/relay/@hint"/>
          <xsl:with-param name="link">/ui/relays?mp=<xsl:value-of select="mp"/></xsl:with-param>
        </xsl:call-template>
      </xsl:if>
      <xsl:if test="id-tuner">
        <xsl:call-template name="btn">
          <xsl:with-param name="caption" select="$lang/buttons/tuner"/>
          <xsl:with-param name="hint" select="$lang/buttons/tuner/@hint"/>
          <xsl:with-param name="link">/ui/tuners?id=<xsl:value-of select="id-tuner"/></xsl:with-param>
        </xsl:call-template>
      </xsl:if>
    </span>
  </div>

  <table cellpadding="0" cellspacing="0" border="0" class="part-content">
    <tr>
      <td class="control-title">
        <xsl:value-of select="$lang/labels/mount-point"/>
      </td>
      <td class="control"><xsl:value-of select="mp"/></td>
    </tr>
    <xsl:if test="source-ip">
      <tr>
        <td class="control-title">
          <xsl:value-of select="$lang/labels/source"/>
        </td>
        <td class="control"><xsl:value-of select="source-ip"/></td>
      </tr>
    </xsl:if>
    <xsl:if test="@content-type">
      <tr>
        <td class="control-title">
          <xsl:value-of select="$lang/labels/stream-type"/>
        </td>
        <td class="control"><xsl:value-of select="@content-type"/></td>
      </tr>
    </xsl:if>
    <xsl:if test="name">
      <tr>
        <td class="control-title">
          <xsl:value-of select="$lang/labels/channel-name"/>
        </td>
        <td class="control"><xsl:value-of select="name"/></td>
      </tr>
    </xsl:if>
    <xsl:if test="url">
      <tr>
        <td class="control-title">
          <xsl:value-of select="$lang/labels/url"/>
        </td>
        <td class="control"><xsl:value-of select="url"/></td>
      </tr>
    </xsl:if>
    <xsl:if test="genre">
      <tr>
        <td class="control-title">
          <xsl:value-of select="$lang/labels/genre"/>
        </td>
        <td class="control"><xsl:value-of select="genre"/></td>
      </tr>
    </xsl:if>
    <xsl:if test="description">
      <tr>
        <td class="control-title">
          <xsl:value-of select="$lang/labels/description"/>
        </td>
        <td class="control"><xsl:value-of select="description"/></td>
      </tr>
    </xsl:if>
    <xsl:if test="bitrate">
      <tr>
        <td class="control-title">
          <xsl:value-of select="$lang/labels/bitrate"/>
        </td>
        <td class="control">
          <xsl:value-of select="bitrate"/>
          <xsl:text> </xsl:text>
          <xsl:value-of select="$lang/labels/kbit-sec"/>
        </td>
      </tr>
    </xsl:if>
  </table>

  <div class="part-title">
    <xsl:value-of select="$lang/labels/metadata"/>
  </div>
  <table cellpadding="0" cellspacing="0" border="0" class="part-content">
    <xsl:apply-templates select="metadata"/>
  </table>
  <div class="part-title">
    <xsl:value-of select="$lang/labels/clients"/>
  </div>
  <table cellpadding="0" cellspacing="0" border="0" class="obj-list">
    <thead>
      <tr>
        <th> </th>
        <th><xsl:value-of select="$lang/labels/ip-address"/></th>
        <th><xsl:value-of select="$lang/labels/connect-time"/></th>
        <th><xsl:value-of select="$lang/labels/elapsed"/></th>
        <th><xsl:value-of select="$lang/labels/agent"/></th>
      </tr>
    </thead>
    <tbody>
      <xsl:apply-templates select="clients/client"/>
    </tbody>
  </table>
</xsl:template>

<xsl:template match="channel/metadata">
  <tr>
    <td>
      <span class="control-title">
        <xsl:call-template name="time-format">
          <xsl:with-param name="time" select="@timestamp"/>
        </xsl:call-template>
      </span>
    </td>
    <td class="control"><xsl:value-of select="."/></td>
  </tr>
</xsl:template>

<xsl:template match="channel/clients/client">
  <tr>
    <td class="btn">
      <xsl:choose>
        <xsl:when test="@check">
          <xsl:call-template name="delete-btn">
            <xsl:with-param name="link">?mp=<xsl:value-of select="../../mp"/>&amp;disconnect=<xsl:value-of select="@id-client"/></xsl:with-param>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="delete-btn">
            <xsl:with-param name="link">?mp=<xsl:value-of select="../../mp"/>&amp;check=<xsl:value-of select="@id-client"/>#client-<xsl:value-of select="@id-client"/></xsl:with-param>
            <xsl:with-param name="check">1</xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <a name="client-{@id-client}"></a>
      <span class="control-title"><xsl:value-of select="ip"/></span>
    </td>
    <td style="text-align: right;">
      <span>
        <xsl:call-template name="time-format">
          <xsl:with-param name="time" select="time"/>
        </xsl:call-template>
      </span>
    </td>
    <td style="text-align: center;">
      <span>
        <xsl:variable name="hours">
          <xsl:value-of select="floor( time/@elapsed div 3600 )"/>
        </xsl:variable>
        <xsl:variable name="min">
          <xsl:value-of select="floor( time/@elapsed div 60 ) mod 60"/>
        </xsl:variable>
        <xsl:variable name="sec">
          <xsl:value-of select="time/@elapsed mod 60"/>
        </xsl:variable>

        <xsl:value-of select="$hours"/>
        <xsl:text>:</xsl:text>
        <xsl:number format="01" value="$min"/>
        <xsl:text>:</xsl:text>
        <xsl:number format="01" value="$sec"/>
      </span>
    </td>
    <td class="control"><xsl:value-of select="user-agent"/></td>
  </tr>
</xsl:template>

</xsl:stylesheet>
