<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!--
	List of relays
-->

<xsl:template match="ui/relays">
  <xsl:apply-templates select="list"/>
  <xsl:apply-templates select="relay"/>
</xsl:template>

<xsl:template match="relays/list">
  <div class="part-content">
    <span class="control-title">
      <xsl:call-template name="btn">
        <xsl:with-param name="caption" select="$lang/buttons/new"/>
        <xsl:with-param name="hint" select="$lang/buttons/new/@hint"/>
        <xsl:with-param name="link">?mp=/new</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="btn">
        <xsl:with-param name="caption" select="$lang/buttons/refresh"/>
        <xsl:with-param name="hint" select="$lang/buttons/refresh/@hint"/>
        <xsl:with-param name="link">/ui/relays</xsl:with-param>
      </xsl:call-template>
    </span>
  </div>
  <table cellpadding="0" cellspacing="0" border="0" class="obj-list">
    <thead>
      <tr>
        <th> </th>
        <th><xsl:value-of select="$lang/labels/mount-point"/></th>
        <th><xsl:value-of select="$lang/labels/current-source"/></th>
        <th><xsl:value-of select="$lang/labels/state"/></th>
      </tr>
    </thead>
    <tbody>
      <xsl:apply-templates select="relay"/>
    </tbody>
  </table>
</xsl:template>

<xsl:template match="list/relay">
  <tr>
    <td class="btn">
      <xsl:choose>
        <xsl:when test="@check">
          <xsl:call-template name="delete-btn">
            <xsl:with-param name="link">?mp=<xsl:value-of select="mp"/>&amp;del=1</xsl:with-param>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="delete-btn">
            <xsl:with-param name="link">?check=<xsl:value-of select="mp"/>#<xsl:value-of select="mp"/></xsl:with-param>
            <xsl:with-param name="check">1</xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <a name="{mp}"></a>
      <a href="?mp={mp}" onclick="return locLoad();">
        <xsl:value-of select="mp"/>
      </a>
    </td>
    <xsl:if test="url">
      <td class="control-title">
        <xsl:value-of select="url"/>
      </td>
      <td>
        <xsl:call-template name="relay-url-state">
          <xsl:with-param name="state" select="url/@state"/>
        </xsl:call-template>
      </td>
    </xsl:if>
  </tr>
</xsl:template>

<!--
	Relay's detail
-->

<xsl:template match="relays/relay">
  <div class="part-content">
    <span class="control-title">
      <xsl:call-template name="btn">
        <xsl:with-param name="caption" select="$lang/buttons/list"/>
        <xsl:with-param name="hint" select="$lang/buttons/list/@hint"/>
        <xsl:with-param name="link">/ui/relays#<xsl:value-of select="mp"/></xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="btn">
        <xsl:with-param name="caption" select="$lang/buttons/refresh"/>
        <xsl:with-param name="hint" select="$lang/buttons/refresh/@hint"/>
        <xsl:with-param name="link">/ui/relays?mp=<xsl:value-of select="mp"/></xsl:with-param>
      </xsl:call-template>
      <xsl:if test="streams/url[@state='online'] or streams/url[@state='pending']">
        <xsl:call-template name="btn">
          <xsl:with-param name="caption" select="$lang/buttons/channel"/>
          <xsl:with-param name="hint" select="$lang/buttons/channel/@hint"/>
          <xsl:with-param name="link">/ui/channels?mp=<xsl:value-of select="mp"/></xsl:with-param>
        </xsl:call-template>
      </xsl:if>
    </span>
  </div>

  <form enctype="multipart/form-data" method="post"
        onsubmit="return locLoad();">
    <table cellpadding="0" cellspacing="0" border="0" class="part-content">
      <tr>
        <td class="control-title">
          <span>
            <xsl:if test="mp/@error">
              <xsl:attribute name="style">color: red;</xsl:attribute>
            </xsl:if>
            <xsl:value-of select="$lang/labels/mount-point"/>
          </span>
        </td>
        <td class="control">
          <xsl:choose>
            <xsl:when test="mp and not(mp/@error)">
              <xsl:choose>
                <xsl:when test="streams/url[@state='online'] or streams/url[@state='pending']">
                  <a href="/ui/channels?mp={mp}" onclick="return locLoad();">
                    <xsl:value-of select="mp"/>
                  </a>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="mp"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
              <input type="text" class="text" name="mp" value="{mp}"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </tr>
      <tr>
        <td class="control-title"> </td>
        <td class="control">
          <label for="swNailed">
            <input type="checkbox" id="swNailed" name="nailed">
              <xsl:if test="@nailed">
                <xsl:attribute name="checked">1</xsl:attribute>
              </xsl:if>
            </input>
            <xsl:value-of select="$lang/labels/nailed"/>
          </label>
        </td>
      </tr>
    </table>

    <div class="part-title">
      <xsl:value-of select="$lang/labels/relay-streams"/>
    </div>
    <xsl:apply-templates select="streams"/>

    <div class="part-content">
      <span class="control">
        <input type="submit" name="submitRelayEdit"
               value="{$lang/buttons/submit}"/>
      </span>
    </div>

  </form>
</xsl:template>

<xsl:template match="relay/streams">
  <div class="part-content">
    <div class="control-title">
      <xsl:value-of select="$lang/comments/relay-streams"/>
    </div>
  </div>
  <table cellpadding="0" cellspacing="0" border="0" class="obj-list">
    <tr>
      <td class="btn">
        <input type="radio" name="urlMain" value="">
          <xsl:if test="not(url/@main)">
            <xsl:attribute name="checked">1</xsl:attribute>
          </xsl:if>
        </input>
      </td>
      <td>
        <xsl:value-of select="$lang/labels/relay-no-main"/>
      </td>
    </tr>

    <xsl:apply-templates select="url"/>

    <tr>
      <td class="btn"><input type="radio" name="urlMain" value="100000"/></td>
      <td>
        <input type="hidden" name="url" value="100000"/>
        <input type="text" class="text" name="url100000" value=""/>
      </td>
    </tr>

  </table>
</xsl:template>

<xsl:template match="streams/url">
  <tr>
    <td class="btn">
      <input type="radio" name="urlMain" value="{position()}">
        <xsl:if test="@main">
          <xsl:attribute name="checked">1</xsl:attribute>
        </xsl:if>
      </input>
    </td>
    <td>
      <input type="hidden" name="url" value="{position()}"/>
      <input type="text" class="text" name="url{position()}" value="{.}"/>
    </td>
    <td>
      <xsl:call-template name="relay-url-state">
        <xsl:with-param name="state"><xsl:value-of select="@state"/></xsl:with-param>
      </xsl:call-template>
    </td>
  </tr>
</xsl:template>


<xsl:template name="relay-url-state">
  <xsl:param name="state"/>

  <xsl:if test="not($state='')">
    <span>
      <xsl:if test="starts-with($state,'err-')">
        <xsl:attribute name="style">color: red;</xsl:attribute>
      </xsl:if>
      <xsl:value-of select="$lang/labels/relay-url[@state=$state]"/>
    </span>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
