/* */

parse source v1 v2 IceHome
IceHome = left( IceHome, lastpos( "\", IceHome ) - 1 )
call value "ICEHOME", IceHome, "OS2ENVIRONMENT"
drop v1 v2

parse upper arg cmd

if wordpos( cmd, "CLEAN OS/2 WIN ALL" ) = 0 then
do
  say "Usage: MAKE.CMD <clean|OS/2|Win|all>"
  return 1
end

make.0 = 0

if cmd = "OS/2" | cmd = "ALL" then
do
  call makeList "OS/2"
  call makeAll "PLATFORM=OS2 CLEAN >nul"
  call makeAll "PLATFORM=OS2"
end

if cmd = "WIN" | cmd = "ALL" then
do
  call makeList "WIN"
  call makeAll "PLATFORM=NT CLEAN >nul"
  call makeAll "PLATFORM=NT"
end

if cmd = "CLEAN" then
do
  call makeList "OS/2"
  call makeAll "PLATFORM=OS2 CLEAN"
  call makeList "WIN"
  call makeAll "PLATFORM=NT CLEAN"
end

/* Exit */
return 0


makeList: procedure expose make.
  make.0 = 0
  os = arg( 1 )
  call makeAdd "zlib-1.2.8"
  call makeAdd "debug"
  call makeAdd "libogg-1.3.2\src"
  call makeAdd "libvorbis-1.3.5\lib"
  call makeAdd "flac-1.3.1\src\libFLAC"
  call makeAdd "lame-3.99.5\mpglib"
  call makeAdd "lame-3.99.5\libmp3lame"
  call makeAdd "libshout-2.3.1\src"
  call makeAdd "libxml2-2.9.2"
  if os = "WIN" then
    call makeAdd "libiconv-1.14\lib"
  if os = "OS/2" then
  do
    call makeAdd "libgiconv"
    call makeAdd "ices-2.0.2\src"
  end
  call makeAdd "ices-cc-0.4.2\src"
  return

makeAdd: procedure expose make.
  idx = make.0 + 1
  make.0 = idx
  make.idx = arg( 1 )
  return

makeDelete: procedure expose make.
  count = make.0
  do idx = 1 to count
    if make.idx = arg( 1 ) then
    do
      make.idx = make.count
      make.0 = count - 1
      leave
    end
  end
  return

makeAll: procedure expose IceHome make.
  makeSwitches = arg( 1 )
  saveDir = directory()

  do idx = 1 to make.0
    makeDir = directory( IceHome || "\packages\" || make.idx )
    if makeDir = "" then
      err( "Cannot change current directory: " || makeDir )

    "@wmake -h -s " || makeSwitches
    if rc \= 0 then
      exit 3
  end

  call directory saveDir
return

err:
  say arg( 1 )
  exit 2