#define INCL_DOSSEMAPHORES
#define INCL_DOSPROCESS
#define INCL_ERRORS
#include <os2.h>
#include <process.h>

#define thread_initialize()
#define thread_shutdown()

typedef HMTX           mutex_t;
typedef HEV            cond_t;
typedef void           thread_type;

#define thread_mutex_create(phmtx) DosCreateMutexSem( NULL, phmtx, 0, FALSE )
#define thread_mutex_destroy(phmtx) DosCloseMutexSem( *phmtx )
#define thread_mutex_lock(phmtx) \
  DosRequestMutexSem( *phmtx, SEM_INDEFINITE_WAIT )
#define thread_mutex_unlock(phmtx) DosReleaseMutexSem( *phmtx )

#define thread_cond_create(phev) \
  DosCreateEventSem( NULL, phev, DCE_AUTORESET, FALSE )
#define thread_cond_destroy(phev) DosCloseEventSem( *phev )
#define thread_cond_broadcast(phev) DosPostEventSem( *phev )
#define thread_cond_wait(phev) DosWaitEventSem( *phev, SEM_INDEFINITE_WAIT )

/*
   thread_type *thread_create(char *name, void *(*start_routine)(void *), 
                              void *arg, int detached);
*/

void __thread(void *arg);

#define thread_create(name, start_routine, arg, detached ) do {\
  void *__threadInfo[2]; \
  __threadInfo[0] = (void *)start_routine;  \
  __threadInfo[1] = arg; \
  _beginthread( __thread, NULL, 65535, &__threadInfo );  \
} while( FALSE )

/* sleep for a number of microseconds */
#define thread_sleep(len) DosSleep( (len) / 1000 )
