#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

#define INCL_DOS
#define INCL_DOSPROCESS
#define INCL_DOSFILEMGR
#define INCL_DOSDEVIOCTL
#include <os2.h>
#include <process.h>
#include "gifsave.h"

#define QCPORT 0x378

extern UCHAR _Far16 _Pascal GET8(USHORT);
extern _Far16 _Pascal OUTP8(USHORT, UCHAR);
extern _Far16 _Pascal OUTP16(USHORT, USHORT);
extern UCHAR _Far16 _Pascal INP8(USHORT);
extern USHORT _Far16 _Pascal INP16(USHORT);

int qcport = QCPORT;
int qcwidth=320, qcheight=240;
int qcbpp=6;
int qccontrast=54,qcbrightness=200,qcwhitebal=210;
int qcmode=-1; /* Mode arguement for 0x7 camera command */

/* Port access routines */

int read_lpstatus(void) { return INP8(qcport+1); }
int read_lpcontrol(void) { return INP8(qcport+2); }
void write_lpdata(int d) { OUTP8(qcport,d); }
void write_lpcontrol(int d) { OUTP8(qcport+2,d); }

unsigned char *buf;

static int GetPixel ( int x, int y )
{
return ( buf[y * qcwidth + x] );
}

/* Try to detect a QuickCam.  It appears to flash the upper 4 bits of
   the status register at 5-10 Hz.	This hasn't really been tested. */

int detect_qc(void)
{
  int reg,lastreg;
  int count=0;
  int i;

  lastreg=reg=read_lpstatus()&0xf0;

  for(i=0;i<30;i++) {
	reg=read_lpstatus()&0xf0;
	if(reg!=lastreg) count++;
	lastreg=reg;
	DosSleep(10000);
  }

  /* Be liberal... */

  if(count>3&&count<15)
	return 1; /* found */
  else
	return 0; /* not found */
}


/* Reset the QuickCam.	This uses the same sequence the Windows
   QuickPic program uses. */

void qc_reset(void)
{
  write_lpcontrol(0x20);
  write_lpdata(0x75);
  write_lpcontrol(0xb);
  write_lpcontrol(0xe);
}

/* qc_waithand busy-waits for a handshake signal from the QuickCam. */

int qc_waithand(int val)
{
  if(val)
	while(!(read_lpstatus()&8));
  else
	while((read_lpstatus()&8));

  return 0;
}

/* Feed the quickcam a command byte. */

void qc_command(int command)
{
  int status;

  write_lpdata(command);
  /* These seem to be needed for some reason. */
  write_lpdata(command);
 DosSleep(4);
  write_lpdata(command);
  GET8(qcport+2);
  status=read_lpstatus();
}

/* Read a scan from the QC */

char *qc_read(int len)
{
  char *ret;
  int i=0;
  int hi,lo;

  ret=malloc(len);

for(i=0;i<len;i++) {
    ret[i]=GET8(qcport+2);
  }

  return ret;
}

/* This is an ugly hack to write pgm files.  I should probably use
libpgm, but I don't have the documentation in front of me, so I hacked
this together. */

unsigned long qc_writepgm(FILE *f,unsigned char *scan,int x, int y, int bpp)
{
  int i;
  unsigned n,a,b,c,d,e,g;
  unsigned long qq=0;

  buf = malloc(x*y+1);

  if(bpp==4) {
	for(i=0;i<y*x/2;i++) {
	  n=scan[i];
	  a=(n>>4)&0xf;
	  b=n&0xf;
	  e=255-a*16;
	  g=255-b*16;
	  if (e==255) e=0;
	  if (g==255) g=0;
	  buf[qq++]=e;
	  buf[qq++]=g;
	}
  } else {
	for(i=0;i<y*x*3/4;i+=3) {
	  a=scan[i]>>2;;
	  b=(scan[i]&3)<<4|(scan[i+1]>>4);
	  c=(scan[i+1]&0xf)<<2|(scan[i+2]>>6);
	  d=(scan[i+2]&0x3f);
	  buf[qq++]=255-a*4;
	  buf[qq++]=255-b*4;
	  buf[qq++]=255-c*4;
	  buf[qq++]=255-d*4;
	}

  }

}


/* Send a set-brightness command */

void qc_setbright(int val)
{
  qc_command(0xB);
  qc_command(val);
}

/* Send a set-contrast command */

void qc_setcontrast(int val)
{
  qc_command(0x19);
  qc_command(val);
}

/* Send a set-white-balance command */

void qc_setwhitebal(int val)
{
  qc_command(0x1f);
  qc_command(val);
}

/* Send a set-width command.  Call with the actual width desired.
   Notice that this uses the bpp value to send the correct width to
   the camera. */

void qc_setwid(int val)
{
  qc_command(0x13);
  if(qcbpp==4)
	qc_command(val/2);
  else
	qc_command(val/4);
}

/* Send a set-height command. */

void qc_setheight(int val)
{
  qc_command(0x11);
  qc_command(val);
}

void usage(void)
{
  printf("Usage:\n");
  printf("  Qframe [options]\n");
  printf("    Options:\n");
  printf("      -x width    Set width            (320)\n");
  printf("      -y height   Set height           (240)\n");
  printf("      -p port     Set port             (0x378)\n");
  printf("      -B bpp      Set bits per pixel   (6)\n");

  printf("      -c val      Set contrast         (54)\n");
  printf("      -w val      Set white balance    (210)\n");
  printf("      -b val      Set brightness       (200)\n");
  printf("      -a val      Set Target Delta    \n");

  printf("      -f filename Set filename         (output.gif)\n");

}

int main(int argc, char **argv)
{
  char *scan;
  int arg,x,zz;
  extern char *gOptArg;
  unsigned char fname[128],last=0;
  unsigned long total,counter,avg;
  unsigned int target=0;

  FILE *fli;
  /* Read command line */

  sprintf(fname,"output.gif");

  while((arg=getopt(argc,argv,"hx:y:p:b:B:c:w:f:a:"))>0) {
	switch (arg) {
    case 'a':
      target=atoi(gOptArg);
      break;
	case 'f':
	  sprintf(fname,gOptArg);
	  break;
	case 'x':
	  qcwidth=atoi(gOptArg);
	  break;
	case 'y':
	  qcheight=atoi(gOptArg);
	  break;
	case 'p':
	  qcport=strtol(gOptArg,NULL,0);
	  break;
	case 'B':
	  qcbpp=atoi(gOptArg);
	  break;
	case 'b':
	  qcbrightness=atoi(gOptArg);
	  break;
	case 'c':
	  qccontrast=atoi(gOptArg);
	  break;
	case 'w':
	  qcwhitebal=atoi(gOptArg);
	  break;
	case 'h':
	  usage();
	  exit(0);
	  break;
	default:
	  printf("%s: Unknown option or error in option\n",argv[0]);
	  usage();
	  exit(1);
	  break;
	}
  }

  switch (qcwidth) {
  case 80:	if(qcheight==60)  qcmode=8; break;
  case 160: if(qcheight==120) qcmode=4; break;
  case 320: if(qcheight==240) qcmode=0; break;
  }

  if (qcmode<0) {
	printf("%s: Error: unsupported resolution (%d x %d)!\n",
		argv[0],qcwidth,qcheight);
	exit(1);
  }

  switch (qcbpp) {
  case 4: break;
  case 6: qcmode+=2; break;
  default:
	printf("%s: Error: Unsupported bit depth\n",argv[0]);
	exit(1);
  }

  printf("Qframe: from the SophWare HoloHaus (c)1996 v1.4\r\n");
  printf("Scanning from QuickCam at 0x%x at %dx%d @ %dbpp\n",
	  qcport,qcwidth,qcheight,qcbpp);


  /* Attempt to get permission to access IO ports.	Must be root */
tryagain:
  qc_reset();
  qc_setbright(qcbrightness);
  qc_setbright(0x01);
  qc_setbright(0x01);
  qc_setbright(qcbrightness);
  qc_setheight(qcheight);
  qc_setwid(qcwidth);
  qc_setheight(qcheight);
  qc_setwid(qcwidth);

  qc_command(0xd);
  qc_command(0x1);
  qc_command(0xf);
  qc_command(0x7);


  qc_setcontrast(qccontrast);
  qc_setwhitebal(qcwhitebal);

  qc_command(0x7);
  qc_command(qcmode);

  if(qcbpp==4)
	scan=qc_read(qcwidth*qcheight/2);
  else
	scan=qc_read(qcwidth*qcheight*3/4);


  total = qc_writepgm(fli,scan,qcwidth,qcheight,qcbpp);
  avg=0;
  for ( counter=0;counter<total;counter++)
    {
        avg+=buf[counter];
    }
  avg /= total;
  printf("Delta = %d\r\n",avg);
  if ( target )
    {
        if ( target == avg ) goto alldone;
        if ( target == avg+1 ) goto alldone;
        if ( target == avg+2 ) goto alldone;
        if ( target == avg-1 ) goto alldone;
        if ( target == avg-2 ) goto alldone;

        if ( target > avg )
            {
                if ( last == 2 ) goto alldone;
                qcbrightness+=2;
                        last=1;

            }
        if ( target < avg )
            {
                if ( last == 1 ) goto alldone;
                qcbrightness-=2;
                last = 2;
            }

        goto tryagain;
    }
  alldone:

  GIF_Create( fname, qcwidth, qcheight, 256, 8 );
  for ( x = 0; x < 256; x++ )
	{
     GIF_SetColor ( x, x,x, x );
	}
  GIF_CompressImage(0, 0, -1, -1, GetPixel );
  GIF_Close ( );

  printf("Wrote file..%s\n",fname);
  free(buf);
  free(scan);

  return 0;
}
