.486p
model flat
ideal

BitsPerSample=16
Channels=1 ; mono
FormatTag=1 ; pcm
SamplesPerSec=48000

extrn DosClose:near
extrn DosCloseEventSem:near
extrn DosCreateEventSem:near
extrn DosExit:near
extrn DosExitList:near
extrn DosOpen:near
extrn DosPostEventSem:near
extrn DosRead:near
extrn DosResetEventSem:near
extrn DosSetPriority:near
extrn DosSleep:near
extrn DosWaitEventSem:near
extrn DosWrite:near

extrn MciGetErrorString:near
extrn MciSendCommand:near

stack 8192

dataseg
szInput db '\PIPE\Webcam\Audio',0

dataseg
BufferSize=4096
NumBuffers=3

dataseg
Adapter=0 ; default
AmpMixer db 'Ampmix0','0'+Adapter,0
AmpOpenParms dd 0,0,offset(AmpMixer),0,0,0
MixerAllocParms dd 0,32,NumBuffers,BufferSize,0,0,0,offset(MixerBuffer1)
MixerSetupParms dd 0,BitsPerSample,FormatTag,SamplesPerSec,Channels,4,7,0,0,0,offset(SoundMixerEvent),0,BufferSize,NumBuffers

dataseg
FreeBuffers dd NumBuffers
MixerBuffer1 dd 0,0,0,0,offset(MixerBuffer2),0,0,0
MixerBuffer2 dd 0,0,0,0,offset(MixerBuffer3),0,0,0
MixerBuffer3 dd 0,0,0,0,offset(MixerBuffer1),0,0,0
MixerBuffer dd offset(MixerBuffer1)

udataseg
DartSem dd ?
FreeCnt dd ?

dataseg
sGood0 db 'started.',13,10
sGood1 db 'stopped.',13,10
sGood2 db 'waiting...',13,10
label sGood3 byte

dataseg
sInfo0 db ' opening ampmixer device',13,10
sInfo1 db ' informing dart being used',13,10
sInfo2 db ' allocating dart buffers',13,10
sInfo3 db ' creating event semaphore',13,10
sInfo4 db ' closing event semaphore',13,10
sInfo5 db ' deallocating dart buffers',13,10
sInfo6 db ' informing dart use ended',13,10
sInfo7 db ' closing ampmixer device',13,10
sInfo8 db ' setting ampmixer volume',13,10
label sInfo9 byte

dataseg
sTest0 db ' opening audio input pipe',13,10
sTest1 db ' reading audio input pipe',13,10
sTest2 db ' closing audio input pipe',13,10
label sTest3 byte

udataseg
AudioHeader db 36 dup(?)
ChunkHeader dd ?
ChunkLength dd ?

udataseg
ActionTaken dd ?
BytesDone dd ?
BytesRead dd ?
fhDevice dd ?
fhInput dd ?

codeseg
proc MainRoutine c near
arg @@Mod,@@Nul,@@Env,@@Arg
; determine begin of arguments
  cld ; operate foreward scan
  mov ecx,512 ; max scan length
  mov edi,[@@Arg] ; start address
  repne scasb ; find terminator
; process passed arguments
  call ProcessArguments
; show application started message
  call DosWrite c,1,offset(sGood0),sGood1-sGood0,offset(BytesDone)
; open pcm audio data input pipe
  call DosWrite c,1,offset(sTest0),sTest1-sTest0,offset(BytesDone)
  call DosOpen c,offset(szInput),offset(fhInput),offset(ActionTaken),0,0,1,01A0h,0
  call ShowReturnCode
  jnz NotPlaySound
label ReadHeaderR00 near
; read begin of riff/wave audio stream header
; call DosWrite c,1,offset(sTest1),sTest2-sTest1,offset(BytesDone)
  call DosRead c,[fhInput],offset(AudioHeader+0),1,offset(BytesDone)
  call ShowReturnCode
  jnz EndPlaySound
; verify start of header
  cmp [AudioHeader],'R'
  jne ReadHeaderR00
; read rest of riff/wave audio stream header
; call DosWrite c,1,offset(sTest1),sTest2-sTest1,offset(BytesDone)
  call DosRead c,[fhInput],offset(AudioHeader+1),35,offset(BytesDone)
  call ShowReturnCode
  jnz EndPlaySound
; verify proper header
  cmp [dword(AudioHeader+0)],'FFIR'
  jne ReadHeaderR00
  cmp [dword(AudioHeader+4)],0
  jne ReadHeaderR00
; update BitsPerSample value
  movzx eax,[word(AudioHeader)+34]
  mov [MixerSetupParms+1*4],eax
; update SamplesPerSec value
  mov eax,[dword(AudioHeader)+24]
  mov [MixerSetupParms+3*4],eax
; update AudioChannels value
  movzx eax,[word(AudioHeader)+22]
  mov [MixerSetupParms+4*4],eax
; register termination processing;
  call DosExitList c,1,offset(ProcessComplete)
; initialize sound device
  call SoundDeviceInit
; invoke sound processing
  call SoundProcessing
; force process complete
  sub eax,eax ; success
  ret ; uses exit list
label EndPlaySound near
; close pcm audio data input pipe
  call DosWrite c,1,offset(sTest2),sTest3-sTest2,offset(BytesDone)
  call DosClose c,[fhInput]
  call ShowReturnCode
label NotPlaySound near
; show application stopped message
  call DosWrite c,1,offset(sGood1),10,offset(BytesDone)
; exit the program
  call DosExit c,1,0
endp MainRoutine

codeseg
proc ProcessComplete c near
arg @@ReasonCode
; report reason code
; mov eax,[@@ReasonCode]
; call ShowReturnCode
; close pcm audio data input pipe
  call DosWrite c,1,offset(sTest2),sTest3-sTest2,offset(BytesDone)
  call DosClose c,[fhInput]
  call ShowReturnCode
; finalize sound device
  call SoundDeviceExit
; show application stopped message
  call DosWrite c,1,offset(sGood1),10,offset(BytesDone)
; exit termination process
  call DosExitList c,3,0)
endp ProcessComplete

codeseg
proc dec2bin near
; decimal to binary
  sub eax,eax ; input
  sub edx,edx ; output
label ConvertInput near
  inc edi ; next position
  mov al,[edi] ; digit
; convert decimal digit
  cmp al,'0' ; minimum
  jb Enddec2bin ; done
  cmp al,'9' ; maximum
  ja Enddec2bin ; done
  sub al,'0' ; digit
  lea edx,[edx*4+edx]
  lea edx,[edx*2+eax]
  jmp ConvertInput
label Enddec2bin Near
  ret ; return
endp dec2bin

codeseg
proc ProcessArguments near
; scan for forward slash
  mov al,[edi] ; character
  inc edi ; next position
  cmp al,00h ; terminator
  je EndScanString ; done
  cmp al,'/' ; parameter
  jne ProcessArguments
; adapter number
  cmp [byte(edi)],'a'
  jne NotAdapter
  call dec2bin ; convert
; verify adapter number
  cmp edx,8 ; maximum
  jna StoreAdapter
  mov edx,8 ; maximum
label StoreAdapter near
; store adapter number
  add dl,"0" ; ascii
  mov [AmpMixer+7],dl
  jmp ProcessArguments
label NotAdapter near
; amp mixer volume
  cmp [byte(edi)],'v'
  jne NotMixerVolume
  call dec2bin ; convert
; verify amp mixer volume
  cmp edx,100 ; maximum
  jna StoreMixerVolume
  mov edx,100 ; maximum
label StoreMixerVolume near
; store amp mixer volume
  mov [MixerVolume+4*4],edx
  jmp ProcessArguments
label NotMixerVolume near
  jmp ProcessArguments
label EndScanString near
; skip sanity checks
  ret ; return
endp ProcessArguments

dataseg
MciMessage db 128 dup(?)
Written dd ?

codeseg
proc ShowMultimediaMessage near
  test eax,eax ; skip success
  jz EndShowMultimediaMessage
  mov esi,offset(MciMessage)
  call MciGetErrorString c,eax,esi,127
; find end of error string
  sub eax,eax ; zero terminator
  mov ecx,127 ; MciMessage length
  mov edi,esi ; offset(MciMessage)
  repne scasb ; find terminator
; show multimedia message
  inc edi ; proper last position
  mov [word(edi)-2],0A0Dh ; append
  sub edi,esi ; message length
  call DosWrite c,1,esi,edi,offset(Written)
label EndShowMultimediaMessage near
  ret ; return
endp ShowMultimediaMessage

dataseg
hex2ascii db '0123456789ABCDEF'
szStatus db '[????????]',13,10

codeseg
proc ShowReturnCode near
; skip zero return code
  test eax,eax ; zero
  jz EndShowCode ; done
  push eax ; save register
; convert return code
  mov ecx,8 ; code length
label ConvertDigit near
  mov edx,eax ; error code
  and edx,0000000Fh ; digit
  mov dl,[hex2ascii+edx]
  mov [szStatus+ecx],dl
  shr eax,4 ; next one
  loop ConvertDigit
; show appropriate info message
  call DosWrite c,1,offset(szStatus),12,offset(BytesDone)
  pop eax ; restore register
  test eax,eax ; check
label EndShowCode near
  ret ; return
endp ShowReturnCode

codeseg
public SoundDeviceExit
proc SoundDeviceExit near
; close dart event semaphore
  call DosWrite c,1,offset(sInfo4),sInfo5-sInfo4,offset(BytesDone)
  call DosCloseEventSem c,[DartSem]
; deallocate dart communication buffers and wait
; 62=MCI_BUFFER,80002h=MCI_DEALLOCATE_MEMORY+MCI_WAIT
  call DosWrite c,1,offset(sInfo5),sInfo6-sInfo5,offset(BytesDone)
  call MciSendCommand c,[AmpOpenParms+04h],62,80002h,offset(MixerAllocParms),0
  call ShowMultimediaMessage
; inform ampmixer that dart is no longer used and wait
; 63=MCI_MIXSETUP,20002h=MCI_MIXSETUP_DEINIT+MCI_WAIT
  call DosWrite c,1,offset(sInfo6),sInfo7-sInfo6,offset(BytesDone)
  call MciSendCommand c,[AmpOpenParms+04h],63,20002h,offset(MixerSetupParms),0
  call ShowMultimediaMessage
; close the waveaudio device and wait
; 02=MCI_CLOSE,00002h=MCI_WAIT
  call DosWrite c,1,offset(sInfo7),sInfo8-sInfo7,offset(BytesDone)
  call MciSendCommand c,[AmpOpenParms+04h],02,00002h,offset(AmpOpenParms),0
  call ShowMultimediaMessage
  ret ; return
endp SoundDeviceExit

codeseg
public SoundDeviceInit
proc SoundDeviceInit near
; open the ampmixer device shared and wait
; 01=MCI_OPEN,02002h=MCI_OPEN_TYPE_ID+MCI_WAIT
  call DosWrite c,1,offset(sInfo0),sInfo1-sInfo0,offset(BytesDone)
  call MciSendCommand c,[AmpOpenParms+04h],01,02002h,offset(AmpOpenParms),0
  test eax,eax ; any error
  jnz MultimediaMessage
; inform ampmixer that dart is used and wait
; 63=MCI_MIXSETUP,10002h=MCI_MIXSETUP_INIT+MCI_WAIT
  call DosWrite c,1,offset(sInfo1),sInfo2-sInfo1,offset(BytesDone)
  call MciSendCommand c,[AmpOpenParms+04h],63,10002h,offset(MixerSetupParms),0
  test eax,eax ; any error
  jnz MultimediaMessage
; allocate dart communication buffers and wait
; 62=MCI_BUFFER,40002h=MCI_ALLOCATE_MEMORY+MCI_WAIT
  call DosWrite c,1,offset(sInfo2),sInfo3-sInfo2,offset(BytesDone)
  call MciSendCommand c,[AmpOpenParms+04h],62,40002h,offset(MixerAllocParms),0
  test eax,eax ; any error
  jnz MultimediaMessage
; create dart event semaphore
  call DosWrite c,1,offset(sInfo3),sInfo4-sInfo3,offset(BytesDone)
  call DosCreateEventSem c,0,offset(DartSem),1,0
  ret ; return
label MultimediaMessage near
; write multimedia error message
  call ShowMultimediaMessage
; exit the program
  call DosExit c,1,0
endp SoundDeviceInit

codeseg
proc SoundMixerEvent c near
arg @@Status,@@Buffer,@@Flags
; handle write complete condition
; cmp [@@Flags],02h ; write complete
; jne EndSoundMixerEvent ; other
; report mixer write completion
  call DosPostEventSem c,[DartSem]
label EndSoundMixerEvent near
  ret ; return
endp SoundMixerEvent

dataseg
MinVol=0 ; default
MixerVolume dd 0,0,0,0,MinVol,0,0,0

codeseg
proc SoundProcessing near
; set amplifier mixer volume
; 12=MCI_SET,80000h=MCI_SET_VOLUME,1000h=MCI_SET_AUDIO,2=MCI_WAIT
  call DosWrite c,1,offset(sInfo8),sInfo9-sInfo8,offset(BytesDone)
  call MciSendCommand c,[AmpOpenParms+04h],12,81002h,offset(MixerVolume),0
  call ShowMultimediaMessage
; foreground server priority
  call DosSetPriority c,2,4,10,0
label MixerBufferProcess near
; read wave/data audio stream header
; call DosWrite c,1,offset(sTest1),sTest2-sTest1,offset(BytesDone)
  call DosRead c,[fhInput],offset(ChunkHeader),8,offset(BytesDone)
  call ShowReturnCode
  jnz EndSoundProcess
; address first sample position
  mov edi,[MixerBuffer] ; current
  mov eax,[edi+4] ; buffer pointer
; read pcm audio chuck into buffer
  call DosRead c,[fhInput],eax,[ChunkLength],offset(BytesRead)
  call ShowReturnCode
  jnz EndSoundProcess
  mov eax,[ChunkLength]
  cmp eax,[BytesRead]
  jne EndSoundProcess
; write this filled mixer buffer
  mov [edi+8],eax ; buffer length
; 32=pmixWrite(PMIXERPROC) entry point
  call [MixerSetupParms+32] c,[MixerSetupParms+28],[MixerBuffer],1
  dec [FreeBuffers] ; buffer used
label UpdateCurrentFreeBuffers near
; update currently available mixer buffers
  call DosResetEventSem c,[DartSem],offset(FreeCnt)
  mov eax,[FreeCnt] ; buffers freed
  add [FreeBuffers],eax ; current
  jnz FillMixerBuffer ; available
; show application waiting message
; call DosWrite c,1,offset(sGood2),sGood3-sGood2,offset(BytesDone)
; await forever mixer buffer available
  call DosWaitEventSem c,[DartSem],-1
  call ShowReturnCode
  jnz EndSoundProcess
  jmp UpdateCurrentFreeBuffers
label FillMixerBuffer near
; address next mixer buffer
  mov eax,[MixerBuffer] ; last
  mov eax,[eax+16] ; user parms
  mov [MixerBuffer],eax ; next
  jmp MixerBufferProcess
label EndSoundProcess near
; hang in here for 3 seconds
  call DosSleep c,3000
  ret ; return
endp SoundProcessing

end MainRoutine
