/******************************************************************************
    GNU General Public License: WebCamApplet

    A Java applet suite for the display of images served from a web cam.

    Copyright (C) 2002 Paul Sidnell

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

package org.webcamapplet.tools;

import java.io.*;
import java.text.*;

/**
 * @author $Author: psidnell $
 * @version $Revision: 1.4 $
 * @since $Date: 2002/12/12 18:48:22 $
 *
 * Does various jobs related to renaming/subclassing to get around browser cacheing
 * of the applet class.
 *
 * It's a horrible hack and doesn't do anything I couldn't do with perl. However I
 * want it to build with just the JDK and ANT.
 */
public class BrowserCacheFixer
{
  public static final String APPLET_PATH = "/src/org/webcamapplet/";
  public static final String APPLET_NAME = "WebCamApplet";
  public static final String APPLET_PACKAGE = "org.webcamapplet";
  public static final String JAR = "webcamapplet";
 
  public static void main (String args[])
  {
    try
    {
      if (args.length >= 3 && args[0].equals ("subclass"))
      {
        String version = args[1];
        String versionSuffix = args[2];
        String baseDir = args[3];
        String subClassFileName = baseDir + APPLET_PATH + APPLET_NAME + versionSuffix + ".java";
        PrintWriter out = new  PrintWriter (new FileOutputStream (subClassFileName));
        out.println ("package " + APPLET_PACKAGE + ";");
        out.println ("/* THIS FILE IS AUTO GENERATED */");
        out.println ("public class " + APPLET_NAME + versionSuffix + " extends " + APPLET_NAME);
        out.println ("{");
        out.println ("  public String getVersion () { return \"" + version + "\"; }");
        out.println ("  public String getCompilationDate () { return \"" + new java.util.Date () +  "\"; }");
        out.println ("}");
        out.close ();
        System.out.println ("Generated " + subClassFileName);
      }
      else if (args.length >= 4 && args[0].equals ("html"))
      {
        String version = args[1];
        String versionSuffix = args[2];
        String baseDir = args[3];
        String fName = args[4];
        String htmlFileName = baseDir + "/" + fName;
        String archive = JAR + versionSuffix + ".jar";
        PrintWriter out = new  PrintWriter (new FileOutputStream (htmlFileName));
        out.println ("<html>");
        out.println ("<head>");
        out.println ("<title>Test HTML</title>");
        out.println ("<applet	code=\"" + APPLET_PACKAGE + "." + APPLET_NAME + versionSuffix + ".class\" archive=\"" + archive + "\" name=\"Applet1\" width=\"160\" height=\"140\"  VIEWASTEXT>");
        out.println ("<param name=width value=\"160\">");
        out.println ("<param name=height value=\"140\">");
        out.println ("<param name=labelHeight value=\"20\">");
        out.println ("<param name=delayMillis value=\"6000\">");
        out.println ("<param name=camRetrySecs value=\"20\">");
        out.println ("<param name=camviewLimitMins value=\"2\">");
        out.println ("<param name=\"labelReloadSecs\" value=\"3\">");
        out.println ("<param name=\"title\" value=\"Example 1\">");
        out.println ("<param name=onImage value=\"camview.jpg\">");
        out.println ("<param name=offImage value=\"offimage.jpg\">");
        out.println ("<param name=limitImage value=\"limitimage.jpg\">");
        out.println ("<param name=click value=\"http://webcamapplet.sourceforge.net/\">");
        out.println ("<param name=logging value=\"true\">");
        out.println ("</applet>");
        out.println ("<P>or try <B>appletviewer " + fName + "</B>");
        out.println ("</html>");
        out.close ();
      }
    }
    catch (Exception e)
    {
      e.printStackTrace ();
    }
  }
}
