/* Rexx */

Call RxFuncAdd 'GdLoadFuncs', 'rexxgd', 'GdLoadFuncs'
Call GdLoadFuncs

font = "GDFONTGIANT"

do forever

im = gdImageCreateFromJpeg("webcam1.jpg")

if im = '' then do
  say "FEHLER beim Laden ("im")"
  exit
end /* if */

white = gdImageColorClosest(im, 255, 255, 255) 
grey = gdImageColorClosest(im, 127, 127, 127) 
black = gdImageColorClosest(im, 0, 0, 0) 

/* String to draw. */
Datum0 = date('E')
Datum = left(Datum0,2)"."substr(Datum0,4,2)"."right(Datum0,2)
string = "Wiesbaden - "time()" - "Datum

/* Draw a centered string. */
/* Call gdImageString im, font, (gdImageGetWidth(im)%2)-(length(string)*gdFontGetWidth(font)%2)+1, gdImageGetHeight(im)-20+1, string, grey */
Call gdImageString im, font, (gdImageGetWidth(im)%2)-(length(string)*gdFontGetWidth(font)%2), gdImageGetHeight(im)-20, string, white


/* Get size of im_in and out_im for later use */
Faktor = 2
in_x = gdImageGetWidth(im)
in_y = gdImageGetHeight(im)
out_x = in_x * Faktor
out_y = in_y * Faktor

/* Make the output image four times as large on both axes */
im4 = gdImageCreate(out_x, out_y)
Call gdImageCopyResized im4, im, 0, 0, 0, 0, out_x, out_y, in_x, in_y

Call gdImageJpeg im, "webcam.jpg", -1
Call gdImageJpeg im4, "webcam4.jpg", -1
/* address cmd "copy webcam.jpg webcam0.jpg" */

/* Destroy image */
Call gdImageDestroy im
Call gdImageDestroy im4

end