/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Stefan Schultz (TUH / ACTS-MoMuSyS)
 *
 * and edited by
 * 
 *   Jan De Lameillieure (HHI / ACTS-MoMuSyS)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1996
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *
 * File:        text_quant_mpeg.h
 *
 * Author:      Stefan Schultz, TUH
 * Created:     May 11, 1996
 *
 * Description:
 *
 * Notes:
 *
 * Modified:
 *      31-JUL-96 Jan De Lameillieure (HHI) : changed #define _TEXT_QUANT_H_ to _TEXT_QUANT_MPEG_H_
                        (caused problems in decoder in case of MPEG-1/-2 like inverse quantisation)
 *
 ***********************************************************HeaderEnd*********/


#ifndef _TEXT_QUANT_MPEG_H_     /* modified by JDL 31-JUL-96 */
#define _TEXT_QUANT_MPEG_H_


#include "momusys.h"
#include "text_defs.h"
#include "text_quant_mpeg.p"


/* Required macros for MPEG quantization */


#define SET_QUANT_TYPE_SEL(status)      QuantizerTypeSelection(1,(status))
#define GET_QUANT_TYPE_SEL              QuantizerTypeSelection(0,0)

#define SET_QMAT_INTRA(val,pos)         QmatMaintenance(1,1,(val),(pos))
#define GET_QMAT_INTRA(pos)             QmatMaintenance(0,1,0,(pos))

#define SET_QMAT_NON_INTRA(val,pos)     QmatMaintenance(1,0,(val),(pos))
#define GET_QMAT_NON_INTRA(pos)         QmatMaintenance(0,0,0,(pos))

#if 0
static Int zz[64] = {0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,12,19,26,33,40,
                     48,41,34,27,20,13,6,7,14,21,28,35,42,49,56,57,50,43,36,
                     29,22,15,23,30,37,44,51,58,59,52,45,38,31,39,46,53,60,
                     61,54,47,55,62,63};
#endif

/* Default quantization matrices */

static Int qmat_intra_def[64]  =        {  8,16,16,16,16,16,16,16,
                                          16,16,16,16,16,16,16,16,
                                          16,16,16,16,16,16,16,16,
                                          16,16,16,16,16,16,16,16,
                                          16,16,16,16,16,16,16,16,
                                          16,16,16,16,16,16,16,16,
                                          16,16,16,16,16,16,16,16,
                                          16,16,16,16,16,16,16,16};

static Int qmat_non_intra_def[64]  =    { 16,16,16,16,16,16,16,16,
                                          16,16,16,16,16,16,16,16,
                                          16,16,16,16,16,16,16,16,
                                          16,16,16,16,16,16,16,16,
                                          16,16,16,16,16,16,16,16,
                                          16,16,16,16,16,16,16,16,
                                          16,16,16,16,16,16,16,16,
                                          16,16,16,16,16,16,16,16};


/* Special quantization matrices (put in your favourite ones here) */

static Int qmat_intra_spec[64] =        {  8,17,18,19,21,23,25,27,
                                          17,18,19,21,23,25,27,28,
                                          20,21,22,23,24,26,28,30,
                                          21,22,23,24,26,28,30,32,
                                          22,23,24,26,28,30,32,35,
                                          23,24,26,28,30,32,35,38,
                                          25,26,28,30,32,35,38,41,
                                          27,28,30,32,35,38,41,45};

static Int qmat_non_intra_spec[64] =    { 16,17,18,19,20,21,22,23,
                                          17,18,19,20,21,22,23,24,
                                          18,19,20,21,22,23,24,25,
                                          19,20,21,22,23,24,25,26,
                                          20,21,22,23,25,26,27,28,
                                          21,22,23,24,26,27,28,30,
                                          22,23,24,26,27,28,30,31,
                                          23,24,25,27,28,30,31,33};


#endif /* _TEXT_QUANT_H_ */
