/******************************************************************************
This software module was originally developed by

Zhixiong Wu			(sgo@hlabs.oki.co.jp),		Oki Electric Industry Co., Ltd.
Yoshihiro Ueda		(yueda@hlabs.oki.co.jp),	Oki Electric Industry Co., Ltd.
Toshifumi Kanamaru	(kanamaru@hlabs.oki.co.jp),	Oki Electric Industry Co., Ltd.

in the course of development of the MPEG-4 Visual (ISO/IEC 14496-2).This 
software module is an implementation of a part of one or more MPEG-4 Visual 
(ISO/IEC 14496-2) tools as specified by the MPEG-4 Visual (ISO/IEC 14496-2). 
ISO/IEC gives users of the MPEG-4 Visual (ISO/IEC 14496-2) free license to this
software module or modifications thereof for use in hardware or software products
claiming conformance to the MPEG-4 Visual (ISO/IEC 14496-2). Those intending to
use this software module in hardware or software products are advised that its
use may infringe existing patents. The original developer of this software module
and his/her company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof in an 
implementation. Copyright is not released for non MPEG-4 Visual (ISO/IEC 14496-2)
conforming products. OKI retains full right to use the code for his/her own
purpose, assign or donate the code to a third party and to inhibit third parties
from using the code for non MPEG-4 Visual (ISO/IEC 14496-2) conforming products.
This copyright notice must be included in all copies or derivative works.

Copyright (c) 1997-1998 Oki Electric Industry Co., Ltd.

******************************************************************************/
/* This code was obtained from Lehigh University/Vector Vision, Inc.. 
It was originally developed by OKI. 
Dr. Hongqiao Sun/Weiping integrated it to the Lehigh/VVI software. 

The copyrights or credits should belong to the following people and companies:

Zhixiong Wu and Yoshihiro Ueda of OKI,
Hongqiao Sun of Vector Vision,
Weiping Li of Lehigh University,

Minor modifications was made by Shipeng Li to integrated it to Sarnoff's SOL
software.
*/
#include <stdio.h>
#include <stdlib.h>
#include "momusys.h"
#include "ShapeUtil.h"

Void *
mymalloc(size_t size)
{
    Void *tmp;

    if ( (tmp=malloc(size))==NULL ) {
        fprintf(stderr,"Malloc error.\n");
        exit(1);
    }
    return(tmp);
}

UChar **
malloc_2d_char(Int d1,Int d2)
{
    UChar **array_2d;
    Int i;

    array_2d = (UChar **) mymalloc(d1*sizeof(UChar *));
    for ( i=0; i<d1; i++ ) {
        array_2d[i] = (UChar *) mymalloc(d2*sizeof(UChar));
    }
    return(array_2d);
}

Void
free_2d_char(UChar **array_2d,Int d1)
{
    Int i;

    for ( i=0; i<d1; i++ ) {
        free(array_2d[i]);
    }
    free(array_2d);
}

Int **
malloc_2d_int(Int d1,Int d2)
{
    Int **array_2d;
    Int i;

    array_2d = (Int **) mymalloc(d1*sizeof(Int *));
    for ( i=0; i<d1; i++ ) {
        array_2d[i] = (Int *) mymalloc(d2*sizeof(Int));
    }
    return(array_2d);
}

Void
free_2d_int(Int **array_2d,Int d1)
{
    Int i;

    for ( i=0; i<d1; i++ ) {
        free(array_2d[i]);
    }
    free(array_2d);
}
