/* $Id: read_control_file.c,v 1.14 1998/03/09 17:08:21 bchai Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was developed by                                         */
/*   Sarnoff Coporation                   and    Texas Instruments          */
/*   Iraj Sodagar   (iraj@sarnoff.com)           Jie Liang (liang@ti.com)   */
/*   Hung-Ju Lee    (hjlee@sarnoff.com)                                     */
/*   Paul Hatrack   (hatrack@sarnoff.com)                                   */
/*   Shipeng Li     (shipeng@sarnoff.com)                                   */
/*   Bing-Bing Chai (bchai@sarnoff.com)                                     */
/*                                                                          */
/* In the course of development of the MPEG-4 standard. This software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG memebers to use, copy, modify,             */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright (C) 1998  Sarnoff Coporation and Texas Instruments             */ 
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dataStruct.h"
#include "errorHandler.h"
#include "read_control_file.h"

extern Int STO_const_alpha;
extern UChar STO_const_alpha_value;

Void free_vm_param(SOL_PARAMETERS* vm_param)
{
  if (vm_param->ImagePath) free(vm_param->ImagePath);
  if (vm_param->SegPath) free(vm_param->SegPath);
  if (vm_param->bitFile) free(vm_param->bitFile);
  if (vm_param->singleBitFile==0)
    free(vm_param->bitFileAC);
  if (vm_param->SegImage) free(vm_param->SegImage);
  if (vm_param) free(vm_param);
}

Void free_vm_param_dec(SOL_PARAMETERS_DEC *vm_param_dec)
{
  if (vm_param_dec->bitFile) free(vm_param_dec->bitFile);
  if (vm_param_dec->singleBitFile==0)
    free(vm_param_dec->bitFileAC);
  if (vm_param_dec->SegImage) free(vm_param_dec->SegImage);
  if (vm_param_dec) free(vm_param_dec);
}

