/* $Id: seg.c,v 1.9 1998/03/06 20:03:09 hatrack Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was developed by                                         */
/*   Sarnoff Coporation                   and    Texas Instruments          */
/*   Iraj Sodagar   (iraj@sarnoff.com)           Jie Liang (liang@ti.com)   */
/*   Hung-Ju Lee    (hjlee@sarnoff.com)                                     */
/*   Paul Hatrack   (hatrack@sarnoff.com)                                   */
/*   Shipeng Li     (shipeng@sarnoff.com)                                   */
/*   Bing-Bing Chai (bchai@sarnoff.com)                                     */
/*                                                                          */
/* In the course of development of the MPEG-4 standard. This software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG memebers to use, copy, modify,             */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright (C) 1998  Sarnoff Coporation and Texas Instruments             */ 
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "dataStruct.h"  
#include "errorHandler.h"
#include "globals.h" 
#include "dwt.h"
#include "ShapeCodec.h"
#include "seg.h"

Int STO_const_alpha;
UChar STO_const_alpha_value;

Void get_virtual_image (PICTURE *myImage, Int wvtDecompLev, Int usemask, Int colors, Int alphaTH, 
		       Int change_CR_disable) 
{
  Int Nx[3], Ny[3];
  Int Width[3], Height[3], width[3], height[3];
  Int nLevels[3];
  UChar *inimage[3], *outimage[3];
  UChar *inmask[3], *outmask[3];
  Int ret,col;
  Int origin_x[3], origin_y[3];

  /* for 4:2:0 YUV image only */
  Nx[0] = Ny[0]=2;
  for(col=1; col<3; col++) Nx[col]=Ny[col]=1;


  Width[0] = myImage[0].width;
  Width[1] = Width[2] = (Width[0]+1)>>1;

  Height[0] = myImage[0].height;
  Height[1] = Height[2] = (Height[0]+1)>>1;

  nLevels[0] = wvtDecompLev ;
  nLevels[1] = nLevels[2] = nLevels[0]-1;
  
  Nx[0] = Ny[0]= 2;
  for(col=1;col<colors;col++)
    Nx[col]=Ny[col]=1;
  

  for (col=0; col<colors; col++) {
    
    inimage[col] = (UChar *)myImage[col].data; 
    inmask[col] = (UChar *)myImage[col].mask; 
      
    ret=GetBox(inimage[col], inmask[col],
	       (Void **)&outimage[col], &outmask[col],
	       Width[col], Height[col], Nx[col],Ny[col],
	       &width[col], &height[col], &origin_x[col], &origin_y[col],
	       0, 
	       usemask
	       ? ((STO_const_alpha) ? STO_const_alpha_value : MASK_VAL)
	       : VTC_RECTANGULAR, 
	       nLevels[col]
	       );
    
    if (ret!=DWT_OK) 
      errorHandler("DWT Error code = %d\n", ret);
    if(usemask) {
      if(col==0) { /* do shape coding */
	ShapeEnCoding(outmask[0], width[0], height[0], alphaTH, 
		      change_CR_disable);
      }
      else { /* obtain new quantized mask for other color components */
	SubsampleMask(outmask[0], outmask[col], width[0], 
		      height[0], 2, 2, 1);
      }
    }
    
    free(inimage[col]);
    myImage[col].data = outimage[col];
    myImage[col].mask = outmask[col];
    if (usemask) free(inmask[col]);
  }


  mzte_codec.width = width[0];
  mzte_codec.height = height[0];
  mzte_codec.origin_x = origin_x[0];
  mzte_codec.origin_y = origin_y[0];
  mzte_codec.real_width = Width[0];
  mzte_codec.real_height = Height[0];

}

Void get_virtual_mask(PICTURE *myImage,  Int wvtDecompLev,
		      Int w, Int h, Int usemask, Int colors) 
{
  Int width[3], height[3];
  Int Width[3], Height[3];
  Int nLevels[3];
  UChar *outmask[3], *tempmask;
  Int ret,col;
  Int Nx[3], Ny[3];
  Int origin_x[3], origin_y[3];

  /* for 4:2:0 YUV image only */
  Nx[0] = Ny[0]=2;
  for(col=1; col<3; col++) Nx[col]=Ny[col]=1;

  nLevels[0] = wvtDecompLev;
  nLevels[1] = nLevels[2] = nLevels[0]-1;
  Width[0]=/* myImage[0].width = */ w;
  Width[1]=Width[2]=/* myImage[1].width = myImage[2].width = */ (w+1)>>1;

  Height[0]=/* myImage[0].height = */ h;
  Height[1]=Height[2] =
    /* myImage[1].height = myImage[2].height= */ (h+1)>>1;
  for (col=0; col<colors; col++) {
    if (usemask) {
      outmask[col] = myImage[col].mask 
	=(UChar *)malloc(sizeof(UChar)*Width[col]*Height[col]);
      if(outmask[col]==NULL)
	errorHandler("Couldn't allocate memory to image\n");
      if(col==0) { /* get decoded shape of Y */
	ShapeDeCoding(outmask[0], Width[0], Height[0]);
	if((Width[0] &((1<<wvtDecompLev)-1))!=0 ||
	   (Height[0] &((1<<wvtDecompLev)-1))!=0 ) {
	  ret=ExtendMaskBox(outmask[0], &tempmask, Width[0], Height[0], 
			Nx[0], Ny[0], &width[0], &height[0],
			nLevels[0]);
	  if (ret!=DWT_OK) 
	    errorHandler("ExtendMaskBox: DWT Error code = %d\n", ret);
	  printf("width=%d height=%d\n", width[0], height[0]);
	  free(outmask[0]);
	  outmask[0]=tempmask;
	}
	else {
	  width[0] = Width[0];
	  height[0] = Height[0];
	}
      }
      else { /* subsample shape for U,V*/
	SubsampleMask(outmask[0], outmask[col], width[0], 
		      height[0], 2, 2, 1);
      }
    }
    else { /* extend rectangular size to multiples of 2^Levels */
      ret=GetMaskBox(NULL, &outmask[col], Width[col], Height[col], 
		     Nx[col], Ny[col], &width[col], &height[col], 
		     &origin_x[col], &origin_y[col], 
		     VTC_RECTANGULAR, nLevels[col]);
      
      if (ret!=DWT_OK) 
	errorHandler("GetMaskBox: DWT Error code = %d\n", ret);
    }
    myImage[col].mask = outmask[col];
  }

  if(!usemask) {

    mzte_codec.width = width[0];
    mzte_codec.height = height[0];
    mzte_codec.origin_x = origin_x[0];
    mzte_codec.origin_y = origin_y[0];
    mzte_codec.real_width = Width[0];
    mzte_codec.real_height = Height[0]; 
  }
  else {
    mzte_codec.width = width[0];
    mzte_codec.height = height[0];
  }
}

/*--------------------------------------------------------------------
  read_segimage()
  
  Return Values
  -------------
  0: full-frame  1: shape-adaptive
  
  Comments
  --------
  Exits program if error occurs.
  --------------------------------------------------------------------*/

Int read_segimage(Char *seg_path, Int seg_width, Int seg_height, 
		  Int img_colors, Int img_bit_depth,
		  PICTURE *image)
{
  File *infptr = NULL;
  Int  seg_size;
  Int wordsize = (img_bit_depth>8)?2:1;
  Int  status,col;
  UChar *inmask[3];

  if ((infptr = fopen(seg_path,"rb")) == NULL) { /* full-frame */
    image[0].mask = image[1].mask = image[2].mask = NULL;
    return (0);
  }
  

  seg_size = seg_width*seg_height; 

  for (col=0; col<img_colors; col++) {
    inmask[col] = (UChar *)malloc(sizeof(UChar)*
					  seg_width*seg_height);
    if(inmask[col]==NULL)
      errorHandler("Couldn't allocate memory to image\n");
  }

  /* Read image */
  if ((status=fread(inmask[0], sizeof(UChar)*wordsize, seg_size,
		    infptr))
       != seg_size)
    errorHandler("Error in reading image file: %s\n",seg_path);
  fclose(infptr);
  
  for (col=1; col<img_colors; col++) { 
    SubsampleMask(inmask[0], inmask[col], seg_width, 
		  seg_height, 2, 2, 
		  (STO_const_alpha)?STO_const_alpha_value:MASK_VAL);
  }
  
  for (col=0; col<img_colors; col++) 
      image[col].mask = inmask[col];

  return 1;
}
