/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Dietmar Zaig (Siemens AG / ACTS-MoMuSyS)
 *
 * and edited by
 * 
 *   Paulo Nunes (IST / ACTS-MoMuSyS)
 *   Fernando Jaureguizar (UPM / ACTS-MoMuSyS)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1996
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File:        mot_decode.h
 *
 * Author:      Dietmar Zaig (Siemens AG)
 *
 * Created:     12.03.96
 *                                                                         
 * Description: Data structures and defines used for motion decoding functions.
 *
 * Notes:       Based on tmndecode, (C) 1995 Telenor R&D.
 *
 * Modified:
 *      09.05.96 Paulo Nunes: Reformatted. New headers.
 *      18.09.96 F. Jaureguizar: Now new B_TRANSP and MB_TRANSP defines
 *               are in mot_util.h. And with one more parameter.
 *      16.06.97 Angel Pacheco: BORDER value no longer exists, it 
 *               is substituted by MBM_TRANSPARENT value (==2).
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#ifndef _GETMOTION_H_
#define _GETMOTION_H_

#include "momusys.h"
#include "vm_vlc_dec.h"
#include "mot_get_mvnum.h"
#include "mot_util.h"

/* For discriminating transparent, skipped and intra MB's in MB_decisions */
#define INTRA      0
#define ONEVEC     1
#define SKIPPED    6
/* #define BORDER  2 <-> substituted by MBM_TRANSPARENT */
#define FOURVEC    4

/* probably defined already ... */
#define PRED_INTRA       0
#define PRED_RESTR       1
#define PRED_NRES_NADV   2
#define PRED_NRES_ADV    3

/* some useful macros. To ease integration work, I've adapted them
   according to the macros used by motion encoding (see cvm.c)
*/

/* get 8x8 MV component */
#define BV(p,xdim,h,v,h2,v2) (p[(2*(v)+(v2))*(xdim)+2*(h)+(h2)])

/* private AND public function protoypes (public should be moved to general
   proto file 
*/
#include "mot_decode.p"

#endif /* ifndef _GETMOTION_H_ */
