/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

import net.sourceforge.dvb.projectx.audio.AudioFormat;

public class AudioFormatLPCM
extends AudioFormat {
    private int[] lpcm_frequency_index = new int[]{48000, 96000};
    private int[] lpcm_bps_index = new int[]{16, 20, 24, -1};

    public int compareHeader() {
        if (this.getLastChannel() != this.getChannel()) {
            return 1;
        }
        if (this.getLastSamplingFrequency() != this.getSamplingFrequency()) {
            return 2;
        }
        if (this.getLastSize() != this.getSize()) {
            return 3;
        }
        if (this.getLastEmphasis() != this.getEmphasis()) {
            return 4;
        }
        return 0;
    }

    public String displayHeader() {
        return "LPCM, DR-" + this.getLastEmphasis() + ", " + this.getLastChannel() + "-ch, " + this.getLastSamplingFrequency() + "Hz, " + this.getLastSize() + "bit, " + (double)this.getLastBitrate() / 1000.0 + "kbps";
    }

    public int parseHeader(byte[] byArray, int n) {
        this.setINTEL(true);
        this.setID(0xFF & byArray[n]);
        this.setPaddingBit((0xFF & byArray[n + 1]) << 8 | 0xFF & byArray[n + 2]);
        this.setLayer(0xFF & byArray[n + 3]);
        this.setProtectionBit(1);
        this.setPrivateBit(0);
        this.setCopyright(0);
        this.setOriginal(0);
        this.setSizeBase(0);
        this.setSize(this.lpcm_bps_index[3 & byArray[n + 4] >>> 6]);
        this.setSamplingFrequency(this.lpcm_frequency_index[1 & byArray[n + 4] >>> 4]);
        this.setChannel(1 + (7 & byArray[n + 4]));
        this.setEmphasis(0xFF & byArray[n + 5]);
        this.setMode(this.getChannel() * this.getSize() / 8);
        this.setBitrate(this.getChannel() * this.getSamplingFrequency() * this.getSize());
        if (this.getSize() < 1) {
            return -1;
        }
        this.setFrameTimeLength(90000.0 / (double)this.getSamplingFrequency());
        return 0;
    }

    public int parseNextHeader(byte[] byArray, int n) {
        this.setINTEL(true);
        this.setNextID(0xFF & byArray[n]);
        this.setNextPaddingBit((0xFF & byArray[n + 1]) << 8 | 0xFF & byArray[n + 2]);
        this.setNextLayer(0xFF & byArray[n + 3]);
        this.setNextProtectionBit(1);
        this.setNextPrivateBit(0);
        this.setNextCopyright(0);
        this.setNextOriginal(0);
        this.setNextSizeBase(0);
        this.setNextSize(this.lpcm_bps_index[3 & byArray[n + 4] >>> 6]);
        this.setNextSamplingFrequency(this.lpcm_frequency_index[1 & byArray[n + 4] >>> 4]);
        this.setNextChannel(1 + (7 & byArray[n + 4]));
        this.setNextEmphasis(0xFF & byArray[n + 5]);
        this.setNextMode(this.getNextChannel() * this.getNextSize() / 8);
        this.setNextBitrate(this.getNextChannel() * this.getNextSamplingFrequency() * this.getNextSize());
        if (this.getNextSize() < 1) {
            return -1;
        }
        this.setNextFrameTimeLength(90000.0 / (double)this.getNextSamplingFrequency());
        return 0;
    }
}

