/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.CheckBoxListener;
import net.sourceforge.dvb.projectx.gui.ColumnLayout;
import net.sourceforge.dvb.projectx.gui.ComboBoxIndexListener;
import net.sourceforge.dvb.projectx.gui.ComboBoxItemListener;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.gui.HexViewer;
import net.sourceforge.dvb.projectx.gui.TextFieldKeyListener;
import net.sourceforge.dvb.projectx.gui.TextFieldListener;
import net.sourceforge.dvb.projectx.gui.UISwitchListener;
import net.sourceforge.dvb.projectx.parser.StripAudio;
import net.sourceforge.dvb.projectx.parser.StripMedion;
import net.sourceforge.dvb.projectx.parser.StripRelook;
import net.sourceforge.dvb.projectx.video.Preview;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class FileProperties
extends JFrame {
    private String title = Resource.getString("General.FileProperties");
    private ComboBoxIndexListener _ComboBoxIndexListener = new ComboBoxIndexListener();
    private ComboBoxItemListener _ComboBoxItemListener = new ComboBoxItemListener();
    private CheckBoxListener _CheckBoxListener = new CheckBoxListener();
    private TextFieldListener _TextFieldListener = new TextFieldListener();
    private TextFieldKeyListener _TextFieldKeyListener = new TextFieldKeyListener();
    private XInputFile inputfile = null;
    private JTextArea area = null;
    private JLabel length = null;
    private JSlider slider = null;
    private View view;
    private Color bg_color = new Color(0, 150, 0);
    private int loadSizeForward = 1024000;
    private int collection_number = 0;
    private int collection_index = 0;
    private int tmp_value = 0;
    private boolean silent = false;
    private Preview Preview = new Preview(this.loadSizeForward);
    private ActionListener _MenuListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("rename")) {
                try {
                    if (FileProperties.this.inputfile.rename()) {
                        FileProperties.this.scanFile();
                        Common.getGuiInterface().showActiveCollection(FileProperties.this.collection_number);
                    }
                    FileProperties.this.toFront();
                }
                catch (IOException iOException) {}
            } else if (string.equals("changeTimestamp")) {
                if (CommonGui.getUserConfirmation("really update the timestamp of '" + FileProperties.this.inputfile.getName() + "' ?")) {
                    FileProperties.this.inputfile.setLastModified();
                    FileProperties.this.scanFile();
                    Common.getGuiInterface().showActiveCollection(FileProperties.this.collection_number);
                }
                FileProperties.this.toFront();
            } else if (string.equals("viewAsHex")) {
                if (FileProperties.this.inputfile.exists()) {
                    new HexViewer().view(FileProperties.this.inputfile.getNewInstance());
                }
            } else if (string.equals("editBasics")) {
                if (CommonGui.getPatchDialog().entry(FileProperties.this.inputfile)) {
                    FileProperties.this.scanFile();
                    Common.getGuiInterface().showActiveCollection(FileProperties.this.collection_number);
                }
                FileProperties.this.toFront();
            } else if (string.equals("assignStreamtype")) {
                Object[] objectArray = Keys.ITEMS_FileTypes;
                String string2 = ((JMenuItem)actionEvent.getSource()).getText();
                int n = 0;
                while (n < objectArray.length) {
                    if (string2.equals(objectArray[n].toString())) {
                        FileProperties.this.inputfile.getStreamInfo().setStreamType(n);
                        FileProperties.this.scanSpecFileType(n);
                        Common.getGuiInterface().showActiveCollection(FileProperties.this.collection_number);
                        return;
                    }
                    ++n;
                }
                FileProperties.this.scanFile();
                Common.getGuiInterface().showActiveCollection(FileProperties.this.collection_number);
            } else if (string.equals("stripRelook")) {
                this.stripRelook(0);
            } else if (string.equals("stripRelook1")) {
                this.stripRelook(1);
            } else if (string.equals("stripMedion")) {
                this.stripMedion();
            } else if (string.equals("stripAudio")) {
                if (FileProperties.this.inputfile.exists() && FileProperties.this.inputfile.getStreamInfo().getStreamType() == 14 && CommonGui.getUserConfirmation("really process '" + FileProperties.this.inputfile.getName() + "' ?")) {
                    StripAudio stripAudio = new StripAudio();
                    Common.setOSDMessage("strip audio data...");
                    XInputFile xInputFile = stripAudio.process(FileProperties.this.inputfile);
                    JobCollection jobCollection = Common.getCollection(FileProperties.this.collection_number);
                    if (xInputFile != null) {
                        jobCollection.removeInputFile(FileProperties.this.collection_index);
                        jobCollection.addInputFile(FileProperties.this.collection_index, xInputFile);
                        Common.getGuiInterface().showActiveCollection(FileProperties.this.collection_number);
                    }
                }
                FileProperties.this.toFront();
            }
        }

        private void stripMedion() {
            if (FileProperties.this.inputfile.exists() && FileProperties.this.inputfile.getStreamInfo().getStreamType() == 1 && CommonGui.getUserConfirmation("really process '" + FileProperties.this.inputfile.getName() + "' ?")) {
                StripMedion stripMedion = new StripMedion();
                Common.setOSDMessage("strip Medion\u00ae data...");
                JobCollection jobCollection = Common.getCollection(FileProperties.this.collection_number);
                XInputFile[] xInputFileArray = stripMedion.process(FileProperties.this.inputfile.getNewInstance(), jobCollection.getOutputDirectory());
                if (xInputFileArray != null) {
                    jobCollection.removeInputFile(FileProperties.this.collection_index);
                    int n = 0;
                    int n2 = FileProperties.this.collection_index;
                    while (n < xInputFileArray.length) {
                        if (xInputFileArray[n] != null) {
                            jobCollection.addInputFile(n2++, xInputFileArray[n]);
                        }
                        ++n;
                    }
                    Common.getGuiInterface().showActiveCollection(FileProperties.this.collection_number);
                }
            }
            FileProperties.this.toFront();
        }

        private void stripRelook(int n) {
            if (FileProperties.this.inputfile.exists() && FileProperties.this.inputfile.getStreamInfo().getStreamType() == 1 && CommonGui.getUserConfirmation("really process '" + FileProperties.this.inputfile.getName() + "' ?")) {
                StripRelook stripRelook = new StripRelook(n);
                Common.setOSDMessage("strip Relook\u00ae data, type " + n + "...");
                JobCollection jobCollection = Common.getCollection(FileProperties.this.collection_number);
                XInputFile[] xInputFileArray = stripRelook.process(FileProperties.this.inputfile.getNewInstance(), jobCollection.getOutputDirectory());
                if (xInputFileArray != null) {
                    jobCollection.removeInputFile(FileProperties.this.collection_index);
                    int n2 = 0;
                    int n3 = FileProperties.this.collection_index;
                    while (n2 < xInputFileArray.length) {
                        if (xInputFileArray[n2] != null) {
                            jobCollection.addInputFile(n3++, xInputFileArray[n2]);
                        }
                        ++n2;
                    }
                    Common.getGuiInterface().showActiveCollection(FileProperties.this.collection_number);
                }
            }
            FileProperties.this.toFront();
        }
    };

    public FileProperties() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FileProperties.this.close();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.buildMenu();
        jPanel.add(this.buildMainPanel());
        this.getContentPane().add(jPanel);
        this.setTitle(this.title);
        ((Component)this).setBounds(200, 100, 660, 360);
        this.setResizable(false);
        UIManager.addPropertyChangeListener(new UISwitchListener(this.getRootPane()));
    }

    protected JMenu buildEditMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.Edit");
        JMenuItem jMenuItem = new JMenuItem(Resource.getString("popup.changeTimestamp"));
        jMenuItem.setActionCommand("changeTimestamp");
        JMenuItem jMenuItem2 = new JMenuItem(Resource.getString("popup.patchbasics"));
        jMenuItem2.setActionCommand("editBasics");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenu.add(jMenuItem2);
        jMenuItem.addActionListener(this._MenuListener);
        jMenuItem2.addActionListener(this._MenuListener);
        return jMenu;
    }

    protected JMenu buildFileMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.File");
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem();
        CommonGui.localize(jMenuItem, "Common.Close");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileProperties.this.close();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(Resource.getString("popup.rename"));
        jMenuItem2.setActionCommand("rename");
        JMenuItem jMenuItem3 = new JMenuItem(Resource.getString("popup.openhex"));
        jMenuItem3.setActionCommand("viewAsHex");
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        jMenu.add(jMenuItem);
        jMenuItem2.addActionListener(this._MenuListener);
        jMenuItem3.addActionListener(this._MenuListener);
        return jMenu;
    }

    protected JPanel buildMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new ColumnLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Preview"));
        this.view = new View();
        jPanel2.add(this.view);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 5)));
        this.slider = new JSlider();
        this.slider.setPreferredSize(new Dimension(160, 30));
        this.slider.setMaximumSize(new Dimension(160, 30));
        this.slider.setMinimumSize(new Dimension(160, 30));
        this.slider.setMaximum(100);
        this.slider.setValue(0);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (!FileProperties.this.silent) {
                    FileProperties.this.scanFile(32L * (long)FileProperties.this.slider.getValue());
                }
            }
        });
        jPanel2.add(this.slider);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 5)));
        this.length = new JLabel("ScanPos: ");
        jPanel2.add(this.length);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new ColumnLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder("File Info"));
        this.area = new JTextArea();
        this.area.setEditable(true);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(460, 280));
        jScrollPane.setMaximumSize(new Dimension(460, 280));
        jScrollPane.setMinimumSize(new Dimension(460, 280));
        jScrollPane.setViewportView(this.area);
        JViewport jViewport = jScrollPane.getViewport();
        jPanel3.add(jScrollPane);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    protected void buildMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.buildFileMenu());
        jMenuBar.add(this.buildEditMenu());
        jMenuBar.add(this.buildPreprocessMenu());
        jMenuBar.add(this.buildStreamMenu());
        this.setJMenuBar(jMenuBar);
    }

    protected JMenu buildPreprocessMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.Preprocess");
        JMenuItem jMenuItem = new JMenuItem(Resource.getString("popup.fixHpAc3"));
        jMenuItem.setActionCommand("fixHpAc3");
        JMenuItem jMenuItem2 = new JMenuItem(Resource.getString("popup.stripAudio"));
        jMenuItem2.setActionCommand("stripAudio");
        JMenuItem jMenuItem3 = new JMenuItem("strip Relook\u00ae type 0 to separate pes..");
        jMenuItem3.setActionCommand("stripRelook");
        JMenuItem jMenuItem4 = new JMenuItem("strip Relook\u00ae type 1 to separate pes..");
        jMenuItem4.setActionCommand("stripRelook1");
        JMenuItem jMenuItem5 = new JMenuItem("strip Medion\u00ae to separate pes..");
        jMenuItem5.setActionCommand("stripMedion");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        jMenu.add(jMenuItem3);
        jMenu.add(jMenuItem4);
        jMenu.addSeparator();
        jMenu.add(jMenuItem5);
        jMenuItem.addActionListener(this._MenuListener);
        jMenuItem2.addActionListener(this._MenuListener);
        jMenuItem3.addActionListener(this._MenuListener);
        jMenuItem4.addActionListener(this._MenuListener);
        jMenuItem5.addActionListener(this._MenuListener);
        return jMenu;
    }

    protected JMenu buildStreamMenu() {
        JMenu jMenu = new JMenu(Resource.getString("popup.assignStreamType"));
        Object[] objectArray = Keys.ITEMS_FileTypes;
        int n = 0;
        while (n <= objectArray.length) {
            JMenuItem jMenuItem = new JMenuItem(n == objectArray.length ? Resource.getString("popup.automatic") : objectArray[n].toString());
            jMenuItem.setActionCommand("assignStreamtype");
            jMenuItem.addActionListener(this._MenuListener);
            if (n == objectArray.length) {
                jMenu.addSeparator();
            }
            jMenu.add(jMenuItem);
            ++n;
        }
        return jMenu;
    }

    public void close() {
        this.inputfile = null;
        Common.getGuiInterface().showActiveCollection(this.collection_number);
        this.dispose();
    }

    public void open(XInputFile xInputFile, int n, int n2) {
        this.collection_number = n;
        this.collection_index = n2;
        this.inputfile = xInputFile;
        this.silent = true;
        this.slider.setMaximum((int)(this.inputfile.length() / 32L));
        this.silent = false;
        this.tmp_value = (int)(this.inputfile.getStreamInfo().getScanPosition() / 32L);
        if (this.tmp_value != this.slider.getValue()) {
            this.slider.setValue(this.tmp_value);
        } else {
            this.scanFile();
        }
        this.show();
    }

    private void previewFile(long l) {
        switch (this.inputfile.getStreamInfo().getStreamType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                long l2 = this.Preview.previewFile(this.inputfile, l, this.loadSizeForward, Common.getSettings().getBooleanProperty(Keys.KEY_Preview_AllGops), Common.getSettings().getBooleanProperty(Keys.KEY_Preview_fastDecode), Common.getSettings().getIntProperty(Keys.KEY_Preview_YGain));
                this.view.setImage(Common.getMpvDecoderClass().getScaledCutImage());
                break;
            }
            case 6: 
            case 7: {
                this.view.setImage("PES Audio");
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.view.setImage("RAW Audio");
                break;
            }
            case 16: {
                this.view.setImage("RAW Subpicture");
                break;
            }
            default: {
                this.view.setImage("Unknown");
            }
        }
    }

    private void scanFile() {
        this.setPanelTitle();
        this.scanFile(this.inputfile.getStreamInfo().getScanPosition());
    }

    private void scanFile(long l) {
        this.setPosInfo(l);
        Common.getScanClass().getStreamInfo(this.inputfile, l);
        this.setFileInfo();
        this.previewFile(l);
    }

    private void scanSpecFileType(int n) {
        long l = this.inputfile.getStreamInfo().getScanPosition();
        this.setPosInfo(l);
        Common.getScanClass().getStreamInfo(this.inputfile, l, n);
        this.setFileInfo();
        this.previewFile(l);
    }

    private void setFileInfo() {
        this.area.setText(this.inputfile.getStreamInfo().getFullInfo());
    }

    private void setPanelTitle() {
        this.setTitle(String.valueOf(this.title) + ": ID " + this.inputfile.getFileID() + " - '" + this.inputfile.getName() + "'");
    }

    private void setPosInfo(long l) {
        this.inputfile.getStreamInfo().setScanPosition(l);
        this.length.setText("ScanPos: " + Common.formatNumber(l));
    }

    private class View
    extends JPanel {
        private int width = 160;
        private int height = 90;
        private Image image;
        private MemoryImageSource source;
        private int[] image_data = new int[this.width * this.height];
        private String alternative = "";

        public View() {
            this.source = new MemoryImageSource(this.width, this.height, this.image_data, 0, this.width);
            this.source.setAnimated(true);
            this.image = this.createImage(this.source);
            this.setPreferredSize(new Dimension(160, 90));
            this.setMaximumSize(new Dimension(160, 90));
            this.setMinimumSize(new Dimension(160, 90));
            this.setBackground(Color.black);
        }

        public void paint(Graphics graphics) {
            graphics.setColor(FileProperties.this.bg_color);
            graphics.fillRect(0, 0, 160, 90);
            graphics.drawImage(this.image, 0, 0, this);
            graphics.setColor(Color.white);
            graphics.drawString(this.alternative, 10, 30);
        }

        public void setImage(String string) {
            this.alternative = string;
            Arrays.fill(this.image_data, 0);
            this.source.newPixels();
            this.repaint();
        }

        public void setImage(int[] nArray) {
            this.alternative = "";
            System.arraycopy(nArray, 0, this.image_data, 0, nArray.length);
            FileProperties.this.inputfile.getStreamInfo().setThumbnail(this.image_data);
            this.source.newPixels();
            this.repaint();
        }
    }
}

