/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.gui.UISwitchListener;

public class PlayerFrame
extends JFrame {
    String title = "Player";
    private Picture picture;
    private int width = 0;
    private int height = 0;
    private int x = 200;
    private int y = 100;

    public PlayerFrame() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PlayerFrame.this.close();
            }
        });
        this.buildMenu();
        this.picture = new Picture();
        this.getContentPane().add("Center", this.picture);
        this.setTitle(this.title);
        ((Component)this).setLocation(this.x, this.y);
        this.setBounds2(this.width, this.height);
        this.setResizable(false);
        UIManager.addPropertyChangeListener(new UISwitchListener(this.getRootPane()));
    }

    protected JMenu buildFileMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.File");
        JMenuItem jMenuItem = new JMenuItem();
        CommonGui.localize(jMenuItem, "Common.Close");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlayerFrame.this.close();
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    protected void buildMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.buildFileMenu());
        this.setJMenuBar(jMenuBar);
    }

    public void close() {
        this.dispose();
    }

    public void repaintPicture() {
        this.repaintPicture(0);
    }

    public void repaintPicture(int n) {
        if (!this.isVisible()) {
            if (n == 1) {
                return;
            }
            ((Component)this).setVisible(true);
            this.toFront();
        }
        int n2 = Common.getMpvDecoderClass().getWidth();
        int n3 = Common.getMpvDecoderClass().getHeight();
        if (n2 != this.width || n3 != this.height) {
            this.width = n2;
            this.height = n3;
            this.setBounds2(this.width, this.height);
            this.picture.setSize();
        }
        this.picture.updateImage();
    }

    public void setBounds2(int n, int n2) {
        ((Component)this).setBounds(this.getX(), this.getY(), n + 6, n2 + 45);
        this.setFrameTitle("    " + n + " * " + n2);
    }

    public void setFrameTitle(String string) {
        this.setTitle(String.valueOf(this.title) + " " + string);
    }

    public class Picture
    extends JPanel {
        private MemoryImageSource source;
        private Image image;
        private int[] image_data;

        public Picture() {
            this.setBackground(Color.gray);
            this.setSize();
        }

        private int YUVtoRGB(int n) {
            int n2 = 255;
            int n3 = 0xFF & n >>> 16;
            int n4 = 0xFF & n >>> 8;
            int n5 = 0xFF & n;
            if (n3 == 0) {
                return -16777216;
            }
            int n6 = (int)((float)n3 + 1.402f * (float)(n5 - 128));
            int n7 = (int)((double)n3 - 0.34414 * (double)(n4 - 128) - 0.71414 * (double)(n5 - 128));
            int n8 = (int)((double)n3 + 1.722 * (double)(n4 - 128));
            int n9 = n6 < 0 ? 0 : (n6 = n6 > 255 ? 255 : n6);
            int n10 = n7 < 0 ? 0 : (n7 = n7 > 255 ? 255 : n7);
            n8 = n8 < 0 ? 0 : (n8 > 255 ? 255 : n8);
            return n2 << 24 | n6 << 16 | n7 << 8 | n8;
        }

        public void paint(Graphics graphics) {
            if (this.image != null) {
                graphics.drawImage(this.image, 0, 0, this);
            }
        }

        public void setSize() {
            this.setPreferredSize(new Dimension(PlayerFrame.this.width, PlayerFrame.this.height));
            this.setMinimumSize(new Dimension(PlayerFrame.this.width, PlayerFrame.this.height));
            this.setMaximumSize(new Dimension(PlayerFrame.this.width, PlayerFrame.this.height));
            this.image_data = new int[PlayerFrame.this.width * PlayerFrame.this.height];
            this.source = new MemoryImageSource(PlayerFrame.this.width, PlayerFrame.this.height, this.image_data, 0, PlayerFrame.this.width);
            this.source.setAnimated(true);
            this.image = this.createImage(this.source);
        }

        public void updateImage() {
            int[] nArray = Common.getMpvDecoderClass().getPixels();
            int n = 0;
            int n2 = this.image_data.length;
            while (n < n2) {
                this.image_data[n] = this.YUVtoRGB(nArray[n]);
                ++n;
            }
            this.source.newPixels();
        }
    }
}

