/*
 *
 *  Shark MP4 Converter
 *
 *  (C) by David Horvath 2010
 *  License: GPL3 or higher
 */

#include "sharkdialog.h"
#include "ui_sharkdialog.h"
#include <QFileDialog>
#include <QFile>
#include <QTextStream>
#include <QDir>
#include "sharkabout.h"
#include "sharkurl.h"
#include "ui_sharkurl.h"

QString filename, foldername, foldernameo, fileN;
QStringList flist, plist;
QDir dir;
int fln;



sharkDialog::sharkDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::sharkDialog)
{
    ui->setupUi(this);
    QFile fio(".sharkmp4.conf");
    fio.open(QIODevice::ReadOnly | QIODevice::Text);
    QTextStream in(&fio);
    QString inin = in.readAll();
    ui->cres->setCurrentIndex(inin.toInt(0,10));
    fio.close();
}

sharkDialog::~sharkDialog()
{
    delete ui;
}

void sharkDialog::on_bfile_clicked()
{
            QFileDialog filed;
             filename = filed.getOpenFileName(this, tr("Open File"),
                                              "/home",
                                              tr("Videos (*.avi *.mpg *.mpeg *.mov *.3gp *.wmv *.flv)"));
             ui->list->addItem(QDir::toNativeSeparators(filename));
}



void sharkDialog::on_bfolder_clicked()
{
    QFileDialog folderd;
    folderd.setFileMode(QFileDialog::Directory);
    foldername = folderd.getExistingDirectory(this,"Select folder", "/home", QFileDialog::ShowDirsOnly);
    dir.setPath(foldername);
    QStringList filters;
         filters << "*.mpg" << "*.avi" << "*.mpeg" << "*.mov" << "*.3gp" << "*.wmv" << "*.flv";
    if (!foldername.isEmpty()){
        flist = dir.entryList(filters, QDir::Files,QDir::NoSort);
        fln = flist.count();

        int x = 0;
        while (x<fln) {
            flist[x] = QDir::toNativeSeparators(foldername + "/") + flist[x];
            x++;
        }
        ui->list->addItems(flist);
    }
}

void sharkDialog::on_bofolder_clicked()
{
    QFileDialog folderc;
    folderc.setFileMode(QFileDialog::Directory);
    foldernameo = folderc.getExistingDirectory(this,"Select folder", "/home", QFileDialog::ShowDirsOnly);
    ui->efolder->setText(QDir::toNativeSeparators(foldernameo + "/"));
}

void sharkDialog::on_bconvert_clicked()
{
    connect (&p, SIGNAL(readyReadStandardOutput()),this, SLOT(outputCommand()));
    ui->bconvert->setEnabled(false);
    ui->bfile->setEnabled(false);
    ui->bfolder->setEnabled(false);
    ui->bofolder->setEnabled(false);
    ui->cres->setEnabled(false);
    ui->efolder->setEnabled(false);
    ui->list->setEnabled(false);
    ui->bclear->setEnabled(false);
    ui->bdel->setEnabled(false);
    ui->babout->setEnabled(false);
    ui->bexit->setEnabled(false);
    ui->bsave->setEnabled(false);
    ui->baddurl->setEnabled(false);
    QListWidgetItem *li;
    int itemnr;
    itemnr = ui->list->count();
    int x = 0;
    QString nopath;
    int npn;
    QString res = ui->cres->currentText();
    res = res.replace("x",":");
    while (x < itemnr) {
        ui->list->setCurrentRow(x);
        li = ui->list->item(x);
        nopath = li->text();
        npn = nopath.lastIndexOf(QDir::toNativeSeparators("/"),-1,Qt::CaseInsensitive) + 1;
        nopath = nopath.remove(0, npn);
        npn = nopath.lastIndexOf(".",-1,Qt::CaseInsensitive);
        nopath = nopath.remove(npn, nopath.count()-npn);
        p.start("mencoder -oac lavc -ovc lavc -of lavf -lavcopts aglobal=1:vglobal=1:vcodec=mpeg4:acodec=libfaac:vbitrate=256:abitrate=96 -lavfopts format=mp4 -ofps 25 -vf scale=" + res + ",harddup -o " + ui->efolder->text() + nopath + ".mp4 " + li->text());
        p.waitForFinished(-1);
        x++;
        ui->list->clearSelection();
        }
        ui->bconvert->setEnabled(true);
        ui->bfile->setEnabled(true);
        ui->bfolder->setEnabled(true);
        ui->bofolder->setEnabled(true);
        ui->cres->setEnabled(true);
        ui->efolder->setEnabled(true);
        ui->list->setEnabled(true);
        ui->bclear->setEnabled(true);
        ui->bdel->setEnabled(true);
        ui->babout->setEnabled(true);
        ui->bexit->setEnabled(true);
        ui->bsave->setEnabled(true);
        ui->baddurl->setEnabled(true);
        disconnect(&p, SIGNAL(readyReadStandardOutput()),this, SLOT(outputCommand()));
}

void sharkDialog::outputCommand()
{
    QByteArray cmdoutput = p.readAllStandardOutput();
    QString txtoutput = cmdoutput;
    int pos1, pos2, c;

    if (txtoutput.indexOf("Pos") > -1){
    pos1 = txtoutput.indexOf("(");
    pos2 = txtoutput.indexOf("%");
    c = txtoutput.count();
    txtoutput = txtoutput.remove(pos2, c-pos2);
    txtoutput = txtoutput.remove(0,pos1+1);

    ui->progress->setValue(txtoutput.toInt(0, 10));
    }

}

void sharkDialog::on_bexit_clicked()
{
    sharkDialog::destroy();
}

void sharkDialog::on_babout_clicked()
{
    sharkAbout sa;
    sa.exec();
}

void sharkDialog::on_bsave_clicked()
{
    QFile fio(".sharkmp4.conf");
    fio.open(QIODevice::WriteOnly | QIODevice::Text);
    QTextStream out(&fio);
    out << ui->cres->currentIndex();
    fio.close();
}

void sharkDialog::on_bdel_clicked()
{
    ui->list->takeItem(ui->list->currentRow());
}

void sharkDialog::on_baddurl_clicked()
{
    sharkUrl su;
    su.exec();
    if (su.urldata != ""){
       ui->list->addItem(su.urldata);
    }

}
