/* Install.cmd: Script to install Account Manager      */
/*                                                     */
/*      Mario Sebastiani -*- pippo_2@libero.it         */
/*                                                     */
/* Last update: 20 Aug 2000                            */

/* Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

'@ECHO OFF'
CurDir = directory()


cls

say "Choose your language - Scegli la lingua"
say " "
say "Press (E) to select English"
say "Premi (I) per selezionare l'Italiano"
say " "
say "Press (X) to exit - Premere (X) per uscire"
parse upper pull Risposta


if Risposta = "X" then exit 0
if Risposta = "I" then lang="-ita" else lang="-eng"

/* if already exist, delete */
call SysDestroyObject '<ACCMGR_FOLDER>'
call SysDestroyObject '<ACCMGR_PROG>'
call SysDestroyObject '<ACCMGR_README>'
call SysDestroyObject '<ACCMGR_MANUAL>'


classname='WPFolder'
title='Account Manager'
location='<WP_DESKTOP>'
setup='OBJECTID=<ACCMGR_FOLDER>;ALWAYSSORT=YES;ICONFILE='||CurDir||'\folder1.ico;ICONNFILE=1,'||CurDir||'\folder2.ico'
Call BldObj


classname='WPProgram'
title='Account Manager'
location='<ACCMGR_FOLDER>'
if Risposta = "I" then
setup='PROGTYPE=PM;EXENAME='||CurDir||'\accmgr.exe;PARAMETERS=-ita;OBJECTID=<ACCMGR_PROG>;ICONFILE='||CurDir||'\am.ico'
else
setup='PROGTYPE=PM;EXENAME='||CurDir||'\accmgr.exe;PARAMETERS=-eng;OBJECTID=<ACCMGR_PROG>;ICONFILE='||CurDir||'\am.ico'
Call BldObj
say ''
if Risposta = "I" then say "E' normale che qui sopra ci siano due righe uguali"
else say "It's OK that above there are 2 identical row"
say ''

if Risposta = "I" then 
do 
  classname='WPProgram'
  title='Leggimi'
  location='<ACCMGR_FOLDER>'
  setup='TYPE=PM;EXENAME=E.EXE;PARAMETERS='||CurDir||'\leggimi.txt;OBJECTID = <ACCMGR_README>'
  Call BldObj
end /* do */   
else
do
  classname='WPProgram'
  title='Read Me'
  location='<ACCMGR_FOLDER>'
  setup='TYPE=PM;EXENAME=E.EXE;PARAMETERS='||CurDir||'\readme.txt;OBJECTID=<ACCMGR_README>'
  Call BldObj
end /* do */
  
if Risposta = "I" then 
call charout ,"Sto creando un collegamento della directory " CurDir
else
call charout ,"I'm making a shadow copy of directory " CurDir

result = SysCreateShadow(CurDir, '<ACCMGR_FOLDER>')

if Risposta = "I" then 
do
  If result=1 Then call charout ,'...   Oggetto creato'
  Else             call charout ,'...   Oggetto NON creato! Errore ='result
end /* do */
else
do
  If result=1 Then call charout ,'...   Object created'
  Else             call charout ,'...   Object NOT created! Result ='result
end /* do */
say ' ';


classname='WPProgram'
if Risposta = "I" then
    title="Manuale"
else
    title='Manual'

location='<ACCMGR_FOLDER>'
setup='PROGTYPE=PM;EXENAME=view.exe;PARAMETERS='||CurDir||'\accmgr.inf;OBJECTID=<ACCMGR_MANUAL>'
Call BldObj



if Risposta = "I" then 
do
  say ' '
  say ' '
  say "OK, ho finito ;-) "
  say ''
  say 'Premere un tasto, grazie....'
end /* do */
else
do
  say ''
  say ' '
  say "OK, this is THE END ;-) "
  say ''
  say 'Strike a key, please....'
end /* do */

'pause >nul'
Exit

/* Build Object */
BldObj:
if Risposta = "I" then call charout, "Sto creando....: "title
else call charout ,"I'm making....: "title

result = SysCreateObject(classname, title, location, setup,"update")

if Risposta = "I" then 
do
  If result=1 Then call charout ,'...   Oggetto creato' 
  Else             call charout ,'...   Oggetto NON creato! Errore ='result 
end /* do */
else
do
  If result=1 Then call charout ,'...   Object created' 
  Else             call charout ,'...   Object NOT created! Result ='result 
end /* do */
Say ' ';
Return

