/* REXX PROGRAM */
/* Batch file to move import/export profiles into proper Goldmine directory */

"@echo off"

destpath = ""
call RxFuncAdd 'SysMkDir', 'RexxUtil', 'SysMkDir'
DO FOREVER
	IF destpath = "" THEN DO
		SAY "Enter the full directory path (including drive) where GoldMine"
		SAY "is installed.  If you press Enter without typing anything"
		SAY "the directory c:\goldmine is assumed."
		SAY "If you would like to abort this batch file, type QUIT and press Enter."
		PULL destpath
		IF destpath = "QUIT" THEN EXIT
		END
	IF destpath = "" THEN destpath = "C:\GOLDMINE"
	/* we will put original import/export files in a subdirectory called IMP */
	fulldestpath = destpath||"\IMPEXP"
	rc = SysMkDir(fulldestpath)
	if rc == 0 THEN LEAVE
	SAY ""
	if rc == 3 THEN say "The path " destpath " was not found."
	ELSE if rc == 5 THEN DO
		say "Warning: it appears the import/export files have already been copied."
		say "           If they are copied again, you may lose your original"
		say "           import/export profiles."
		say "    Press return to continue; type QUIT to exit"
		PULL response
		IF response = "" THEN LEAVE
		ELSE EXIT
		END
	ELSE say "Error creating the directory: " fulldestpath
		SAY "Enter a new path."
		SAY ""
		destpath = ""
		END

version=""
DO FOREVER
	IF version = "" THEN DO
		SAY "What version of Goldmine are you using?"
		SAY "     Respond 'WIN' if you are using Goldmine for Windows"
		SAY "     Respond '95' if you are using Goldmine for Windows 95"
		SAY "If you would like to abort this batch file, type QUIT and press Enter."
		PULL version
		IF version = "QUIT" THEN EXIT
		END
	IF version = "WIN" | version = "95" THEN LEAVE
	SAY ""
	SAY "ERROR: Invalid Goldmine version"
	SAY ""
	version = ""
	END

/* Copy the files */
SAY ""
SAY "Now copying files..."
IF version = "WIN" THEN DO
	"copy " impex2wn.ntx fulldestpath"\impexp2.ntx"
	"copy " impexpwn.gbf fulldestpath"\impexp.dbf"
	"copy " impexpwn.gbt fulldestpath"\impexp.dbt"
	"copy " impexpwn.ntx fulldestpath"\impexp.ntx"
	END
ELSE DO
	"copy " impex295.ntx fulldestpath"\impexp2.ntx"
	"copy " impexp95.gbf fulldestpath"\impexp.dbf"
	"copy " impexp95.gbt fulldestpath"\impexp.dbt"
	"copy " impexp95.ntx fulldestpath"\impexp.ntx"
	END

