/* REXX PROGRAM */
/* This REXX program expects Omnifile to be the host environment */
/* If you are attempting to change this file, you will normally only need to change the command in the CHANGE_REXX_VARIABLES subroutine. */


/* MAIN SUBROUTINE */
szEnvironment = address()
IF ((szEnvironment <> "Omnifile") & (szEnvironment <> "Contacts")) THEN DO
	SAY "This rexx file can only be run by Omnifile or Contact Connection, not directly."
	RETURN 1
	END

/* Load the Rexx variables based on the arguments the user passed in. */
FileIn = ARG(1)
HeaderFile = ARG(2)
Delimiter = ARG(3)
RecType = ARG(4)

/* Make sure the required arguments where given. */
IF FileIn = "" THEN DO
	SAY "The following arguments are expected: FILEIN HEADERFILE DELIMITER"
	SAY "    FILEIN is required."
	SAY "    HEADERFILE will default to FILEIN if not given."
	SAY "    DELIMITER will default to ',' if not given."
	RETURN 1
	END
/* Set the default header file to the input file and the default delimiter to ','. */
IF HeaderFile = "" THEN HeaderFile = FileIn
IF Delimiter = "" THEN Delimiter = ','
SetDefaultDelimiter(Delimiter)

/* If you want to override the RecType passed in, use the following format */
/* RecType = GetTypeGivenName("Individual") */
SetDefaultType(RecType)

/* Load the Header Line and pass it to Omnifile in order to initialize the import. */
headerLine = LINEIN(HeaderFile)
SetHeaderLine(headerLine)

/* For each line in the input file, load the line, loads the Rexx variables, modify the Rexx variables, and add the record. */
DO while LINES(FileIn)
	line = LINEIN(FileIn)
	IF line == "" THEN ITERATE
	Rec = GetRec(0, RecType)
	SetRexxVariables(line)
	CALL CHANGE_REXX_VARIABLES
	SetRecFromRexxVariables()
	AddRec()
	end
/* Close all the files. */
result = stream(FileIn, 'c', 'close')
IF HeaderFile \= FileIn THEN stream(HeaderFile, 'c', 'close')
RETURN 0


/* SUBROUTINE */
CHANGE_REXX_VARIABLES:
/* If necessary, change fields from a format suitable for import. */
/* This subroutine is usually the only portion that the user needs to change. */

RETURN

