/*****************************************************************************/
/* INSTALL.CMD Installation script using REXX, allowing upgrade installation */
/* (c)1997 Uwe Schlenther Software, Bebelstrae 30, 70193 Stuttgart, Germany */
/*****************************************************************************/

SIGNAL ON ERROR NAME Err

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs;

AppName="WarpNote Encryption Engine"
ExeFile="ENCRYPT.DLL"
DefaultDir="C:\OS2\DLL"

Call SysFileTree ExeFile,"dirs","FO"

if dirs.0<>1 then do
  say ""
  say "It seems you haven't unpacked the archive file."
  say "Please do so and try again."
  exit
end

say ""
say "You're about to install "AppName". Welcome !"
say ""

call Upgrade

exit



CopyFiles:
  arg Path

  call SysMkDir Path

  INTERPRET "'COPY ENCRYPT.DLL 'Path'\*.*'"

  return 0

Upgrade:
  dirs.0=0

  do until (LENGTH(drive)=1) & (dirs.0>0)
    say ""
    say "On what drive do you expect your installation ? (C,D,...)"
    pull drive
    if LENGTH(drive)=1 then do
      call SysFileTree drive":\WARPNOTE.EXE","dirs","FSO"
      if dirs.0=0 then say "The installation was not found on drive "drive"."
    end
  end

  do i=1 to dirs.0
    dirs.i=FILESPEC("D",dirs.i) || FILESPEC("P",dirs.i)
    l=LENGTH(dirs.i)
    if l>3 then if SUBSTR(dirs.i,l,1)="\" then dirs.i=SUBSTR(dirs.i,1,l-1)
    say ""
    say "Do you want to install "AppName" in "dirs.i" ? (Y/N)"
    say ""
    pull answer
    if answer="Y" then do
      call CopyFiles dirs.i
    end
  end
return 0

Err:
  say ""
  say "An error has occured. Possible causes are:"
  say ""
  say " - You have interrupted installation by pressing CTRL-BREAK."
  say " - A file is missing in the package. Try to unpack the archive file again."
  say " - A file cannot be replaced because it is in use. Make sure the program"
  say "   you're about to install is not running currently."
  say ""
  say "Please try again later."
exit

