/*============================================================================*/
/* SETILog2.CMD                                                               */
/*                                                                            */
/* Log the results so that SETIWatch will see them.                           */
/*                                                                            */
/*============================================================================*/
/* Part of SETIView/2 Cache                                                   */
/*                                                                            */
/* Copyright ??????????????????????????                                       */
/* Created:   Sometime in 1999 or 2000                                        */
/*                                                                            */
/*============================================================================*/
/* Modification History:                                                      */
/* 0.1.3 - Had SYMBOL(param) \= 'BAD' when it should have been                */
/*         SYMBOL(param) = 'VAR'.  Remember, always use the positive!         */
/*                                                                            */
/* 0.1.4 - Redid the same line as above because it didn't work.  Does now.    */
/*       - Stopped writing double quotes to SETILOG.CSV as it seemed to break */
/*         SETIWatch (under Win2000).                                         */
/*                                                                            */
/* 0.1.5 - New: Added parameters to not backup the SAH files or write to the  */
/*         SETILOG.CSV file.                                                  */
/*                                                                            */
/* 0.1.6 - Fix: Was logging even if there wasn't a result file.  Now checking */
/*         this correctly.                                                    */
/*       - New: Fixing code and file names up a bit.                          */
/*                                                                            */
/* 0.1.7 - New: Writing host and operating system from SVCACHE.HOST           */
/*       - Fix: Heading for SETILOG.CSV has changed.                          */
/*                                                                            */
/*============================================================================*/
Trace 'Off'
Parse Arg params
Say "Logging SETI@Home results"
say 'Parameters used are: "' || params || '"'

Call Initialize
Call ParseParameters params


If global.sayHelp Then Do
   Call SayParameters
   Return 0
End

loggedfile = 'LOGGED.LOG'
basename   = date('be')||time('m')
csvname    = strip(global.csvDir) || "\SETILog.csv"

If Length(Stream(global.seti_result_file_name, 'C', 'query exists')) = 0 Then Do
   Say "No results.sah.  Nothing to log."
   Return -1
End /* If .. then Do */

If global.log Then Do
   call Readfile "user_info.sah"

   Call CreateCSVFile

   lout = left(date('S'),4)'.'substr(date('S'),5,2)'.'right(date('S'),2) time('N')
   lout = lout || ',' || id
   lout = lout || ',' || key
   lout = lout || ',' || email_addr
   lout = lout || ',' || name
   if length(url)>0 then
     lout = lout || ',' || url
   else
     lout = lout || ','
   lout = lout || ',' || country
   lout = lout || ',' || postal_code
   lout = lout || ',' || show_name
   lout = lout || ',' || show_email
   lout = lout || ',' || venue
   lout = lout || ',' || strip(register_time)
   lout = lout || ',' || strip(last_wu_time)
   lout = lout || ',' || strip(last_result_time)
   lout = lout || ',' || nwus
   lout = lout || ',' || nresults
   lout = lout || ',' || total_cpu
   lout = lout || ',' || params_index

   call Readfile "state.sah"

   call Readfile global.seti_result_file_name

   call Readfile loggedfile

   If (Strip(logged) = Strip(name)) Then Return 0

   loggedLine = 'logged =' || name
/*   Call Stream csvname, 'C', 'Open' */
/*   Call Stream csvname, 'C', 'seek <0' */

   Call Stream loggedfile, 'C', 'OPEN WRITE'
   Call Stream loggedfile, 'C', 'seek =0'
   Call LineOut loggedfile, loggedLine, 1
   Call Stream loggedfile, 'C', 'CLOSE'

   Call Stream csvname, 'C', 'Open Write'

   lout = lout || ',' || task
   lout = lout || ',' || major_version
   lout = lout || ',' || name
   lout = lout || ',' || data_type
   lout = lout || ',' || data_class
   lout = lout || ',' || splitter_version
   lout = lout || ',' || start_ra
   lout = lout || ',' || strip(start_dec)
   lout = lout || ',' || end_ra
   lout = lout || ',' || strip(end_dec)
   lout = lout || ',' || strip(angle_range)
   lout = lout || ',' || strip(time_recorded)
   lout = lout || ',' || subband_center
   lout = lout || ',' || subband_base
   lout = lout || ',' || subband_sample_rate
   lout = lout || ',' || fft_len
   lout = lout || ',' || ifft_len
   lout = lout || ',' || subband_number
   lout = lout || ',' || receiver

   call charout csvname, lout

   lout = ""
   lout = lout || ',' || nsamples
   lout = lout || ',' || tape_version
   lout = lout || ',' || ncfft
   lout = lout || ',' || cr
   lout = lout || ',' || fl
   lout = lout || ',' || cpu
   lout = lout || ',' || prog
   lout = lout || ',' || bs_power
   lout = lout || ',' || bs_score
   lout = lout || ',' || bs_bin
   lout = lout || ',' || bs_fft_ind
   lout = lout || ',' || bs_chirp_rate
   lout = lout || ',' || bs_fft_len
   lout = lout || ',' || bg_score
   lout = lout || ',' || bg_power
   lout = lout || ',' || bg_chisq
   lout = lout || ',' || bg_bin
   lout = lout || ',' || bg_fft_ind
   lout = lout || ',' || bg_chirp_rate
   lout = lout || ',' || bg_fft_len

   lout = lout || ',' || bg_pot
   lout = lout || ',' || bp_score
   lout = lout || ',' || bp_power
   lout = lout || ',' || bp_mean
   lout = lout || ',' || bp_period
   lout = lout || ',' || bp_freq_bin
   lout = lout || ',' || bp_time_bin
   lout = lout || ',' || bp_chirp_rate
   lout = lout || ',' || bp_fft_len
   lout = lout || ',' || bp_pot
   lout = lout || ',' || bt_score
   lout = lout || ',' || bt_power
   lout = lout || ',' || bt_mean
   lout = lout || ',' || bt_period
   lout = lout || ',' || bt_bperiod
   lout = lout || ',' || bt_tpotind0_0
   lout = lout || ',' || bt_tpotind0_1
   lout = lout || ',' || bt_tpotind1_0
   lout = lout || ',' || bt_tpotind1_1
   lout = lout || ',' || bt_tpotind2_0
   lout = lout || ',' || bt_tpotind2_1
   lout = lout || ',' || bt_freq_bin
   lout = lout || ',' || bt_time_bin
   lout = lout || ',' || bt_chirp_rate
   lout = lout || ',' || bt_scale
   lout = lout || ',' || bt_fft_len
   lout = lout || ',' || bt_pot

   /* Write the host details. Hopefully this won't break SETIWatch compatability. */
   Call GetHostDetails
   lout = lout || ',' || hostDetails.hostName
   lout = lout || ',' || hostDetails.opSys

/*   Call Stream csvname, 'C', 'Seek <0' */
   call charout csvname, lout
   call lineout csvname, ""
   Call Stream csvname, 'C', 'CLOSE'
End /* If .. Then Do */

If global.backup Then Call CopyFiles

Exit 0 /* SETILog2.cmd */



ReadFile:
arg inf

do while lines(inf)
  line = linein(inf)
  parse value line with param "=" value
  value = Strip(value)
  param = translate(strip(param),"_"," ")
/*  If symbol(param) \= "BAD" & DataType(param, 'Symbol')  Then Do */
  If DataType(param, 'Symbol') & DataType(Substr(param, 1, 1), 'Mixed Case') Then Do
    If length(value) > 256 | Length(value) = 0 Then value = ''
    Interpret param "='"value"'"
  End /* If .. Then Do */
end
Call Stream inf, 'C', 'CLOSE'
return


CreateCSVFile:

if length(stream(csvname,'C','query exists'))=0 then do
  Call Stream csvname, 'C', 'Open Write'
  call charout csvname, '"date","id","key","email_addr","user_name","url","country","postal_code","show_name","show_email",'
  call charout csvname, '"venue","register_time","last_wu_time","last_result_time","nwus","nresults","total_cpu","params_index",'
  call charout csvname, '"task","version","name","data_type","data_class","splitter_version",'
  call charout csvname, '"start_ra","start_dec","end_ra","end_dec","angle_range","time_recorded","subband_center","subband_base","subband_sample_rate",'
  call charout csvname, '"fft_len","ifft_len","subband_number","receiver","nsamples","tape_version","ncfft","cr","fl","cpu","prog","bs_power","bs_score","bs_bin",'
  call charout csvname, '"bs_fft_ind","bs_chirp_rate","bs_fft_len","bg_score","bg_power","bg_chisq","bg_bin","g_fft_ind","bg_chirp_rate","bg_fft_len"'
  call charout csvname, ',"bg_pot","bp_score","bp_power","bp_mean","bp_period","bp_freq_bin","bp_time_bin","bp_chirp_rate","bp_fft_len","bp_pot"'
  call charout csvname, ',"bt_score","bt_power","bt_mean","bt_period","bt_bperiod","bt_tpotind0_0","bt_tpotind0_1","bt_tpotind1_0","bt_tpotind1_1"'
  call charout csvname, ',"bt_tpotind2_0","bt_tpotind2_1","bt_freq_bin","bt_time_bin","bt_chirp_rate","bt_scale","bt_fft_len","bt_pot"'
  call charout csvname, ',"hostname","operating_system"'
  call lineout csvname, ""
  Call Stream csvname, 'C', 'CLOSE'
end

Return

CopyFiles:
'@copy' global.seti_result_file_name    basename'.result' '>nul'
'@copy  state.sah'                      basename'.state' '>nul'
'@copy  user_info.sah'                  basename'.user'  '>nul'

Return


Initialize:
Procedure expose global. hostDetails.

global.backup = 1
global.log    = 1

/* These are the marker files for various actions. */
global.seti_result_file_name = 'result.sah'

global.setihost_file = 'SVCache.HOST'
hostDetails.hostName = ''
hostDetails.opSys    = ''

Return


ParseParameters:
Procedure expose global.
Parse Arg theParams

upperParams = Translate(theParams)

global.csvDir = Strip(theParams)

global.sayHelp = (Pos('/?', upperParams) > 0)

If \global.sayHelp Then Do
   noBackupParmPos = WordPos('/NOBACKUP', Translate(theParams))
   If noBackupParmPos = 1 Then Do
      theParams = SubWord(theParams, 2)
      global.backup = 0
   End /* If .. Then Do */
   Else If noBackupParmPos > 1 Then Do
      theParams = SubWord(theParams, 1, noBackupParmPos - 1) SubWord(theParams, noBackupParmPos + 1)
      global.backup = 0
   End /* If .. Then Do */

   noLogParmPos = WordPos('/NOLOG', Translate(theParams))
   If noLogParmPos = 1 Then Do
      theParams  = SubWord(theParams, 2)
      global.log = 0
   End /* If .. Then Do */
   Else If noLogParmPos > 1 Then Do
      theParams  = SubWord(theParams, 1, noLogParmPos - 1) SubWord(theParams, noLogParmPos + 1)
      global.log = 0
   End /* If .. Then Do */

   If Strip(theParams) = '' Then global.csvDir = '.'
   Else global.csvDir = Strip(theParams)
   If Substr(global.csvDir, Length(global.csvDir), 1) = '\' Then
      global.csvDir = Substr(global.csvDir, 1, Length(global.csvDir) - 1)

End /* If .. Then Do */

If \global.log Then Say 'Not logging this entry'
If \global.backup Then Say 'Not backing up this entry'
Say 'SETILOG.CSV is in' global.csvDir

Return


GetHostDetails:
/* Read the host file to determine the processor name and operating system. */
Procedure expose global. hostDetails.

processorname    = ''
operating_system = ''
found = 0

Call stream global.setihost_file , 'C', 'OPEN READ'
if lines(global.setihost_file) <> 0 then do
   do while \found & lines(global.setihost_file) > 0
      theline = linein(global.setihost_file)
      if abbrev(theline, 'host=') Then Do
         Parse Var theline . '=' processorname
      End /* If .. Then Do */
      Else If abbrev(theline, 'opera') Then Do
         Parse Var theline . '=' operating_system
      end /* Else If .. Then Do */
   end /* Do While .. */
End /* If .. Then Do */
call stream global.setihost_file, 'C', 'CLOSE'

hostDetails.hostName = Strip(processorName)
hostDetails.opSys    = Strip(operating_system)

Return  /* GetHostDetails */


SayParameters:
Procedure expose global.

tab = '   '
Say 'Command format is:'
Say
Say tab 'SETILog2 [/NOBACKUP] [/NOLOG | setilog_dirname] [/?]'
Say
Say 'Where:'
Say tab '/NOBACKUP       - will backup SAH files'
Say tab "/NOLOG          - don't log the work unit in SETILOG.CSV"
Say tab 'setilog_dirname - the directory the SETILOG.CSV file is in.  The'
Say tab tab 'default the current directory'
Say tab '/?              - display this help.  All other parameters are ignored.'


Return

