// mfcht.h
// (c) Petr Mikulk (mikulik@sci.muni.cz) - 1994--1999
// Freeware version. It is distributed without any warranty.
//  History: 1994  - C unit, 1991 pascal unit

// For new structures see the end of this file

#ifndef MFCHT_H
#define MFCHT_H

#include <math.h>

// ---- physical constants -----

#define  c_light   2.997924e8      // m/s
#define  h_Planck  6.626176e-34    // Js
#define  hbar_Planck 1.0545887e-34 // Js
#define  e_el      1.6021892e-19   // C
#define  m_el      9.109534e-31    // kg
#define  m_p       1.6726485e-27   // kg
#define  m_n       1.6749543e-27   // kg
#define  m_unit    1.6605655e-27   // kg
#define  mi_Bohr   9.274078e-24    // Am^2  or  J/T
#define  a0_Bohr   5.2917706e-11   // m
#define  r_el      2.8179380e-15   // m e^2 / (4 pi e0 m_el c^2)
#define  N_Avog    6.022045e23     // 1/mol
#define  k_Boltz   1.380662e-23    // J/K
#define  R_plyn    8.31441         // J / mol / K
#define  Kappa     6.6720e-11      // N m^2 kg^-2
#define  g_grav    9.80665         // m s^-2
#define  epsilon0  8.854187818e-12 // F / m
#define  jedna_4pie0 1/(4*M_PI*epsilon0)
#define  mi0       4e-7 * M_PI     // H / m


// ---- periodic system ----

#define  zetB  5
#define  zetC  6
#define  zetN  7
#define  zetAl 13
#define  zetSi 14
#define  zetP  15
#define  zetGa 31
#define  zetGe 32
#define  zetAs 33

#define  zetTe 0
#define  zetZn 0

#define  zetO  8
#define  zetFe 26
#define  zetCo 27
#define  zetY  39
#define  zetNb 41
#define  zetSm 62
#define  zetGd 64
#define  zetTb = 65
#define  zetW  74


// ---- lattice parameters ----
// now they are in Angstroms !

// diamant structure

extern const double  lpGaAs; // = 5.65325e-10;
extern const double  lpAlAs; // = 5.6620e-10;
extern const double    lpAlAsonGaAs; // = 5.6664e-10; // as grown on GaAs
extern const double  lpSi;  // = 5.4309e-10;
extern const double  lpGe;  // = 5.6575e-10;
extern const double  lpC;   // = 3.567e-10;   // diamant
extern const double  lpGa5Al5As; // = ( lpGaAs + lpAlAs ) /2;
extern const double  lpZnTe; // = 6.09e-10;

// cubic - bcc

extern const double lpFe; // = 2.8664e-10;
extern const double lpW;  // = 3.1648e-10;
extern const double lpNb; // = 3.3066e-10;

//  hexagonal
extern const double lpY_a,  lpY_c;
extern const double lpGd_a, lpGd_c;
extern const double lpTb_a, lpTb_c;
extern const double lpSapphire_a, lpSapphire_c;
extern const double lpSm_a, lpSm_c;
extern const double lpY2Co17_a,   lpY2Co17_c;

// other structures:
//     Diamond a=3.567;   Debye[300K]=1860 K
//     Be      a=2.286; c=3.583;     =1188 K


/* see  atomsf.dat
{ ---- relative masses ---- }

const double mrB  = 10.82;     mrC  = 12.011;   mrN  = 14.0067;
      mrAl = 26.98154;  mrSi = 28.0855;  mrP  = 30.9737;
      mrGa = 69.72;     mrGe = 72.59;    mrAs = 74.9216;

      mrFe = 55.85;     mrCo = 58.933;
      mrY  = 88.91;     mrGd = 157.25;
      mrNb = 92.906;    mrSm = 150.36;
      mrTb = 158.93;    mrW  = 183.85;

      mrZn = 65.380;    mrTe = 127.60;
*/


// ---- wavelengths ----
// order according to decreasing wavelength

#define TiKa1  0
#define CrKa1  1
#define FeKa1  2
#define CoKa1  3
#define CuKa2  4
#define CuKa   5
#define CuKa1  6
#define CuKb1  7
#define MoKa2  8
#define MoKa   9
#define MoKa1  10
#define MoKb1  11
#define AgKa2  12
#define AgKa   13
#define AgKa1  14
#define AgKb2  15
#define TaKa1  16
#define WKa1   17
#define AuKa1  18
#define XrayLambdaLast 18

extern double XrayLambda [];      // wavelengths
extern char *( XrayLambdaStr[] ); // their names

double ReadWaveLength ( char opt );
// if opt==0 then only cin >> lambda; return lambda
// otherwise clever read

#define A2M 12398.51826402524603

/*
{ --- Debye-Waller factors B ---}

      dwbGaAs = 0.596177e-20; { 283 K = the Debye temperature }
      dwbAlAs = 0.353084e-20; { 446 }
      dwbGe   = 0.558810e-20; { 292 }
      dwbSi   = 0.444083e-20; { 543 }
      dwbGa5Al5As = ( dwbGaAs + dwbAlAs ) /2;
      dwbFe   = 0.291911e-20; { 470 }
      dwbY    = 0.495128e-20; { 280 }
      dwbGd   = 0.542138e-20; { 200 }
      dwbTb   = 0;            { ? I don't know the Debye temperature }
      dwbW    = 0.120269e-20; { 400 }
      dwbSapphire = 0;        { ? }
      dwbNb   = 0;            { ? }
      dwbSm   = 0;            { ? }
      dwbZnTe = 0;            { ? }
      dwbY2Co17 = 0;          { ? }


{ --- procedures for calc. of atomic scattering factors --- }

procedure ASFSi ( STL: float; Lambda: float; var ASF: Complex );
procedure ASFGe ( STL: float; Lambda: float; var ASF: Complex );
procedure ASFAl ( STL: float; Lambda: float; var ASF: Complex );
procedure ASFGa ( STL: float; Lambda: float; var ASF: Complex );
procedure ASFAs ( STL: float; Lambda: float; var ASF: Complex );

procedure ASFO  ( STL: float; Lambda: float; var ASF: Complex );
procedure ASFFe ( STL: float; Lambda: float; var ASF: Complex );
procedure ASFY  ( STL: float; Lambda: float; var ASF: Complex );
procedure ASFNb ( STL: float; Lambda: float; var ASF: Complex );
procedure ASFSm ( STL: float; Lambda: float; var ASF: Complex );
procedure ASFGd ( STL: float; Lambda: float; var ASF: Complex );
procedure ASFTb ( STL: float; Lambda: float; var ASF: Complex );
procedure ASFW  ( STL: float; Lambda: float; var ASF: Complex );
procedure ASFZn ( STL: float; Lambda: float; var ASF: Complex );
procedure ASFTe ( STL: float; Lambda: float; var ASF: Complex );
procedure ASFCo ( STL: float; Lambda: float; var ASF: Complex );


const AtomScatFact: array [ atomSi..atomCo ] of Pointer =
        ( @ASFSi, @ASFGe, @ASFAl, @ASFGa, @ASFAs,
          @ASFFe, @ASFY,  @ASFGd, @ASFTb, @ASFW, @ASFO, @ASFNb,
          @ASFSm, @ASFZn, @ASFTe, @ASFCo );

const KolikZnaRtg = 16;     { lib. usporadani }
      CoZnaRtg: array [1..KolikZnaRtg] of String10 =
        ( 'Si','Ge','GaAs','AlAs','AlAsonGaAs','Ga.5Al.5As',
	  'Fe','Y','Gd','Tb','W','Sapphire', 'Nb', 'Sm','ZnTe',
          'Y2Co17' );

function RtgZnaLatku ( Latka: String10 ): boolean;



IMPLEMENTATION


(*******  Atomic scattering factors for x-rays ****************
By: International  Tables for X-ray Crystallography,
The International Union of Crystallography, Birmingham, England,
1974.  Ozn. STL = sin(theta)/lambda. Pak:

              4                    2
f ( STL ) = suma a * exp ( -b * STL )  + c
            i=1   i          i

Coefficients for Analytical Approximation to the Scattering
Factors - Table 2.2B *****************************************)

procedure ASF1974 ( STL: float; Coef: Array9F; var ASF: Complex );
{ Stl je  sin theta / lambda }
var X: float; I: integer;
begin
X:=Coef[9];
STL:=-sqr(STL);
for I:=0 to 3 do
    X:=X + Coef[2*I+1] * exp( STL * Coef[2*I+2] );
if STL=0 then X:=round(X); { vyrovnani chyby pro theta=0 }
Cnum(X,0,ASF);
end;


(********************** Table 2.3.1 ************************
   Real and Imaginary Dispersion Corrections for Atomic
Scattering Factors:  sf = asf1974 + sfr + i sfi

{ Int. Tables 1974:
      CrKa      FeKa       CuKa      MoKa      AgKa
Si   .355  .693   .311  .509    .244  .330   .072  .071   .042  .043
Al   .318  .522   .269  .381    .204  .246   .056  .052   .032  .031
Ga  -.570 1.569  -.841 1.168  -1.354  .777   .163 1.609   .249 1.059
Ge  -.462 1.786  -.717 1.331  -1.163  .886   .081 1.801   .228 1.190
As  -.365 2.022  -.607 1.508  -1.011 1.006  -.030 2.007   .196 1.332
Zn  -.684 1.373  -.978 1.021  -1.612  .678   .222 1.431   .260  .938
Te -4.267 11.995 -1.63 9.203   -.418 6.352  -.772 1.675 -1.212  1.096
}


{ Int. Tables 1992: }

	CrKa         FeKa         CuKa        MoKa         AgKa
Si   .3647  .6921    .3209  .5081    .2541   .3302    .0817 .0704    .0522  .0431
Al   .3260  .5212   .2774  .3807    .2130    .2455    .0645 .0514    .0313  .0522
Ga  -.4989 1.5674   -.7701 1.1663  -1.2846   .7763    .2307 1.6083   .3179 1.0589
Ge  -.3858 1.7841   -.6412 1.3291  -1.0885   .8855    .1547 1.8001   .3016 1.1903
As  -.2871 2.0194   -.5260 1.5069   -.9300  1.0051   -.0499 2.0058   .2758 1.3314
Fe -1.2935  .7620  -2.0554  .5649  -1.1336  3.1974    .3463  .8444   .5448  .3050
Y    .1263 3.9964    .0138 3.0054   -.2670  2.0244  -2.7962 3.5667  -.2879 2.4099
Gd -5.3778 5.7756  -7.1681 4.4280  -8.8380 11.9157   -.1653 3.9035  -.3741 2.5954
Tb -5.0951 6.1667  -6.5583 4.7292  -9.1472  9.1891   -.1723 4.1537  -.3496 2.7654
Sm -6.0570 5.0744  -9.3497 3.8839  -5.3236 12.2178   -.1638 3.4418  -.4287 2.2815
W  -3.9270 10.3696 -4.2486 8.0005  -5.4734  5.5774   -.8490 6.8722  -.4201 4.6430
O   0.0928 0.0731   0.0716 0.0518   0.0492 0.0322    0.0106 0.0060  0.0056 0.0036
Nb  0.1211 4.8761   0.1072 3.6768  -0.1121 2.4826   -2.0727 0.6215  -.8282 2.8404
Co -1.0738 0.8897  -1.5743 0.6602  -2.3653 3.6143     .3494 0.9721   .3050 0.6296
***********************************************************)

procedure AddDispCorr ( B: Array10F; Lambda: float; var DispCorr: Complex );
var DC: Complex; Lambda09, Lambda11: float;
begin
Lambda09:=Lambda/0.9; Lambda11:=Lambda/1.1;
if (Lambda09>AgKa) and (Lambda11<AgKa) then Cnum(B[5],B[6],DC)
  else if (Lambda09>CrKa1) and (Lambda11<CrKa1) then Cnum(B[1],B[2],DC)
  else if (Lambda09>FeKa1) and (Lambda11<FeKa1) then Cnum(B[3],B[4],DC)
  else if (Lambda09>CuKa) and (Lambda11<CuKa) then Cnum(B[5],B[6],DC)
  else if (Lambda09>MoKa) and (Lambda11<MoKa) then Cnum(B[7],B[8],DC)
  else if (Lambda09>AgKa) and (Lambda11<AgKa) then Cnum(B[9],B[10],DC)
  else begin Cnum( 0, 0, DC );
       writeln('Dispersion correction for the wavelength ',Lambda,' is not in table - treated as 0.');
       end;
Cadd(DispCorr,DC,DispCorr);
end;

(***                 a1        b1        a2        b2        a3       b3       a4       b4       c    ***)

procedure ASFSi ( STL: float; Lambda: float; var ASF: Complex );
{ Si/v: maximum error 0.009. Pro Stl=0 je SF=13.9976 }
const A: Array9F = ( 6.29150,  2.43860,  3.03530,  32.3337,  1.98910, 0.678500,1.54100, 81.6937, 1.14070  );
(**
 { Si/val: maximum error 0.001. 0: 13.99906 }
 const A: Array9F = ( 5.66269,  2.66520,  3.07164,  38.6634,  2.62446, 0.916946,1.39320, 93.5458, 1.24707  );
 { Si/+4: maximum error 0.000. 0: 9.999987 }
 const A: Array9F = ( 4.43918,  1.64167,  3.20345,  3.43757,  1.19453, 0.214900,0.416530,6.65365, 0.746297 );
**)
{B:Array10F=(0.355, 0.693, 0.311, 0.509, 0.244, 0.330, 0.072, 0.071, 0.042, 0.043);   =1974}
 B:Array10F=(0.3647,0.6921,0.3209,0.5081,0.2541,0.3302,0.0817,0.0704,0.0522,0.0431); {=1992}
begin ASF1974(STL,A,ASF);
AddDispCorr(B,Lambda,ASF);
end;


function StringToLambda ( Lambda: string ): real;
var I: integer;
begin
Lambda:=UpString(Lambda);
for I:=1 to HowManyLambda do
  if Lambda=WhichLambdaStr[I] then
    begin StringToLambda:=WhichLambda[I]; exit end;
Beepni(2); StringToLambda:=CuKa
end;

*/

#endif

/*****************      NEW STRUCTURES:       *********************
TbCo2: a=7.223 A  sc   Z=8 times per elementary cell  group Fd3m
TbFe2: a=7.341 A  sc   Z=8 times per elementary cell  group Fd3m
Cr:    a=2.88 A   bcc  Z=2 times per elementary cell
******************************************************************/

// eof mfcht.h

