/* 
   Version 1.2							1997/1/10

   dolink.c : This file is part of the alliance 3.0 patch for OS/2 & WIN32

   Copyright (C) 1996 Christoph Jaeschke, jaeschke@item.uni-bremen.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#define TOP "/alliance"

#include <process.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>

void mkDirs(char * top, char * machine) {

  char sysstr[1024];

  sprintf( sysstr, "%s/archi", top);
  mkdir( sysstr, 0 );
  sprintf( sysstr, "%s/archi/%s", top, machine);
  mkdir( sysstr, 0 );
  sprintf( sysstr, "%s/archi/%s/bin", top, machine);
  mkdir( sysstr, 0 );
  sprintf( sysstr, "%s/archi/%s/include", top, machine);
  mkdir( sysstr, 0 );
  sprintf( sysstr, "%s/archi/%s/lib", top, machine);
  mkdir( sysstr, 0 );
}

int main (int argc, char *argv[]) {

  char MACHINE[10];
  char sysstr[1024];
  char line[1024];
  char toolName[256];
  char *c;
  FILE *f;
  DIR *d;

  if( !argv[1] ) {
    printf("usage : dolink [emx,cyg]\n");
    exit( 1 );
  }
  else if( 0==strcmp(argv[1],"emx") ) {
    strcpy(MACHINE, "emx");
  }
  else if( 0==strcmp(argv[1],"cyg") ) {
    strcpy(MACHINE, "cyg");
  }
  else {
    printf("usage : dolink [emx,cyg]\n");
    exit( 1 );
  }

  printf("Linking directories:\n");
  sprintf( sysstr, "touch %s/tools/link.started", TOP);
  system( sysstr );
  sprintf( sysstr, "%s/tmp", TOP);
  mkdir( sysstr, 0 );
  mkDirs(TOP, MACHINE);
  sprintf( sysstr, "ls %s/tools/* -1d > dirs.tmp", TOP);
  system( sysstr );
  f = fopen("dirs.tmp","r");
  while (fgets(line, 1000, f)) {
	line[strlen(line)-1] = '\0';
	sprintf( sysstr, "%s/sce", line);
	if (d = opendir( sysstr)) {
	c = (char*) strrchr(line, '/');
	printf("%s ", ++c );
	mkDirs(line, MACHINE);
	sprintf(sysstr, "%s/archi/%s/obj", line, MACHINE);
	mkdir(sysstr, 0);
	sprintf( sysstr, "cp -r %s/sce/* %s/archi/%s/obj/", line, line, MACHINE);
	system( sysstr );
	closedir(d);	
	}
  }
  fclose(f);
  system( "rm dirs.tmp" );
  printf("\n");
  sprintf( sysstr, "touch %s/tools/link.finished", TOP);
  system( sysstr );
}