/* 
   Version 1.2							1997/1/10

   genlibwin32.c : This file is part of the alliance 3.0 patch for OS/2 & WIN32

   Copyright (C) 1996 Christoph Jaeschke, jaeschke@item.uni-bremen.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <process.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

/*
    original comment in genlib:

    # @(#)genlib version 3.21
    # script to be executed in *csh*
    # laboratoire masi cao-vlsi, UPMC, copyright 1990
    # software support e-mail : cao-vlsi@masi.ibp.fr
    # Author : Frederic Petrot 07/10/90
    # Modifications, and all that stuff, by Fred also

*/

int main (int argc, char *argv[]) {

#define buflen 1024

  FILE *errfile;
  int i, talk, erase;
  int rc;
  char buffer[buflen];
  char* name;
  char errname[1024];
  char exename[1024];
  char objname[1024];
  char cname[1024];
  char systemstr[4096];

  if( !argv[1] ) {/* yes, a simple solution, but this adapts the script behaviour */
    printf("usage : genlib [-gv] program (without extension)\n");
    exit( 1 );
  }
  else if( 0==strcmp(argv[1],"") ) {
    printf("usage : genlib [-gv] program (without extension)\n");
    exit( 1 );
  }
  else if( !argv[2] ) {/* yes, a simple solution, but this adapts the script behaviour */
    name = argv[1];
    talk = 0;
    erase = 1;
  }
  else if( 0==strcmp(argv[2],"") ) {
    name = argv[1];
    talk = 0;
    erase = 1;
  }
  else if( 0==strcmp(argv[1],"-v") ) {
    name = argv[2];
    talk = 1;
    erase = 1;
  }
  else if( 0==strcmp(argv[1],"-g") ){
    name = argv[2];
    talk = 0;
    erase = 0;
  }
  else if(( 0==strcmp(argv[1],"-gv" ) || ( 0==strcmp(argv[1],"-vg")) )) {
    name = argv[2];
    talk = 1;
    erase = 0;
  }
  else {
    printf("usage : genlib [-gv] program (without extension)\n");
    exit( 1 );
  }
  sprintf(errname, "%s.grr", name);
  sprintf(exename, "./%s.exe", name);
  sprintf(objname, "%s.o", name);
  sprintf(cname, "%s.c", name);
  remove(errname);
  remove(objname);
  printf("\n");
  printf("             @@@@ @                        @@@@@@         @   @@@      \n");
  printf("           @@    @@                          @@          @@@   @@      \n");
  printf("          @@      @                          @@           @    @@      \n");
  printf("         @@             @@@@@   @@@ @@@      @@                @@ @@   \n");
  printf("         @@            @     @   @@@   @     @@        @@@@    @@@  @@ \n");
  printf("         @@     @@@@@ @@     @@  @@    @@    @@          @@    @@    @@\n");
  printf("         @@     @ @@  @@@@@@@@@  @@    @@    @@          @@    @@    @@\n");
  printf("         @@    @  @@  @@         @@    @@    @@          @@    @@    @@\n");
  printf("          @@      @@  @@      @  @@    @@    @@      @   @@    @@    @@\n");
  printf("           @@    @@    @@    @@  @@    @@    @@     @    @@    @@@  @@ \n");
  printf("             @@@@        @@@@   @@@@  @@@@ @@@@@@@@@@  @@@@@@ @@@ @@   \n");
  printf("\n");
  printf("                         Procedural Generation Language\n");
  printf("\n");
  printf("                    Alliance CAD System 3.0,     genlib 3.21\n");
  printf("                    Copyright (c) 91-95, MASI, CAO-VLSI Team\n");
  printf("                    E-mail support:     cao-vlsi@masi.ibp.fr\n");
  printf("\n");
  if( talk ) printf("Compiling %s.c ...\n",name);
  freopen(errname, "w", stderr);

  sprintf(systemstr, "%s %s %s %s  %s %s %s %s  %s %s %s %s  %s",
        COMPILERNAME, CFLAGS1, CFLAGS2, CFLAGS3,
        ALLIANCE_INCLUDE, ALLIANCE_LIB, "-g", "-o",
        name, cname, LIBLIST1, LIBLIST2,
        LIBLIST3 );
  rc = system(systemstr);
  if( rc ) {
    if( rc == -1 ) {
      printf("error occured during system(%s)\n", systemstr);
      exit(1);
    }
    printf("Compilation aborted\n");;
    printf("Errors report in %s file\n", errname);
    errfile = fopen (errname, "r");
    while (fgets(buffer, buflen, errfile)) {
      fputs(buffer, stdout);
    }
    fclose(errfile);
    exit(1);
  }
  if( talk ) {
	printf("( * means overridden from environment variables)");
	if (getenv("MBK_CATA_LIB"))
		printf("MBK_CATA_LIB   * : %s\n", getenv("MBK_CATA_LIB"));
	else
		printf("MBK_CATA_LIB     : .              \n");
	if (getenv("MBK_WORK_LIB"))
		printf("MBK_WORK_LIB   * : %s\n", getenv("MBK_WORK_LIB"));
	else
		printf("MBK_WORK_LIB     : .              \n");
	if (getenv("MBK_IN_LO"))
		printf("MBK_IN_LO      * : %s\n", getenv("MBK_IN_LO"));
	else
		printf("MBK_IN_LO        : al             \n");
	if (getenv("MBK_OUT_LO"))
		printf("MBK_OUT_LO     * : %s\n", getenv("MBK_OUT_LO"));
	else
		printf("MBK_OUT_LO       : al             \n");
	if (getenv("MBK_IN_PH"))
		printf("MBK_IN_PH      * : %s\n", getenv("MBK_IN_PH"));
	else
		printf("MBK_IN_PH        : ap             \n");
	if (getenv("MBK_OUT_PH"))
		printf("MBK_OUT_PH     * : %s\n", getenv("MBK_OUT_PH"));
	else
		printf("MBK_OUT_PH       : ap             \n");
	if (getenv("MBK_CATAL_NAME"))
		printf("MBK_CATAL_NAME * : %s\n", getenv("MBK_CATAL_NAME"));
	else
		printf("MBK_CATAL_NAME   : CATAL          \n");
  }
  if( talk ) printf("Executing ...\n");
  rc = system( exename );
  if( talk ) printf("Removing tmp files ...\n");
  if( erase ) {
    remove( exename );
    remove( name );
  }
  remove( objname );
  remove( errname );
  exit( rc );
}
