/*
 * Psych0's Astrology Tool
 * (k) 1998, 1999 by Andrew Ziem <ziem@iex.net>
 * http://members.xoom.com/sdexter/psoft/
 *
 */


int write_astrolog(char *dirname)
{
  CHART c;
  FILE *f;
  char drive[MAXDRIVE];
  char dir[MAXDIR];
  char file[MAXFILE];
  char ext[MAXEXT];
  char fn[MAXPATH];
  int done;


  fnsplit(dirname, drive, dir, NULL, NULL);
  fnmerge(fn, drive, dir, NULL, NULL);

  printf("Writing Astrolog charts to directory:\n");
//  printf("  (%s)...\n", fn);

  sort_data(SORT_TYPE_NAME, 0, 0);

  LLSnodePtr2First(ListCharts);

  do
  {
     LLSnodeDataTo(ListCharts, &c);

     fnsplit(dirname, drive, dir, NULL, NULL);
     fnmerge(fn, drive, dir, str_to_fn(last_name(c.name)), "");

     f = fopen(fn, "wt");

     printf("  %s...\n", fn);

     fprintf(f, "@0102 ; autosynthesized Astrolog chart\n");
     fprintf(f, "/qb %s %i %i  ", abv_months_txt[c.born.month], c.born.mday, c.born.year);
     fprintf(f, "%i:%i %cT %i:%i", c.born.hour, c.born.minutes, c.born.daylightsavings ? 'D' : 'S', c.born.timezone, c.born.timezone_minutes);
     fprintf(f, "  %s", latlong(c.born.longitude, c.born.longitude_minutes, LL_LONGITUDE));
     fprintf(f, " %s\n", latlong(c.born.latitude, c.born.latitude_minutes, LL_LATITUDE));
     fprintf(f, "/zi \"%s\" \"%s\"\n", c.name, c.born.location);
     fprintf(f, "\n");
     fprintf(f, "\n");
     fprintf(f, "; number: %i/%i\n", numerologize_bday(c.born.mday, c.born.month, c.born.year, FALSE), numerologize_bday(c.born.mday, c.born.month, c.born.year, TRUE));
     fprintf(f, "\n\n; EOF\n");

     fclose(f);

  } while (LLSnodePtr2Next(ListCharts));

  printf("\n");

  return TRUE;

}


int write_data(char *fname)
{
  CHART c;
  FILE *f;
  int x;


  printf("Writing PAT chart data file:\n");
  printf("  %s...\n", fname);

  f = fopen(fname, "at"); /* a+t */

  if (f == NULL)
  {
    fprintf(stderr, "  --> error: unable to open file for writing\n");
    return FALSE;
  }

  if (0 == ftell(f))
  {
//     printf("debug: write.data.ftell == 0\n");
     fprintf(f, "%s\n\n", DAT_HDR);
  }

//  sort_data(SORTBYNAME);

  LLSnodePtr2First(ListCharts);

  do
  {
    LLSnodeDataTo(ListCharts, &c);

    fprintf(f, "\nName=%s\n", c.name);
    if (c.born.mday)
      fprintf(f, "Birthdate=%s %i, %i\n", abv_months_txt[c.born.month ], c.born.mday, c.born.year);
    if (c.born.hour || c.born.minutes)
      fprintf(f, "Birthtime=%i:%i\n", c.born.hour, c.born.minutes);
    if (c.born.timezone || c.born.timezone_minutes)
      fprintf(f, "Timezone=%i:%i\n", c.born.timezone, c.born.timezone_minutes);
    if (strlen(c.born.location) > 1)
      fprintf(f, "Location=%s\n", c.born.location);
    if (c.born.longitude || c.born.longitude_minutes)
      fprintf(f, "Longitude=%i:%i%c\n", abs(c.born.longitude), c.born.longitude_minutes, c.born.longitude < 0 ? 'W' : 'E');
    if (c.born.latitude || c.born.latitude_minutes)
      fprintf(f, "Latitude=%i:%i%c\n", abs(c.born.latitude), c.born.longitude_minutes, c.born.latitude < 0 ? 'S' : 'N');

    for (x = 0; x < BODIES; x++)
    {
      /* see if data exists for this planet */
      if (c.planet[x].sign > 0 && c.planet[x].sign <= SIGNS)
	fprintf(f, "%s=%02i%s%02i %s\n", bodytxt[x], c.planet[x].degrees, abv_sign_txt[c.planet[x].sign], c.planet[x].minutes, c.planet[x].retrograde == 0 ? "" : "R");
    }
    fprintf(f, "End\n\n");

  } while (LLSnodePtr2Next(ListCharts));

  fclose(f);

  printf("\n");

  return TRUE;
} /* write_data() */


int write_numerology(char *fname)
{
  CHART c;
  FILE *f;
  int last_number = -1;


  printf("Writing astronumerological report:\n");
  printf("  %s...\n", fname);


  f = fopen(fname, "at"); /* a+t */

  if (f == NULL)
  {
     fprintf(stderr, "  --> error: unable to open file for writing\n");
     return FALSE;
  }

  fprintf(f, "*** Astronumerological Report (of combined month, day and year numbers)\n");
  fprintf(f, TXT_LINE_ONE);
  fprintf(f, TXT_LINE_TWO);
  fprintf(f, TXT_LINE_THREE);

  sort_data(SORT_TYPE_NUMEROLOGY, 0, 0);

  LLSnodePtr2First(ListCharts);

  do
  {
     LLSnodeDataTo(ListCharts, &c);

     if (last_number != numerologize_bday(c.born.mday, c.born.month, c.born.year, FALSE))
     {
        fprintf(f, "\n\n** %i/%i\n", numerologize_bday(c.born.mday, c.born.month, c.born.year, FALSE), numerologize_bday(c.born.mday, c.born.month, c.born.year, TRUE));
        last_number = numerologize_bday(c.born.mday, c.born.month, c.born.year, FALSE);
     }

     fprintf(f, "  %s\n", c.name);


  } while (LLSnodePtr2Next(ListCharts));

  fprintf(f, "\n\n-- end of list (of %i people)\n", charts);

  fclose(f);

  printf("\n");

  return TRUE;

}

int write_combo(char *fname)
{
  CHART c;
  FILE *f;
  int body1sign, body2sign;


  printf("Writing planet combonations report:\n");
  printf("  %s...\n", fname);

  f = fopen(fname, "at"); /* a+t */

  if (f == NULL)
  {
     fprintf(stderr, "  --> error: unable to open file for writing\n");
     return FALSE;
  }

  fprintf(f, "*** Astrological Report: Combonation of Two Planets\n");
  fprintf(f, TXT_LINE_ONE);
  fprintf(f, TXT_LINE_TWO);
  fprintf(f, TXT_LINE_THREE);

  sort_data(SORT_TYPE_DOUBLE, SUN, MOON);


  for (body1sign = 1; body1sign <= SIGNS; body1sign++)
  {

    /* go through the signs next */
    for (body2sign = 1; body2sign <= SIGNS; body2sign++)
    {
       int any = FALSE; /* flip to one and say hi if entry found */



       /* reset */
       LLSnodePtr2First(ListCharts);

       do
       {
	  LLSnodeDataTo(ListCharts, &c);
	  if (c.planet[SortFieldBody].sign == body1sign && c.planet[SortFieldBodySecondary].sign == body2sign)
	  {
	     if (!any)
	     {
		any = TRUE;
		fprintf(f, "\n");
		fprintf(f, " %s in %s\n", bodytxt[SortFieldBody], sign_txt[body1sign]);
		fprintf(f, " %s in %s\n", bodytxt[SortFieldBodySecondary], sign_txt[body2sign]);
	     }
	    fprintf(f, "   %s\n", c.name);
	}
      } while (LLSnodePtr2Next(ListCharts));
    } /* for */
  } /* for */

  fprintf(f, "\n\n-- end of list (of %i people)\n", charts);

  fclose(f);

  printf("\n");

  return TRUE;

}


int write_bysign(char *fname)
{
  FILE *f;
  CHART c;
  int body, sign;
  

  printf("Writing astrological report, ordered by planets then signs:\n");
  printf("  %s...\n", fname);

  f = fopen(fname, "wt"); /* a+t */

  if (f == NULL)
  {
     fprintf(stderr, "  --> error: unable to open file for writing\n");
     return FALSE;
  }

  fprintf(f, "*** Astrological Report: Ordered by Planets Then Signs\n\n");
  fprintf(f, TXT_LINE_ONE);
  fprintf(f, TXT_LINE_TWO);
  fprintf(f, TXT_LINE_THREE);

  /* go through the bodies first */
  for (body = 0; body < BODIES; body++)
  {
    int anysign = FALSE;


    /* sort */
    sort_data(SORT_TYPE_BYSIGN, body, 0);

    /* go through the signs next */
    for (sign = 1; sign <= SIGNS; sign++)
    {
      int any = FALSE; /* flip to one and say hi if entry found */


      /* reset */
      LLSnodePtr2First(ListCharts);

      do
      {
	LLSnodeDataTo(ListCharts, &c);
	if (c.planet[body].sign == sign)
	{
	   if (!any)
	       {
		  if (!anysign)
		  {
		     anysign = TRUE;
		     fprintf(f, "\n\n** %s\n", bodytxt[body]);
		  }
		  any = TRUE;
		  fprintf(f, "\n  %s in %s\n", bodytxt[body], sign_txt[sign]);
		}
	    fprintf(f, "   %3i %s%s\n", c.planet[body].degrees, c.name, c.planet[body].retrograde ? " [retrograde]" : "");
	}
      } while (LLSnodePtr2Next(ListCharts));
    } /* for */
  } /* for */

  fprintf(f, "\n\n-- end of list (of %i people)\n", charts);

  fclose(f);

  printf("\n");

  return TRUE;

} /* write_bysign() */


int write_plain(char *fname)
{
  FILE *f;
  CHART c;
  int x;
  char ns, ew;


  printf("Writing plain text of charts:\n");
  printf("  %s...\n", fname);

  f = fopen(fname, "wt"); /* a+t */

  if (f == NULL)
  {
    fprintf(stderr, "  --> error: unable to open file for writing\n");
    return FALSE;
  }

  fprintf(f, "*** Astrological Profiles: (Aesthetically Pleasing) Plain Charts\n\n");
  fprintf(f, TXT_LINE_ONE);
  fprintf(f, TXT_LINE_TWO);
  fprintf(f, TXT_LINE_THREE);

  sort_data(SORT_TYPE_NAME, 0, 0);

  LLSnodePtr2First(ListCharts);

  do
  {
    LLSnodeDataTo(ListCharts, &c);


    fprintf(f, "\n***************************************************************************\n");
    fprintf(f, "       Name: %s\n", c.name);
    if (c.born.month || c.born.mday || c.born.year)
      fprintf(f, "  Date Born: %s %i, %i\n", abv_months_txt[c.born.month], c.born.mday, c.born.year);
    fprintf(f, "  Time Born: %i:%i (%cT %i:%i GMT)\n", c.born.hour, c.born.minutes, c.born.daylightsavings == TRUE ? 'D' : 'S', c.born.timezone, c.born.timezone_minutes);
    fprintf(f, "   Location: %s\n",  c.born.location);
    if (c.born.longitude < 0 /* && c.born.longitude_minutes < 0 */)
      ew = 'W';
      else
      ew = 'E';
    if (c.born.latitude < 0)
      ns = 'S';
      else
      ns = 'N';
    fprintf(f, "Coordinates: %i%c%i %i%c%i\n", abs(c.born.longitude), ew, c.born.longitude_minutes, c.born.latitude, ns, c.born.latitude_minutes);
    fprintf(f, "    Chinese: %i\n", chinese_zodiac_year(c.born.year, c.born.month, c.born.year));

    for (x = 0; x < BODIES; x++)
    {
      /* see if data exists for this planet */
      if (c.planet[x].sign != 0)
	fprintf(f, "%11s: %i %s %i %s\n", bodytxt[x], c.planet[x].degrees, sign_txt[c.planet[x].sign], c.planet[x].minutes, c.planet[x].retrograde == 0 ? "" : "Rx");
    }

    fprintf(f, "***************************************************************************\n\n");

  } while (LLSnodePtr2Next(ListCharts));

  fprintf(f, "\n-- end of list (of %i people)\n", charts);

  fclose(f);

  printf("\n");

//  printf("  --> %i entries written\n\n", charts);

  return TRUE;

} /* write_plain() */


int write_chinese(char *fname)
{
  FILE *f;
  CHART c;
//  int prev_year = -1;


  printf("Writing Chinese zodiac report:\n");
  printf("  %s...\n", fname);

  f = fopen(fname, "wt"); /* a+t */

  if (f == NULL)
  {
     fprintf(stderr, "  --> error: unable to open file for writing\n");
     return FALSE;
  }

  fprintf(f, "*** Chinese Zodiac Report\n\n");
  fprintf(f, TXT_LINE_ONE);
  fprintf(f, TXT_LINE_TWO);
  fprintf(f, TXT_LINE_THREE);

  sort_data(SORT_TYPE_CHINESE, 0, 0);

  LLSnodePtr2First(ListCharts);

  do
  {
	LLSnodeDataTo(ListCharts, &c);

/*	if (prev_year != c.born.year)
	{
	   fprintf(f, "\n\n** %s\n", chinese_zodiac_txt[
           prev_year = c.born.year;
	} */

//     fprintf(f, "\n  %s in %s\n", bodytxt[body], sign_txt[sign]);

  } while (LLSnodePtr2Next(ListCharts));

  fprintf(f, "\n\n-- end of list (of %i people)\n", charts);

  fclose(f);

  printf("\n");

  return TRUE;

} /* write_data() */


