## Copyright (C) 1996, 1997 John W. Eaton
##
## This file is part of Octave.
##
## Octave is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
##
## Octave is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with Octave; see the file COPYING.  If not, write to the Free
## Software Foundation, 59 Temple Place - Suite 330, Boston, MA
## 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} mplot (@var{x}, @var{y})
## @deftypefnx {Function File} {} mplot (@var{x}, @var{y}, @var{fmt})
## @deftypefnx {Function File} {} mplot (@var{x1}, @var{y1}, @var{x2}, @var{y2})
## This is a modified version of the @code{plot} function that works with
## the multiplt version of @code{gnuplot} to plot multiple plots per page. 
## This plot version automatically advances to the next subplot position
## after each set of arguments are processed.
## 
## See the description of the @var{plot} function for the various options.
## @end deftypefn

## Author: Vinayak Dutt <Dutt.Vinayak@mayo.EDU>
## Adapted-By: jwe

function mplot (...)

  if (! gnuplot_has_multiplt)
    error ("mplot: gnuplot does not appear to support this feature");
  endif

  ## global variables to keep track of multiplt options

  global __multiplt_mode__ = 0;
  global __multiplt_xsize__;
  global __multiplt_ysize__;
  global __multiplt_xn__;
  global __multiplt_yn__;
  global __multiplt_xi__;
  global __multiplt_yi__;

  gset nologscale;
  gset nopolar;

  __plt__ ("plot", all_va_args);

  ## update the plot position

  if (__multiplt_mode__)

    if (__multiplt_xi__ < __multiplt_xn__)
      __multiplt_xi__++;
    else
      __multiplt_xi__ = 1;
      if (__multiplt_yi__ < __multiplt_yn__)
	__multiplt_yi__++;
      else
	__multiplt_yi__ = 1;
      endif
    endif

    xo = (__multiplt_xi__ - 1.0) * __multiplt_xsize__;
    yo = (__multiplt_yn__ - __multiplt_yi__) * __multiplt_ysize__;

    eval (sprintf ("gset origin %g, %g", xo, yo));

  endif

endfunction
