## Copyright (C) 1996, 1997 John W. Eaton
##
## This file is part of Octave.
##
## Octave is free software; you can redistribute it and/or modify it
## under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
##
## Octave is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with Octave; see the file COPYING.  If not, write to the Free
## Software Foundation, 59 Temple Place - Suite 330, Boston, MA
## 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} multiplt (@var{xn}, @var{yn})
## Sets and resets multiplt mode.
## 
## If the arguments are non-zero, @code{multiplt} will set up multiplt
## mode with @var{xn}, @var{yn} subplots along the @var{x} and @var{y}
## axes.  If both arguments are zero, @code{multiplt} closes multiplt
## mode.
## @end deftypefn

## Author: Vinayak Dutt, Dutt.Vinayak@mayo.EDU
## Created: 3 July 95
## Adapted-By: jwe

function multiplt (xn, yn)

  if (! gnuplot_has_multiplt)
    error ("multiplt: gnuplot does not appear to support this feature");
  endif

  ## global variables to keep track of multiplt options

  global __multiplt_mode__ = 0;
  global __multiplt_xsize__;
  global __multiplt_ysize__;
  global __multiplt_xn__;
  global __multiplt_yn__;
  global __multiplt_xi__;
  global __multiplt_yi__;

  if (nargin != 2)
    usage ("multiplt (xn, yn)");
  endif

  if (! (is_scal (xn) && is_scal (yn)))
    error ("multiplt: xn and yn have to be scalars");
  endif

  xn = round (xn);
  yn = round (yn);

  if (xn == 0 && yn == 0)

    oneplot ();

    ## XXX FIXME XXX -- do we really need to reset these here?

    __multiplt_xsize__ = 1;
    __multiplt_ysize__ = 1;
    __multiplt_xn__ = 1;
    __multiplt_yn__ = 1;
    __multiplt_xi__ = 1;
    __multiplt_yi__ = 1;

  else

    if (xn < 1 || yn < 1)
      error ("multiplt: xn and yn have to be positive integers");
    endif

    gset multiplt;

    xsize = 1.0 ./ xn;
    ysize = 1.0 ./ yn;

    eval (sprintf ("gset size %g, %g", xsize, ysize));

    xo = 0.0;
    yo = (yn - 1.0)*ysize;

    eval (sprintf ("gset origin %g, %g", xo, yo));

    __multiplt_mode__ = 1;
    __multiplt_xsize__ = xsize;
    __multiplt_ysize__ = ysize;
    __multiplt_xn__ = xn;
    __multiplt_yn__ = yn;
    __multiplt_xi__ = 1;
    __multiplt_yi__ = 1;

    gnuplot_command_replot = "cle;rep";

    clearplot;

  endif

endfunction
