#include <config.h>
/* $Id: say.c,v 1.13 1994/11/08 13:30:50 a904209 Exp a904209 $
	$Log: say.c,v $
 * Revision 1.13	1994/11/08	13:30:50  a904209
 * 2.0 release
 *
 * Revision 1.12	1994/11/04	13:32:31  a904209
 * 1.99.1 - Change configure stuff
 *
 * Revision 1.11	1994/11/02	10:55:31  a904209
 * Add autoconf. Tested on SunOS/Solaris
 *
 * Revision 1.10	1994/10/04	17:12:50  a904209
 * 3rd pre-release
 *
 * Revision 1.9  1994/10/04  09:08:27	a904209
 * Next Patch merge
 *
 * Revision 1.8  1994/10/03  08:41:47	a904209
 * 2nd pre-release
 *
 * Revision 1.7  1994/09/19  15:48:29	a904209
 * Split hplay.c, gdbm dictionary, start of f0 contour, netaudio and HP ports
 *
 * Revision 1.6  1994/04/15  16:47:37	a904209
 * Edits for Solaris2.3 (aka SunOs 5.3)
 *
 * Revision 1.5  1994/02/24  15:03:05	a904209
 * Added contributed linux, NeXT and SGI ports.
 *
 * Revision 1.4  93/11/18	16:29:06  a904209
 * Migrated nsyth.c towards Jon's scheme - merge still incomplete
 *
 * Revision 1.3  93/11/16	14:32:44  a904209
 * Added RCS Ids, partial merge of Jon's new klatt/parwave
 *
 * Revision 1.3  93/11/16	14:00:58  a904209
 * Add IDs and merge Jon's klatt sources - incomplete
 *
 */
char *say_id = "$Id: say.c,v 1.13 1994/11/08 13:30:50 a904209 Exp a904209 $";
extern char *Revision;
#define INCL_VIO
#define INCL_DOS
#define INCL_KBD
#include <os2.h>
#include <stdio.h>
#include <stdarg.h>
#include <ctype.h>
#include <useconfig.h>
#include <math.h>
#include <signal.h>
#include <setjmp.h>
#include <float.h>
#include "proto.h"
#include "nsynth.h"
#include "hplay.h"
#include "dict.h"
#include "ASCII.h"
#include "darray.h"
#include "holmes.h"
#include "phtoelm.h"
#include "text.h"
#include "getargs.h"
#include "phones.h"
#include "btserver.h"
#include "btalk.h"

char *program = "say";

char *sentence; /* bring along the way the original string */

/* options */
int verbose = 0,
	 text = 1,
	 show_ignore = 0;

/* resets the state of quiet after a playback */
BOOL muted;

/* queue item counter */
ULONG numqueue = 0;

struct SEMQUE
{
	HEV sem;
	HQUEUE que;
};

/* screen data */
struct WINDOW
{
	USHORT orgy;
	USHORT orgx;
	USHORT maxy;
	USHORT maxx;
};

VIOMODEINFO screen;
VIOCURSORINFO cursor;
struct WINDOW window;

struct POS
{
	USHORT x;
	USHORT y;
};

struct POS volumepos, amppos, mutepos, numqueuepos;


jmp_buf mark; /* ?? */


unsigned
spell_out(word, n, phone)
char *word;
int n;
darray_ptr phone;
{
 unsigned nph = 0;
/* printf("Spelling '%.*s'\n", n, word); */

 while (n-- > 0)
  {
	nph += xlate_string(ASCII[*word++ & 0x7F], phone);
  }
 return nph;
}

int
suspect_word(s, n)
char *s;
int n;
{
 int i = 0;
 int seen_lower = 0;
 int seen_upper = 0;
 int seen_vowel = 0;
 int last = 0;
 for (i = 0; i < n; i++)
  {
	char ch = *s++;
	if (i && last != '-' && isupper(ch))
	 seen_upper = 1;
	if (islower(ch))
	 {
	  seen_lower = 1;
	  ch = toupper(ch);
	 }
	if (ch == 'A' || ch == 'E' || ch == 'I' || ch == 'O' || ch == 'U' || ch == 'Y')
	 seen_vowel = 1;
	last = ch;
  }
 return !seen_vowel || (seen_upper && seen_lower) || !seen_lower;
}

static unsigned xlate_word PROTO((char *word, int n, darray_ptr phone));

static unsigned
xlate_word(word, n, phone)
char *word;
int n;
darray_ptr phone;
{
 unsigned nph = 0;

 if (*word != '[')
  {
	if (dict)
	 {
	  unsigned char *p = dict_find(word, n);
	  if (p)
		{
		 unsigned char *s = p;
		 while (*s)
		  {
			char *x = dialect[(unsigned) (*s++)];
			while (*x)
			 {
			  phone_append(phone, *x++);
			  nph++;
			 }
		  }
		 phone_append(phone, ' ');
		 free(p);
		 return nph + 1;
		}
	  else
		{
		 /* If supposed word contains '.' or '-' try breaking it up... */
		 char *h = word;
		 while (h < word + n)
		  {
			if (*h == '.' || *h == '-')
			 {
			  nph += xlate_word(word, h++ - word, phone);
			  nph += xlate_word(h, word + n - h, phone);
			  return nph;
			 }
			else
			 h++;
		  }
		}
	 }
	if (suspect_word(word, n))
	 {
		nph = spell_out(word, n, phone);
		return(nph);
	 }
	else
	 {
	  if (dict || verbose)
		/* fprintf(stderr, "Guess %p '%.*s'\n", dict, n, word) */;
	  nph += NRL(word, n, phone);
	 }
  }
 else
  {
	if ((++word)[(--n) - 1] == ']')
	 n--;
	while (n-- > 0)
	 {
	  phone_append(phone, *word++);
	  nph++;
	 }
  }
 phone_append(phone, ' ');
 return nph + 1;
}

void
say_phones(phone, len, verbose)
char *phone;
int len;
int verbose;
{
 char *visible_sentence, *visible_phone;
 darray_t elm;
 unsigned frames;
 darray_init(&elm, sizeof(char), len);
 if ((frames = phone_to_elm(phone, len, &elm)))
  {
	unsigned max_samples = frames * klatt_global.nspfr;
	short *samp = (short *) malloc(sizeof(short) * max_samples);
/*   if (verbose)
	 printf("%.*s\n", len, phone); */
	if (samp)
	 {
	  unsigned nsamp;

	  nsamp = holmes(elm.items, (unsigned char *) darray_find(&elm, 0),
									  max_samples, samp);

	  phone[len] = '\0';
	  visible_sentence = (char *) malloc((strlen(sentence) + 1) * sizeof(char));
	  visible_phone = (char *) malloc((strlen(phone) + 1) * sizeof(char));
	  strcpy(visible_sentence,sentence);
	  strcpy(visible_phone,phone);
	  audio_play(nsamp, samp, visible_sentence, visible_phone);

	  free(sentence);
	  sentence = calloc(1, sizeof(char));

	  free(samp);
	 }
  }
 darray_free(&elm);
}




unsigned
xlate_string(string, phone)
char *string;
darray_ptr phone;
{
 unsigned nph = 0;
 char *s = string;
 char ch;

 while (isspace(ch = *s))
  s++;
 while ((ch = *s))
  {
	char *word = s;
	if (isalpha(ch))
	 {
	  while (isalpha(ch = *s) || ((ch == '\'' || ch == '-' || ch == '.') && isalpha(s[1])))
		s++;
	  if (!ch || isspace(ch) || ispunct(ch) || (isdigit(ch) && !suspect_word(word, s - word)))
		{
		nph += xlate_word(word, s - word, phone);
		}
	  else
		{
		 while ((ch = *s) && !isspace(ch) && !ispunct(ch))
		  s++;
		 nph += spell_out(word, s - word, phone);
		}
	 }
	else if (isdigit(ch) || (ch == '-' && isdigit(s[1])))
	 {
	  int sign = (ch == '-') ? -1 : 1;
	  long value = 0;
	  if (sign < 0)
		ch = *++s;
	  while (isdigit(ch = *s))
		{
		 value = value * 10 + ch - '0';
		 s++;
		}
	  if (ch == '.' && isdigit(s[1]))
		{
		 word = ++s;
		 nph += xlate_cardinal(value * sign, phone);
		 nph += xlate_string("point", phone);
		 while (isdigit(ch = *s))
		  s++;
		 nph += spell_out(word, s - word, phone);
		}
	  else
		{
		 /* check for ordinals, date, time etc. can go in here */
		 nph += xlate_cardinal(value * sign, phone);
		}
	 }
	else if (ch == '[' && strchr(s, ']'))
	 {
	  char *word = s;
	  while (*s && *s++ != ']')
		/* nothing */ ;
	  nph += xlate_word(word, s - word, phone);
	 }
	else if (ispunct(ch))
	 {
	  switch (ch)
		{
		  /* On end of sentence flush the buffer ... */
		 case '!':
		 case '?':
		 case '.':
		  if ((!s[1] || isspace(s[1])) && phone->items)
			{
			 say_phones((char *) darray_find(phone, 0), phone->items, verbose);
			 phone->items = 0;
			}
		  s++;
		  phone_append(phone, ' ');
		  break;
		 case '"':                 /* change pitch ? */
		 case ':':
		 case '-':
		 case ';':
		 case ',':
		 case '(':
		 case ')':
		  s++;
		  phone_append(phone, ' ');
		  break;
		 case '[':
		  {
			char *e = strchr(s, ']');
			if (e)
			 {
			  s++;
			  while (s < e)
				phone_append(phone, *s++);
			  s = e + 1;
			  break;
			 }
		  }
		 default:
		  nph += spell_out(word, 1, phone);
		  s++;
		  break;
		}
	 }
	else
	 {
	  while ((ch = *s) && !isspace(ch))
		s++;
	  nph += spell_out(word, s - word, phone);
	 }
	while (isspace(ch = *s))
	 s++;
  }
 return nph;
}

char *
concat_args(argc, argv)
int argc;
char *argv[];
{
 int len = 0;
 int i;
 char *buf;
 for (i = 1; i < argc; i++)
  len += strlen(argv[i]) + 1;
 buf = (char *) malloc(len);
 if (buf)
  {
	char *d = buf;
	for (i = 1; i < argc;)
	 {
	  char *s = argv[i++];
	  while (*s)
		*d++ = *s++;
	  if (i < argc)
		*d++ = ' ';
	  else
		*d = '\0';
	 }
  }
 return buf;
}

void
say_string(s)
char *s;
{
 darray_t phone;
 darray_init(&phone, sizeof(char), 128);
 xlate_string(s, &phone);
 sentence = (char *) realloc(sentence, (strlen(s) + strlen(sentence) + 2) * sizeof(char));
 strcat(sentence, s);
 if (phone.items)
  say_phones((char *) darray_find(&phone, 0), phone.items, verbose);
 darray_free(&phone);
}

extern int darray_fget PROTO((FILE * f, darray_ptr p));

int
darray_fget(f, p)
FILE *f;
darray_ptr p;
{
 int ch;
 while ((ch = fgetc(f)) != EOF)
  {
	phone_append(p, ch);
	if (ch == '\n')
	 break;
  }
 phone_append(p, '\0');
 return p->items - 1;
}

extern void say_file PROTO((FILE * f));

void
say_file(f)
FILE *f;
{
 char *temp = NULL;
 darray_t line;
 darray_t phone;
 darray_init(&line, sizeof(char), 128);
 darray_init(&phone, sizeof(char), 128);

 while (darray_fget(f, &line))
  {
	temp = (char *) darray_find(&line, 0);
	sentence = (char *) realloc(sentence, (strlen(temp) + strlen(sentence) + 2) * sizeof(char));
	strcat(sentence, temp);
	xlate_string(temp, &phone);
	line.items = 0;
  }
 if (phone.items)
  say_phones((char *) darray_find(&phone, 0), phone.items, verbose);
 darray_free(&phone);
 darray_free(&line);
}

void StatusThread(void *arg)
{
	ULONG resetcount;
	struct SEMQUE *semque = (struct SEMQUE *) arg;
	char scrstr[10];

	while(1)
	{
		DosQueryQueue(semque->que, &numqueue);
		snprintf(scrstr,10,"%3d",numqueue);
		VioWrtCharStr(scrstr, strlen(scrstr), numqueuepos.y, numqueuepos.x, 0);
		DosWaitEventSem(semque->sem,-1);
		DosResetEventSem(semque->sem,&resetcount);
	}
}

void KeyboardThread(void *arg)
{
	KBDKEYINFO key;
	struct SEMQUE *semque = (struct SEMQUE *) arg;
	char scrstr[10];

	_itoa(volume,scrstr,10);
	VioWrtCharStr(scrstr, strlen(scrstr), volumepos.y, volumepos.x, 0);
	snprintf(scrstr,10,"%.1f",ampfactor);
	VioWrtCharStr(scrstr, strlen(scrstr), amppos.y, amppos.x, 0);
	quiet = muted = FALSE;
	VioWrtCharStr("unmuted  ", 7, mutepos.y, mutepos.x, 0);

	while(key.chChar != 27)
	{
		KbdCharIn(&key,IO_WAIT,0);

		switch(key.chChar)
		{
			case '+':
				if(volume < 100)
				{
					volume++;
					set_volume();
					snprintf(scrstr,10,"%-3d",volume);
					VioWrtCharStr(scrstr, strlen(scrstr), volumepos.y, volumepos.x, 0);
				}
				break;
			case '-':
				if(volume > 0)
				{
					volume--;
					set_volume();
					snprintf(scrstr,10,"%-3d",volume);
					VioWrtCharStr(scrstr, strlen(scrstr), volumepos.y, volumepos.x, 0);
				}
				break;
			case '*':
				ampfactor += 0.1f;
				snprintf(scrstr,10,"%-4.1f",ampfactor);
				VioWrtCharStr(scrstr, strlen(scrstr), amppos.y, amppos.x, 0);
				break;
			case '/':
				if(ampfactor > 0)
				{
					ampfactor -= 0.1f;
					snprintf(scrstr,10,"%-4.1f",ampfactor);
					VioWrtCharStr(scrstr, strlen(scrstr), amppos.y, amppos.x, 0);
				}
				break;
			case 'm':
			case 'M':
				quiet = muted = TRUE;
				VioWrtCharStr("muted  ", 7, mutepos.y, mutepos.x, 0);
				break;
			case 'u':
			case 'U':
				quiet = muted = FALSE;
				VioWrtCharStr("unmuted  ", 7, mutepos.y, mutepos.x, 0);
				break;
			case 'p':
			case 'P':
				{
					REQUESTDATA request;
					ULONG size;
					void *pointer;
					BYTE priority;
					struct QUEUEDATA *queuedata;
					while(!DosReadQueue(semque->que, &request, &size, &pointer, 0, DCWW_NOWAIT, &priority, semque->sem))
						if(queuedata = (struct QUEUEDATA *) pointer)
						{
							if(queuedata->string)
								DosFreeMem(queuedata->string);
							DosFreeMem(queuedata);
						}
					DosPostEventSem(semque->sem);
					stop_audio();
					break;
				}
		}
	}

	term_holmes();
	if (dict)
	  dict_term();

	VioScrollUp(0, 0, -1, -1, -1, " \x7", 0);
	VioSetCurPos(0,0,0);
	VioSetCurType(&cursor, 0);

	printf("\n"
			 "Thank You for using BackTalk!  Don't forget to send me e-mail\n"
          "(or anything else) - Samuel Audet <guardia@cam.org>\n");

	DosExit(EXIT_PROCESS,0);
}

/* prints within the margin provided in the window variable of structure WINDOW
	found in a global variable */
int winprintf(char *fmt, ... )
{
	char *current;
	va_list args;
   char string[2048]; /* let's hope it doesn't go over, bug in vsnprintf() */
	int rc;

	/* "virtual cursor" */
	static ULONG x = 0, y = 0;

	va_start(args, fmt);
	rc = vsnprintf(string, 2048, fmt, args);
	va_end(args);

	for(current = string ; *current ; current++)
		if (*current == '\n')
		{
			if(y + window.orgy + 1 == window.maxy)
				VioScrollUp(window.orgy, window.orgx, window.maxy, window.maxx, 1, " \x7", 0);
			else
				y++;
			x = 0;
		}
		else if (*current == '\t')
			while(fmod(++x,8))
				VioWrtCharStr(" ", 1, (window.orgy + y), (window.orgx + x), 0);
		else
		{
			if (window.orgx + x == window.maxx)
			{
				if(y + window.orgy + 1 == window.maxy)
					VioScrollUp(window.orgy, window.orgx, window.maxy, window.maxx, 1, " \x7", 0);
				else
					y++;
				x = 0;
			}
			VioWrtCharStr(current, 1, (window.orgy + y), (window.orgx + x++), 0);
		}

	return rc;
}


int main(int argc, char *argv[])
{

 _control87(EM_INVALID | EM_DENORMAL | EM_ZERODIVIDE | EM_OVERFLOW | EM_UNDERFLOW | EM_INEXACT, MCW_EM);

 sentence = calloc(1, sizeof(char));

 VioScrollUp(0, 0, -1, -1, -1, " \x7", 0);
 VioSetCurPos(0,0,0);

 screen.cb = sizeof(screen);
 VioGetMode(&screen,0);
 window.orgy = 4;
 window.orgx = 0;
 window.maxy = screen.row;
 window.maxx = screen.col;

 argc = audio_init(argc, argv);
 argc = init_synth(argc, argv);
 argc = init_holmes(argc, argv);
 argc = dict_init(argc, argv);
 argc = getargs("Misc",argc, argv,
					 "T", NULL, &text, "Text, show readable text",
					 "v", NULL, &verbose, "Verbose, show unreadable phonemes",
					 "i", NULL, &show_ignore, "Display pronunciation conversion errors",
					 NULL);

 if(!help_only)
 {
	struct SEMQUE semque;

	VioGetCurType(&cursor, 0);
	cursor.attr = -1;
	VioSetCurType(&cursor, 0);
	cursor.attr = 0;

	if (!DosCreateQueue(&(semque.que), QUE_PRIORITY | QUE_CONVERT_ADDRESS, QUEUE) &&
		 !DosCreateEventSem(SEMAPHORE,&(semque.sem),1,0)										)
	{
		REQUESTDATA request;
		ULONG size;
		void *pointer;
		BYTE priority;

		struct QUEUEDATA *queuedata,tempdata;

		ULONG tid[2];

		char *scrstr;

		FILE *file;
		ULONG csid;
		PID cpid;
		STARTDATA startdata = {0};
		startdata.Length = sizeof(startdata);

		/* show control panel */

      scrstr = "BackTalk 2.01     (C) 1996-1997 Samuel Audet <guardia@cam.org>";
		VioWrtCharStr(scrstr, strlen(scrstr), 0, 0, 0);
		scrstr = "Keys:    Esc           - +                 / *       U/M          P        items";
		VioWrtCharStr(scrstr, strlen(scrstr), 1, 0, 0);
		scrstr = "Actions: Exit  Volume:      Amplification:      Sound           Purge     queued";
		VioWrtCharStr(scrstr, strlen(scrstr), 2, 0, 0);
		volumepos.x = 23; volumepos.y = 2;
		amppos.x = 43; amppos.y = 2;
		mutepos.x = 54; mutepos.y = 2;
		numqueuepos.x = 71; numqueuepos.y = 1;

		/* startup programs */

		if(file = fopen("btstart.lst","r"))
		{
			char temp[CCHMAXPATH],temp2[CCHMAXPATH];

			startdata.Related = SSF_RELATED_CHILD;
			startdata.FgBg = SSF_FGBG_BACK;
			startdata.PgmControl = SSF_CONTROL_MINIMIZE;
			startdata.InheritOpt = SSF_INHERTOPT_PARENT;
			startdata.PgmName = temp;
			startdata.ObjectBuffer = temp;
			startdata.ObjectBuffLen = sizeof(temp);
			while(fgets(startdata.PgmName,sizeof(temp),file))
			{
				ULONG rc;
				char *pos;

				if(pos = strchr(startdata.PgmName,'\n'))
					*pos = '\0';
				startdata.PgmInputs = strchr(startdata.PgmName,' ');
				if(startdata.PgmInputs)
					*(startdata.PgmInputs++) = '\0';
				else
					startdata.PgmInputs = "";

				/* for some god saken reason, dosstartsession starts VIO
					sessions in full screen when SSF_INHERTOPT_PARENT is set and
					that the full path to the program isn't given to it */

			  if(strlen(startdata.PgmName))	/* the whole system jams on 0 length strings !?? */
			  {
					winprintf("Starting: %s %s", startdata.PgmName, startdata.PgmInputs);

					if(strchr(startdata.PgmName,'\\'))
					{
						if(!DosQueryPathInfo(startdata.PgmName, FIL_QUERYFULLNAME, temp2, sizeof(temp2)))
							startdata.PgmName = temp2;
					}
					else if(!DosSearchPath(SEARCH_CUR_DIRECTORY | SEARCH_ENVIRONMENT | SEARCH_IGNORENETERRS,
											  "PATH",startdata.PgmName,&temp2,sizeof(temp2)))
						startdata.PgmName = temp2;

					if(rc = DosStartSession(&startdata,&csid,&cpid))
						winprintf(" -> failed  rc = %d  failure due to %s",rc,startdata.ObjectBuffer);
					winprintf("\n");

					startdata.PgmName = temp;
				}
			}
			fclose(file);
		}

		/* threads that are going to watch for user input and queue status */

		tid[0] = _beginthread(KeyboardThread,0,16384,(void *) &semque);
		tid[1] = _beginthread(StatusThread,0,8192,(void *) &semque);

		while(1) /* forever */
		{
			DosReadQueue(semque.que, &request, &size, &pointer, 0, DCWW_WAIT, &priority, 0);
			DosPostEventSem(semque.sem);

			queuedata = (struct QUEUEDATA *) pointer;

			tempdata.F0hz10 = def_pars.F0hz10;
			tempdata.nspfr = klatt_global.nspfr;
			tempdata.f0_flutter = klatt_global.f0_flutter;

			if (queuedata->F0hz10) def_pars.F0hz10 = queuedata->F0hz10;
			if (queuedata->mSec_per_frame) klatt_global.nspfr = (klatt_global.samrate * queuedata->mSec_per_frame) / 1000;
			if (queuedata->f0_flutter) klatt_global.f0_flutter = queuedata->f0_flutter;

         quiet = muted;
         start_audio();

			switch(request.ulData)
			{
				case SAYSTRING:
					if(queuedata->string) say_string(queuedata->string);
					break;

				case SAYFILE:
					if(queuedata->string)
					{
						if(file = fopen(queuedata->string,"r"))
						{
							say_file(file);
							fclose(file);
						}
					}
					break;

				case NUMQUEUE:
				{
					char temp[200];
					DosQueryQueue(semque.que, &numqueue);
					if (numqueue == 0)
						say_string("There is no item queued.");
					else if (numqueue == 1)
						say_string("There is one item queued.");
					else
					{
						strcpy(temp,"There are ");
						_itoa(numqueue,strchr(temp,'\0'),10);
						strcat(temp," items queued.");
						say_string(temp);
					}
					break;
				}
			}

			end_audio();

			if(queuedata)
			{
				if(queuedata->string)
					DosFreeMem(queuedata->string);
				DosFreeMem(queuedata);
			}

			winprintf("\n");
			def_pars.F0hz10 = tempdata.F0hz10;
			klatt_global.nspfr = tempdata.nspfr;
			klatt_global.f0_flutter = tempdata.f0_flutter;

		} /* while forever */

	} /* if create queue */

 term_holmes();
 if (dict)
  dict_term();

 VioScrollUp(0, 0, -1, -1, -1, " \x7", 0);
 VioSetCurPos(0,0,0);
 VioSetCurType(&cursor, 0);

 printf("\nBackTalk server already running!\n");

 } /* if !help_only */

 return (0);
}
