#define INCL_WIN
#define INCL_GPI
#define INCL_DOS
#define M2Z

#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <bseerr.h>
#include "feed.h"

void contFeed(void)
{
    // supports the 2.0, 2.0.1, and 2.0.2 demo sheets
    #define OLDNUM 11
    static char *oldnames[OLDNUM] = {"HOPII","STONE","MESAC",
        "CARGZ","ARCSD","SNTFE","FLAGS",
        "PHNIX","ALBQU","CACTS","TBLWD"};
    static double oldvalues[OLDNUM] = {75,35,17,30,13,37,16,9,19,62,24};


    #define NUM 6
    static char *names[NUM] = {"DM","RAND","FRANC","POUND","PESATA","ESCUDO"};
    static double values[NUM] = {1.55,3.6,5.1,0.62,125.0,150.0};
    static double values2[NUM] = {1.55,3.6,5.1,0.62,125.0,150.0};
    static double ranges[NUM * 2] = {1.63,1.47,4.1,3.3,5.5,4.85,0.7,0.57,
                                        137.00,115.00,183.00,135.00};
    int x;

    for (;;) {
        int t;
        double d;
        double rng;

        for (x = 0; x < OLDNUM; x++)
        {
            setRTFValue("BID",oldnames[x],oldvalues[x]);
            d = rand();
            d /= 32767;
            d -= 0.5;
            d /= 50;
            d += 1;
            oldvalues[x] *= d;
            oldvalues[x] *= 100;
            t = oldvalues[x];
            oldvalues[x] = t;
            oldvalues[x] /= 100;
        }

        for (x = 0; x < NUM; x++)
        {
            setRTFValue(names[x],"CURRENT",values[x]);
            setRTFValue(names[x],"+30",values2[x]);

            rng = (ranges[x * 2] - ranges[x * 2 + 1]);

            t = rand() % 100;
            t -= 50;
            d = t;
            d = rng * d/1000;
            d += values[x];
            if (d > ranges[x * 2]) {
                d = ranges[x * 2];
            } else if ( d < ranges[x * 2 +1]) {
                d = ranges[x * 2 +1];
            } // endif
            values[x] = d;

            t = rand() % 100;
            t -= 50;
            d = t;
            d = rng * d/1000;
            d += values2[x];
            if (d > ranges[x * 2]) {
                d = ranges[x * 2];
            } else if ( d < ranges[x * 2 +1]) {
                d = ranges[x * 2 +1];
            } // endif
            values2[x] = d;
        }

        DosSleep(200);
    }
}

main(int argc,char **argv)
{

    if (argc == 4) {
        setRTFValue(argv[1],argv[2],atof(argv[3]));
    }
    else if (argc == 2 && !strcmp(argv[1],"-t")) contFeed();

    else printf("To send a single value to the Mesa Real Time System, type \"FEED key1 key2 value\"\nwhere key1 & 2 are strings denoting the keys used to look up the values\nvalue is a number which contains the value to set.\nTo run the feed program continuously, type \"FEED -t\" at the command prompt\n");

    return 0;
}
