#include "os2h.h"

extern "C"
{
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
}

#define LWD


HAB myHab;
HMQ myHmq;

HWND myFrame,myText;


int forkThread(void *func,void *data)
{
	ULONG tmp;

#ifdef BORLAND
	DosCreateThread(&tmp,(PFNTHREAD) func,(ULONG) data,0,32 * 1024);
#else
	tmp = _beginthread(( void ( * _Optlink  )( void * ))func,(int) NULL,32 * 1024,data);
#endif

	return tmp;
}

static int dialing = 0;

void dial(void *)
{
	if (!dialing) {
		FILE *num,*ser;
		char tmp[1000];

		dialing = 1;

		num = fopen("c:/Mesa/phone.num","r");
		if (num) {
			fscanf(num,"%s\n",tmp);
			fclose(num);

			ser = fopen("com1","w");
			if (ser) {
				fprintf(ser,"%s\n",tmp);
				DosSleep(45000);
				fclose(ser);
			}
		}


		dialing = 0;
	}
}

MRESULT EXPENTRY myPageWindowProc(HWND hw,ULONG msg,MPARAM mp1,MPARAM mp2)
{
	int handled = 1;
	MRESULT ret = 0;

	switch (msg) {
		case WM_INITDLG:
			myFrame = hw;
			myText = WinWindowFromID(hw,101);
			handled = 0;
			break;

		case WM_USER:
			WinSetWindowText(myText,(PSZ)mp1);
			if (strlen((char *) mp1) > 2) {
				forkThread(dial,NULL);
			}

			free((void *)mp1);
			break;

		default:
			handled = 0;
	}

	if (!handled) ret = WinDefDlgProc(hw,msg,mp1,mp2);

	return ret;

}


void listenToPort(void *)
{
	HFILE phil;
	char *t;

	DosCreateNPipe((PSZ) "\\pipe\\Pager",&phil,
		NP_ACCESS_INBOUND | NP_NOINHERIT | NP_WRITEBEHIND,
		NP_WAIT | NP_TYPE_MESSAGE | NP_READMODE_MESSAGE | 1,
		4096,4096,0);

	for (;;) {
		char n1[256];
		ULONG len;

		DosConnectNPipe(phil);
		DosRead(phil,&n1,sizeof(n1),&len);
		if (len == sizeof(n1)) {
			t = (char *) malloc(sizeof(n1));
			strcpy(t,n1);
			WinPostMsg(myFrame,WM_USER,(MPARAM) t,0);
		}
		DosDisConnectNPipe(phil);
	}
}

void clearDisplay(void *)
{
	for (;;) {
		char *t;

		DosSleep(5000);
		t = (char *) malloc(100);
		t[0] = 0;
		WinPostMsg(myFrame,WM_USER,(MPARAM) t,0);
	}
}


int main(int,char **)
{
	ULONG flCreate;

	myHab = WinInitialize(0);
	myHmq = WinCreateMsgQueue(myHab,0);

	forkThread(listenToPort,(void *)0);
	forkThread(clearDisplay,(void *)0);

	WinDlgBox(HWND_DESKTOP,HWND_DESKTOP,myPageWindowProc,0,1,0);

	WinDestroyMsgQueue(myHmq);
	WinTerminate(myHab);

	return 0;

}

