/*-------------------REXX routine---------------------------*
 *File: instini.cmd                                                           *
 *Purpose: Replace the epfidlds.exe in install.in_  on the user's machine. *
 *Called only for distribution install. 					       *	
 *Arguments expected:                                                       *
 *thiscmd -  full path to the update source directory.                      *  
 *instDir  -  the previous install directory                                  *      
 *--------------------------------------------------------- */


PARSE SOURCE .  . thiscmd

/*Get the Install Dir from the arguments.Parse argument list in uppercase.*/
ARG   instDir 

'@ECHO OFF'

/*  Load REXX functions.  */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Find out the directory of this command file. */
cwdpath = filespec('drive', thiscmd) || filespec('path', thiscmd)

/* Save the current directory. */
curdir=directory() 

/* Set required current directory. */
call directory(instDir) 

/*Calls below to replace the file epfidlds.exe in install.in_.*/
cwdpath||'epfipak2.exe '||' epfidlds.exe install.in_ /r' 
cwdpath||'epfipak2.exe '|| cwdpath||'epfidlds.exe install.in_ /a'

/* Reset original current directory. */
call directory(cwdpath)

EXIT