/* Rexx */

trace o

lanpath = ''

Call Determine_RIPL_Directory

"@SET NSWSIBMLAN="lanpath
"@SET NSWSDIRENV="rpldir
"@SET NSWSSERVER="servername

return




Determine_RIPL_Directory:
   /* find out where IBMLAN is installed */
   os2path = value('PATH',,'OS2ENVIRONMENT')

   If lanpath = '' Then Do
      ibmlanp = pos(':\IBMLAN', translate(os2path))
      if ibmlanp = 0 Then return 4

      landrv = substr(os2path, ibmlanp-1, 1)
      lanpath = landrv || ':\IBMLAN'
   end

   fname = lanpath || '\IBMLAN.INI'
   servername = ''
   domainname = ''
   rpldir = ''
   rpluserdir = ''

   /* read IBMLAN.INI looking for the COMPUTERNAME, DOMAIN, RPLDIR, and */
   /* RPLUSERDIR entries */
   parmcnt = 4
   do until lines(fname) = 0
      data = translate(linein(fname))
      If substr(data, 1, 1) <> ';' Then Do
         keyword = word(data, 1)
         dpos = pos('=', keyword)
         If dpos > 0 Then keyword = substr(keyword, 1, dpos-1)
         eqpos = pos('=', data)
         If eqpos > 0 Then Do
            Select
              When keyword = 'COMPUTERNAME' Then Do
                   servername = strip(substr(data, eqpos+1))
                   parmcnt = parmcnt - 1
              end

              When keyword = 'DOMAIN' Then Do
                   domainname = strip(substr(data, eqpos+1))
                   parmcnt = parmcnt - 1
              end

              When keyword = 'RPLDIR' Then Do
                   rpldir = strip(substr(data, eqpos+1))
                   parmcnt = parmcnt - 1
              end

              When keyword = 'RPLUSERDIR' Then Do
                   rpluserdir = strip(substr(data, eqpos+1))
                   parmcnt = parmcnt - 1
              end

              otherwise;
            end
         end
         If parmcnt <= 0 Then Leave
      end
   end
   Call stream fname, 'C', 'close'

   if servername = '' then return 4

   if domainname = '' then return 4

   if rpldir = '' then return 4

   if rpluserdir = '' then return 4

   return 0


