/* REXX Script to create a My_URLs <WEBXURLS> folder on the desktop */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

result = SysIni('USER', 'PM_Workplace:Location', '<WEBXURLS>', 'DELETE:')
if result <> 'ERROR:' then
	SAY '<WEBXURLS> object (My_URLs folder) removed from the USER INI successfully!'

fldrName = 'My_URLs'
destination = '<WP_DESKTOP>'
If SysCreateObject("WPFolder", fldrName, destination, "CCVIEW=YES;ICONFONT=8.Helv;ALWAYSSORT=YES;DEFAULTSORT=3;DEFAULTVIEW=ICON;ICONVIEW=NONFLOWED,MINI;OBJECTID=<WEBXURLS>;", "fail") Then
Do
	rc = SysSetObjectData('<WEBXURLS>', 'ICONFILE=' || DIRECTORY() || '\Icons\NETF.ICO;ICONNFILE=1,' || DIRECTORY() || '\Icons\NETFOP.ICO')
	rc = SysSaveObject('<WEBXURLS>', 0)
	Say 'Created the My_URLs folder'
End
Else
Do
	Say 'Could not create the folder.  Does it exist still?'
	Say 'If not, try running FIX-FOLD.CMD after deleting all the folders'
	Say 'created by Ini2URLs.  (Then reinstall)'
	Say ' '
	Say 'If this still does not work, email jroepcke@compusmart.ab.ca'
	Say 'for free support.'
	Exit
End
	
