/****************************************************************************/
/* HEADER.REX - Visual HTML common header for simple Rexx CGI scripts       */
/* Set the type of response to HTML text.                                   */
/* Parse the parameters from the previous form.                             */
/* Trap errors and report them back to the caller.                          */
/****************************************************************************/
itrace = 1

say "Content-type: text/html"          /* Send MIME data type for HTML      */
say                                    /* Blank line after all HTTP headers */

signal on SYNTAX name _Syntax_Trap

parse source OPSYS .
if OPSYS="OS/2" then env = "OS2ENVIRONMENT"
else env = "SYSTEM"                    /* REGINA on Unix or NT              */

method=value("REQUEST_METHOD",,env)
len = value("CONTENT_LENGTH",,env)
if (method == "GET") then query_string = value("QUERY_STRING",,env)
If (method == "POST") & (len \= "") Then Do
  post_string = charin(,,len)
  query_string = post_string
  End
NF = ParseQueryString( query_string)

        do i=1 to NF
        Call Value Parms.Tag.i,Parms.XVal.i
        end

signal _End_Header

_Syntax_Trap :
say "<PRE>"
say "This Program ended because it was not written correctly"
say "The error was in line" SIGL
say "Please report the problem to the Webmaster"
say "</PRE>"
exit

_End_Header:
