<?xml version="1.0"?>

  <!--XSLT 1.0 - http://www.untravelledsphere.com -->

<xsl:transform xmlns:xlink="http://www.w3c.org/1999/xlink"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
               version="1.0">
   

 <xsl:include href="variables.xml" />

 <xsl:output method="text" omit-xml-declaration="yes"/>


<xsl:template match="/">
:userdoc. 
  <xsl:apply-templates select="//TechNote/Cover" />
  <xsl:apply-templates select="//TechNote/Section" />
<xsl:text>  
</xsl:text>:euserdoc.

<!--
  <center><h3>Table of Content</h3></center>
    <table border='0' cellspacing='0'>
    <xsl:apply-templates select="//TechNote/Section" mode="toc" />
    </table>
  <xsl:text>
  </xsl:text><hr/><xsl:text>
  </xsl:text>     <xsl:apply-templates select="//TechNote/Section" />
  <hr/>
<xsl:text>
    </xsl:text>
  <center><small><font color='blue'>This material was automatically generated from an original XML document<br/> conforming to the TechNote Document Type Definition (DTD)</font></small> 
<xsl:text>
    </xsl:text>
  </center>
<xsl:text>
  </xsl:text>
  </body>
<xsl:text>
</xsl:text>
</html>
-->
</xsl:template>


<xsl:template name="OrgHeader" >
  <center><xsl:text>
    </xsl:text>
    <table border='0' >
      <tr>
        <td align='center' width='500'><strong><xsl:value-of select="./Title" /></strong></td>
        <td align='right'><img src="images/MiniLogo.jpg" height='80' width='120'/> </td>
      </tr>
    </table>
    </center>
    <hr/>
    <xsl:text>

    </xsl:text>
</xsl:template>


<xsl:template name="OrgFooter" >
  <hr/>
  <xsl:text>
  
  </xsl:text>
  <center>
  <small>
  <table border='0'>
    <tr>
      <td align='left' width='200'><small><xsl:value-of select="$OrgName"/><xsl:text>  </xsl:text><xsl:value-of select="$SecurityLevel"/></small></td>
      <td align='center' width='400'><small><xsl:value-of select="$ProjectName"/></small></td>
      <td align='right' width='200'><small><xsl:apply-templates select="./DocDate" mode="Org" /></small></td></tr>
    <tr><td>  </td><td align='center'><small>Page 1 of n</small></td><td>  </td></tr>
    <tr></tr>
  </table>
  </small>
  </center>
</xsl:template>


<xsl:template name="RevisionHistoryOrg" >
  <table border='1'>
  <tr>
    <td width='100'><strong>Version number</strong></td>
    <td width='100'><strong>Date</strong></td>
    <td width='500'><strong>Summary of changes</strong></td>
    <td width='100'><strong>Revision marks</strong></td>
  </tr>
  <tr>
    <td><i><xsl:value-of select="//Cover/Version" /></i></td>
    <td><i><xsl:apply-templates select="//Cover/DocDate" mode="Org" /></i></td>
    <td>Current revision  </td>
    <td>No</td>
  </tr>
  <xsl:if test="./RevisionList">
    <xsl:apply-templates select="./RevisionList" />
  </xsl:if>
  </table>
</xsl:template>  
   
<xsl:template match="Cover">
<!--  <xsl:variable name="DocumentDateFull">
    <xsl:apply-templates select="./DocDate" mode="Org2" /> 
  </xsl:variable>
  <xsl:call-template name="OrgHeader" />
      
    <center><img src='images/Logo.jpg' height='320' width='480' /></center>
    <br/>
    <xsl:text>
    </xsl:text><center>   -->
:title.<xsl:value-of select="./Title" />  for <xsl:value-of select="$ProjectName"/>:etitle.
:h1 res=001
        x=left y=top width=100% height=25%
        group=1.<xsl:value-of select="./Title" />
:p.:font facename='Tms Rmn' size=42x32.<xsl:value-of select="./Title" />:font facename=default size=0x0.





<!-- </i></strong>

    </center><br/><br/><br/>
    
    <center>
    <small>
    <table border='0' cellspacing='0'>
    <tr>
      <td><strong><small>Version Number: </small></strong> </td><td><small><i><xsl:value-of select="./Version" /></i></small></td>
    </tr>
    <tr>
      <td><strong><small>Draft/Final as of:  </small></strong> </td><td><small><xsl:value-of select="$DocumentDateFull"/></small></td>
    </tr>
    <tr>
      <td><strong><small>Printed on:  </small></strong> </td><td><small><xsl:value-of select="$DocumentDateFull" /></small> </td>
    </tr>
    <tr>
      <td><strong><small>Author:  </small></strong> </td><td><small><i><xsl:value-of select="./AuthorName" /></i></small></td>
    </tr>
    <tr>
      <td><strong><small>Owner:  </small></strong> </td><td><small><i><xsl:value-of select="./OwnerName" /></i></small></td>
    </tr>
    </table>
    </small>
    </center>
-->
    
    <!--
    <xsl:apply-templates select="./SignoffSheet" />
    -->
<!--   
  <br/><br/><br/>
    <xsl:call-template name="OrgFooter" />
-->      
  <!-- HERE BEGINS THE DOC INFO SHEET FOR Org FORMAT -->
<!--  
  <br/>
  <h3>Document Information</h3>
  <table border='0'>
  <tr><td width='50'> </td>
  <td>
  <strong>Document source</strong>
  </td></tr>
  <tr><td width='50'> </td>
  <td>
  <p>This document is maintained as an online document. Contact the owner for the latest version.</p>
  </td></tr>
  <tr><td width='50'> </td>
  <td>
  <strong>Revision history</strong>
  </td></tr>
  <tr><td width='50'> </td>
  <td>
  <xsl:call-template name="RevisionHistoryOrg" />
  </td></tr>
  <tr><td width='50'> </td>
  <td>
  <strong>Approvals</strong>
  </td></tr>
  <tr><td width='50'> </td>
  <td>
  <p>This document has been approved by the following people.  The signed approval forms are filed in the Project Control Book.
    (See signoff sheets at the end of the document).</p>
  </td></tr>
  <tr><td width='50'> </td>
  <td>
  <xsl:apply-templates select="//SignoffSheet" mode="Org" />
  </td></tr>
  <tr><td width='50'> </td>
  <td>
  <strong>Distribution</strong>
  </td></tr>
  <tr><td width='50'> </td>
  <td>
  <p>This document has been distributed to:</p>
  </td></tr>
  <tr><td width='50'> </td>
  <td>
  <xsl:apply-templates select="//DistributionList" mode="Org" />
  </td></tr>
  </table>
-->  
  <!-- HERE BEGINS THE TOC FOR Org FORMAT -->
  
  
  
</xsl:template> <!-- COVER -->



<xsl:template match="OwnerName" >
  <h2>Owner: <xsl:value-of select="."/></h2>
</xsl:template>

<xsl:template match="SignoffSheet" mode="Org" >
  <table border='1'>
    <tr>
      <td width='300'><strong>Name</strong></td>
      <td width='500'><strong>Function</strong></td>
    </tr>
  <xsl:apply-templates select="SignoffEntry"  mode="Org"/>
  </table>
</xsl:template>


<xsl:template match="SignoffSheet" >
  <center>
  <h2>Signoff Sheet</h2>
  <table border='3'>
    <tr>
      <td><strong>Name</strong></td>
      <td><strong>Function</strong></td>
      <td width='300'><strong>Signature</strong></td>
      <td width='150'><strong>Date</strong></td>
    </tr>
  <xsl:apply-templates select="SignoffEntry" />
  </table>
  </center>
  <br />
  <hr />
</xsl:template>

<xsl:template match="SignoffEntry" mode="Org" >
  <tr>
    <td><xsl:value-of select="Signator"/></td>
    <td><xsl:value-of select="SignatorTitle"/></td>
  </tr>
</xsl:template>

<xsl:template match="SignoffEntry" >
  <tr>
    <td><xsl:value-of select="Signator"/></td>
    <td><xsl:value-of select="SignatorTitle"/></td>
    <td><br/><br/></td>
    <td><br/><br/></td>
  </tr>
</xsl:template>




<xsl:template match="DistributionList" mode="Org" >
  <table border='1'>
    <tr>
      <td width='300'><strong>Name</strong></td>
      <td width='500'><strong>Title</strong></td>
    </tr>
  <xsl:apply-templates select="DistributionEntry"  mode="Org"/>
  </table>
</xsl:template>


<xsl:template match="DistributionList" >
  <center>
  <h2>Distribution List</h2>
  <table border='3'>
    <tr>
      <td><strong>Name</strong></td>
      <td><strong>Title</strong></td>
    </tr>
  <xsl:apply-templates select="DistributionEntry" />
  </table>
  </center>
  <br />
  <hr />
</xsl:template>

<xsl:template match="DistributionEntry" mode="Org" >
  <tr>
    <td><xsl:value-of select="RecipientName"/></td>
    <td><xsl:value-of select="RecipientTitle"/></td>
  </tr>
</xsl:template>

<xsl:template match="DistributionEntry" >
  <tr>
    <td><xsl:value-of select="RecipientName"/></td>
    <td><xsl:value-of select="RecipientTitle"/></td>
  </tr>
</xsl:template>





  <!-- THE SECTION TEMPLATE
  -->


  <xsl:template match="Section">
       <xsl:param name="numberingPrefix"/>
     <xsl:variable name="depth" >
       <xsl:value-of select="count(./ancestor::node())" />
     </xsl:variable >
     <xsl:variable name="numberParam">
       <xsl:number />
     </xsl:variable>
     <xsl:variable name="dooeyParam" select="$numberingPrefix" />
     <xsl:variable name="anchorValue">
       <xsl:value-of select="$dooeyParam"/><xsl:number/>
     </xsl:variable>
    <xsl:text>
</xsl:text><xsl:value-of select="concat(':h',($depth - 1),'.')" />
    <xsl:value-of select="normalize-space(./SectionTitle)" /><xsl:apply-templates select="./SectionContent" />
    <xsl:apply-templates select="./Section" />
  </xsl:template>  




  <xsl:template match="UseCase">
    <table border="1">
    <tr><td>Use Case Name</td><td colspan="2"><xsl:value-of select="./UseCaseTitle" /></td></tr>
    <tr><td>Requirement</td><td colspan="2"><xsl:value-of select="./UCRequirement" /></td></tr>
    <tr><td>Goal</td><td colspan="2"><xsl:value-of select="./UCGoal" /></td></tr>
    <tr><td>Preconditions</td><td colspan="2"><xsl:apply-templates select="./UCPreconditions" /></td></tr>
    <tr><td>Actors</td><td colspan="2"><xsl:apply-templates select="./UCActors" /></td></tr>
    <tr><td>Description</td><td>Step</td><td>Action</td></tr>
    <xsl:apply-templates select="./UCDescription/Paragraph" />
    <tr><td>Result</td><td colspan="2"><xsl:apply-templates select="./UCResult" /></td></tr>
   </table>    
  </xsl:template>

  
  <xsl:template match="UCDescription/Paragraph">
    <tr><td> </td><td><xsl:number /></td><td><xsl:apply-templates /></td></tr>
  </xsl:template>


  <xsl:template match="ImageLink">
    <br/>
  <center>
    <strong><xsl:value-of select='.' /></strong>
    <br/>
    <img alt='{.}' border='0' src='{@xlink:href}'/>
  </center>
  </xsl:template>

  <xsl:template match="PageLink">
    <a href='{@xlink:href}'><xsl:value-of select='.' /></a>
  </xsl:template>

  <xsl:template match="Paragraph">
    <xsl:text>
</xsl:text>:p.<xsl:apply-templates/></xsl:template>

  <xsl:template match="T">
    <xsl:call-template name="wrap">
      <xsl:with-param name="string" select="normalize-space(.)" />
      <xsl:with-param name="line-length" select="80" />
    </xsl:call-template>
  </xsl:template>
 
  <xsl:template match="GlossaryEntry"><xsl:value-of select="normalize-space(./FullName)"/> (:hp2.<xsl:value-of select="normalize-space(./Abbreviation)"/>:ehp2.) </xsl:template>

  <xsl:template match="List">
    <xsl:if test="@style='ordered'">
:ol.
    <xsl:apply-templates />
:eol.
  </xsl:if>
    <xsl:if test="@style!='ordered'">
:ul.
    <xsl:apply-templates />
:eul.
  </xsl:if>
  </xsl:template>
  
  <xsl:template match="Member">
    :li.<xsl:apply-templates /></xsl:template>


  <xsl:template match="Emphasis[@intensity='high']">:hp2.<xsl:value-of select="normalize-space(.)"/><xsl:text> </xsl:text>:ehp2.</xsl:template>

  <xsl:template match="Emphasis">:hp1.<xsl:value-of select="normalize-space(.)"/><xsl:text> </xsl:text>:ehp1.</xsl:template>

  <xsl:template match="Table">
    <table border="1">
    <xsl:apply-templates />
  </table>
  </xsl:template>
    
  <xsl:template match="TableRow">
    <tr>
    <xsl:apply-templates />
  </tr>
  </xsl:template>


  <xsl:template match="TableCell">
    <td>
    <xsl:apply-templates />
  </td>
  </xsl:template>

  <xsl:template match="DocDate" mode="Org"><xsl:apply-templates select="TNDate" mode="Org"/></xsl:template>
  <xsl:template match="DocDate" mode="Org2"><xsl:apply-templates select="TNDate" mode="Org2"/></xsl:template>
  <xsl:template match="DocDate"><xsl:apply-templates select="TNDate"/></xsl:template>

  <xsl:template match="TNDate" mode="Org">
    <!-- Year Numeric -->
      <xsl:value-of select="@year" /><xsl:text>/</xsl:text>
      <!-- Month by Number -->
      <xsl:value-of select="@month" /><xsl:text>/</xsl:text>
      <!-- Day of Month -->
      <xsl:value-of select="@dayOfMonth" /><xsl:text>  </xsl:text>
  </xsl:template>

  <xsl:template match="TNDate" mode="Org2">
      <!-- Day of Week -->
      <xsl:if test="@dayOfWeek">
        <xsl:value-of select="@dayOfWeek"/><xsl:text>, </xsl:text>
      </xsl:if>
      <!-- Month by Name -->
      <xsl:choose>
      <xsl:when test="@month='1'">January</xsl:when>
      <xsl:when test="@month='2'">February</xsl:when>
      <xsl:when test="@month='3'">March</xsl:when>
      <xsl:when test="@month='4'">April</xsl:when>
      <xsl:when test="@month='5'">May</xsl:when>
      <xsl:when test="@month='6'">June</xsl:when>
      <xsl:when test="@month='7'">July</xsl:when>
      <xsl:when test="@month='8'">August</xsl:when>
      <xsl:when test="@month='9'">September</xsl:when>
      <xsl:when test="@month='10'">October</xsl:when>
      <xsl:when test="@month='11'">November</xsl:when>
      <xsl:when test="@month='12'">December</xsl:when>
    </xsl:choose><xsl:text> </xsl:text>
          <!-- Day of Month -->
      <xsl:value-of select="@dayOfMonth" /><xsl:text>,  </xsl:text>
    <!-- Year Numeric -->
    <xsl:value-of select="@year" />
  </xsl:template>
  
  <xsl:template match="TNDate">
      <!-- Day of Month -->
      <xsl:value-of select="@dayOfMonth" /><xsl:text>  </xsl:text>
      <!-- Month by Name -->
      <xsl:choose>
      <xsl:when test="@month='1'">January</xsl:when>
      <xsl:when test="@month='2'">February</xsl:when>
      <xsl:when test="@month='3'">March</xsl:when>
      <xsl:when test="@month='4'">April</xsl:when>
      <xsl:when test="@month='5'">May</xsl:when>
      <xsl:when test="@month='6'">June</xsl:when>
      <xsl:when test="@month='7'">July</xsl:when>
      <xsl:when test="@month='8'">August</xsl:when>
      <xsl:when test="@month='9'">September</xsl:when>
      <xsl:when test="@month='10'">October</xsl:when>
      <xsl:when test="@month='11'">November</xsl:when>
      <xsl:when test="@month='12'">December</xsl:when>
    </xsl:choose><xsl:text>,  </xsl:text>
    <!-- Year Numeric -->
    <xsl:value-of select="@year" />
  </xsl:template>


  <xsl:template match="BiblioEntry">
    <xsl:apply-templates select="./AuthorList" />
    <xsl:apply-templates select="./Article | ./Book" />
    <xsl:apply-templates select="./Publisher" />
    <xsl:apply-templates select="./EditorList" />
    <xsl:apply-templates select="./PageRange" />
  </xsl:template>


  <xsl:template match="AuthorList">
    <xsl:apply-templates select="./PersonName" /> 
  </xsl:template>

  <xsl:template match="EditorList">
    <xsl:if test="last() > 0">
      <xsl:text>(</xsl:text><xsl:apply-templates select="./PersonName"/><xsl:text> ed.),  </xsl:text>
    </xsl:if>
  </xsl:template>
     
  <xsl:template match="PageRange">
    <xsl:text>pp. </xsl:text><xsl:value-of select="@low"/><xsl:text>-</xsl:text><xsl:value-of select="@high"/><xsl:text>. </xsl:text>
  </xsl:template>
     
  <xsl:template match="PersonName">
    <xsl:value-of select="./FirstName"/><xsl:text> </xsl:text>
    <xsl:value-of select="./Initials" /><xsl:text> </xsl:text>
    <xsl:value-of select="./LastName" /><xsl:text>, </xsl:text>
  </xsl:template>  

  <xsl:template match="Article">
    <i><xsl:value-of select="./ArticleTitle"/></i><xsl:text>, </xsl:text>
    <xsl:value-of select="./PeriodicalName" /><xsl:text>, </xsl:text>
    <xsl:apply-templates select="./PeriodicalIssue" />
    <xsl:apply-templates select="./PeriodicalDate" />
  </xsl:template>

  <xsl:template match="PeriodicalName">
    <xsl:value-of select="."/>
  </xsl:template>

  <xsl:template match="PeriodicalIssue">
    <xsl:if test="string-length(@volume) > 0">
      <xsl:text>Vol. </xsl:text><xsl:value-of select="@volume"/>
    </xsl:if>
    <xsl:if test="string-length(@number) > 0">
      <xsl:text> No. </xsl:text><xsl:value-of select="@number"/>
    </xsl:if>
    <xsl:text>, </xsl:text>
  </xsl:template>

  <xsl:template match="PeriodicalDate">
    <xsl:value-of select="./@month"/><xsl:text> </xsl:text><xsl:value-of select="./@year"/><xsl:text>,  </xsl:text>
  </xsl:template>

  <xsl:template match="Publisher">
    <xsl:value-of select="."/><xsl:text>, </xsl:text>
  </xsl:template>


  <xsl:template match="CodeExample">
:br.
:table cols='80'.
:row.
:c.:lines.<xsl:value-of select='.' /> :elines.
:etable.  </xsl:template>


  <xsl:template match="Definition" >
      <strong><xsl:value-of select="./DefName"/></strong><br/>
      <xsl:apply-templates select="./DefContent"/>
  </xsl:template>

  <xsl:template match="RevisionList" >
    <xsl:apply-templates select="./RevisionEntry" />
  </xsl:template>

  <xsl:template match="RevisionEntry" >
    <tr>
      <td><i><xsl:value-of select="./Version" /></i>
      </td>
      <td><i><xsl:apply-templates select="./TNDate" mode="Org" /></i>
      </td>
      <td><xsl:apply-templates select="./VersionComment" />
      </td>
      <td>
         <xsl:choose>
           <xsl:when test="@revisionMarks='no'">No</xsl:when>
           <xsl:when test="@revisionMarks='yes'">Yes</xsl:when>
           <xsl:otherwise>No</xsl:otherwise>
         </xsl:choose>
      </td>
    </tr>
  </xsl:template>


  <xsl:template match="VersionComment">
    <xsl:apply-templates select="./*" />
  </xsl:template>

  <xsl:template name="substring-before-last">
    <xsl:param name="string" />
    <xsl:param name="char" select="' '" />
    <xsl:if test="contains($string, $char)">
      <xsl:value-of select="substring-before($string, $char)" />
      <xsl:variable name="rest" select="substring-after($string, $char)" />
      <xsl:if test="contains($rest, $char)">
        <xsl:value-of select="$char" />
        <xsl:call-template name="substring-before-last" >
          <xsl:with-param name="string" select="$rest" />
          <xsl:with-param name="char" select="$char" />
        </xsl:call-template>
      </xsl:if>
    </xsl:if>
  </xsl:template>


  <xsl:template match="node()|@*" mode="wrap" name="wrap">
    <xsl:param name="string" select="normalize-space()" />
    <xsl:param name="line-length" select="80" />
    <xsl:variable name="line">
      <xsl:choose>
        <xsl:when test="string-length($string) > $line-length">
          <xsl:call-template name="substring-before-last">
            <xsl:with-param name="string" select="substring($string,1,$line-length)" />
            <xsl:with-param name="char" select="' '" />              
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise><xsl:value-of select="$string"/></xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="rest" select="substring($string, string-length($line) + 2)" />
    <!--NOW OUTPUT THINGS IF THEY ARE NON-EMPTY -->
    <xsl:if test="$line">
      <xsl:value-of select="normalize-space($line)"/>
      <xsl:text>&#xA;</xsl:text>
    </xsl:if>
    <xsl:if test="$rest">
      <xsl:call-template name="wrap">
        <xsl:with-param name="string" select="$rest" />
        <xsl:with-param name="line-length" select="$line-length" />
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

</xsl:transform>