#include "..\Escriba.h"
#ifdef APIENTRY
#undef APIENTRY
#endif
:userdoc.
:title.Aide: Escriba, Traitement de textes
:docprof toc=123456.

:h1 res=ID_MAIN.Introduction
:i1.Introduction
:artwork name='Escriba.bmp' align=center.
:p.
Ce programme est un traitement de textes &odqf.tel cran, tel
rsultat&cdqf. (What You See Is What You Get, WYSIWYG) pour le
Gestionnaire de Prsentation d&apos.OS/2. Il ne se pose pas en
concurrent des traitements de textes professionnels pour OS/2 ou
Windows, mais a pour objectif de fournir un ensemble plus limit de
fonctionnalits. Il permet les oprations classiques de mise en forme de
texte, et offre la possibilit d&apos.y insrer des graphiques. Toutes
les polices ATM installes sont gres, dans tous les formats natifs et
dans une large palette de tailles. L&apos.impression se fait au travers
du gestionnaire d&apos.impression d&apos.OS/2, ce qui permet
d&apos.imprimer sur tout support d&apos.impression gr par cette
interface, y compris les priphriques de tlcopie et les traceurs.
Sur les versions ad-hoc d&apos.OS/2, la saisie et l&apos.affichage des caractres
cods sur deux octets (DBCS) sont grs, ainsi que les polices TrueType
installes dans la Palette de Polices.
:p.
:sl compact.
:li.&sqbul.:link reftype=hd res=60001.Lancement et Fermeture:elink.
:li.&sqbul.:link reftype=hd res=60002.Chargement et Sauvegarde de Documents:elink.
:li.&sqbul.:link reftype=hd res=60003.dition de Documents:elink.
:li.&sqbul.:link reftype=hd res=60004.Impression de Documents:elink.
:li.&sqbul.:link reftype=hd res=60005.Gestion des Fentres:elink.
:li.&sqbul.:link reftype=hd res=60006.Quelques Informations:elink.
:li.&sqbul.:link reftype=hd res=60007.Enregistrement:elink.
:esl.

:h2 res=60001.Lancement &amp. Fermeture
:hp4.Lancement:ehp4.
:p.
Une fois Escriba install, il peut tre lanc de trois faons. La premire
consiste simplement  cliquer deux fois sur l&apos.icne cre durant
l&apos.installation. Dans ce cas, le programme se chargera et crera une
fentre document vide utilisable immdiatement.
:p.
La seconde mthode consiste  faire glisser un fichier document sur
l&apos.icne du programme. Le document sera ouvert et affich dans la zone de
travail, prt  tre modifi.
:p.
La troisime mthode consiste  utiliser la commande START. Normalement,
ceci ne fonctionnera que si le rpertoire actif est le rpertoire o est
install Escriba. Si ce rpertoire est spcifi dans les paramtres
:hp2.PATH:ehp2., :hp2.HELP:ehp2. et :hp2.LIBPATH:ehp2. du fichier
:hp2.CONFIG.SYS:ehp2., vous pouvez utiliser la commande :hp2.START:ehp2.
 partir de n&apos.importe quel rpertoire.
:p.
Il existe aussi une mthode indirecte pour lancer Escriba. Quand Escriba
enregistre un fichier dans son propre format, il marque le fichier comme
tant de type &apos.Escriba&apos.. Le systme de fichiers associe ce
type de fichiers au traitement de textes Escriba, et quand l&apos.objet
fichier est ouvert, l&apos.action excute par dfaut consiste  lancer
Escriba, qui ouvre le fichier. Le traitement de textes Escriba est aussi
associ aux types :hp1.Plain text:ehp1. et :hp1.Pluma:ehp1., et apparat
dans le menu Ouvrir du menu systme des objets de ce type.

:p.
:hp4.Fermeture:ehp4.
:p.
Pour quitter Escriba, vous pouvez cliquer deux fois sur l&apos.icne de
barre de titre du programme (la mini-icne en haut et  gauche de la
fentre du programme), ou bien vous pouvez utiliser la touche
:hp2.F3:ehp2.. Si certains documents ouverts n&apos.ont pas t
sauvegards aprs avoir t modifis, Escriba vous proposera de les
enregistrer avant de sortir. La fermeture d&apos.Escriba peut tre annule
lors de ces messages de confirmation.

:h2 res=60002.Chargement &amp. Sauvegarde de Documents
:hp4.Chargement:ehp4.
:p.
Des documents peuvent tre chargs dans le traitement de textes au
lancement ou plus tard. En lachant un ou plusieurs objets fichiers sur
l&apos.icne d&apos.Escriba, celui-ci est ouvert et chargera les documents, dans
des fentres spares. Vous pouvez aussi lancer Escriba depuis la ligne
de commande, en spcifiant ventuellement le nom d&apos.un document  ouvrir.
Quelle que soit la mthode utilise, le fait de lancer Escriba alors
qu&apos.il s&apos.excute dj entrane la cration d&apos.une nouvelle fentre et non
le chargement d&apos.une deuxime copie d&apos.Escriba.
:p.
Une fois le traitement de textes lanc, il est possible d&apos.ouvrir des
documents avec l&apos.option de menu :link reftype=hd res=IDM_OPEN.Ouvrir:elink..
La bote de dialogue d&apos.ouverture de fichier standard du systme est
affiche; par dfaut, seuls les fichiers semblant tre des documents
(d&apos.aprs le type du fichier ou l&apos.extension) sont affichs, mais vous
pouvez choisir :hp1.Tous les fichiers:ehp1.. Vous pouvez slectionner
autant de fichiers  charger que vous le dsirez; une fois votre choix
effectu, les fichiers seront chargs en arrire-plan. Au dbut du
chargement, toutes les fentres de documents actives sont rduites, et
le premier document  se charger devient le document actif. Les autres
seront rduits ds la fin de leur chargement.
:p.
Une fois la liste des documents  ouvrir valide, Escriba dtermine le
type de chaque fichier. Si le contenu d&apos.un fichier semble correct pour
plusieurs types de fichiers, vous devrez prciser de quel type est
rellement le fichier. Si le contenu d&apos.un fichier ne semble correct pour
aucun des types de fichiers, vous en serez inform et le document ne
sera pas charg.
:p.
:hp4.Sauvegarde:ehp4.
:p.
Il existe trois possibilit pour sauvegarder un document sur disque&colon.
:link reftype=hd res=IDM_SAVE.Enregistrer:elink.,
:link reftype=hd res=IDM_SAVEAS.Enregistrer en...:elink. et
:link reftype=hd res=IDM_SAVE_CLOSE.Enregistrer et fermer:elink..
La commande :hp2.Enregistrer:ehp2. sauvegarde le fichier sous son nom et
avec son type actuel. Si ce n&apos.est pas possible, Escriba vous demandera
de modifier le nom du fichier ou son type.
La commande :hp2.Enregistrer en:ehp2. vous permet de modifier le nom du
fichier et/ou son type avant de l&apos.enregistrer.
Le commande :hp2.Enregistrer &amp. fermer:ehp2. fonctionne de faon
identique  la commande :hp2.Enregistrer:ehp2.,  ceci prs que la
fentre du document est ferme une fois celui-ci enregistr.
:p.
Si vous tentez de fermer la fentre d&apos.un document ayant t modifi
mais pas sauvegard, Escriba vous demandera si vous voulez d&apos.abord
enregistrer le document. De mme, si vous quittez le traitement de
textes alors que des documents modifis sont encore ouverts, Escriba
vous proposera de sauvegarder ces documents avant de sortir. Une
confirmation vous sera demande pour chacun des documents ouverts
modifis.

:h2 res=60003.dition de Documents
:hp4.Dplacement:ehp4.
:p.
Les touches suivantes permettent de se dplacer dans la fentre
du document&colon.
:table cols='20 60' rules=both frame=box.
:row.:c.Flche Gauche           :c.Caractre/code prcdent.
:row.:c.Flche Droite           :c.Caractre/code suivant.
:row.:c.Flche Haut             :c.Ligne prcdente.
:row.:c.Flche Bas              :c.Ligne suivante.
:row.:c.Page Haut               :c.Page prcdente.
:row.:c.Page Bas                :c.Page suivante.
:row.:c.Dbut                   :c.Dbut de la ligne.
:row.:c.Fin                     :c.Fin de la ligne.
:row.:c.Ctrl + Flche Gauche    :c.Mot prcdent.
:row.:c.Ctrl + Flche Droite    :c.Mot suivant.
:row.:c.Ctrl + Page Haut        :c.Haut de la page.
:row.:c.Ctrl + Page Bas         :c.Bas de la page.
:row.:c.Ctrl + Dbut            :c.Dbut du document.
:row.:c.Ctrl + Fin              :c.Fin du document.
:etable.

De plus, vous pouvez utiliser la souris pour positionner directement le
curseur  tout endroit visible du document. Vous pouvez utiliser la
souris sur les barres de dfilement, si elles sont visibles, pour
dplacer la page horizontalement ou verticalement dans la fentre.

:p.Enfin, quatre plaquettes spciales sont disposes en bas et  droite
de la fentre du document. Ces plaquettes fournissent les
fonctionnalits des touches :hp2.Ctrl+Dbut:ehp2., :hp2.Page Haut:ehp2.,
:hp2.Page Bas:ehp2. et :hp2.Ctrl+Fin:ehp2..

:p.Lors vos dplacements  l&apos.intrieur du document, souvenez-vous que
les codes insrs pour modifier les marges, les polices, etc... sont
considrs comme des lments du texte, et le curseur s&apos.arrtera sur
chacun d&apos.eux quand vous utilisez les touches flches vers la gauche ou
la droite pour vous dplacer  travers le document.

:note.Les touches :hp1.Dbut:ehp1. et :hp1.Fin:ehp1. fonctionnent
de faon lgrement diffrente du standard.
Si vous pressez la touche Dbut quand le curseur se trouve dj en dbut
de ligne, il se dplace au dbut de la ligne prcdente. De mme, si
vous pressez la touche Fin quand le curseur se trouve dj en fin de
ligne, il se dplace  la fin de la ligne suivante.

:p.:hp4.Texte:ehp4.

:p.Le texte est insr dans le document en le tapant au clavier. 
mesure que vous saisissez du texte, celui-ci est mis en forme. Si un mot
est trop long pour tenir sur une ligne, il est dplac sur la ligne
suivante. Si vous tapez trop vite, les touches sont mmorises puis
insres par groupe pour vous rattraper.

:p.Une fois que vous avez saisi du texte dans le document, vous pouvez
dplacer le curseur pour le modifier. Normalement, le curseur est en
mode insertion, reprsent par une barre verticale. Quand vous tapez du
texte au milieu d&apos.un texte existant, le nouveau texte est insr au
milieu de l&apos.ancien, et le document est remis en forme en consquence. Si
vous dsirez plutt remplacer du texte, pressez la touche
:hp2.Inser:ehp2.. Le curseur apparatra comme un bloc couvrant le
caractre sur lequel il se trouve, et ce que vous saisirez remplacera ce
qui se trouve sous le curseur. Attention, si le curseur se trouve sur un
code de changement de police ou une autre marque, ce code sera remplac
par ce que vous taperez, comme le serait un texte normal.
:p.
Pour slectionner une portion de texte, positionnez le curseur au dbut
de la zone  slectionner; pressez ensuite la touche
:hp2.Majuscules:ehp2., et dplacez le curseur jusqu&apos. la fin de la zone
 slectionner, tout en maintenant la touche :hp2.Majuscules:ehp2.
enfonce. Une fois qu&apos.une portion de texte est slectionne, elle peut
tre dplace ou copie, coupe du document, copie vers le
presse-papiers, ou remplace avec le contenu du presse-papiers. De plus,
si un bloc de texte est slectionn, le fait de commencer  saisir 
nouveau du texte entrainera l&apos.effacement du texte slectionn.
:p.
Le texte slectionn peut tre dplac ou copi  l&apos.aide de la souris.
Pour cela, vous devez presser le bouton droit de la souris sur la zone
slectionne, puis dplacer la souris jusqu&apos. ce que le curseur soit sur
la nouvelle position du bloc de texte. Le texte sera dplac quand vous
relacherez le bouton de la souris. Si vous voulez copier et non dplacer
le texte, maintenez la touche :hp2.Ctrl:ehp2. enfonce au moment ou vous
relachez le bouton de la souris. Si vous relachez le bouton de la souris
sans l&apos.avoir dplace, un menu contextuel apparatra, prsentant toutes
les commandes qui peuvent tre appliques  un bloc de texte.
:p.
:hp4.Attributs du Texte:ehp4.
:p.
En tout point du document, certains attributs de style et de formattage
sont effectifs. Les marges sont dfinies  une certaine position, les
tabulations  des endroits prcis, et la police des caractres possde des
caractristiques prcises. N&apos.importe lequel de ces attributs peut tre
modifi de la position du curseur jusqu&apos. la fin du document, ou pour
une zone de texte slectionne. Si vous choisissez la police de
caractres :hp1.Times Roman:ehp1. sans qu&apos.une zone de texte ne soit
slectionne, la nouvelle police sera applique  partir de la position
du curseur, jusqu&apos. ce qu&apos.une autre marque de police soit rencontre.
Dans le cas o une zone de texte est slectionne, cependant, toutes les
marques de police seront supprimes de la zone slectionne, et la
police Times Roman sera applique sur toute la zone slectionne. La
police en vigueur aprs la zone de texte slectionne n&apos.est pas
modifie. Tous les attributs de texte sont grs de la mme faon, que
ce soient les marges, les tabulations, l&apos.indentation, la police, la
taille de la police, les couleurs... tous.
:p.
:hp4.Graphiques:ehp4.
:p.
Des graphiques peuvent tre placs dans un document  partir du presse-
papiers du systme, d&apos.une portion visible du bureau, ou d&apos.un fichier
graphique. Utilisez le menu :link reftype=hd res=IDM_PASTE_FROM.Coller depuis:elink. pour cela.
:p.
Le graphique tant plac dans le document, vous pouvez le dplacer, le
copier ou le redimensionner  tout moment. Pour dplacer le graphique,
cliquez le bouton droit de la souris sur le corps de l&apos.image et faites
la glisser jusqu&apos. sa nouvelle position. Pour le copier, procdez de la
mme faon, mais maintenez la touche :hp2.Ctrl:ehp2. enfonce au moment
o vous relachez le bouton de la souris. Pour redimensionner une image,
cliquez le bouton droit de la souris sur l&apos.espace situ immdiatement 
ct du graphique; le bord du graphique apparatra, et vous n&apos.aurez
qu&apos. le faire glisser pour changer la taille de l&apos.image.

:h2 res=60004.Impression de Documents
:p.Il y a actuellement deux options d&apos.impression disponibles:
:link reftype=hd res=IDM_PRINT_ALL.Imprimer le Document:elink. et
:link reftype=hd res=IDM_PRINT_PAGE.Imprimer la Page:elink..
:p.
:hp4.Imprimer le Document:ehp4. entrane l&apos.impression du document actif
complet. Vous pouvez obtenir le mme rsultat en pressant les touches
:hp2.Ctrl:ehp2. et :hp2.I:ehp2..
:p.
:hp4.Imprimer la Page:ehp4. imprime la page affiche du document actif.
Ceci peut aussi tre effectu en pressant les touches :hp2.Alt:ehp2. et
:hp2.I:ehp2..

:h2 res=60005.Gestion des Fentres
:p.Il est possible d&apos.avoir plusieurs fentres de documents ouvertes en
mme temps.  chaque fois que vous ouvrez une nouvelle fentre de
document, toutes les fentres de documents ouvertes sont rduites et
ranges dans la partie infrieure de la zone de travail. La nouvelle
fentre de document occupera autant de surface que possible, sans
toutefois cacher les icnes des documents rduits.
:p.
Pour rendre  une fentre de document sa taille normale, il suffit de
cliquer deux fois sur son icne, comme pour n&apos.importe quelle icne.
La fentre retrouvera la position et la taille qu&apos.elle avait avant
d&apos.tre rduite.
:p.
Si vous rendez  plusieurs fentres de documents leur taille normale,
elles vont sans doute se chevaucher. Deux commandes permettent d&apos.y
mettre bon ordre:
:link reftype=hd res=IDM_TILE.Mosaque:elink. et
:link reftype=hd res=IDM_CASCADE.Cascade:elink..
:hp2.Mosaque:ehp2. arrangera toutes les fentres de document non
minimises de faon  ce qu&apos.aucune n&apos.en recouvre une autre.
L&apos.effet est le mme que celui constat quand le systme arrange les
fentres du bureau en mosaque.
La commande :hp2.Cascade:ehp2. arrangera toutes les fentres de
documents non rduites de faon  ce qu&apos.elles forment une pile, 
l&apos.instar d&apos.un jeu de cartes. Elles sont arranges de faon 
ce que toutes leurs barres de titre soient visibles. Le document actif
est plac au sommet de la pile.
:p.
Il existe une autre commande de gestion de l&apos.espace de travail:
:link reftype=hd res=IDM_ARRANGEICONS.Arranger les Icnes:elink.
Cette commande rangera proprement les icnes dans la partie infrieure
de la zone de travail.
:p.
Pour le cas o une fentre de document est entirement cache, le menu
:link reftype=hd res=IDM_WINDOW_MENU.Fentres:elink. contient une liste des
documents ouverts. Vous pouvez slecter n&apos.importe laquelle des
fentres dans ce menu pour en faire la fentre active. Si la fentre
tait rduite, elle retrouvera sa taille normale.

:h2 res=60006.Quelques Informations
&sqbul.Le fait d&apos.avoir beaucoup de polices de caractres dans le
menu :hp2.Polices:ehp2. est agrable, mais OS/2 ne libre pas la mmoire
alloue aux polices avant que vous n&apos.arrtiez le systme. Ceci peut
provoquer une augmentation de la taille de votre fichier d&apos.change
de plusieurs mga-octets.
:p.
&sqbul.Certaines polices ATM disponibles sur des serveurs tlmatiques
ne sont pas compltement vrifies et peuvent provoquer un arrt de
votre systme. Soyez prudents avec des polices venant de fournisseurs
tiers nouvellement installes, quoique vous ne devriez pas avoir de
problmes avec des polices fournies par IBM ou Adobe.
:p.
&sqbul.Les graphiques insrs dans les documents peuvent tre de grande
taille. Quand vous insrez une grande image dans le document, mais la
rduisez une fois dans le document, ne croyez pas que le graphique
occupe moins de place; il s&apos.agit toujours du mme graphique
qu&apos.avant sa rduction.

:h2 res=60007.Enregistrement
:p.Ce programme est un partagiciel (shareware).
Vous pouvez librement en distribuer des copies non modifies  toute
personne intresse. Si vous trouvez le programme utile, et dcidez
de continuer  l&apos.utiliser, vous devez le payer. Le prix est de 30$
amricains, et vous pouvez payer par les moyens suivants&colon.
:p.
:hp4.Chque ou mandat&colon.:ehp4.
Si vous dsirez payer par chque ou par mandat, veuillez envoyer votre
rglement, accompagn de vos nom, adresse postale, de la date et du
numro de version de votre copie de Escriba, &colon.
:lm margin=6.:hp4.:sl compact.
:li.Escriba Registrations
:li.c/o Rick Papo
:li.38290 Avondale
:li.Westland, MI 48186-3830
:li.tats-Unis d&apos.Amrique
:esl.:ehp4.:lm margin=1.
.br
:hp4.VISA/MasterCard/Discover&colon.:ehp4.
Si vous dsirez utiliser une carte de crdit pour rgler votre
enregistrement, la socit BMT Micro fournit ce service pour Escriba.
Elle peut tre contacte au 1-800-414-4268 (tats-Unis uniquement) ou au
1-910-791-7052, par tlcopie au 1-910-350-2937, ou sur son BBS au
1-910-350-8061. Les lignes vocales sont ouvertes de 8h  20h (cte est
des tats-Unis). Les autres numros fonctionnent 24h/24. L&apos.adresse
postale de BMT Micro est&colon.
:lm margin=6.:hp4.:sl compact.
:li.BMT Micro
:li.452 Horn Rd
:li.Wilmington, NC 28412-2411
:li.tats-Unis d&apos.Amrique
:esl.:ehp4.:lm margin=1.
:note. Si vous rsidez dans l&apos.une des rpublique qui formaient
l&apos.Union Sovitique ou appartenaient au pacte de Varsovie, vous
pouvez vous enregistrer pour 5$ amricains (pas de cartes de crdit,
s&apos.il vous plat).
:p.Une fois votre enregistrement reu, il vous sera envoy un reu et la
dernire version du traitement de texte sur disquette. Vous recevrez
plus tard une autre disquette, au prochain changement majeur de version.
La documentation imprime n&apos.est pas encore disponible, mais quand
elle le sera, tous les utilisateurs enregistrs du traitement de texte
en recevront une copie. Si vous voulez obtenir les versions ultrieures
sur disquette, elles coteront 5$ amricains.

:h2 res=60008.Questions et rapport d&apos.anomalies
:p.Si vous recontrez des problmes dans l&apos.utilisation de ce programme,
l&apos.auteur, Rick Papo, peut tre joint par l&apos.un des moyens
suivants&colon.
:table cols='15 60' rules=both frame=box.
:row.:c.Internet        :c.:hp4.rpapo@msen.com:ehp4.
:row.:c.Courrier postal :c.:hp4.Rick Papo, 38290 Avondale, Westland, MI 48186-3830, -U:ehp4.
:row.:c.Tlphone       :c.:hp4.tats-Unis (313) 326-8547:ehp4.
:etable.
La priorit est donne aux requtes et aux problmes des utilisateurs
enregistrs (voir :link reftype=hd res=60007.Enregistrement:elink.), mais tous
les messages seront traits. Le courrier lectronique est ramass tous
les jours.
:p.Dans toute correspondance, veuillez prciser le numro de version
d&apos.Escriba que vous utilisez.

:h1 res=IDM_FILE_MENU.Menu Fichier
:i1.Menu Fichier
:p.Les commandes suivantes sont accessibles depuis le menu fichier&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_NEW.Nouveau:elink.
:li.&sqbul.:link reftype=hd res=IDM_OPEN.Ouvrir...:elink.
:li.&sqbul.:link reftype=hd res=IDM_RECALL.Rouvrir:elink.
:li.&sqbul.:link reftype=hd res=IDM_MERGE.Fusionner...:elink.
:li.&sqbul.:link reftype=hd res=IDM_SAVE.Enregistrer:elink.
:li.&sqbul.:link reftype=hd res=IDM_SAVEAS.Enregistrer en...:elink.
:li.&sqbul.:link reftype=hd res=IDM_SAVE_CLOSE.Enregistrer et Fermer:elink.
:li.&sqbul.:link reftype=hd res=IDM_CLOSE.Fermer:elink.
:li.&sqbul.:link reftype=hd res=IDM_PRINT.Imprimer:elink.
:li.&sqbul.:link reftype=hd res=IDM_PREFERENCES.Prfrences...:elink.
:li.&sqbul.:link reftype=hd res=IDM_DEFAULTS.Caractristiques du Document...:elink.
:li.&sqbul.:link reftype=hd res=IDM_CONFIGURE_EXTENSIONS.Configurer les extensions...:elink.
:li.&sqbul.:link reftype=hd res=IDM_LANGUAGE_MENU.Langue:elink.
:li.&sqbul.:link reftype=hd res=IDM_EXIT.Quitter:elink.
:esl.

:h2 res=IDM_NEW.Nouveau (Option de menu)
:p.Cette option de menu cre une nouvelle fentre de document vide. Les
marges, police et autres attributs du document sont ceux qui ont t
spcifis dans le dialogue :hp2.Caractristiques du Document:ehp2.
s&apos.il a t appel alors qu&apos.aucun document n&apos.tait actif.
:p.
Toutes les autres fentres ouvertes sont rduites en bas de la zone de
travail et la nouvelle fentre occupe une surface aussi importante que
possible.

:h2 res=IDM_OPEN.Ouvrir... (Option de menu)
:p.Quand cette option de menu est slectionne, le dialogue systme standard
d&apos.ouverture de fichier est propos. Vous pouvez choisir un ou
plusieurs documents  ouvrir. Aprs avoir press la touche
:hp2.Entre:ehp2., ou slectionn la plaquette :hp2.Ok:ehp2., tous les
fichiers que vous avez choisis seront ouverts. Un indicateur de
chargement, rouge, apparatra sur la partie droite de la barre de titre
du programme. Pour chaque document charg, une fentre de document sera
cre. Le premier document charg deviendra le document actif, et sa
fentre sera agrandie. Tous les autres documents chargs seront rduits.
Ils peuvent tre affichs  partir du menu :hp2.Fentres:ehp2., ou bien
en cliquant deux fois sur leur icne.
:p.Le raccourci clavier pour cette fonction est :hp2.Ctrl+O:ehp2..
:p.Voir:link reftype=hd res=256.Ouvrir/Fusionner/Enregistrer en... (Dialogue):elink. pour plus d&apos.informations.

:h3 res=256.Ouvrir/Fusionner/Enregistrer en... (Dialogue)
:p.Vous avez slectionn l&apos.option de menu :hp2.Ouvrir:ehp2.,
:hp2.Fusionner:ehp2. ou :hp2.Enregistrer en:ehp2., et vous tes en
consquence face  ce dialogue. C&apos.est la bote de dialogue fichier
standard fournie par le systme d&apos.exploitation, et elle suit les
rgles dfinies dans la documentation du systme.
:artwork name='Francais\FileDlg.bmp' align=center.
:p.Quelques commentaires:
:p.
&rarrow. l&apos.ouverture de la bote de dialogue aprs une commande Ouvrir
ou Fusionner, le champ :hp1.Type de fichier:ehp1. contient :hp1.<Tous
les documents>:ehp1.. Tous les fichiers semblant tre des documents au
format natif d&apos.Escriba ou dans l&apos.un des formats tendus (Texte
brut, BMP, GIF, JPG, PCX, TIF, etc.) sont affichs dans la liste. Vous pouvez
choisir d&apos.afficher :hp1.<Tous les fichiers>:ehp1. ou bien l&apos.un des types
de fichiers enumrs.
:p.
&rarrow.Quand cette bote de dialogue est affiche aprs une commande
:hp2.Enregistrer:ehp2. ou :hp2.Enregistrer en:ehp2., le type actuel du
document est slectionn. Si vous dsirez changer le type du document,
choisissez un autre type dans la liste.
:p.
&rarrow. Quand vous slectionnez des fichiers  ouvrir, vous pouvez
choisir autant de fichiers que dsir dans la liste des fichiers.
:p.
&rarrow. Quand vous slectionnez un fichier  fusionner, un seul fichier
peut tre choisi.
:p.
&rarrow. Quand vous avez slectionn l&apos.option :hp2.Enregistrer
en:ehp2., il est impossible de choisir un fichier dans la liste des
fichiers. La liste sert uniquement d&apos.aide-mmoire. Vous devez
saisir au clavier le nom du fichier que vous dsirez sauvegarder dans le
champ de saisie.
:p.
&rarrow. Le rpertoire choisi dans ce dialogue devient le nouveau
rpertoire courant pour le programme. La prochaine fois que vous
utiliserez les commandes :hp2.Ouvrir:ehp2., :hp2.Fusionner:ehp2. ou
:hp2.Enregistrer en:ehp2., elles se positionneront dans ce rpertoire.

:note.Les fichiers enregistrs sur disque sont marqus comme tant des
documents de type :hp1.Escriba:ehp1.. Ce marquage est effectu en
utilisant les attributs supplmentaires, et il est donc perdu si vous
l&apos.archivez  l&apos.aide d&apos.un programme (tel PKZip) ne grant
pas les attributs supplmentaires.
Il existe des programmes d&apos.archivage plus rcents qui prservent
ces informations.

:h4 res=IDD_FILETYPE.Choix du type de fichier (Bote de Dialogue)
:p.Cette bote de dialogue est prsente quand vous chargez un fichier dont
le format correspond  plusieurs types de fichiers. Le programme affiche
le nom du fichier et les types possibles, parmi lesquels vous devez
choisir le bon type. Pressez Entre ou slectionnez Ok aprs avoir choisi le
type. Pour annuler le chargement du fichier, slectionnez Annuler ou pressez
la touche chap.

:h2 res=IDM_RECALL.Menu Rouvrir
:p.Cette option de menu ouvre un sous-menu dans lequel les dix documents
les plus rcemment sauvegards sont proposs.
:p.Voir :link reftype=hd res=IDM_RECALL0.Lignes du menu Rouvrir:elink.
pour plus d&apos.informations.

:h3 res=IDM_RECALL0.Lignes du menu Rouvrir
:p.Cette ligne de menu reprsente l&apos.un des dix fichiers les plus
rcemment sauvegards. Pour rouvrir l&apos.un de ces documents dans
une nouvelle fentre, slectionnez-le  l&apos.aide des touches du curseur
puis pressez :hp2.Entre:ehp2., ou slectionnez le fichier dsir 
l&apos.aide de la souris.

:h2 res=IDM_MERGE.Fusionner... (Option de menu)
:p.Quand cette option de menu est slectionne, le dialogue systme standard de
choix de fichier apparat. Ce dialogue permet de choisir un fichier,
dont le contenu sera insr dans le document actif  la position du
curseur.
:p.Voir:link reftype=hd res=256.Ouvrir/Fusionner/Enregistrer en... (Dialogue):elink.
pour plus d&apos.informations.

:h2 res=IDM_SAVE.Enregistrer (Option de menu)
:p.Cette commande provoque la sauvegarde du document actif dans son
fichier. Si aucune modification n&apos.a t apporte au document, cette
option n&apos.est pas disponible.
:p.Le raccourci clavier pour cette fonction est :hp2.Ctrl+E:ehp2..

:h2 res=IDM_SAVEAS.Enregistrer en... (Option de menu)
:p.Quand cette option de menu est slectionne, le dialogue systme standard de
choix de fichier est prsent. Il vous permet de saisir le nom de
fichier sous lequel sera sauvegard le document actif, et il permet
aussi de choisir le rpertoire dans lequel il sera enregistr.
:p.Voir:link reftype=hd res=256.Ouvrir/Fusionner/Enregistrer en... (Dialogue):elink. pour plus d&apos.informations.

:h2 res=IDM_SAVE_CLOSE.Enregistrer et Fermer (Option de menu)
:p.Cette option fournit un moyen rapide de sauvegarder et fermer le
document actif.
:p.Le raccourci clavier pour cette fonction est :hp2.F4:ehp2..

:h2 res=IDM_CLOSE.Fermer (Option de menu)
:p.Cette commande entrane la fermeture du document actif. Si des
modifications ont t apportes au document et n&apos.ont pas t
sauvegardes, le programme vous demandera si vous voulez enregistrer le
document.
Si vous slectionnez :hp2.Oui:ehp2., ou pressez la touche :hp2.O:ehp2., le
document sera enregistr sous son nom de fichier actuel.
Si vous slectionnez :hp2.Non:ehp2., ou pressez la touche :hp2.N:ehp2., le
document sera ferm sans que les modifications ne soient sauvegardes.
Si vous slectionnez :hp2.Annuler:ehp2., ou pressez la touche
:hp2.chap:ehp2., la commande :hp2.Fermer:ehp2. sera annule et la
fentre du document restera la fentre active.

:h2 res=IDM_PRINT.Imprimer (Sous-menu)
:p.Ce sous-menu permet d&apos.accder aux diverses commandes
d&apos.impression, qui sont actuellement au nombre de deux&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_PRINT_ALL.Imprimer le Document:elink.
:li.&sqbul.:link reftype=hd res=IDM_PRINT_PAGE.Imprimer la Page:elink.
:esl.

:h3 res=IDM_PRINT_ALL.Menu Imprimer le Document
:p.Ce menu donne accs aux diffrentes options concernant l&apos.impression de
la totalit du document. Les commandes suivantes sont
disponibles&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_PRINT_ALL_NORMAL.Dans l&apos.ordre normal:elink.
:li.&sqbul.:link reftype=hd res=IDM_PRINT_ALL_REVERSE.En ordre inverse:elink.
:esl.

:h4 res=IDM_PRINT_ALL_NORMAL.Imprimer le document dans l&apos.ordre normal (Option de menu)
:p.Cette option demande l&apos.impression du document actif. Une fentre
d&apos.tat rouge est affiche pendant que le document est envoy  la
file d&apos.impression du systme, pour information. Vous pouvez
continuer  travailler sur le document immdiatement aprs en avoir
demand l&apos.impression. Le document sera imprim tel qu&apos.il est
au moment prcis de la demande d&apos.impression.
:p.Le raccourci clavier pour cette fonction est :hp2.Ctrl+P:ehp2..

:h4 res=IDM_PRINT_ALL_REVERSE.Imprimer le document en ordre inverse (Option de menu)
:p.Le document actif est imprim, comme par la commande 
:link reftype=hd res=IDM_PRINT_ALL_NORMAL.Imprimer le Document dans l&apos.ordre normal:elink.,
 ceci prs que les pages sont imprimes dans l&apos.ordre inverse.

:h3 res=IDM_PRINT_PAGE.Imprimer la Page (Option de menu)
:p.La page en cours du document actif est imprime quand vous slectionnez
cette option de menu. Une fentre d&apos.tat rouge est affiche pendant
que le document est envoy  la file d&apos.impression du systme, pour
votre information uniquement. Vous pouvez continuer  travailler sur le
document immdiatement aprs avoir command l&apos.impression. Le
document sera imprim tel qu&apos.il est au moment ou vous en demandez
l&apos.impression.
:p.Le raccourci clavier pour cette fonction est :hp2.Alt+I:ehp2..

:h2 res=IDM_PREFERENCES.Prfrences... (Option de menu)
:p.Voir:link reftype=hd res=IDD_PREFERENCES.Prfrences (Dialogue):elink. pour plus d&apos.informations.

:h3 res=IDD_PREFERENCES.Prfrences (Dialogue)
:p.Ce dialogue vous permet de configurer l&apos.apparence et le comportement de
Escriba en ce qui concerne le traitement de textes lui mme, et non pour
ce qui est des document en cours de mise en forme.
:artwork name='Francais\Prefer.bmp' align=center.
:p.Les options disponibles sont&colon.
:p.:hp2.Animer:ehp2.
Quand cette option est slectionne, l&apos.ouverture et la fermeture de la
fentre principale du traitement de textes sont animes, de la mme
faon que l&apos.ouverture et la fermeture des dossiers du systme. Pour que
cette animation fonctionne, elle doit tre autorise depuis l&apos.objet
:hp1.Systme:ehp1. dans le dossier :hp1.Configuration du Systme:ehp1..
:p.:hp2.Afficher les Rgles:ehp2.
Si cette case est coche, toutes les fentres de documents contiendront
une rgle horizontale et une rgle verticale, disposes sur les bords
des fentres.
:p.:hp2.Afficher les Barres de Dfilement:ehp2.
Si cette case est coche, toutes les fentres de documents contiendront
des barres de dfilement horizontale et verticale permettant de faire
dfiler le document  l&apos.aide de la souris.
:p.:hp2.Afficher la ligne d&apos.tat:ehp2.
Si cette case est coche, une ligne d&apos.tat est affiche en bas de chaque
fentre de document. Cette ligne d&apos.tat affiche la position du curseur
et la nature du caractre ou du code de contrle qui se trouve sous le
curseur.
:p.:hp2.Montrer noms de Fichiers complets:ehp2.
Si cette case est coche, le nom de fichier complet de chaque document
sera affich dans la barre de titre de la fentre du document. Dans le
cas contraire, la partie du nom de fichier du document contenant le
spcificateur de disque et le nom du rpertoire ne sera pas affiche.
:p.:hp2.Sparer les pages dans la file d&apos.impression:ehp2.
Si cette case est coche, les pages d&apos.un document seront envoyes
sparment  la file d&apos.impression du systme. Comme les travaux
d&apos.impression ne commencent  tre imprims qu&apos.une fois qu&apos.ils sont
entirement en file d&apos.attente, cette option permet un dmarrage plus
rapide de l&apos.impression de documents comportant plusieurs pages.
Attention, si votre imprimante est partage sur un rseau, les pages du
document peuvent tre imprimes dans le dsordre ou mlanges avec les
documents d&apos.autres utilisateurs.
:p.:hp2.Imprimer en ordre inverse:ehp2.
Quand cette case est coche, les pages du document sont imprimes en
ordre inverse. Cette option est utile si votre imprimante empile les
pages imprimes face en haut.
:p.:hp2.Rouvrir le document au lancement:ehp2.
Si cette case est coche, le dernier document ferm sera ouvert
automatiquement lors du lancement d'Escriba.
:p.:hp2.Zoom initial:ehp2.
Ce groupe de boutons radio vous permettent de slectionner le type de
zoom qui sera appliqu initialement aux fentres de document. Quand
vous ouvrez une nouvelle fentre de document ou que vous chargez un
document depuis le disque, la mthode de zoom spcifie sera applique
 la fentre lors de son ouverture. Vous pouvez choisir l&apos.un des types
de zoom suivants&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_100.Zoom 100%:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_FULLWIDTH.Zoom pleine largeur:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_FULLHEIGHT.Zoom pleine hauteur:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_MARGINS.Zoom marges:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_ALL.Zoom tout:elink.
:esl.
:p.
Une fois les options dsires coches, pressez la touche
:hp2.Entre:ehp2. ou slectionnez la plaquette :hp2.Ok:ehp2. pour valider vos
choix. Ces changements seront appliqus  tous les nouveaux documents
ultrieurement crs.
:p.
Si vous voulez fermer la bote de dialogue en laissant les
caractristiques par dfaut inchanges, pressez la touche
:hp2.chap:ehp2. ou slectionnez la plaquette :hp2.Annuler:ehp2..

:h2 res=IDM_DEFAULTS.Caractristiques du Document... (Option de menu)
:p.Cette commande fait apparatre une bote de dialogue  l&apos.aide de
laquelle il est possible de choisir l&apos.imprimante, le format de papier,
la police de caractres, sa taille et sa couleur, les attributs de la
police et la justification du texte (horizontale et verticale) pour le
document.
:p.Voir:link reftype=hd res=IDD_DEFAULTS.Caractristiques du Document (Dialogue):elink. pour plus d&apos.informations.

:h3 res=IDD_DEFAULTS.Caractristiques du Document (Dialogue)
:p.Cette bote de dialogue vous permet de modifier les caractristiques par
dfaut du document. Ces caractristiques s&apos.appliquent au document
actif; si aucun document n&apos.est ouvert, les caractristiques sont
mmorises et seront utilises lors de la cration de nouveaux
documents.
.br
Les options de confirmation sont groupes par catgorie sur 
les pages suivantes.
:sl compact.
:li.:link reftype=hd res=IDD_DEFAULTS_PAGE_AUTHOR.Auteur:elink.
:li.:link reftype=hd res=IDD_DEFAULTS_PAGE_PRINTER.Imprimante:elink.
:li.:link reftype=hd res=IDD_DEFAULTS_PAGE_FONT.Polices:elink.
:li.:link reftype=hd res=IDD_DEFAULTS_PAGE_LAYOUT1.Disposition (1):elink.
:li.:link reftype=hd res=IDD_DEFAULTS_PAGE_LAYOUT2.Disposition (2):elink.
:li.:link reftype=hd res=IDD_DEFAULTS_PAGE_NATIONAL.Langue:elink.
:esl.
:p.
Une fois les caractristiques par dfaut spcifies, pressez la touche
:hp2.Entre:ehp2. ou slectionnez la plaquette :hp2.Ok:ehp2. pour valider
vos choix. Si aucun document n&apos.est ouvert, ou si vous avez coch la
case :hp2.Sauvegarde globale:ehp2., les caractristiques
s&apos.appliqueront  tous les documents crs ultrieurement. Si une
fentre de document est ouverte, les caractristiques seront aussi
appliques  ce document. Aucun autre document n&apos.est affect.
:p.
Si vous slectionnez la plaquette :hp2.Appliquer:ehp2., les nouvelles
caractristiques par dfaut sont immdiatement appliques au document
actif, et en deviennent les nouvelles caractristiques par dfaut.
:p.
Si vous voulez annuler le dialogue et ne pas modifier les
caractristiques par dfaut, pressez la touche :hp2.chap:ehp2. ou
slectionnez la plaquette :hp2.Annuler:ehp2.. Les modifications valides par
la plaquette :hp2.Appliquer:ehp2. ne sont pas annules.

:h4 res=IDD_DEFAULTS_PAGE_AUTHOR.Page d&apos.identification de l&apos.auteur
:artwork name='Francais\Default0.bmp' align=center.
:p.:hp2.Auteur:ehp2.
Ce champ vous permet de modifier le nom de l'auteur et le titre du
document sauvegards dans l'en-tte. La date de cration du document est
aussi affiche.

:h4 res=IDD_DEFAULTS_PAGE_PRINTER.Configuration de l&apos.imprimante
:artwork name='Francais\Default1.bmp' align=center.
:p.:hp2.Imprimante:ehp2.
Ce champ vous permet de choisir quelle imprimante (si vous disposez de
plusieurs imprimantes) sera utilise pour l&apos.impression du document.
Vous pouvez choisir n&apos.importe laquelle des imprimantes dfinies
dans le systme.
:p.:hp2.Configuration de l&apos.imprimante:ehp2.
Le fait slecter cette plaquette provoquera l&apos.ouverture de la bote
de dialogue permettant de dfinir les caractristiques d&apos.un travail
d&apos.impression. Le contenu de ce dialogue varie en fonction de
l&apos.imprimante slectionne, et ne peut tre document ici. Veuillez
vous reporter aux informations fournies par la bote de dialogue. Au
retour de la bote de dialogue, le format de papier sera mis  jour dans
la zone situe au dessous de la plaquette.

:h4 res=IDD_DEFAULTS_PAGE_FONT.Configuration des polices
:artwork name='Francais\Default2.bmp' align=center.
:p.:hp2.Police:ehp2.
Permet de dsigner la police initiale pour le document. Vous pouvez
choisir n&apos.importe quelle police installe sur votre systme.
:p.:hp2.Taille:ehp2.
Dfinit la taille initialement utilise pour la police. Vous pouvez
choisir n&apos.importe quelle taille dans la liste propose.
:p.:hp2.Couleur:ehp2.
Dfinit la couleur initiale utilise pour le texte du document. Vous
pouvez choisir n&apos.importe quelle couleur dans la liste propose.
:p.:hp2.Gras:ehp2.
Si cette case est coche, le texte sera initialement en gras. Si la
police utilise dispose d&apos.une police spciale pour l&apos.attribut gras, elle
sera utilise; dans le cas contraire, le systme construira une police
correspondant  l&apos.attribut gras.
:p.:hp2.Italique:ehp2.
Si cette case est coche, le texte sera initialement en italiques. Si la
police utilise dispose d&apos.une police spciale pour l&apos.attribut italique,
elle sera utilise; dans le cas contraire, le systme construira une
police correspondant  l&apos.attribut italique.
:p.:hp2.Soulign:ehp2.
Si cette case est coche, le texte sera initialement soulign.
:p.:hp2.Barr:ehp2.
Si cette case est coche, le texte sera initialement barr.
:p.:hp2.Contour:ehp2.
Si cette case est coche, seul le contour des caractres sera dessin.
:p.:hp2.Majuscules:ehp2.
Si cette case est coche, le texte sera initialement en lettres
majuscules.

:h4 res=IDD_DEFAULTS_PAGE_LAYOUT1.Disposition, page 1
:artwork name='Francais\Default3.bmp' align=center.
:p.:hp2.Justification:ehp2.
Dfinit le type de justification horizontale  utiliser. Les
justifications possibles sont :hp2.Gauche:ehp2., :hp2.Centr:ehp2.,
:hp2.Droite:ehp2., :hp2.Gauche et Droite:ehp2.. La justification 
gauche aligne le texte sur la marge gauche de la page. La justification
centre centre le texte entre les marges gauche et droite, mais ne
modifie pas l&apos.espacement entre les mots. La justification  droite
aligne le texte sur la marge droite de la page. Enfin, la justification
 gauche et  droite aligne le texte  la fois sur les marges gauche et
droite de la page, au besoin en modifiant l&apos.espacement entre les
mots.
:p.:hp2.Centrer la Page:ehp2.
Si cette case est coche, toutes les pages seront centres
verticalement.
:p.:hp2.Marges:ehp2.
Ces quatre champs permettent de spcifier les valeurs initiales des
marges, en pouces ou en centimtres selon l&apos.unit choisie. Les
marges ne peuvent dpasser les limites imposes par le support
slectionn.

:h4 res=IDD_DEFAULTS_PAGE_LAYOUT2.Disposition, page 2
:artwork name='Francais\Default4.bmp' align=center.
:p.:hp2.Tabulations:ehp2.
Ce champ vous permet de spcifier l&apos.espacement par dfaut utilis
par les tabulations. Si vous saisissez 0,500 ici, les taquets de
tabulations seront initialement placs tous les demi-pouce ou
centimtre,  partir de la marge gauche et jusqu&apos. la marge droite.
:p.:hp2.Indentation:ehp2.
Ce champ de saisie vous permet de dfinir l&apos.indentation de paragraphe
qui sera applique, par dfaut, au dbut du document. Si vous entrez la
valeur 0,5, le texte de la premire ligne du document (et de chaque
premire ligne de paragraphe) sera dcal d&apos.un demi centimtre (ou
pouce, le cas chant) vers la droite.
:p.:hp2.Interligne:ehp2.
Cette zone contient les choix d&apos.interligne disponibles.
L&apos.option :hp2.Normal:ehp2. correspond  un espacement vertical de
100%, l&apos.option :hp2.1 1/2:ehp2.  un espacement de 150% et
l&apos.option :hp2.Double:ehp2.  200%.

:h4 res=IDD_DEFAULTS_PAGE_NATIONAL.Langue
:artwork name='Francais\Default5.bmp' align=center.
:p.:hp2.Page de codes:ehp2.
Ce champ permet de dfinir la page de codes, ou le jeu de caractres
nationaux, utilis par le document.
Voir :link reftype=hd res=61002.Pages de codes:elink. pour plus d&apos.information.
:p.:hp2.Centimtres:ehp2.
Si cette case est coche, les mesures seront exprimes dans le systme
mtrique. Les rgles horizontale et verticale seront gradues en
centimtres.
:p.:hp2.Format de la date:ehp2.
Ce champ permet de dfinir le format de la date  utiliser pour les
commandes :hp2.Date d&apos.impression:ehp2. et
:hp2.Aujourd&apos.hui:ehp2.. Voir
:link reftype=hd res=IDD_DATEFMT.Format de la date:elink. pour plus d&apos.informations.

:h2 res=IDM_CONFIGURE_EXTENSIONS.Configurer les extensions... (Option de menu)
:p.Cette commande appele une bote de dialogue  partir de laquelle
peuvent tre configures les extensions installes.
:p.Voir :link reftype=hd res=IDD_CONFIGURE_EXTENSIONS.Configurer les extensions (Dialogue):elink. pour plus d&apos.informations.

:h3 res=IDD_CONFIGURE_EXTENSIONS.Configurer les extensions (Dialogue)
:p.Cette bote de dialogue permet de configurer les extensions installes.
:artwork name='Francais\ConfigEx.bmp' align=center.

:h3 res=IDM_LANGUAGE_MENU.Langue (Sous-menu)
:p.Ce sous-menu permet de choisir la langue utilise pour les menus et
botes de dialogue de l&apos.application.
:p.Voir :link reftype=hd res=IDM_LANGUAGES.Ligne du menu Langue:elink.
pour plus d&apos.informations.

:h4 res=IDM_LANGUAGES.Ligne du menu Langue (Option de menu)
:p.Les lignes du sous-menu :hp2.Langue:ehp2. permettent de choisir la
langue dans laquelle seront affichs les menus et botes de dialogue de
l&apos.application.
Les langues sont exprimes dans leur forme d&apos.origine (Espaol pour
l&apos.espagnol, par exemple).
Une fois la nouvelle langue choisie, les fentres de l&apos.application sont
raffiches. Certains aspects du document (tel le format des dates) sont
aussi changs.

:h2 res=IDM_EXIT.Quitter (Option de menu)
:p.Cette commande permet de quitter le programme.

:h1 res=IDM_EDIT_MENU.Menu dition
:i1.Menu dition
:p.Les commandes suivantes sont accessibles depuis le menu
:hp2.dition:ehp2.&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_UNDO.Dfaire:elink.
:li.&sqbul.:link reftype=hd res=IDM_REDO.Refaire:elink.
:li.&sqbul.:link reftype=hd res=IDM_CUT.Couper:elink.
:li.&sqbul.:link reftype=hd res=IDM_COPY.Copier:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE.Coller:elink.
:li.&sqbul.:link reftype=hd res=IDM_CLEAR.Effacer:elink.
:li.&sqbul.:link reftype=hd res=IDM_CLEARCLIPBOARD.Effacer le Presse-papiers:elink.
:li.&sqbul.:link reftype=hd res=IDM_SELECT_ALL.Tout slectionner:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM.Menu Coller depuis:elink.
:li.&sqbul.:link reftype=hd res=IDM_INSERT_FUNCTION.Menu Insrer fonction:elink.
:li.&sqbul.:link reftype=hd res=IDM_SEARCH.Chercher...:elink.
:li.&sqbul.:link reftype=hd res=IDM_FINDNEXT.Trouver suivant:elink.
:li.&sqbul.:link reftype=hd res=IDM_GOTOPAGE.Aller vers page:elink.
:li.&sqbul.:link reftype=hd res=IDM_SPELL.Correcteur orthographique...:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM.Zoom:elink.
:esl.

:h2 res=IDM_UNDO.Dfaire (Option de menu)
:p.Cette commande annule la modification la plus rcemment effectue sur le
document. Si vous utilisez plusieurs fois de suite cette fonction, les
modifications de moins en moins rcentes sont annules, jusqu&apos. ce que
toutes les modifications apportes au document aient t annules (le
document se trouve alors dans l&apos.tat o il se trouvait quand il a t
charg). Sur un nouveau document, le document finirait par tre dans son
tat initial, c&apos.est  dire vide.
:p.Le raccourci clavier pour cette fonction est :hp2.Alt+Retour:ehp2..

:h2 res=IDM_REDO.Refaire (Option de menu)
:p.Si vous n&apos.avez pas modifi le document depuis la dernire fois que vous
avez dfait une modification, cette fonction vous permet de refaire la
modification qui a t dfaite. Il est possible de dfaire toutes les
modifications apportes au document, puis de les refaire toutes.
Toutefois, si vous modifiez le document aprs un
:link reftype=hd res=IDM_UNDO.Dfaire:elink., toutes les modifications
ultrieures sont perdues et il devient impossible de les refaire.
:p.Le raccourci clavier pour Refaire est :hp2.Maj+Alt+Retour:ehp2..

:h2 res=IDM_CUT.Couper (Option de menu)
:p.Cette commande efface le texte slectionn du document et le place dans
le presse-papiers.
:p.Le raccourci clavier pour cette fonction est :hp2.Maj+Suppr:ehp2..

:h2 res=IDM_COPY.Copier (Option de menu)
:p.Cette commande recopie le texte slectionn du document vers le
presse-papiers.
:p.Le raccourci clavier pour cette fonction est :hp2.Ctrl+Inser:ehp2..

:h2 res=IDM_PASTE.Coller (Option de menu)
:p.Cette commande copie le contenu du presse-papiers vers le document, en
remplaant le texte slectionn (en mode remplacement) ou en l&apos.insrant
aprs le curseur (en mode insertion).
:p.Le raccourci clavier pour cette fonction est :hp2.Maj+Inser:ehp2..

:h2 res=IDM_CLEAR.Effacer (Option de menu)
:p.Cette commande efface le texte slectionn du document, sans altrer le
presse-papiers. Cette commande est exactement quivalente  une pression
de la touche :hp2.Suppr:ehp2..

:h2 res=IDM_CLEARCLIPBOARD.Effacer le Presse-papiers (Option de menu)
:p.Cette commande efface le contenu du presse-papiers.

:h2 res=IDM_SELECT_ALL.Selectionner tout (Option de menu)
Cette commande slectionne tout le texte du document, du dbut  la fin.
:p.Cette commande peut aussi tre invoque en cliquant deux fois le
bouton 1 de la souris sur la zone situe en haut et  gauche, au
croisement des rgles verticale et horizontale.

:h2 res=IDM_PASTE_FROM.Menu Coller depuis
:p.Ce menu permet de choisir une source pour un graphique devant tre insr
dans le document.
Les options suivantes sont disponibles&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_CLIP.Coller depuis le presse-papiers:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_SCRN.Coller depuis l&apos.cran:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_FILE.Coller depuis un fichier graphique:elink.
:esl.

:h3 res=IDM_PASTE_FROM_CLIP.Menu Coller depuis le presse-papiers
:p.Ce menu permet de choisir une option de collage  partir du presse-papiers
du systme.
Les options suivantes sont disponibles&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_CLIP_BITMAP.Coller un bitmap depuis le presse-papiers:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_CLIP_METAFILE.Coller un mtafichier depuis le presse-papiers:elink.
:esl.

:h4 res=IDM_PASTE_FROM_CLIP_BITMAP.Coller un bitmap depuis le presse-papiers (Option de menu)
:p.Si une image en mode points (bitmap) a t place dans le presse-papiers
du systme, cette option de menu vous permet de la coller dans votre
document. Aprs avoir slectionn cette option, vous devez indiquer
l&apos.un des angles de la zone o vous voulez coller l&apos.image.
Indiquez cet angle en le dsignant  l&apos.aide du pointeur de la
souris, puis en pressant le bouton gauche. Tout en conservant le bouton
press, dplacez le curseur de la souris vers le coin oppos de la zone
o l&apos.image doit tre place. Un rectangle va se former et reflter
les dplacements de la souris. Une fois la dimension souhaite atteinte,
relchez le bouton de la souris. L&apos.image sera colle dans le
rectangle, sa taille tant automatiquement adapte.

:h4 res=IDM_PASTE_FROM_CLIP_METAFILE.Coller un mtafichier depuis le presse-papiers (Option de menu)
:p.Si un mtafichier graphique a t plac dans le presse-papiers du
systme, cette option de menu vous permet d&apos.insrer ce graphique
dans votre document. Aprs avoir slectionn cette option, vous devez
indiquer la position du graphique dans votre document, comme pour
l&apos.option de menu :link reftype=hd res=IDM_PASTE_FROM_CLIP_BITMAP.Coller un bitmap depuis le presse-papiers:elink..

:h3 res=IDM_PASTE_FROM_SCRN.Menu Coller depuis l&apos.cran
:p.Ce menu permet de choisir une option de Collage utilisant une image
graphique capture sur l&apos.affichage.
Les options suivantes sont disponibles&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_SCRN_ENTIRE.Coller le bureau:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_SCRN_FRAME.Coller une zone de l&apos.cran:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_SCRN_WINDOW.Coller une fentre du bureau:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_SCRN_RECT.Coller une zone rectangulaire de l&apos.affichage:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_SCRN_HIDE.Hide:elink.
:esl.

:h4 res=IDM_PASTE_FROM_SCRN_ENTIRE.Coller le bureau (Option de menu)
:p.Quand vous slectionnez cette option de menu, une image du bureau, dans son
tat actuel, est ralise et vous devez ensuite indiquer l&apos.endroit
o la positionner comme pour l&apos.option de menu 
:link reftype=hd res=IDM_PASTE_FROM_CLIP_BITMAP.Coller un bitmap depuis le presse-papiers:elink..

:note.Attention, le volume du graphique cr par cette option peut tre
relativement important. Quelle que soit la taille de l&apos.image sur le
document, la quantit de mmoire occupe par le graphique reste la mme,
et une image du bureau complet peut reprsenter de 100  800ko, en
fonction de la rsolution de l&apos.cran et du nombre de couleurs.

:h4 res=IDM_PASTE_FROM_SCRN_FRAME.Coller une zone de l&apos.cran (Option de menu)
:p.Cette fonction n&apos.est pas encore disponible.

:h4 res=IDM_PASTE_FROM_SCRN_WINDOW.Coller une fentre du bureau (Option de menu)
:p.Cette fonction n&apos.est pas encore disponible.

:h4 res=IDM_PASTE_FROM_SCRN_RECT.Coller une zone rectangulaire de l&apos.affichage (Option de menu)
:p.Cette fonction n&apos.est pas encore disponible.

:h4 res=IDM_PASTE_FROM_SCRN_HIDE.Cacher (Option de menu)
:p.Quand cette option est coche, les fentres de l&apos.application sont caches
si vous appelez une des commandes du menu
:link reftype=hd res=IDM_PASTE_FROM_SCRN.Coller depuis l&apos.cran:elink..
Une fois la commande excute, l&apos.application est  nouveau affiche.

:h3 res=IDM_PASTE_FROM_FILE.Coller depuis un fichier graphique (Option de menu)
:p.Quand vous slectionnez cette option, la bote de dialogue de slection de
fichier est affiche. Vous devez choisir le fichier graphique qui sera
insr dans votre document. Les types de fichier actuellement grs
sont&colon.
:sl compact.
:li.&sqbul.Image en mode points (bitmap) IBM OS/2 (.BMP)
:li.&sqbul.Mtafichier (MetaFile) IBM OS/2 (.MET)
:li.&sqbul.Image en mode points (bitmap) MicroSoft Windows (.BMP)
:li.&sqbul.Graphic Interchange Format (.GIF)
:li.&sqbul.Joint Photographic Experts Group File Interchange Format (.JPG, .JPEG ou .JFIF)
:li.&sqbul.Fichiers PC Paintbrush (.PCX ou .PCC)
:li.&sqbul.Tag Image File Format (.TIF ou .TIFF)
:esl.
:p.Aprs avoir slectionn un fichier, vous devrez indiquer
l&apos.endroit o l&apos.insrer dans le document, comme pour
l&apos.option de menu 
:link reftype=hd res=IDM_PASTE_FROM_CLIP_BITMAP.Coller un bitmap depuis le presse-papiers:elink..

:h2 res=IDM_INSERT_FUNCTION.Menu Insrer fonction
:p.Ce sous-menu vous permet d&apos.insrer un certain nombre de codes fonctions
dans le document. Les options suivantes sont disponibles&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_DATE.Date:elink.
:li.&sqbul.:link reftype=hd res=IDM_CURRENTPAGE.Numro de la page:elink.
:li.&sqbul.:link reftype=hd res=IDM_PAGECOUNT.Nombre de pages:elink.
:li.&sqbul.:link reftype=hd res=IDM_SEPARATOR.Separator:elink.
:li.&sqbul.:link reftype=hd res=IDM_BARCODE.Code  barres...:elink.
:esl.
:note.Ce sous-menu ne fait pas partie du menu contextuel d&apos.un texte
slectionn.

:h3 res=IDM_DATE.Insrer la Date (Option de menu)
:p.Ce sous-menu vous donne accs aux fonctions d&apos.insertion de date.
Trois options sont proposes&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_DATETODAY.Date d&apos.aujourd&apos.hui:elink.
:li.&sqbul.:link reftype=hd res=IDM_DATECURRENT.Date d&apos.impression:elink.
:li.&sqbul.:link reftype=hd res=IDM_DATECHANGED.Date de mise  jour:elink.
:li.&sqbul.:link reftype=hd res=IDM_DATEFMT.Format de la Date...:elink.
:esl.
:note.Ce sous-menu ne fait pas partie du menu contextuel d&apos.un texte
slectionn.

:h4 res=IDM_DATETODAY.Date d&apos.aujourd&apos.hui (Option de menu)
:p.Cette option de menu insre dans le document un code qui affiche la date
 laquelle le code a t insr. Cette date n&apos.volue pas, et ne peut pas
tre dite.
Quand vous dplacez le curseur dans le texte, cette date est considre
comme un unique caractre ou code. Le format d&apos.affichage de la date peut
tre modifi dans la bote de dialogue
:link reftype=hd res=IDD_DATEFMT.Format de la date...:elink. mais vous devez
modifier le format avant le code de la date, car ce code utilise le
format en vigueur  sa position dans le document.
:note.Cette option n&apos.est pas disponible dans le menu contextuel d&apos.un
texte slectionn.

:h4 res=IDM_DATECURRENT.Date d&apos.impression (Option de menu)
:p.Cette commande insre dans le document un code qui affiche toujours la
date courante. La date affiche ou imprime est toujours la date
courante, et non la date  laquelle la commande a t excute. La date
tant prsente sous la forme d&apos.un code, elle ne peut tre modifie.
Quand le curseur passe sur la date, elle est considre comme un seul
caractre. Le format sous lequel la date apparat peut tre modifi via
la bote de dialogue :link reftype=hd res=IDD_DATEFMT.Format de la date...:elink., 
mais vous devez modifier le format avant le code de la
date, car ce code utilise le format en vigueur  sa position dans le
document.
:note.Cette option n&apos.est pas disponible dans le menu contextuel
d&apos.un texte slectionn.

:h4 res=IDM_DATECHANGED.Date de mise  jour (Option de menu)
:p.Cette commande insre dans le document un code qui affiche la date de
dernire modification du document. La date sera modifie quand le
document sera mis  jour. La date tant prsente sous la forme d&apos.un
code, elle ne peut tre modifie. Quand le curseur passe sur la date,
elle est considre comme un seul caractre. Le format sous lequel la
date apparat peut tre modifi via la bote de dialogue 
:link reftype=hd res=IDD_DATEFMT.Format de la date...:elink., mais vous devez modifier le
format avant le code de la date, car ce code utilise le format en
vigueur  sa position dans le document.
:note.Cette option n&apos.est pas disponible dans le menu contextuel
d&apos.un texte slectionn.

:h4 res=IDM_DATEFMT.Format de la Date... (Option de menu)
:p.La slection de cette option de menu provoque l&apos.ouverture de la
bote de dialogue:link reftype=hd res=IDD_DATEFMT.Format de la Date...:elink., 
qui permet de modifier le format utilis pour la cration des dates.

:h5 res=IDD_DATEFMT.Format de la Date... (Dialogue)
:p.Cette bote de dialogue permet de modifier le format utilis pour la
cration des dates.
:artwork name='Francais\DateFmt.bmp' align=center.
:p.La chane de caractres cre pour reprsenter la
date est le contenu du champ de saisie, certains caractres prcds du
signe :hp1.%:ehp1. ayant une signification particulire. Ces caractres
sont les suivants&colon.
:sl compact.
:li.&percent.s - Jour de la semaine (dimanche, lundi, etc.)
:li.&percent.t - Abrviation du jour de la semaine (dim, lun, etc.)
:li.&percent.j - Jour du mois, sous forme numrique.
:li.&percent.m - Mois de l&apos.anne, sous forme numrique.
:li.&percent.M - Mois de l&apos.anne (janvier, fvrier, etc...)
:li.&percent.n - Abrviation du mois (jan, fev, etc.)
:li.&percent.a - Anne (4 chiffres).
:li.&percent.b - Abrviation de l&apos.anne (2 chiffres).
:esl.
:p.
Tout autre texte entr dans ce champ est copi directement dans la date
cre. Par exemple, la chane de format &odqf.%s %j %M %a&cdqf. deviendrait
&odqf.:hp1.jeudi 13 juillet 1995:ehp1.&cdqf..
:p.
Pour valider le nouveau format de la date, slectionnez la plaquette
:hp2.Ok:ehp2.. Le document actif sera remis en forme en consquence.
:p.
Si vous slectionnez la plaquette :hp2.Appliquer:ehp2., le nouveau format de
date est appliqu au document actif.
:p.
Pour refermer la bote de dialogue sans sauvegarder les modifications,
slectionnez la plaquette :hp2.Annuler:ehp2. ou pressez la touche
:hp2.chap:ehp2. Les modifications valides par la plaquette
:hp2.Appliquer:ehp2. ne seront pas annules.

:h3 res=IDM_CURRENTPAGE.Numro de la page (Option de menu)
:p.Cette option de menu insre dans le document un code qui affiche le
numro de la page o se trouve ce code.

:h3 res=IDM_PAGECOUNT.Nombre de pages (Option de menu)
:p.Cette option de menu insre dans le document un code qui affiche le
nombre total de pages dans le document.

:h3 res=IDM_SEPARATOR.Separateur (Option de menu)
Cette option de menu insre une fonction spciale de sparation dans le
document. Le sparateur termine la ligne en cours, dessine un trait de
sparation sur la ligne suivante, et dplace le curseur sur la ligne
suivante.

:h3 res=IDM_BARCODE.Code  barres (Option du menu)
Ce menu appelle un dialogue avec lequel vous pouvez prparer l&apos.insertion
d&apos.un graphique de code  barres dans le document. Pour plus
d&apos.informations, voir 
:link reftype=hd res=IDD_BARCODE.Insertion de Code  barres (Dialogue):elink..

:h4 res=IDD_BARCODE.Insertion d&apos.un Code  Barres (Dialogue)
Ce dialogue vous permet de spcifier le type et le texte
d&apos.un graphic de Code  Barres  tre insr dans le document.
:artwork name='Francais\BarCode.bmp' align=center.
Vous devez
selectionnerle type de Code  Barres  partir de la liste fournie et ensuite 
entrer le texte qui devra tre cod dans l&apos.espace d&apos.insertion. Lorsque 
complt, pressez la touche ENTREZ ou cliquez le bouton O.K.,  ce moment 
l&apos.on vous demandera de positionner le graphique sur le document courant, 
comme dans le cas du 
:link reftype=hd res=IDM_PASTE_FROM_CLIP_BITMAP.Coller un bitmap depuis le presse-papier (Option de menu):elink..

:h2 res=IDM_SEARCH.Chercher... (Option de menu)
:p.Cette option de menu ouvre une bote de dialogue dans laquelle vous
pouvez dfinir une chane de caractres  rechercher, et ventuellement
une autre chane de caractres par laquelle remplacer la premire.
:p.Voir :link reftype=hd res=IDD_SEARCH.Chercher... (Dialogue):elink. pour
plus d&apos.informations.
:p.Le raccourci clavier pour cette fonction est :hp2.Ctrl+C:ehp2..

:h3 res=IDD_SEARCH.Chercher... (Dialogue)
:p.Cette bote de dialogue vous permet de dfinir une chane de caractres
 rechercher pour les commandes
:link reftype=hd res=IDM_SEARCH.Chercher:elink. et
:link reftype=hd res=IDM_FINDNEXT.Trouver suivant:elink., et ventuellement
une autre chane de caractres par laquelle remplacer la premire.

:artwork name='Francais\Search.bmp' align=center.
:p.Pour rechercher une chane de caractres, saisissez la dans la
premire zone de saisie puis pressez :hp2.Entre:ehp2. ou slectionnez la
plaquette :hp2.Chercher:ehp2.. La chane sera recherche dans le document
et mise en surbrillance. La bote de dialogue reste prsente  l&apos.cran
pour vous permettre de modifier la chane  rechercher.
:p.Pour remplacer un texte par un autre, saisissez le texte original
dans la premire zone de saisie et le nouveau texte dans la seconde zone
de saisie, puis pressez la touche :hp2.Entre:ehp2. pour trouver le
texte  remplacer, ou slectionnez la plaquette :hp2.Remplacer:ehp2. pour
rechercher et remplacer le texte. Vous pouvez rpter l&apos.operation de
remplacement pour chaque occurence du texte recherch.
:p.Pour remplacer un texte par un autre, puis chercher l&apos.occurence
suivante du texte d&apos.origine, slectionnez la plaquette :hp2.Remplacer
&amp. Chercher:ehp2..
:p.Pour remplacer toutes les occurences du texte original par le
nouveau, slectionnez la plaquette :hp2.Remplacer tous:ehp2..
:p.Vous pouvez faire en sorte que les recherches soient influences ou
non par la casse des caractres en slectant ou non la case  cocher
:hp2.Minuscules/majuscules:ehp2..
:p.Si vous dsirez que votre recherche obisse aux rgles des
Expressions Rgulire (Regular Expressions) UNIX, cochez la
case :hp2.Expression Rgulire:ehp2..
:p.Pour fermer la bote de dialogue, pressez la touche :hp2.chap:ehp2.
ou slectionnez la plaquette :hp2.Annuler:ehp2.. Le contenu des champs de
saisie est conserv pour la prochaine utilisation de cette fonction.

:h2 res=IDM_FINDNEXT.Trouver suivant (Option de menu)
:p.Si vous avez dfini une chane de caractres  rechercher dans la
bote de dialogue
:link reftype=hd res=IDD_SEARCH.Chercher... (Dialogue):elink., cette option de
menu recherchera l&apos.occurence suivante de la chane spcifie et la
slectionnera.
:p.Voir :link reftype=hd res=IDD_SEARCH.Chercher... (Dialogue):elink. pour plus
d&apos.informations.
:p.Le raccourci clavier pour cette fonction est :hp2.Ctrl+F:ehp2.

:h2 res=IDM_GOTOPAGE.Aller vers page (Option de menu)
Cette option vous permet d'afficher une page donne du document.
Voir l'aide de la bote de dialogue
:link reftype=hd res=IDD_GOTOPAGE.Aller vers page:elink.
pour plus d'informations.

:h3 res=IDD_GOTOPAGE.Aller vers page (Dialogue)
Cette bote de dialogue vous permet de spcifier le numro de la page du
document que vous dsirez afficher. Saisissez le numro de la page puis
pressez :hp2.Entre:ehp2., ou bien pressez :hp2.chap:ehp2. pour annuler
cette fonction.

:h2 res=IDM_SPELL.Correcteur orthographique (Option de menu)
:p.Cette option est disponible si le module optionnel de contrle
orthographique est install sur votre systme et si les fichiers
dictionnaires ont pu tre ouverts. Quand vous slectionnez cette option,
le correcteur orthographique inspecte le document actif  partir de la
position du curseur,  la recherche de fautes d&apos.orthographe. Quand un
mot mal orthographi est trouv, il est mis en surbrillance et la bote
de dialogue :link reftype=hd res=IDD_SPELL.Correcteur orthographique:elink.
est affiche, vous permettant de prciser au correcteur l&apos.action 
entreprendre.
:p.Le raccourci clavier pour cette fonction est :hp2.F5:ehp2..

:h3 res=IDD_SPELL.Correcteur orthographique (Bote de dialogue)
:p.Cette bote de dialogue est affiche quand le correcteur orthographique
trouve un mot dont il ne reconnat pas l&apos.orthographe. Le mot suspect est
affich, ainsi qu&apos.une liste de mots ressemblants issus du dictionnaire.

:artwork name='Francais\Spell.bmp' align=center.
:p.Si vous dsirez ignorer cette anomalie, pressez la touche
:hp2.Entre:ehp2. ou slectionnez la plaquette :hp2.Ignorer:ehp2..
:p.Si vous souhaitez que le correcteur orthographique ignore ce mot pour
le reste de la session, slectionnez la plaquette :hp2.Confirmer:ehp2..
:p.Pour ajouter le mot  votre dictionnaire personnel, en conservant
la casse, slectionnez la plaquette :hp2.Ajouter:ehp2..
:p.Pour ajouter le mot  votre dictionnaire, en caractres minuscules,
slectionnez la plaquette :hp2.Ajouter minuscule:ehp2.. Un mot en minuscules
peut correspondre  ce mme mot quelle qu&apos.en soit la casse.
:p.Si vous dsirez appliquer l&apos.une des corrections proposes,
slectionnez le mot dans la liste puis pressez :hp2.Entre:ehp2., ou
cliquez deux fois sur le mot. Le mot original du texte sera remplac par
le mot choisi.
:p.Si l&apos.orthographe correcte du mot ne figure pas dans la liste des
corrections proposes, vous pouvez saisir une orthographe diffrente
dans le champ de saisie au dessus de la liste des corrections, puis
slecter la plaquette :hp2.Remplacer:ehp2..
:p.Pour quitter le correcteur orthographique sans appliquer de
correction, pressez la touche :hp2.chap:ehp2. ou slectionnez la plaquette
:hp2.Annuler:ehp2.. Les corrections dj appliques sont conserves,
mais elles peuvent tre annules grce  la commande
:link reftype=hd res=IDM_UNDO.Dfaire:elink..

:h2 res=IDM_ZOOM.Zoom (Sous-menu)
:p.Cette option de menu ouvre un sous-menu des diffrentes commandes de
zoom sur le document disponibles. Les commandes suivantes sont
disponibles&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_100.Zoom 100%:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_FULLWIDTH.Zoom Pleine Largeur:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_FULLHEIGHT.Zoom Pleine Hauteur:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_MARGINS.Zoom Marges:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_ALL.Zoom Tout:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_WINDOW.Zoom Fentre:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_SET.Zoom Spcial...:elink.
:esl.

:h3 res=IDM_ZOOM_100.Zoom 100% (Option de menu)
:p.Cette commande choisit une chelle d&apos.affichage de 100%. Le
contenu de l&apos.cran devrait tre imprim avec exactement la mme
taille,  condition que les paramtres d&apos.chelle du systme (hors
de contrle du programme) soient renseigns correctement.

:h3 res=IDM_ZOOM_FULLWIDTH.Zoom Pleine Largeur (Option de menu)
:p.Cette commande choisit une chelle d&apos.affichage telle que la page
occupe toute la largeur de sa fentre d&apos.affichage. Ceci peut
rduire ou augmenter l&apos.chelle d&apos.affichage, selon la largeur
de la fentre d&apos.affichage.

:h3 res=IDM_ZOOM_FULLHEIGHT.Zoom Pleine Hauteur (Option de menu)
:p.Cette commande choisit une chelle d&apos.affichage telle que la page
occupe toute la hauteur de sa fentre d&apos.affichage. Ceci rduit
habituellement l&apos.chelle d&apos.affichage, rsultant en un
affichage plus petit que ce que donnera l&apos.impression.

:h3 res=IDM_ZOOM_MARGINS.Zoom Marges (Option de menu)
:p.Cette commande choisit une chelle d&apos.affichage telle que la
portion de document situe entre les marges horizontales occupe toute la
largeur de la fentre d&apos.affichage. Habituellement, ceci augmente
l&apos.chelle d&apos.affichage, selon la largeur de la fentre
d&apos.affichage.

:h3 res=IDM_ZOOM_ALL.Zoom Tout (Option de menu)
:p.Cette commande choisit l&apos.chelle d&apos.affichage la plus petite
parmis les chelles correspondant  :hp1.Zoom Pleine Hauteur:ehp1. et
:hp1.Zoom Pleine Largeur:ehp1.. De cette faon, la page entire
apparatra dans la fentre, aussi petite ou difforme que soit la fentre
du document.
:p.Le raccourci clavier pour cette fonction est :hp2.Ctrl+Z:ehp2.;
quand le raccourci clavier est utilis, cette fonction bascule entre les
modes :hp1.Zoom Tout:ehp1. et le type de zoom spcifi dans les :link
reftype=hd res=IDD_PREFERENCES.Prfrences:elink..

:h3 res=IDM_ZOOM_WINDOW.Zoom Fentre (Option de menu)
:p.Cette commande vous permet de dfinir une portion rectangulaire du
document actif sur laquelle zoomer. Une fois la portion slectionne,
l&apos.chelle d&apos.affichage sera modifie et le document
repositionn de faon  ce que la zone slectionne soit visible et
occupe la plus grande partie possible de la fentre.

:h3 res=IDM_ZOOM_SET.Zoom Spcial... (Option de menu)
:p.Cette commande entrane l&apos.ouverture d&apos.une bote de dialogue permettant
de modifier le facteur de zoom.
:p.Voir :link reftype=hd res=IDD_ZOOM_SET.Zoom Spcial... (Dialogue):elink.
pour plus d&apos.informations.

:h4 res=IDD_ZOOM_SET.Zoom Spcial... (Dialogue)
:p.Cette bote de dialogue permet  l&apos.utilisateur de spcifier un facteur
de zoom quelconque. Utilisez les touches haut et bas pour modifier le
facteur de zoom, ou saisissez directement la valeur, puis pressez la
touche :hp2.Entre:ehp2. ou slectionnez la plaquette :hp2.Ok:ehp2. pour
appliquer le nouveau facteur de zoom.
:artwork name='Francais\ZoomSet.bmp' align=center.
:p.Pour appliquer le nouveau facteur de zoom sans refermer la bote de
dialogue, slectionnez la plaquette :hp2.Appliquer:ehp2.. Un facteur de zoom
valid ainsi restera actif aprs la fermeture de la bote de dialogue,
mme si vous utilisez la touche :hp2.chap:ehp2..
:p.Pour refermer la bote de dialogue sans appliquer les changements
apports au facteur de zoom, pressez la touche :hp2.chap:ehp2. ou
slectionnez la plaquette :hp2.Annuler:ehp2.. Les modifications valides par
la plaquette :hp2.Appliquer:ehp2. ne seront pas annules.

:h1 res=IDM_LAYOUT_MENU.Menu Disposition
:i1.Menu Disposition
:p.Les commandes suivantes sont accessibles depuis le menu
:hp4.Disposition:ehp4.&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_MARGINS.Marges...:elink.
:li.&sqbul.:link reftype=hd res=IDM_TABS.Tabulations...:elink.
:li.&sqbul.:link reftype=hd res=IDM_INDENT.Indentation...:elink.
:li.&sqbul.:link reftype=hd res=IDM_LINESPACING_MENU.Interligne:elink.
:li.&sqbul.:link reftype=hd res=IDM_JUSTIFICATION.Justification:elink.
:li.&sqbul.:link reftype=hd res=IDM_PAGECENTER.Centrer la Page:elink.
:li.&sqbul.:link reftype=hd res=IDM_PAGEBREAK.Saut de Page:elink.
:li.&sqbul.:link reftype=hd res=IDM_HEADER.En-tte...:elink.
:li.&sqbul.:link reftype=hd res=IDM_FOOTER.Pied de page...:elink.
:esl.

:h2 res=IDM_MARGINS.Marges... (Option de menu)
:p.Cette commande entrane l&apos.apparition d&apos.une bote de dialogue  partir de
laquelle il est possible de dfinir les quatre marges (haut, bas,
gauche, droite).
:p.Voir:link reftype=hd res=IDD_MARGINS.Marges (Dialogue):elink. pour plus d&apos.informations.

:h3 res=IDD_MARGINS.Marges (Dialogue)
:p.Cette bote de dialogue vous permet de spcifier les marges
d&apos.impression de gauche, droite, du haut et du bas de la page. Ces
marges sont exprimes dans l&apos.unit de mesure slectionne (pouces ou
centimtres) ; elles reprsentent des distances  partir des bords du
support d&apos.impression actif.
:artwork name='Francais\Margins.bmp' align=center.
:p.Quand de nouvelles valeurs sont entres pour les marges, les rgles
horizontale et verticale du document actif sont modifies pour reflter
les modifications, mais le document lui-mme n&apos.est pas remis en
forme.
:p.Pressez la touche :hp2.Entre:ehp2. ou slectionnez la plaquette
:hp2.Ok:ehp2. pour valider les valeurs saisies. Dans le cas o les
marges ne sont pas applicables sur le support d&apos.impression en
cours, vous serez averti par un message d&apos.erreur et la bote de
dialogue restera ouverte.
:p.Si vous slectionnez la plaquette :hp2.Appliquer:ehp2., les nouvelles marges
sont appliques au document actif, et deviennent les nouvelles marges.
:p.Pour fermer la bote de dialogue et annuler les modifications saisies,
pressez la touche :hp2.chap:ehp2. ou slectionnez la plaquette
:hp2.Annuler:ehp2.. Les modifications valides par la plaquette
:hp2.Appliquer:ehp2. ne sont pas annules.
:note.Les nouvelles marges gauche et droite prendront effet  partir de
la ligne suivante,  moins que la commande de dfinition des marges
n&apos.ait t insre dans le document au tout dbut d&apos.une
nouvelle ligne. Les marges haut et bas seront appliques  partir de la
page suivante,  moins que la commande de dfinition des marges
n&apos.ait t insre au tout dbut d&apos.une nouvelle page.

:h2 res=IDM_TABS.Tabulations... (Option de menu)
:p.Cette commande invoque une bote de dialogue  l&apos.aide de laquelle
il est possible de modifier les positions des taquets de tabulation du
document. Les nouvelles valeurs seront appliques  partir de la
position du curseur.
:p.Voir:link reftype=hd res=IDD_TABS.Tabulations (Dialogue):elink. pour plus d&apos.informations.

:h3 res=IDD_TABS.Tabulations (Dialogue)
:p.Cette bote de dialogue vous permet d&apos.ajouter et de supprimer des
taquets de tabulations. Vos modifications sont immdiatement visibles
sur la rgle horizontale de la fentre active.
:artwork name='Francais\Tabs.bmp' align=center.
:p.Pour positionner un taquet de tabulation, entrez sa position dans le
champ de saisie, puis slectionnez la plaquette :hp2.Dfinir:ehp2..
:p.Pour supprimer un taquet de tabulation, entrez sa position dans le
champ de saisie, puis slectionnez la plaquette :hp2.Effacer:ehp2..
:p.Une fois que vous avez effectu toutes les modifications que vous
dsirez apporter aux tabulations de votre document, pressez la touche
:hp2.Entre:ehp2. ou slectionnez la plaquette :hp2.Ok:ehp2.. Les modifications
appportes seront appliques au document  partir de la position du
curseur.
:p.Si vous slectionnez la plaquette :hp2.Appliquer:ehp2., les nouvelles
dfinitions des tabulations sont appliques immdiatement au document.
:p.Pour fermer la bote de dialogue et annuler les modifications
effectues, pressez la touche :hp2.chap:ehp2. ou slectionnez la plaquette
:hp2.Annuler:ehp2.. Les modification valides  l&apos.aide de la plaquette
:hp2.Appliquer:ehp2. ne sont pas annules.

:h2 res=IDM_INDENT.Indentation... (Option de menu)
:p.Cette commande provoque l&apos.ouverture d&apos.une bote de dialogue vous
permettant de dfinir la taille de l&apos.indentation  utiliser au dbut de
chaque nouveau paragraphe.
:p.Voir:link reftype=hd res=IDD_INDENT.Indentation (Dialogue):elink. pour plus d&apos.informations.

:h3 res=IDD_INDENT.Indentation (Dialogue)
:p.Cette bote de dialogue vous permet de dfinir l&apos.indentation
utilise  partir de la position du curseur.
:artwork name='Francais\Indent.bmp' align=center.
:p.Vous pouvez saisir la nouvelle distance d&apos.indentation, puis
slecter la plaquette :hp2.Ok:ehp2. pour prendre en compte la nouvelle
valeur. Le document actif sera reformat en consquence.
:p.Si vous slectionnez la plaquette :hp2.Appliquer:ehp2., la nouvelle
distance d&apos.indentation est applique immdiatement au document
actif.
:p.Pour fermer la bote de dialogue sans enregistrer les modifications,
slectionnez la plaquette :hp2.Annuler:ehp2. ou pressez la touche
:hp2.chap:ehp2.. Les modifications valides par la plaquette
:hp2.Appliquer:ehp2. ne seront pas annules.

:h2 res=IDM_LINESPACING_MENU.Menu interligne
:p.Ce sous-menu propose les diffrents interlignes disponibles.
:p.L&apos.interligne actif est coch.
:p.Voir :link reftype=hd res=IDM_LINESPACINGS.Entres du menu interligne:elink.
pour plus d&apos.informations.

:h3 res=IDM_LINESPACINGS.Entres du menu interligne
:p.Ces lignes de menu reprsentent les options d&apos.interligne disponibles.
Les interlignes sont dfinis comme des pourcentages d&apos.un interligne
normal pour la police et la taille en cours. Quand une de ces options
d&apos.interligne est choisie, l&apos.interligne correspondant est appliqu  la
zone de texte slectionne, ou  partir de la position du curseur si
aucun texte n&apos.est slectionn.

:h3 res=IDM_LINESPACINGMGR.Gestionnaire du menu interligne
:p.Cette fonction n&apos.est pas encore disponible.

:h2 res=IDM_JUSTIFICATION.Justification (Option de menu)
:p.Ce sous-menu prsente les diffrentes options de justification
horizontale du texte. Les options disponibles sont&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_JUST_LEFT.Justification  Gauche:elink.
:li.&sqbul.:link reftype=hd res=IDM_JUST_CENTER.Justification au Centre:elink.
:li.&sqbul.:link reftype=hd res=IDM_JUST_RIGHT.Justification  Droite:elink.
:li.&sqbul.:link reftype=hd res=IDM_JUST_FULL.Justification  Gauche et  Droite:elink.
:esl.

:h3 res=IDM_JUST_LEFT.Justification  Gauche (Option de menu)
:p.Cette option de menu insre dans le document une commande entranant la
justification  gauche du texte,  partir de la ligne suivant la
position du curseur,  moins que la commande ne soit insre au tout
dbut d&apos.une ligne, auquel cas la commande prendra effet immdiatement.

:h3 res=IDM_JUST_CENTER.Justification au Centre (Option de menu)
:p.Cette option de menu insre dans le document une commande entranant la
justification centre du texte,  partir de la ligne suivant la position
du curseur,  moins que la commande ne soit insre au tout dbut
d&apos.une ligne, auquel cas la commande prendra effet immdiatement.

:h3 res=IDM_JUST_RIGHT.Justification  Droite (Option de menu)
:p.Cette option de menu insre dans le document une commande entranant la
justification  droite du texte,  partir de la ligne suivant la
position du curseur,  moins que la commande ne soit insre au tout
dbut d&apos.une ligne, auquel cas la commande prendra effet immdiatement.

:h3 res=IDM_JUST_FULL.Justification Gauche et Droite (Option de menu)
:p.Cette option de menu insre dans le document une commande entranant la
justification du texte  droite et  gauche,  partir de la ligne
suivant la position du curseur,  moins que la commande ne soit insre
au tout dbut d&apos.une ligne, auquel cas la commande prendra effet
immdiatement. La taille des espaces  l&apos.intrieur du texte
justifi  gauche et  droite est adapte pour aligner le texte sur les
marges gauche et droite. Les lignes se terminant par un retour chariot
ou un saut de page sont justifies  gauche.

:h2 res=IDM_PAGECENTER.Centrer la Page (Option de menu)
:p.Cette option de menu insre dans le document une commande entranant le
centrage vertical de la page,  partir de la page suivante; si la
commande est entre au tout dbut d&apos.une nouvelle page, son effet
est immdiat.
:note.Cette fonction ne peut tre utilise si des graphiques sont
prsents sur la page; le cas chant, la fonction est inactive.

:h2 res=IDM_PAGEBREAK.Saut de Page (Option de menu)
:p.Cette commande provoque l&apos.insertion d&apos.un saut de page dans le document 
la position du curseur. Le curseur se dplacera vers le dbut de la
nouvelle page.
:p.Le raccourci clavier pour cette fonction est Ctrl+Entre.
:note.Cette option n&apos.est pas disponible dans le menu contextuel
d&apos.un texte slectionn.

:h2 res=IDM_HEADER.En-tte... (Option de menu)
Permet d'accder  la bote de dialogue dans laquelle vous dfinissez
l'apparence de l'en-tte.

:h3 res=IDD_HEADER.En-tte (Dialogue)
Cette bote de dialogue vous permet de dfinir l'en-tte. Pour le
moment, l'en-tte doit tre fourni dans le format natif d'Escriba. Plus
tard, la saisie se fera en WYSIWYG. La plupart des codes de fonction
(comme PageNumber, PageCount, LeftJustify, etc) sont valides pour le
format d'en-tte, mais pas tous (PrinterSettings).

:h2 res=IDM_FOOTER.Pied de page... (Option de menu)
Permet d'accder  la bote de dialogue dans laquelle vous dfinissez
l'apparence du pied de page.

:h3 res=IDD_FOOTER.Pied de page (Dialogue)
Cette bote de dialogue vous permet de dfinir le pied de page. Pour le
moment, le pied de page doit tre fourni dans le format natif d'Escriba.
Plus tard, la saisie se fera en WYSIWYG. La plupart des codes de
fonction (comme PageNumber, PageCount, LeftJustify, etc) sont valides
pour le format de pied de page, mais pas tous (PrinterSettings).

:h1 res=IDM_FONT_MENU.Menu Polices
:i1.Menu Police
:p.Ce menu propose la liste de toutes les polices de caractres disponibles.
:p.La police active est coche.
:p.Voir :link reftype=hd res=IDM_FONTS.Entres du menu Polices:elink.
pour plus d&apos.informations.

:h2 res=IDM_FONTS.Entres du menu Polices
:p.Chaque ligne du menu reprsente une des polices de caractres
disponibles, affiche dans la police correspondante, en 18 points. La
slection d&apos.une police dans le menu entrane son application  la
zone de texte slectionne, ou  partir de la position du curseur si
aucun texte n&apos.est slectionn.

:h2 res=IDM_FONTS_PGUP.Suite 
:p.Cette option de menu est disponible si la liste complte des polices
disponibles ne peut tre affiche dans le menu, et si d&apos.autres polices
sont disponibles avant la premire affiche. Pour faire dfiler le menu
vers le haut, slectionnez cette option de menu.

:h2 res=IDM_FONTS_PGDN.Suite 
:p.Cette option de menu est disponible si la liste complte des polices
disponibles ne peut tre affiche dans le menu, et si d&apos.autres
polices sont disponibles aprs la dernire affiche. Pour faire dfiler
le menu vers le bas, slectionnez cette option de menu.

:h2 res=IDM_FONTMGR.Gestionnaire du menu polices
:p.Cette fonction n&apos.est pas encore disponible.

:h1 res=IDM_SIZE_MENU.Menu Taille
:i1.Menu Taille
:p.Ce menu propose une liste des tailles de polices disponibles.
:p.La taille de la police  la position du curseur est coche.
:p.Voir :link reftype=hd res=IDM_SIZES.Entres du menu Taille:elink.
pour plus d&apos.informations.

:h2 res=IDM_SIZES.Entres du menu Taille
:p.Chaque ligne du menu reprsente une des tailles de police disponibles,
dans la police de caractres active. La slection d&apos.une taille
entrane son application  la zone de texte slectionne, ou  partir de
la position du curseur si aucun texte n&apos.est slectionn.

:h2 res=IDM_SIZES_PGUP.Suite 
:p.Cette option de menu est disponible si la liste complte des tailles
disponibles ne peut tre affiche dans le menu, et si d&apos.autres
tailles sont disponibles avant la premire affiche. Pour faire dfiler
le menu vers le haut, slectionnez cette option de menu.

:h2 res=IDM_SIZES_PGDN.Suite 
:p.Cette option de menu est disponible si la liste complte des tailles
disponibles ne peut tre affiche dans le menu, et si d&apos.autres
tailles sont disponibles aprs la dernire affiche. Pour faire dfiler
le menu vers le bas, slectionnez cette option de menu.

:h2 res=IDM_SIZEMGR.Gestionnaire du menu Taille
:p.Cette fonction n&apos.est pas encore disponible.

:h1 res=IDM_ATTR_MENU.Menu Attributs
:i1.Menu Attributs
:p.Ce menu permet d&apos.insrer des commandes d&apos.attributs de polices
de caractres dans le document. Tous les attributs de police grs
nativement par le Gestionnaire de Prsentation sont prsents&colon.
:hp2.Normal:ehp2., :hp2.Gras:ehp2., :hp2.Italique:ehp2.,
:hp2.Soulign:ehp2., :hp2.Barr:ehp2. et :hp2.Contour:ehp2.. Pour
affecter un attribut  tout le texte  partir de la position du curseur,
ou  la zone de texte slectionne, slectionnez l&apos.option de menu
correspondante  l&apos.aide de la souris ou du clavier. Les lignes du menu
:hp2.Attributs:ehp2. sont prsentes dans la police et la taille en
vigueur  la position du curseur, et les attributs actifs sont cochs.
N&apos.importe quelle combinaison d&apos.attributs ( l&apos.exclusion de l&apos.attribut
:hp2.Normal:ehp2.) peut tre cre. L&apos.attribut :hp2.Normal:ehp2. est
actif quand aucun des autres ne l&apos.est.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_NORMAL.Normal:elink.
:li.&sqbul.:link reftype=hd res=IDM_BOLD.Gras:elink.
:li.&sqbul.:link reftype=hd res=IDM_ITALIC.Italique:elink.
:li.&sqbul.:link reftype=hd res=IDM_UNDERSCORE.Soulign:elink.
:li.&sqbul.:link reftype=hd res=IDM_STRIKEOUT.Barr:elink.
:li.&sqbul.:link reftype=hd res=IDM_OUTLINE.Contour:elink.
:li.&sqbul.:link reftype=hd res=IDM_CAPS.Majuscules:elink.
:li.&sqbul.:link reftype=hd res=IDM_EXPAND_MENU.Menu Largeur:elink.
:li.&sqbul.:link reftype=hd res=IDM_LINECOLOR_MENU.Menu Couleur du trait:elink.
:li.&sqbul.:link reftype=hd res=IDM_LINEWIDTH_MENU.Menu paisseur du trait:elink.
:li.&sqbul.:link reftype=hd res=IDM_FILLCOLOR_MENU.Menu Couleur de remplissage:elink.
:li.&sqbul.:link reftype=hd res=IDM_FILLTYPE_MENU.Menu Motif de remplissage:elink.
:li.&sqbul.:link reftype=hd res=IDM_LINEEND_MENU.Line End Menu:elink.
:li.&sqbul.:link reftype=hd res=IDM_LINEJOIN_MENU.Line Join Menu:elink.
:esl.

:h2 res=IDM_NORMAL.Normal (Option de menu)
:p.La slection de cette option de menu annule tous les attributs de police
actifs (tels gras, italique, etc...) Si cette option est slectionne alors
qu&apos.une portion de texte est slectionne, elle n&apos.a
d&apos.effet que sur le texte slectionn. Si aucun texte n&apos.est
slectionn, l&apos.effet est appliqu  partir de la position du
curseur. Les commandes d&apos.attributs prsentes plus loin dans le
document ne sont pas affectes.
:p.Le raccourci clavier pour cette fonction est :hp2.Ctrl+N:ehp2..

:h2 res=IDM_BOLD.Gras (Option de menu)
:p.La slection de cette option de menu applique l&apos.attribut de police
:hp2.Gras:ehp2. au texte slectionn, ou bien  partir de la position du
curseur. Les commandes d&apos.attributs prsentes plus loin dans le
document ne sont pas affectes.
:p.Le raccourci clavier pour cette fonction est :hp2.Ctrl+G:ehp2..

:h2 res=IDM_ITALIC.Italique (Option de menu)
:p.La slection de cette option de menu applique l&apos.attribut de police
:hp2.Italique:ehp2. au texte slectionn, ou bien  partir de la
position du curseur. Les commandes d&apos.attributs prsentes plus loin
dans le document ne sont pas affectes.
:p.Le raccourci clavier pour cette fonction est :hp2.Ctrl+T:ehp2..

:h2 res=IDM_UNDERSCORE.Soulign (Option de menu)
:p.La slection de cette option de menu applique l&apos.attribut de police
:hp2.Soulign:ehp2. au texte slectionn, ou bien  partir de la
position du curseur. Les commandes d&apos.attributs prsentes plus loin dans
le document ne sont pas affectes.
:p.Le raccourci clavier pour cette fonction est :hp2.Ctrl+S:ehp2..

:h2 res=IDM_STRIKEOUT.Barr (Option de menu)
:p.La slection de cette option de menu applique l&apos.attribut de police
:hp2.Barr:ehp2. au texte slectionn, ou bien  partir de la position
du curseur. Les commandes d&apos.attributs prsentes plus loin dans le
document ne sont pas affectes.

:h2 res=IDM_OUTLINE.Contour (Option de menu)
:p.La slection de cette option de menu applique l&apos.attribut de police
:hp2.Contour:ehp2. au texte slectionn, ou bien  partir de la position
du curseur. Les commandes d&apos.attributs prsentes plus loin dans le
document ne sont pas affectes.

:h2 res=IDM_CAPS.Majuscules (Option de menu)
:p.La slection de cette option de menu applique l&apos.attribut de police
:hp2.Majuscules:ehp2. au texte slectionn, ou bien  partir de la
position du curseur. Les commandes d&apos.attributs prsentes plus loin
dans le document ne sont pas affectes.

:h2 res=IDM_EXPAND_MENU.Menu Largeur
:p.Ce menu propose un choix de largeurs pour la police de caractres.
:p.La largeur active  la position du curseur est coche.
:p.Voir :link reftype=hd res=IDM_EXPANDS.Entres du menu Largeur:elink.
pour plus d&apos.informations.

:h3 res=IDM_EXPANDS.Entres du menu Largeur
:p.Chaque ligne de ce menu reprsente une des largeurs disponibles, dans la
police actuelle. La slection d&apos.une de ces largeurs entrane son
application  la zone de texte slectionne, ou  partir du curseur si
aucun texte n&apos.est slectionn.

:h3 res=IDM_EXPANDS_PGUP.Suite 
:p.Cette option de menu est disponible si la liste complte des largeurs
disponibles ne peut tre affiche dans le menu, et si largeurs sont
disponibles avant la premire affiche. Pour faire dfiler le menu vers
le haut, slectionnez cette option de menu.

:h3 res=IDM_EXPANDS_PGDN.Suite 
:p.Cette option de menu est disponible si la liste complte des largeurs
disponibles ne peut tre affiche dans le menu, et si d&apos.autres
largeurs sont disponibles aprs la dernire affiche. Pour faire dfiler
le menu vers le bas, slectionnez cette option de menu.

:h3 res=IDM_EXPANDMGR.Gestionnaire de Largeurs
:p.Cette fonction n&apos.est pas encore disponible.

:h2 res=IDM_LINECOLOR_MENU.Menu Couleur du trait
:p.Ce menu propose les couleurs de trac disponibles.
:p.La couleur active  la position du curseur est coche.
:p.Voir :link reftype=hd res=IDM_LINECOLORS.Entres du menu Couleur du trait:elink.
pour plus d&apos.informations.

:h3 res=IDM_LINECOLORS.Entres du menu Couleur du trait
:p.Chaque ligne de ce menu reprsente une des couleurs de trait
disponibles. La slection d&apos.une couleur entrane son application  la
zone de texte slectionne, ou  partir de la position du curseur si
aucun texte n&apos.est slectionn.
:note.Ces couleurs s&apos.appliquent aux lignes, au texte plein et  la
partie contour des textes ayant l&apos.attribut contour.

:h3 res=IDM_LINECOLORS_PGUP.Suite 
:p.Cette option de menu est disponible si la liste complte des couleurs de
trait disponibles ne peut tre affiche dans le menu, et si d&apos.autres
couleurs sont disponibles avant la premire affiche. Pour faire dfiler
le menu vers le haut, slectionnez cette option de menu.

:h3 res=IDM_LINECOLORS_PGDN.Suite 
:p.Cette option de menu est disponible si la liste complte des couleurs de
trait disponibles ne peut tre affiche dans le menu, et si d&apos.autres
couleurs sont disponibles aprs la dernire affiche. Pour faire dfiler
le menu vers le bas, slectionnez cette option de menu.

:h3 res=IDM_LINECOLORMGR.Gestionnaire du menu Couleur du trait
:p.Cette fonction n&apos.est pas encore disponible.

:h2 res=IDM_LINEWIDTH_MENU.Menu paisseur du trait
:p.Ce menu propose les paisseurs de trait disponibles.
:p.L&apos.paisseur du trait active  la position du curseur est coche.
:p.Voir :link reftype=hd res=IDM_LINEWIDTHS.Entres du menu paisseur du trait:elink.
pour plus d&apos.informations.

:h3 res=IDM_LINEWIDTHS.Entres du menu paisseur du trait
:p.Chaque ligne de ce menu reprsente une des paisseurs de trait
disponibles. La slection d&apos.une paisseur entrane son application
 la zone de texte slectionne, ou  partir de la position du curseur
si aucun texte n&apos.est slectionn.

:note.L&apos.paisseur du trait s&apos.applique aux lignes, et  la
partie contour des textes possdant l&apos.attribut contour.

:h3 res=IDM_LINEWIDTHS_PGUP.Suite 
:p.Cette option de menu est disponible si la liste complte des paisseurs
de trait disponibles ne peut tre affiche dans le menu, et si
d&apos.autres paisseurs sont disponibles avant la premire affiche.
Pour faire dfiler le menu vers le haut, slectionnez cette option de menu.

:h3 res=IDM_LINEWIDTHS_PGDN.Suite 
:p.Cette option de menu est disponible si la liste complte des paisseurs
de trait disponibles ne peut tre affiche dans le menu, et si
d&apos.autres paisseurs sont disponibles aprs la dernire affiche.
Pour faire dfiler le menu vers le bas, slectionnez cette option de menu.

:h3 res=IDM_LINEWIDTHMGR.Gestionnaire du menu paisseur du trait
:p.Cette fonction n&apos.est pas encore disponible.

:h2 res=IDM_FILLCOLOR_MENU.Menu Couleur de remplissage
:p.Ce menu propose toutes les couleurs de remplissage des textes possdant
l&apos.attribut contour.
:p.La couleur de remplissage active  la position du curseur est coche.
:p.Voir :link reftype=hd res=IDM_FILLCOLORS.Entres du menu Couleur de remplissage:elink. 
pour plus d&apos.informations.

:h3 res=IDM_FILLCOLORS.Entres du menu Couleur de remplissage
:p.Chaque ligne de ce menu reprsente une des couleurs de remplissage
disponibles. La slection d&apos.une couleur entrane son application 
la zone de texte slectionne, ou  partir de la position du curseur si
aucun texte n&apos.est slectionn.

:h3 res=IDM_FILLCOLORS_PGUP.Suite 
:p.Cette option de menu est disponible si la liste complte des couleurs de
remplissage disponibles ne peut tre affiche dans le menu, et si
d&apos.autres couleurs sont disponibles avant la premire affiche. Pour
faire dfiler le menu vers le haut, slectionnez cette option de menu.

:h3 res=IDM_FILLCOLORS_PGDN.Suite 
:p.Cette option de menu est disponible si la liste complte des couleurs de
remplissage disponibles ne peut tre affiche dans le menu, et si
d&apos.autres couleurs sont disponibles aprs la dernire affiche. Pour
faire dfiler le menu vers le bas, slectionnez cette option de menu.

:h3 res=IDM_FILLCOLORMGR.Gestionnaire du menu Couleur de remplissage
:p.Cette fonction n&apos.est pas encore disponible.

:h2 res=IDM_FILLTYPE_MENU.Menu Motif de remplissage
:p.Ce menu prsente la liste des motifs de remplissage des textes
possdant l&apos.attribut contour.
:p.Le motif de remplissage actif  la position du curseur est coch.
:p.Voir :link reftype=hd res=IDM_FILLTYPES.Entres du menu Motif de remplissage:elink. 
pour plus d&apos.informations.

:h3 res=IDM_FILLTYPES.Entres du menu Motif de remplissage
:p.Chaque ligne de ce menu reprsente un des motifs de remplissage
disponibles. La slection d&apos.un motif entrane son application  la
zone de texte slectionne, ou  partir de la position du curseur si
aucun texte n&apos.est slectionn.

:h3 res=IDM_FILLTYPES_PGUP.Suite 
:p.Cette option de menu est disponible si la liste complte des motifs de
remplissage disponibles ne peut tre affiche dans le menu, et si
d&apos.autres motifs sont disponibles avant le premier affich. Pour
faire dfiler le menu vers le haut, slectionnez cette option de menu.

:h3 res=IDM_FILLTYPES_PGDN.Suite 
:p.Cette option de menu est disponible si la liste complte des motifs de
remplissage disponibles ne peut tre affiche dans le menu, et si
d&apos.autres motifs sont disponibles aprs le dernier affich. Pour
faire dfiler le menu vers le bas, slectionnez cette option de menu.

:h3 res=IDM_FILLTYPEMGR.Gestionnaire du menu Motif de remplissage
:p.Cette fonction n&apos.est pas encore disponible.

:h2 res=IDM_LINEEND_MENU.Menu Fin de ligne
:p.Ce menu affiche la liste des types de fin de lignes disponibles.
:p.Le type actif  la position du curseur est coch dans la liste.
:p.Voir :link reftype=hd res=IDM_LINEENDS.Entres du menu Fin de ligne:elink.
pour plus d&apos.information.

:h3 res=IDM_LINEENDS.Entres du menu Fin de ligne
:p.Cette ligne du menu reprsente l&apos.un des types de fin de lignes
disponibles pour le texte possdant l&apos.attribut :hp1.Contour:ehp1.. Pour
dfinir un type de fin de ligne  appliquer  partir de la position du
curseur, ou pour appliquer un type  une zone de texte slectionne,
slectionnez le type dsir  l&apos.aide de la souris, ou bien utilisez les
flches du clavier puis pressez la touche :hp2.Entre:ehp2..

:h3 res=IDM_LINEENDS_PGUP.Suite 
:p.Cette option de menu est disponible si tous les choix du menu :hp2.Fin
de ligne:ehp2. ne peuvent tre affichs simultanment, et que d&apos.autres
choix sont disponibles avant le premier affich. Slectez cette option
pour faire dfiler le menu vers le haut.

:h3 res=IDM_LINEENDS_PGDN.Suite 
:p.Cette option de menu est disponible si tous les choix du menu :hp2.Fin
de ligne:ehp2. ne peuvent tre affichs simultanment, et que d&apos.autres
choix sont disponibles aprs le dernier affich. Slectez cette option
pour faire dfiler le menu vers le bas.

:h3 res=IDM_LINEENDMGR.Gestionnaire du menu Fin de ligne
:p.Cette fonction n&apos.est pas encore disponible.

:h2 res=IDM_LINEJOIN_MENU.Menu Jointure
:p.Ce menu propose la liste des types de jointures disponibles.
:p.Le type de jointure actif  la position du curseur est coch dans la
liste.
:p.Voir :link reftype=hd res=IDM_LINEJOINS.Entres du menu Jointure:elink.
pour plus d&apos.information.

:h3 res=IDM_LINEJOINS.Entres du menu Jointure
:p.Cette ligne du menu reprsente l&apos.un des types de jointures disponibles
pour le texte possdant l&apos.attribut :hp1.Contour:ehp1.. Pour dfinir un
type de jointure  appliquer  partir de la position du curseur, ou pour
appliquer un type  une zone de texte slectionne, slectionnez le type
dsir  l&apos.aide de la souris, ou bien utilisez les flches du clavier
puis pressez la touche :hp2.Entre:ehp2..

:h3 res=IDM_LINEJOINS_PGUP.Suite 
:p.Cette option de menu est disponible si tous les choix du menu
:hp2.Jointure:ehp2. ne peuvent tre affichs simultanment, et que
d&apos.autres choix sont disponibles avant le premier affich. Slectez cette
option pour faire dfiler le menu vers le haut.

:h3 res=IDM_LINEJOINS_PGDN.Suite 
:p.Cette option de menu est disponible si tous les choix du menu
:hp2.Jointure:ehp2. ne peuvent tre affichs simultanment, et que
d&apos.autres choix sont disponibles aprs le dernier affich. Slectez cette
option pour faire dfiler le menu vers le bas.

:h3 res=IDM_LINEJOINMGR.Gestionnaire du menu Jointure
:p.Cette fonction n&apos.est pas encore disponible.

:h1 res=IDM_WINDOW_MENU.Menu Fentres
:i1.Menu Fentres
:p.Ce menu donne accs aux fonctions de manipulations de fentres, ainsi
qu&apos. la liste des fentres de documents ouvertes. Les commandes
suivantes sont disponibles&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_TILE.Mosaque:elink.
:li.&sqbul.:link reftype=hd res=IDM_CASCADE.Cascade:elink.
:li.&sqbul.:link reftype=hd res=IDM_ARRANGEICONS.Arranger les Icnes:elink.
:li.&sqbul.:link reftype=hd res=IDM_WINDOWS.Fentres actives:elink.
:esl.

:h2 res=IDM_TILE.Mosaque (Option de menu)
:p.Cette commande arrange les fentres de documents non-rduites de faon
 ce que toutes soient entirement visibles; les icnes reprsentant
les fentres de documents rduites sont places en bas de l&apos.espace
de travail, et restent visibles.

:h2 res=IDM_CASCADE.Cascade (Option de menu)
:p.Cette commande arrange les fentres de documents non-rduites de faon 
ce qu&apos.elles soient aussi grandes que possible, mais en permettant
de voir les barres de titre de toutes les fentres et les icnes des
fentres rduites. Les icnes reprsentant les fentres rduites sont
dplaces vers la partie infrieure de l&apos.espace de travail si
ncessaire.

:h2 res=IDM_ARRANGEICONS.Arranger les Icnes (Option de menu)
:p.Cette commande arrange les icnes des fentres de documents rduites
dans la partie infrieure gauche de l&apos.espace de travail. Cette
opration est ralise automatiquement quand les commandes
:hp2.Mosaque:ehp2. et :hp2.Cascade:ehp2. sont excutes.

:h2 res=IDM_WINDOWS.Fentres actives
:p.Cette partie du menu Fentres affiche une liste des fentres de
documents ouvertes. La slection d&apos.un des document proposs
entrane le passage de la fentre correspondante au premier plan.

:h1 res=IDM_HELP_MENU.Menu Aide
:i1.Menu Aide
:p.Le menu d&apos.aide est dispos de faon conforme au standard SAA, et fournit
les commandes suivantes&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_HELP_INDEX.Index:elink.
:li.&sqbul.:link reftype=hd res=IDM_EXTENDED_HELP.Aide gnrale:elink.
:li.&sqbul.:link reftype=hd res=IDM_HELP_FOR_HELP.Utiliser l&apos.aide:elink.
:li.&sqbul.:link reftype=hd res=IDM_KEYS_HELP.Aide sur les touches:elink.
:li.&sqbul.:link reftype=hd res=IDM_ABOUT_MENU.Menu infos produit:elink.
:esl.

:h2 res=IDM_HELP_INDEX.Index (Option de menu)
:p.Cette option de menu donne accs  l&apos.index du systme d&apos.aide.

:h2 res=IDM_EXTENDED_HELP.Aide gnrale (Option de menu)
:p.Cette option donne accs  des informations d&apos.ordre gnral sur
l&apos.application.

:h2 res=IDM_HELP_FOR_HELP.Utiliser l&apos.Aide (Option de menu)
:p.Cette option donne accs aux instructions de base sur la faon
d&apos.utiliser le programme d&apos.aide en ligne. Ces informations ne
sont pas spcifiques  cette application.

:h2 res=IDM_KEYS_HELP.Aide sur les touches (Option de menu)
:p.Les touches suivantes sont disponibles dans Escriba&colon.
J&apos.ai fait de mon mieux pour rester conforme au standard SAA CUA, tel que
je le comprends. Le manque d&apos.information (dont je dispose) sur le sujet
est impressionnant.
:table cols='20 60' rules=both frame=box.
:row.:c.F1              :c.Aide en ligne
:row.:c.F3              :c.Sortie
:row.:c.F4              :c.Sortie aprs fermeture du document actif
:row.:c.F5              :c.Contrle orthographique
:row.:c.F10             :c.Menu
:row.:c.Ctrl + Tab      :c.Document suivant
:row.:c.Ctrl + C        :c.Chercher
:row.:c.Ctrl + E        :c.Savegarde du document actif
:row.:c.Ctrl + G        :c.Gras
:row.:c.Ctrl + I        :c.Impression du document
:row.:c.Alt + I         :c.Impression de la page en cours
:row.:c.Ctrl + N        :c.Texte Normal (Annule les attributs de texte)
:row.:c.Ctrl + O        :c.Ouverture d&apos.un document
:row.:c.Ctrl + S        :c.Soulign
:row.:c.Ctrl + T        :c.Italique
:row.:c.Ctrl + Z        :c.Zoom Tout actif/inactif
:row.:c.Ctrl + Ret. Arr.:c.Efface jusqu&apos.au dbut du mot
:etable.
De plus, certaines touches permettent de naviguer dans le document. Voir
:link reftype=hd res=60003.dition de documents (Navigation):elink. pour une
description de ces touches.

:h2 res=IDM_ABOUT_MENU.Menu infos produit (sous-menu)
:p.Cette option de menu donne accs  la bote de dialogue d&apos.informations
sur le programme et  la bote de dialogue de Copyright.
:p.Voir:link reftype=hd res=IDD_ABOUT.Infos produit (Dialogue):elink. pour
plus d&apos.informations.
:p.Si vous slectionnez la plaquette de menu conditionnel, une liste des
produits installs est propose, vous donnant accs aux informations sur
chacun de ces produits.

:h3 res=IDM_ABOUT.Ligne du menu Infos produit (Option de menu)
:p.Cette ligne du menu Infos produit reprsente Escriba ou une des
extensions installes. Slectez une ligne du menu pour accder aux
informations sur ce produit.
(Voir :link reftype=hd res=IDD_ABOUT.Infos produit (Dialogue):elink. pour plus
d&apos.informations).

:h4 res=IDD_ABOUT.Infos produit (Dialogue)
:p.Cette bote de dialogue affiche le nom du programme, son icne et la
notice de Copyright. Pour quitter la bote de dialogue, pressez la
touche :hp2.Entre:ehp2., la barre d&apos.espace ou la touche
:hp2.chap:ehp2., ou slectionnez la plaquette :hp2.Ok:ehp2.  l&apos.aide
de la souris.
:artwork name='Francais\About.bmp' align=center.

:h1 res=60009.Menus contextuels
:i1.Menus contextuels
:p.Il existe plusieurs menus contextuels qui peuvent tre appels d&apos.un
simple clic du bouton droit de la souris. Dans leur ensemble, ces menus
contextuels proposent plus de fonctions que les menus droulants de la
fentre principale.
:p.
Quand vous cliquez le bouton droit de la souris sur l&apos.espace de
travail du programme (pas sur une fentre de document), le 
:link reftype=hd res=IDM_MAIN_CONTEXT.Menu contextuel gnral:elink. est affich. Quand
vous cliquez le bouton droit sur une fentre de document, mais pas sur
une zone de texte slectionn ni sur un graphique, le 
:link reftype=hd res=IDM_DEFAULTMENU.Menu standard:elink. est affich. Un clic du bouton
droit sur une zone de texte slectionn appele le 
:link reftype=hd res=IDM_TEXTMENU.Menu Texte slectionn:elink.. Il y a aussi un 
:link reftype=hd res=IDM_BITMAPMENU.Menu Graphique:elink. et un 
:link reftype=hd res=IDM_BORDERMENU.Menu Bordure de graphique:elink..

:h2 res=IDM_MAIN_CONTEXT.Menu contextuel gnral
:p.Ce menu apparat quand vous cliquez le bouton droit de la souris sur
l&apos.espace de travail du programme (hors d&apos.une fentre de
document). Il propose les actions disponibles  l&apos.extrieur
d&apos.un document,  savoir&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_REFRESH.Rgnration:elink.
:li.&sqbul.:link reftype=hd res=IDM_FILE_MENU.Fichier:elink.
:li.&sqbul.:link reftype=hd res=IDM_WINDOW_MENU.Fentres:elink.
:li.&sqbul.:link reftype=hd res=IDM_HELP_MENU.Aide:elink.
:esl.
:note.Le sous-menu Fichier de ce menu ne contient pas toutes les options
du menu Fichier normal, mais uniquement celles qui ne sont pas relatives
 un document. Ces exceptions sont notes dans les descriptions
dtailles de chaque option de menu. De plus, si aucune fentre de
document n&apos.est ouverte, le sous-menu Fentres sera dsactiv.

:h3 res=IDM_REFRESH.R-afficher (Option de menu)
:p.Cette option de menu provoque le r-affichage de la fentre du
document.

:h2 res=IDM_DEFAULTMENU.Menu standard
:p.Ce menu apparat quand vous cliquez le bouton droit de la souris sur
une zone du document qui n&apos.est ni (1) un texte slectionn, (2) un
graphique, ou (3) le bord d&apos.un graphique. Il prsente les commandes
qui peuvent tre appliques au document dans son intgralit. Ces
commandes sont les suivantes&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_REFRESH.Refresh:elink.
:esl.

:h2 res=IDM_TEXTMENU.Menu texte
:p.Ce menu apparat quand vous pressez le bouton droit de la souris sur
une zone de texte slectionne. Il prsente les commandes qui peuvent
tre appliques  une portion de texte slectionne,  savoir&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_CUT.Couper:elink.
:li.&sqbul.:link reftype=hd res=IDM_COPY.Copier:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE.Coller:elink.
:li.&sqbul.:link reftype=hd res=IDM_CLEAR.Effacer:elink.
:li.&sqbul.:link reftype=hd res=IDM_LAYOUT_MENU.Disposition:elink.
:li.&sqbul.:link reftype=hd res=IDM_FONT_MENU.Police:elink.
:li.&sqbul.:link reftype=hd res=IDM_SIZE_MENU.Taille:elink.
:li.&sqbul.:link reftype=hd res=IDM_ATTR_MENU.Attributs:elink.
:esl.
:note.Le sous-menu :hp2.Disposition:ehp2. de ce menu ne contient pas
toutes les options du menu :hp2.Disposition:ehp2. normal, mais
uniquement celles qui peuvent tre appliques  un bloc de texte
slectionn. Ces diffrences sont notes dans la description dtaille
de chaque option de menu.

:h2 res=IDM_BITMAPMENU.Menu graphique
:p.Ce menu apparat quand vous pressez le bouton droit de la souris sur un
objet graphique. Il prsente les commandes qui peuvent tre appliques 
un tel objet. Les commandes sont les suivantes&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_BACKGROUND.Arrire-plan:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_NOTEXTASIDE.Pas d&apos.habillage:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_HALFTONE.Demi-teinte:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_REVERSE.Reverse:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_OPTIMIZE.Optimiser:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION.Position:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_SIZE.Taille:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_ASPECT.Aspect:elink.
:esl.

:h3 res=IDM_BITMAP_BACKGROUND.Arrire-plan (Option de menu)
:p.Quand cette option de menu est slectionne, le graphique est marqu
comme tant  l&apos.arrire-plan de la page. Le texte peut figurer
par dessus le graphique.

:h3 res=IDM_BITMAP_NOTEXTASIDE.Pas d&apos.habillage (Option de menu)
:p.Quand vous slectionnez cette option de menu, le graphique est marqu de
faon qu&apos.aucun texte ne l&apos.habille  gauche ou  droite.

:h3 res=IDM_BITMAP_HALFTONE.Demi-teinte (Option de menu)
:p.Quand vous slectionnez cette option de menu, le graphique est affich en
demi-teintes, ce qui est particulirement pratique pour les graphiques
utiliss en arrire-plan.

:h3 res=IDM_BITMAP_REVERSE.Inverse (Option de menu)
Quand cette option est coche, l&apos.image est affiche en couleurs
inverses.
:note.Cette option ne fonctionne qu&apos.avec les graphiques en mode point
(pas avec les mtafichiers).

:h3 res=IDM_BITMAP_OPTIMIZE.Optimiser (Option de menu)
:p.Quand cette option de menu est slectionne, l&apos.image est optimise pour
l&apos.imprimante utilise; c&apos.est  dire que la mise  l&apos.chelle sera faite
de telle sorte que la taille de l&apos.image sur l&apos.imprimante sera un
multiple entier de la taille du bitmap d&apos.origine. Cela permet
d&apos.obtenir la meilleure apparence possible sur l&apos.imprimante.
:note.Cette option ne fonctionne qu&apos.avec les graphiques bitmap
(pas les mtafichiers).

:h3 res=IDM_BITMAP_POSITION.Menu Position du graphique
:p.Ce menu donne accs aux options qui influent sur la position d&apos.un
graphique dans une page du document. Les options suivantes sont
disponibles&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_NEXT_CHAR.Next Character:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_NEXT_LINE.Next Line:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_EDGE_LEFT.Bord gauche:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_MARGIN_LEFT.Marge gauche:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_CENTERED_X.Centr horizontalement:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_MARGIN_RIGHT.Marge droite:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_EDGE_RIGHT.Bord droit:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_EDGE_TOP.Bord suprieur:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_MARGIN_TOP.Marge du haut:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_CENTERED_Y.Centr verticalement:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_MARGIN_BOTTOM.Marge du bas:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_EDGE_BOTTOM.Bord infrieur:elink.
:esl.
Les options actives pour le graphique slectionn sont coches.

:h4 res=IDM_BITMAP_POSITION_NEXT_CHAR.Positionner le graphique caractre suivant (Option de menu)
Quand cette option est slecte, le graphique est considr comme un
gros caractre insr dans le texte du document. Le graphique sera
affich  l&apos.endroit o il a t insr dans le document, en adaptant le
texte autour de lui.

:h4 res=IDM_BITMAP_POSITION_NEXT_LINE.Positionner le graphique ligne suivante (Option de menu)
Fonction non implmente.

:h4 res=IDM_BITMAP_POSITION_EDGE_LEFT.Bord gauche (Option de menu)
:p.Quand cette option est coche, le graphique est positionn par rapport
au bord gauche de la page, en fonction de la taille et des limites du
support. Si un nouveau support est choisi, la position du graphique
sera adapte au nouveau support.

:h4 res=IDM_BITMAP_POSITION_MARGIN_LEFT.Marge gauche (Option de menu)
:p.Quand cette option est coche, le graphique est positionn par rapport 
la marge gauche de la page. En cas de modification de la marge, la
position du graphique sera adapte.

:h4 res=IDM_BITMAP_POSITION_CENTERED_X.Centr horizontalement (Option de menu)
:p.Quand cette option est coche, le graphique est centr horizontalement,
normalement par rapport aux marges du document. Si l&apos.option de taille du
graphique slectionne est :link reftype=hd res=IDM_BITMAP_SIZE_EDGETOEDGE_X.Bord--bord horizontalement:elink., 
le centrage sera effectu par rapport aux limites d&apos.impression du support.

:h4 res=IDM_BITMAP_POSITION_MARGIN_RIGHT.Marge droite (Option de menu)
:p.Quand cette option est coche, le graphique est positionn par rapport 
la marge droite de la page. En cas de modification de la marge, la
position du graphique sera adapte.

:h4 res=IDM_BITMAP_POSITION_EDGE_RIGHT.Bord droit (Option de menu)
:p.Quand cette option est coche, le graphique est positionn par rapport
au bord droit de la page, en fonction de la taille et des limites du
support. Si un nouveau support est choisi, la position du graphique
sera adapte au nouveau support.

:h4 res=IDM_BITMAP_POSITION_EDGE_TOP.Bord suprieur (Option de menu)
:p.Quand cette option est coche, le graphique est positionn par rapport
au bord suprieur de la page, en fonction de la taille et des limites du
support. Si un nouveau support est choisi, la position du graphique
sera adapte au nouveau support.

:h4 res=IDM_BITMAP_POSITION_MARGIN_TOP.Marge du haut (Option de menu)
:p.Quand cette option est coche, le graphique est positionn par rapport 
la marge du haut de la page. En cas de modification de la marge, la
position du graphique sera adapte.

:h4 res=IDM_BITMAP_POSITION_CENTERED_Y.Centr verticalement (Option de menu)
:p.Quand cette option est coche, le graphique est centr verticalement,
normalement par rapport aux marges du document. Si l&apos.option de taille du
graphique slectionne est :link reftype=hd res=IDM_BITMAP_SIZE_EDGETOEDGE_X.Bord--bord verticalement:elink., 
le centrage sera effectu par rapport aux limites d&apos.impression du support.

:h4 res=IDM_BITMAP_POSITION_MARGIN_BOTTOM.Marge du bas (Option de menu)
:p.Quand cette option est coche, le graphique est positionn par rapport 
la marge du base de la page. En cas de modification de la marge, la
position du graphique sera adapte.

:h4 res=IDM_BITMAP_POSITION_EDGE_BOTTOM.Bord infrieur (Option de menu)
:p.Quand cette option est coche, le graphique est positionn par rapport
au bord infrieur de la page, en fonction de la taille et des limites du
support. Si un nouveau support est choisi, la position du graphique
sera adapte au nouveau support.

:h3 res=IDM_BITMAP_SIZE.Menu Taille du graphique
:p.Ce sous-menu permet de dfinir la taille du graphique sur la page du
document. Les options disponibles sont&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_SIZE_EDGETOEDGE_X.Bord--bord horizontalement:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_SIZE_MARGINTOMARGIN_X.Marge--marge horizontalement:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_SIZE_EDGETOEDGE_Y.Bord--bord verticalement:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_SIZE_MARGINTOMARGIN_Y.Marge--marge verticalement:elink.
:esl.
La ou les options actives pour le graphique slectionn sont coches.

:h4 res=IDM_BITMAP_SIZE_EDGETOEDGE_X.Bord--bord horizontalement (Option de menu)
:p.Le graphique est dimentionn de faon  occuper toute la largeur de la
page, d&apos.un bord  l&apos.autre. Si l&apos.option de conservation des proportions
est active (voir le :link reftype=hd res=IDM_BITMAP_ASPECT.Menu Apparence du graphique:elink.), 
il est possible que le graphique soit moins large.

:h4 res=IDM_BITMAP_SIZE_MARGINTOMARGIN_X.Marge--marge horizontalement (Option de menu)
:p.Le graphique est dimentionn de faon  occuper toute la largeur de la
page, d&apos.une marge  l&apos.autre. Si l&apos.option de conservation des proportions
est active (voir le :link reftype=hd res=IDM_BITMAP_ASPECT.Menu Apparence du graphique:elink.), 
il est possible que le graphique soit moins large.

:h4 res=IDM_BITMAP_SIZE_EDGETOEDGE_Y.Bord--bord verticalement (Option de menu)
:p.Le graphique est dimentionn de faon  occuper toute la hauteur de la
page, d&apos.un bord  l&apos.autre. Si l&apos.option de conservation des proportions
est active (voir le :link reftype=hd res=IDM_BITMAP_ASPECT.Menu Apparence du graphique:elink.), 
il est possible que le graphique soit moins haut.

:h4 res=IDM_BITMAP_SIZE_MARGINTOMARGIN_Y.Marge--marge verticalement (Option de menu)
:p.Le graphique est dimentionn de faon  occuper toute la hauteur de la
page, d&apos.une marge  l&apos.autre. Si l&apos.option de conservation des proportions
est active (voir le :link reftype=hd res=IDM_BITMAP_ASPECT.Menu Apparence du graphique:elink.), 
il est possible que le graphique soit moins haut.

:h3 res=IDM_BITMAP_ASPECT.Menu Apparence du graphique
:p.Ce menu permet de dfinir si les proportions d&apos.un graphique doivent tre
conserves, et le cas chant selon quelle rgle. Les options
disponibles sont&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_ASPECT_FLOAT.Libre:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_ASPECT_FIX_X.Largeur fixe:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_ASPECT_FIX_Y.Hauteur fixe:elink.
:esl.
La ou les options actives pour le graphique slectionn sont coches.

:h4 res=IDM_BITMAP_ASPECT_FLOAT.Libre (Option de menu)
:p.Quand cette option est coche, les dimensions du graphiques ne sont pas
tenues de respecter les proportions d&apos.origine. L&apos.effet n&apos.est pas
immdiatement visible, sauf si une des options de taille
:hp1.Bord--bord:ehp1. ou :hp1.Marge--marge:ehp1. est active, ce qui
peut entraner un changement de la taille du graphique.

:h4 res=IDM_BITMAP_ASPECT_FIX_X.Largeur fixe (Option de menu)
:p.Quand cette option est coche, le graphique conserve toujours ses
proportions d&apos.origine. Si sa largeur est modifie par l&apos.utilisateur, le
programme adaptera la hauteur de faon  conserver le rapport
hauteur/largeur d&apos.origine.

:h4 res=IDM_BITMAP_ASPECT_FIX_Y.Hauteur fixe (Option de menu)
:p.Quand cette option est coche, le graphique conserve toujours ses
proportions d&apos.origine. Si sa heuteur est modifie par l&apos.utilisateur, le
programme adaptera la largeur de faon  conserver le rapport
hauteur/largeur d&apos.origine.

:h2 res=IDM_BORDERMENU.Menu bordure de graphique
:p.Ce menu est appel en pressant le bouton droit de la souris sur la
bordure d&apos.un objet graphique. Il prsente les commandes qui peuvent
tre appliques  cet objet, qui sont&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_BORDER_SIZE.Taille bordure:elink.
:li.&sqbul.:link reftype=hd res=IDM_BORDER_COLOR.Couleur bordure:elink.
:li.&sqbul.:link reftype=hd res=IDM_BORDER_CAPTION.Titre bordure:elink.
:esl.

:h3 res=IDM_BORDER_SIZE.Taille bordure (Option de menu)
:p.Cette fonction n&apos.est pas encore disponible.

:h3 res=IDM_BORDER_COLOR.Couleur bordure (Option de menu)
:p.Cette fonction n&apos.est pas encore disponible.

:h3 res=IDM_BORDER_CAPTION.Titre bordure (Option de menu)
:p.Cette fonction n&apos.est pas encore disponible.

:h1 res=60010.Botes de dialogues diverses

:h2 res=IDD_PROFILE_PATH.Rpertoire configuration
:p.Cette bote de dialogue apparat quand le programme ne parvient pas 
retrouver son fichier de configuration (.INI), et vous demande le nom du
rpertoire dans lequel se trouve ou doit tre cr le fichier.
:artwork name='Francais\Profile.bmp' align=center.
:p.Le nom de rpertoire saisi doit tre valide. Une fois le nom de
rpertoire saisi, pressez la touche :hp2.Entre:ehp2. ou slectionnez la
plaquette :hp2.Ok:ehp2. pour valider.
:p.Si vous voulez annuler la squence d&apos.initialisation du
programme, pressez la touche :hp2.chap:ehp2. ou slectionnez la plaquette
:hp2.Annuler:ehp2..

:h2 res=IDD_PROMPT_SAVE.Document modifi. Le sauvegarder ?
.* :artwork name='Francais\SaveChng.bmp' align=center.
:p.Vous tentez de quitter le programme ou de fermer une fentre de
document, alors que les modifications apportes au document actif n&apos.ont
pas t sauvegardes. Pressez la touche :hp2.O:ehp2. ou slectionnez la
plaquette :hp2.Oui:ehp2. si vous dsirez sauvegarder les modifications
dans le fichier. Pressez :hp2.N:ehp2. ou slectionnez la plaquette
:hp2.Non:ehp2. si vous ne dsirez pas sauvegarder le document (les
modifications seront perdues). Pressez la touche :hp2.chap:ehp2. ou
slectionnez la plaquette :hp2.Annuler:ehp2. si vous dsirez annuler la
fermeture du programme ou de la fentre de document.

:h2 res=IDD_PROMPT_SAVECONFIRM1.Confirmation
:p.Si cette bote de dialogue apparat, vous tentez d&apos.enregistrer votre
document sous un nouveau nom, correspondant  un fichier dj existant.
.* :artwork name='Francais\SaveConf.bmp' align=center.
:p.Si vous dsirez effectivement remplacer le fichier existant, pressez la
touche :hp2.O:ehp2. ou slectionnez la plaquette :hp2.Oui:ehp2.. Si vous ne
souhaitez pas craser le fichier existant, slectionnez la plaquette
:hp2.Non:ehp2. ou pressez la touche :hp2.Entre:ehp2.; dans ce cas, le
document ne sera pas sauvegard, et vous devrez effectuer la sauvegarde
en fournissant un nom diffrent.

:h2 res=IDD_PROMPT_SAVECONFIRM2.Confirmation du changement de type
:p.Cette bote de dialogue est affiche quand vous avez demand de
modifier le type d&apos.un fichier lors d&apos.une sauvegarde.
.* :artwork name='Francais\SaveCnf2.bmp' align=center.
:p.Pour changer le type du fichier, pressez la touche :hp2.O:ehp2. ou
slectionnez la plaquette :hp2.Oui:ehp2..
Si vous ne dsirez pas changer le type du fichier, pressez la touche
:hp2.Entre:ehp2. ou :hp2.N:ehp2.. Dans ce cas, le document ne sera
pas sauvegard, et vous devrez reprendre l&apos.opration.

:h2 res=IDD_MESSAGE_SPELLDONE.Contrle orthographique termin
:p.Cette bote de dialogue est affiche  la fin du contrle
orthographique du document.
.* :artwork name='Francais\SpelDone.bmp' align=center.
:p.Pour continuer, pressez la touche :hp2.Entre:ehp2. ou slectionnez la
plaquette :hp2.Ok:ehp2..

:h2 res=IDD_ERROR_HELPMANAGER.Erreur du gestionnaire d&apos.aide
:p.Si ce message apparat, il y a un problme dans le fichier d&apos.aide de
l&apos.application. Veuillez en informer le dveloppeur de l&apos.application.
(Voire le traducteur, Raphal Vanney; Fido 2&colon.320/222.7 | e-mail
rvanney@ibm.net)

:h2 res=IDD_ERROR_EXCEPTION.Arrt du programme/exception
.* :artwork name='Francais\Except.bmp' align=center.
:p.Cette bote de dialogue est affiche quand Escriba rencontre une erreur
fatale  son fonctionnement. Veuillez informer l&apos.auteur en utilisant
l&apos.un des moyens prsents dans la section 
:link reftype=hd res=60008.Questions et rapport d&apos.anomalies:elink., en incluant le fichier
:hp1.ESCRIBA.LOG:ehp1., qui doit tre prsent dans le rpertoire o
Escriba est install.

:h2 res=IDD_ERROR_WINREGISTERCLASS.Erreur d&apos.enregistrement de classe
:p.Si ce message d&apos.erreur a t affich, l&apos.application a t
incapable d&apos.enregistrer une de ses classes de fentres. Veuillez
informer l&apos.auteur en utilisant l&apos.un des moyens prsents dans
la section :link reftype=hd res=60008.Questions et rapport d&apos.anomalies:elink..

:h2 res=IDD_ERROR_CREATECLIENT.Erreur cration client
:p.Cette bote de dialogue est affiche quand Escrina est incapable de
crer une fentre cliente. Veuillez informer l&apos.auteur en utilisant
l&apos.un des moyens prsents dans la section 
:link reftype=hd res=60008.Questions et rapport d&apos.anomalies:elink..

:h2 res=IDD_ERROR_TOOMANYDOCUMENTS.Trop de documents ouverts
:p.Cette bote de dialogue est affiche si vous essayez d&apos.ouvrir trop
de documents.

:h2 res=IDD_ERROR_TOOMANYLOADED.Trop de documents chargs
:p.Cette bote de dialogue est affiche si vous avez charg trop de
documents.

:h2 res=IDD_ERROR_DOCUMENT_CREATE.Erreur cration de document
:p.Cette bote de dialogue est affiche si Escriba n&apos.est pas capable
de crer un objet document. Veuillez informer l&apos.auteur en utilisant
l&apos.un des moyens prsents dans la section 
:link reftype=hd res=60008.Questions et rapport d&apos.anomalies:elink..

:h2 res=IDD_ERROR_DOCUMENT_LOAD.Erreur de chargement de document
:p.Cette bote de dialogue est affiche si Escriba ne parvient pas 
charger un document. Veuillez vrifier le nom du fichier et les
rpertoires spcifis. Il est aussi possible que le fichier soit en
cours d&apos.utilisation par un autre programme, rendant impossible son
ouverture par Escriba.

:h2 res=IDD_ERROR_DOCUMENT_SAVE.Erreur sauvegarde document
:p.Cette bote de dialogue est affiche quand Escriba n&apos.a pas russi 
ouvrir le fichier dans lequel vous lui avez demand d&apos.enregistrer un
document. Veuillez vrifier la validit du nom de fichier, en
particulier l&apos.existance du rpertoire spcifi. Il est aussi
possible que le fichier soit ouvert par un autre programme, ce qui
empche sa r-criture par Escriba.

:h2 res=IDD_ERROR_CREATEPRINTSTATUS.Erreur cration fentre d&apos.tat impression
:p.Cette bote de dialogue est affiche si Escriba est incapable
d&apos.initialiser la fentre d&apos.tat d&apos.impression. Veuillez
informer l&apos.auteur en utilisant l&apos.un des moyens prsents dans
la section :link reftype=hd res=60008.Questions et rapport d&apos.anomalies:elink..

:h2 res=IDD_ERROR_CREATELOADSTATUS.Erreur cration fentre d&apos.tat chargement
:p.Cette bote de dialogue est affiche si Escriba est incapable
d&apos.initialiser la fentre d&apos.tat de chargement. Veuillez
informer l&apos.auteur en utilisant l&apos.un des moyens prsents dans
la section :link reftype=hd res=60008.Questions et rapport d&apos.anomalies:elink..

:h2 res=IDD_ERROR_BLOCKMEMORY.Mmoire insuffisante pour la copie
:p.Cette bote de dialogue signale un manque de mmoire pour couper ou
copier le texte slectionn dans le presse-papiers. Essayez
d&apos.effectuer la copie par petites portions.

:h2 res=IDD_ERROR_BADGRAPHICFILE.Fichier graphique non reconnu
:p.Cette bote de dialogue est affiche quand vous essayez de charger un
fichier graphique dont le format n&apos.est pas reconnu, ou qui contient
des donnes errones. Les formats graphiques actuellement reconnus sont
les suivants : BMP, GIF, JPG, PCX, PCC, MET et TIF. Si le fichier que
vous essayez de charger est d&apos.un de ces types, et si vous pouvez le
visualiser  l&apos.aide d&apos.un programme de visualisation
d&apos.images, veuillez informer l&apos.auteur en utilisant l&apos.un
des moyens prsents dans la section 
:link reftype=hd res=60008.Questions et rapport d&apos.anomalies:elink..

:h2 res=IDD_ERROR_VERIFY1.Erreur vrification - Ouvrir
:p.Cette erreur signifie que le fichier que vous avez essay
d&apos.ouvrir n&apos.a pas pu l&apos.tre pour une raison indtermine.
Vrifiez le nom et le chemin, puis ressayez.

:h2 res=IDD_ERROR_VERIFY2.Erreur vrification - Mmoire
:p.Cette erreur se produit quand Escriba n&apos.a pas pu obtenir
suffisemment de mmoire pour charger le fichier spcifi.

:h2 res=IDD_ERROR_VERIFY3.Erreur vrification - Code incorrect
:p.Cette erreur se produit si le fichier que vous tentez de charger, au
format Escriba, contient des codes d&apos.chappement incorrects.
Le fichier peut tre corrompu.

:h2 res=IDD_ERROR_VERIFY4.Erreur vrification - Fonction incorrecte
:p.Cette erreur se produit si le fichier que vous tentez de charger, au
format Escriba, contient des codes de fonction incorrects.
Le fichier peut tre corrompu, ou bien avoir t cr avec une version
plus rcente d&apos.Escriba.

:h2 res=IDD_ERROR_VERIFY5.Erreur vrification - Nulls
:p.Cette erreur se produit si le fichier que vous tentez de charger, au
format Escriba, contient des caractres nuls.
Le fichier peut tre corrompu.

:h2 res=IDD_ERROR_VERIFY6.Erreur vrification - En-ttes/fin non balancs
:p.Cette erreur se produit si le fichier que vous tentez de charger, au
format Escriba, ne contient pas les octets de fin correspondant  chaque
en-tte de fonction.
Le fichier peut tre corrompu.

:h2 res=IDD_ERROR_VERIFY7.Erreur vrification - Pas de prface
:p.Cette erreur se produit si le fichier que vous tentez de charger, au
format Escriba, ne commence pas par une fonction Preface.
Le fichier peut tre corrompu.

:h2 res=IDD_ERROR_VERIFY8.Erreur vrification - Aucun type valide
:p.Cette erreur se produit si le type du fichier que vous essayez de
charger n&apos.est pas reconnu. Escriba est incapable de charger un tel
fichier.
:note.De nouveaux modules de traitement des fichiers sont dvelopps en
permanence. Si vous n&apos.arrivez pas  charger un fichier dont vous avez
besoin, prenez contact avec l&apos.auteur  l&apos.une des adresses donnes dans
la rubrique :link reftype=hd res=60008.Questions et rapports d&apos.anomalies:elink..

:h2 res=IDD_ERROR_IMPORT1.Erreur d&apos.importation - Ouverture
:p.Cette erreur se produit si Escriba ne parvient pas  ouvrir le fichier
que vous dsirez charger. Vrifiez le nom et le chemin, puis essayez 
nouveau.

:h2 res=IDD_ERROR_IMPORT2.Erreur d&apos.importation - Mmoire
:p.Cette erreur indique qu&apos.Escriba n&apos.a pas pu obtenir suffisemment de
mmoire pour charger le fichier spcifi en mmoire.

:h2 res=IDD_ERROR_EXPORT1.Erreur d&apos.exportation - Ouverture/cration
:p.Cette erreur indique qu&apos.Escriba n&apos.est pas parvenu  ouvrir le fichier 
sauvegarder. Vrifiez  nouveau le chemin et le nom de fichier. Si le
fichier existe dj, il est possible qu&apos.il ne soit accessible qu&apos.en
lecture.

:h2 res=IDD_ERROR_EXPORT2.Erreur d&apos.exportation - Espace disque
:p.Cette erreur est affiche quand Escriba ne parvient pas  crire
un fichier sur disque.
Vrifiez qu&apos.il reste suffisemment d&apos.espace libre sur le disque.

:h2 res=IDD_METAFILE_VERIFY1.Erreur, vrification de mtafichier - Ouverture
Ce message d&apos.erreur signifie que le mtafichier choisi n&apos.a pas pu tre
ouvert. En gnral, cette erreur rsulte du fait qu&apos.une application est
entrain d&apos.crire sur ce fichier.

:h2 res=IDD_METAFILE_VERIFY2.Erreur, vrification de mtafichier - Fichier trop petit
Le mtafichier choisi est trop petit.

:h2 res=IDD_METAFILE_VERIFY3.Erreur, vrification de mtafichier - Chargement
Cette erreur signifie qu&apos.il est impossible de charger le fichier en
mmoire pour vrification. Si cette erreur se reproduit, veuillez
contacter l&apos.auteur  l&apos.une des adresses mentionnes sur la page
:link reftype=hd res=60008.Questions et rapports d&apos.anomalies:elink..

:h2 res=IDD_METAFILE_VERIFY4.Erreur, vrification de mtafichier - Donnes incorrectes
Cette erreur est affiche quand l&apos.en-tte du mtafichier contient des
donnes incorrectes. Vrifiez que le mtafichier peut tre affich ou
charg par le programme PICVIEW (:hp1.Affichage d&apos.images:ehp1., dans le
dossier :hp1.Production:ehp1.). Si c&apos.est le cas, veuillez contacter
l&apos.auteur  l&apos.une des adresses mentionnes sur la page 
:link reftype=hd res=60008.Questions et rapports d&apos.anomalies:elink..

:h2 res=IDD_ERROR_LOADLANGUAGE.Erreur de choix de langue
Cette erreur se produit quand les fichiers de la langue choisie n&apos.ont pu
tre compltement chargs. Veuillez contacter l&apos.auteur  l&apos.une des
adresses mentionnes sur la page 
:link reftype=hd res=60008.Questions et rapports d&apos.anomalies:elink..

:h1 res=61000.Documentation technique

:h2 res=61001.Format des fichiers documents
:p.Un fichier document peut tre considr comme un flux de caractres et
de codes de fonctions.  l&apos.exception des codes de contrle 15, 16
et 17, les caractres du texte sont stocks sans modification. Les codes
15, 16 et 17 sont remplacs par une squence d&apos.chappement, 15
tant le code d&apos.chappement : si le texte contient un code ASCII
16, le fichier de donnes contient un code ASCII 15 suivi d&apos.un code
ASCII 16 pour reprsenter le code 16 d&apos.origine. Si un code 15 est
rencontr sans tre suivi d&apos.un code 15, 16 ou 17, il est interprt
comme un code 15 littral.
:p.
Un code littral 17 &odqf.&larrow.&cdqf. dfinit le dbut d&apos.un code fonction.
Un code littral 16 &odqf.&rarrow.&cdqf. dfinit la fin d&apos.un code fonction.
Si un terminateur de code fonction est trouv sans tre prcd d&apos.un
dbut de code fonction, il est trait comme un caractre littral.
:p.
Les codes fonctions suivants sont actuellement utiliss&colon.

:lm margin=3.:p.&larrow.Version&colon.:hp5.versionnumber:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit la version de Escriba qui a t utilise
pour diter et enregistrer le document sur disque. Le numro de version
est compos de quatre chiffres, qui sont traits comme s&apos.il y avait une
virgule entre les deux premiers et les deux derniers. La version 1.00
serait reprsente par le nombre 0100. Ce code de fonction est destin 
permettre la conversion de documents d&apos.un format ancien vers un format
rcent, et n&apos.existait pas dans les fichiers crs par les version
antrieures  la beta 0.92. Ce code de fonction ne peut tre utilis
ailleurs que dans les paramtres du code fonction &odqf.Preface&cdqf..

:lm margin=3.:p.&larrow.Preface&colon.:hp5.codesfonctions:ehp5.&rarrow.
:lm margin=5.:p.
Ceci est un code de fonction spcial qui apparat dans le document
sauvegard mais n&apos.est pas visible  l&apos.cran. Les paramtres de cette
fonction sont d&apos.autres codes fonctions. L&apos.effet combin de tous les
codes de fonctions est de dfinir l&apos.tat par dfaut du document. Tous
les codes fonctions qui modifient l&apos.tat du document peuvent tre
utiliss, en sus des fonctions Printer, Form, JobSettings, TabSpacing et
Metric, qui ne peuvent pas tre utilises ailleurs. Les codes fonctions
qui gnrent du texte (PageCount, PageNumber, Graphic, Date) ne peuvent
tre utiliss ici.

:lm margin=3.:p.&larrow.Printer&colon.:hp5.nom:ehp5.&rarrow.
:lm margin=5.:p.
Ce code fonction dfinit le nom de l&apos.imprimante pour laquelle le
document a t format. Ce code ne peut tre utilis ailleurs que
dans les paramtres du code fonction &odqf.Preface&cdqf..

:lm margin=3.:p.&larrow.Form&colon.:hp5.nom:ehp5.&rarrow.
:lm margin=5.:p.
Ce code fonction dfinit le nom du support d&apos.impression pour lequel
le document a t format. Il n&apos.est utilis que quand un document conu
pour une imprimante donne est reformatt pour une autre. Ce code ne
peut tre utilis ailleurs que dans les paramtres du code fonction
&odqf.Preface&cdqf..

:lm margin=3.:p.&larrow.CodePage&colon.:hp5.nombre:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction est utilis pour indiquer le numro de la page de
codes  utiliser pour afficher le document. Ce code ne peut tre utilis
ailleurs que dans les paramtres du code fonction &odqf.Preface&cdqf..
Voir :link reftype=hd res=61002.Pages de codes:elink. pour plus d&apos.informations.

:lm margin=3.:p.&larrow.Font&colon.:hp5.nom:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit le nom de la police  utiliser pour la suite
du document. Ce nom doit tre celui d&apos.une police vectorielle
disponible dans la Palette de Polices du systme, ou dans le menu
Polices d&apos.Escriba.

:lm margin=3.:p.&larrow.Size&colon.:hp5.corps:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit, en points, le corps de la police  utiliser
pour la suite du document. Un point reprsente 1/72 de pouce anglais. Un
corps (une hauteur) de 12 points correspond normalement  des caractres
hauts de 1/6 pouce ; cette correspondance est une rgle de conduite qui
n&apos.est pas ncessairement adopte par les concepteurs de polices de
caractres. Diffrentes polices n&apos.ont pas forcment la mme taille
quand elles sont imprime dans le mme corps. Escriba accepte les
tailles de corps donnes avec une rsolution de 1/10 de point.

:lm margin=3.:p.&larrow.Color&colon.:hp5.couleur:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit la couleur (rouge-vert-bleu)  utiliser pour
les traits et le texte dans la suite du document. La couleur est
exprime sous la forme d&apos.un nombre hexadcimal de six chiffres, les
deux premiers reprsentant la composante rouge, la paire suivante le
vert et la dernire paire le bleu. Le blanc, par exemple, serait
&odqf.FFFFFF&cdqf., le noir &odqf.000000&cdqf., et le jaune &odqf.FFFF00&cdqf..

:lm margin=3.:p.&larrow.LineWidth&colon.:hp5.width:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit l&apos.paisseur du trait utilis pour
dessiner le contour des caractres, quand l&apos.attribut contour est
dfini. Cette paisseur est exprime dans la mme unit que toutes les
autres dimensions.

:lm margin=3.:p.&larrow.LineEnd&colon.:hp5.type:ehp5.&rarrow.
:lm margin=5.:p.
Ce code dtermine le type de fin de ligne  utiliser au del de la
position actuelle.
Les types valides incluent tous les codes :hp2.LINEEND:ehp2. dfinis
dans l&apos.&odqf.OS/2 Programmer&apos.s Reference&cdqf..

:lm margin=3.:p.&larrow.LineJoin&colon.:hp5.type:ehp5.&rarrow.
:lm margin=5.:p.
Ce code dtermine le type de jointure  utiliser au del de la
position actuelle.
Les types valides incluent tous les codes :hp2.LINEJOIN:ehp2. dfinis
dans l&apos.&odqf.OS/2 Programmer&apos.s Reference&cdqf..

:lm margin=3.:p.&larrow.FillColor&colon.:hp5.couleur:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit la couleur (rouge-vert-bleu)  utiliser pour
le remplissage des caractres possdant l&apos.attribut contour dans la
suite du document. La couleur est exprime de la mme faon que pour le
code de fonction :hp2.Color:ehp2. (voir plus haut).

:lm margin=3.:p.&larrow.FillType&colon.:hp5.type:ehp5.&rarrow.
:lm margin=5.:p.
Ce code dtermine le motif utilis pour remplir le texte possdant
l&apos.attribut :hp1.Contour:ehp1.  utiliser au del de la position
actuelle.
Les types valides incluent tous les codes :hp2.PATSYM:ehp2. dfinis
dans l&apos.&odqf.OS/2 Programmer&apos.s Reference&cdqf..

:lm margin=3.:p.&larrow.Bold&colon.:hp5.1/0:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction active ou dsactive l&apos.attribut :hp1.gras:ehp1. 
partir de la position actuelle.

:lm margin=3.:p.&larrow.Italic&colon.:hp5.1/0:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction active ou dsactive l&apos.attribut :hp1.italique:ehp1. 
partir de la position actuelle.

:lm margin=3.:p.&larrow.Underscore&colon.:hp5.1/0:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction active ou dsactive l&apos.attribut :hp1.soulign:ehp1. 
partir de la position actuelle.

:lm margin=3.:p.&larrow.Strikeout&colon.:hp5.1/0:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction active ou dsactive l&apos.attribut :hp1.biff:ehp1. 
partir de la position actuelle.

:lm margin=3.:p.&larrow.Outline&colon.:hp5.1/0:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction active ou dsactive l&apos.attribut :hp1.contour:ehp1. 
partir de la position actuelle.

:lm margin=3.:p.&larrow.Caps&colon.:hp5.1/0:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction active ou dsactive l&apos.attribut :hp1.majuscules:ehp1.
 partir de la position actuelle.

:lm margin=3.:p.&larrow.Expand&colon.:hp5.pourcentage:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit la largeur de texte  appliquer  partir de
la position actuelle. Ce facteur est exprim sous forme de pourcentage,
100 reprsentant la taille normale des caractres.

:lm margin=3.:p.&larrow.TopMargin&colon.:hp5.distance:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit la position courante de la marge du haut,
relativement au bas de la page. Cet attribut ne prend son effet qu&apos.
la page suivante, sauf si la page en cours ne contient encore aucun
lment imprimable.

:lm margin=3.:p.&larrow.BottomMargin&colon.:hp5.distance:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit la position courante de la marge du bas,
relativement au bas de la page. Cet attribut ne prend son effet qu&apos.
la page suivante, sauf si la page en cours ne contient encore aucun
lment imprimable.

:lm margin=3.:p.&larrow.LeftMargin&colon.:hp5.distance:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit la position courante de la marge gauche,
relativement au ct gauche de la page. Cet attribut ne prend son effet
qu&apos. la ligne suivante, sauf si la ligne en cours ne contient encore
aucun lment imprimable.

:lm margin=3.:p.&larrow.RightMargin&colon.:hp5.distance:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit la position courante de la marge de droite,
relativement au ct gauche de la page. Cet attribut ne prend son effet
qu&apos. la ligne suivante, sauf si la ligne en cours ne contient encore
aucun lment imprimable.

:lm margin=3.:p.&larrow.LeftJustify&rarrow.
:lm margin=5.:p.
Ce code de fonction active la justification horizontale  gauche&colon.
le texte sera align contre la marge gauche. Cet attribut ne prend son
effet qu&apos. la ligne suivante, sauf si la ligne en cours ne contient
encore aucun lment imprimable.

:lm margin=3.:p.&larrow.CenterJustify&rarrow.
:lm margin=5.:p.
Ce code de fonction active la justification horizontale centre&colon.
le texte sera centr entre les marges gauche et droite. Cet attribut ne
prend son effet qu&apos. la ligne suivante, sauf si la ligne en cours ne
contient encore aucun lment imprimable.

:lm margin=3.:p.&larrow.RightJustify&rarrow.
:lm margin=5.:p.
Ce code de fonction active la justification horizontale  droite&colon.
le texte sera align contre la marge droite. Cet attribut ne prend son
effet qu&apos. la ligne suivante, sauf si la ligne en cours ne contient
encore aucun lment imprimable.

:lm margin=3.:p.&larrow.FullJustify&rarrow.
:lm margin=5.:p.
Ce code de fonction active la justification horizontale  droite et 
gauche&colon. le texte sera complt pour tre align  la fois sur les
marges droite et gauche. Les lignes de fin de paragraphe ou les lignes
isoles sont alignes  gauche. Cet attribut ne prend son effet qu&apos. la
ligne suivante, sauf si la ligne en cours ne contient encore aucun
lment imprimable.

:lm margin=3.:p.&larrow.CenterPage&colon.:hp5.1/0:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit l&apos.tat de l&apos.attribut :hp1.centrage
vertical:ehp1. de la page. Quand il est actif au dbut d&apos.une page, cette
page est centre verticalement.

:lm margin=3.:p.&larrow.TabSet&colon.:hp5.distance:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction ajoute un taquet de tabulation  la position
spcifie, dans la table de tabulation.

:lm margin=3.:p.&larrow.TabClear&colon.:hp5.distance:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction supprime le taquet de tabulation prsent  la
position spcifie.

:lm margin=3.:p.&larrow.TabSpacing&colon.:hp5.distance:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit la distance  utiliser entre deux taquets de
tabulation au dbut du document.  partir de la marge gauche, des
taquets de tabulation sont crs automatiquement  l&apos.intervalle
dfini ici. Ce code de fonction ne peut tre utilis ailleurs que dans
les paramtres du code fonction &odqf.Preface&cdqf..

:lm margin=3.:p.&larrow.Indent&colon.:hp5.distance:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit la distance d&apos.indentation des lignes de
dbut de paragraphe. Les lignes de dbut de paragraphe sont (1) la
premire ligne du document et (2) la premire ligne de texte aprs un
caractre de fin de paragraphe.

:lm margin=3.:p.&larrow.Metric&colon.:hp5.1/0:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit l&apos.unit de mesure utilise dans le document.
Si le paramtre est &odqf.1&cdqf., l&apos.unit de mesure est le centimtre ; dans le
cas contraire, l&apos.unit est le pouce.
Ce code de fonction ne peut tre utilis ailleurs que dans les paramtres du code fonction &odqf.Preface&cdqf..

:lm margin=3.:p.&larrow.Graphic&colon.:hp5.x,y,cx,cy[,Background][,NoTextAside][,Halftone][,Reverse][,PrinterOptimize][[,KeepAspectFixX|KeepAspectFixY]]&colon.type&bsl.0data:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit une zone de graphique dans le document. 
:p.Les coordonnes :hp2.x:ehp2. et :hp2.y:ehp2. dfinissent la position de la
zone sur la page,  partir de l&apos.angle infrieur gauche de la page (et
non du coin suprieur gauche). Les paramtres :hp2.cx:ehp2. et
:hp2.cy:ehp2. dfinissent la largeur et la hauteur de la zone. Les
quatres paramtres sont donns dans l&apos.unit active (millime de pouce ou
de centimtre).
:p.Les coordonnes numriques peuvent tre remplaces par les mots-cls
:hp2.Inline:ehp2.,
:hp2.LeftMargin:ehp2.,
:hp2.RightMargin:ehp2.,
:hp2.LeftEdge:ehp2.,
:hp2.RightEdge:ehp2. ou
:hp2.Centered:ehp2. pour la position horizontale, et
:hp2.TopMargin:ehp2.,
:hp2.BottomMargin:ehp2.,
:hp2.TopEdge:ehp2.,
:hp2.BottomEdge:ehp2. ou
:hp2.Centered:ehp2. pour la position verticale. Les mots-cls
:hp2.EdgeToEdge:ehp2. ou
:hp2.MarginToMargin:ehp2. 
sont accepts pour les deux dimensions.
Si &apos.Inline&apos. est spcifi pour la position X, la position Y est
ignore. De mme, si &apos.EdgeToEdge&apos. ou
&apos.MarginToMargin&apos. est spcifi pour la taille X ou Y, la
position correspondante est ignore.

:p.Les paramtres :hp2.Background:ehp2., :hp2.NoTextAside:ehp2.,
:hp2.Halftone:ehp2. et :hp2.Reverse:ehp2. sont optionnels. Ils doivent, le cas chant,
figurer :hp2.exactement:ehp2. tels qu&apos.indiqu ici.
:p.Le paramtre :hp2.Background:ehp2. indique que le graphique ne doit
pas influer sur la position du texte sur la page, et doit apparatre
derrire le texte, en arrire-plan.
:p.Le paramtre :hp2.NoTextAside:ehp2. indique qu&apos.aucun texte ne doit
apparatre sur les cts du graphique; le graphique est trait comme
s&apos.il occupait toute la largeur de la page.
:p.Le paramtre :hp2.Halftone:ehp2., quand il est prsent, indique que
les couleurs du graphique doivent tre atnues. Cette opration est
effectue en ne dessinant qu&apos.un pixel sur deux, ce qui fait que le
paramtre n&apos.est pas valide dans le cas de mtafichiers graphiques.
:p.Le paramtre &apos.Reverse&apos. indique que le graphique doit tre
affich en couleurs inverses. Cette option ne peut pas tre gre pour
les mtafichiers graphiques.

:p.Le paramtre :hp2.PrinterOptimize:ehp2., quand il est prsent,
indique que le graphique doit tre optimis pour la rsolution de
l&apos.imprimante. Pour cela, l&apos.chelle choisie lors de l&apos.impression est un
nombre entier. Cette option ne s&apos.applique pas aux mtafichiers.

:p.Le paramtre :hp2.KeepAspectFixX:ehp2. indique que la hauteur du
graphique sera dtermine d&apos.aprs sa largeur, en conservant
l&apos.aspect du graphique original. Le paramtre :hp2.KeepAspectFixY:ehp2.
est similaire, sauf que c&apos.est la largeur qui sera dtermine d&apos.aprs la
hauteur.

:p.Le champ :hp2.Type:ehp2. dfinit le type du graphique, parmi
:hp2.BM:ehp2. (pour bitmap),
:hp2.MF:ehp2. (pour mtafichier),
:hp2.UP:ehp2. (pour code  barre UPC), 
:hp2.39:ehp2. (pour code  barre 39),
:hp2.PN:ehp2. (pour code  barre POSTNET) ou
:hp2.E8:ehp2. (pour code  barre EAN-8).
Tous les graphiques bitmaps (BMP, GIF, JPG, PCX, TIF...) sont stocks
dans le document sous forme de bitmap OS/2. Ce champ doit tre termin
par un zro (chane ASCIIZ).
:p.Les donnes du graphique sont places aprs le zro qui termine
l&apos.en-tte. Les codes 15, 16 et 17 prsents dans les donnes binaires du
graphiques sont cods comme dfini plus haut.
:p.Pour les bitmaps, les donnes contiennent tout d&apos.abord un nombre de
quatre octets indiquant la taille de l&apos.en-tte; ensuite vient un nombre
de quatre octets indiquant la taille des donnes du bitmap. Viennent
enfin l&apos.en-tte puis les donnes du bitmap.
:p.Pour les mtafichiers, les donnes binaires incluent un nombre de
quatre octets donnant la taille des donnes du mtafichier, puis le
mtafichier lui-mme.
:p.Pour les codes UPC, les donnes contiennent un texte de douze
chiffres reprsentant le code UPC.
:p.Pour les codes Code-39, les donnes peuvent tre de n&apos.importe quelle
longueur, les caractres valides tant&colon. les lettre de A  Z
(en majuscules), les chiffres de 0  9, l&apos.espace, et les signes
&dot.,
&plus.,
&dash.,
&asterisk.,
&slash.,
&dollar. et
&percent..
:p.Pour les codes  barres POSTNET, les donnes sont composes de cinq
ou neuf chiffres.
:p.Pour les codes  barres EAN-8, les donnes sont composes de sept
caractres numriques.

:lm margin=3.:p.&larrow.Date&colon.Fixed&colon.:hp5.time:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction gnre un texte reprsentant une date spcifique,
date exprime en secondes coules depuis le premier janvier 1970 
minuit. Le format de la date est dfini par la fonction &odqf.DateFormat&cdqf..

:lm margin=3.:p.&larrow.Date&colon.Current&rarrow.
:lm margin=5.:p.
Ce code de fonction gnre un texte reprsentant la date du jour
d&apos.aprs l&apos.horloge du systme. Le format de la date est dfini
par la fonction &odqf.DateFormat&cdqf..

:lm margin=3.:p.&larrow.Date&colon.Changed&rarrow.
:lm margin=5.:p.
Ce code de fonction gnre un texte reprsentant la date de la dernire
modification apporte au document. Le format de la date est dfini par
la fonction &odqf.DateFormat&cdqf..

:lm margin=3.:p.&larrow.DateFormat&colon.:hp5.chaneformat:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit le format de date qui sera utilis dans le
document  partir de la position courante. La syntaxe est similaire 
celle utilises dans l&apos.instruction :hp2.printf:ehp2. du langage
:hp2.C:ehp2.,  l&apos.exception des codes pouvant suivre le caractre
&odqf.&percent.&cdqf., qui sont&colon.

:lm margin=10.:sl compact.
:li.m - mois, sous forme numrique (1, 2, etc)
:li.M - mois, en clair (janvier, fvrier, etc)
:li.n - mois abrg (jan, fv, etc)
:li.d - jour du mois
:li.y - anne (sicle inclus)
:li.z - anne (2 chiffres, sans le sicle)
:li.w - jour de la semaine (dimanche, lundi, etc)
:li.x - jour de la semaine abrg (dim, lun, etc)
:esl.:lm margin=5.
:note.Ce format interne n&apos.est pas dpendant du langage, contrairement
aux codes fournis par l&apos.utilisateur.

:lm margin=3.:p.&larrow.LineSpacing&colon.:hp5.pourcentage:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit l&apos.interligne, en pourcentage de
l&apos.interligne normal,  utiliser pour la suite du document.

:lm margin=3.:p.&larrow.JobSettings&colon.:hp5.donnespilote:ehp5.&rarrow.
:lm margin=5.:p.
Le paramtre de ce code de fonction est la structure de donnes
retourne par la bote de dialogue de configuration de
l&apos.impression. La structure complte est fonction du pilote
d&apos.imprimante, et n&apos.est pas forcment documente par
l&apos.auteur du pilote d&apos.imprimante ; une partie de ces donnes,
appele en-tte, est dfinie et documente par IBM. Les donnes tant
sous forme binaire, les codes 15, 16 et 17 sont prcds d&apos.un code
d&apos.chappement. Ce code de fonction ne peut tre utilis ailleurs
que dans les paramtres du code fonction &odqf.Preface&cdqf..

:lm margin=3.:p.&larrow.PageNumber&rarrow.
:lm margin=5.:p.
Ce code de fonction gnre un texte reprsentant le numro de la page
dans laquelle se trouve le code.

:lm margin=3.:p.&larrow.PageCount&rarrow.
:lm margin=5.:p.
Ce code de fonction gnre un texte reprsentant le nombre de pages
dans le document.

:lm margin=3.:p.&larrow.Glyph&colon.:hp5.nombre:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction gnre un texte d&apos.un caractre correspondant au
paramtre numrique. Le caractre affich ou imprim dpend de la page
de codes et de la police en cours.
Ce code de fonction est cr quand l&apos.utilisateur utilise les touches
Alt+nnn pour entrer un caractre, et rsoud le problme de savoir si un
code de contrle doit tre trait comme tel ou affich.

:lm margin=3.:p.&larrow.Author&colon.:hp5.name:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fontion n&apos.apparat que dans la section :hp2.Preface:ehp2. et
permet de dfinir le nom de l&apos.auteur du document.

:lm margin=3.:p.&larrow.CreateDate&colon.:hp5.time:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fontion n&apos.apparat que dans la section :hp2.Preface:ehp2. et
permet d&apos.enregistrer la date de cration du document. Cette date est
enregistre sous la mme forme que les autres, c&apos.est  dire en nombre de
secondes coules depuis le 1er janvier 1970.

:lm margin=3.:p.&larrow.Comment&colon.:hp5.commentary:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction peut tre utilis pour inclure un commentaire dans
le corps du document. Le commentaire ne sera ni affich ni imprim.

:lm margin=3.:p.&larrow.Separateur&rarrow.
:lm margin=5.:p.
Ce code de fonction genre une fin de ligne, suivie par une ligne de
sparation, puis une autre fin de ligne. Cette fonction est similaire 
la fonction :hp2.<hr>:ehp2. du langage HTML.

:lm margin=3.:p.&larrow.Title&colon.:hp5.nom:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction n'apparat que dans la section Preface et dclare le
titre du document.

:lm margin=3.:p.&larrow.Header&colon.:hp5.texte:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit l'en-tte de page  utiliser  partir de ce
point. Si rien d'imprimable ne figure encore sur la page, l'en-tte est
aussi utilis pour la page courante.

:lm margin=3.:p.&larrow.Footer&colon.:hp5.texte:ehp5.&rarrow.
:lm margin=5.:p.
Ce code de fonction dfinit le pied de page  utiliser  partir de ce
point. Si rien d'imprimable ne figure encore sur la page, il est aussi
utilis pour la page courante.

:lm margin=1.

:note.Les distances sont exprimes en units de 0,001 pouce ou
centimtre, en fonction de l&apos.unit de mesure choisie. Une distance
de 0,5 centimtre ou pouce serait donc exprime 500.

:note.Les pourcentages sont exprims sous forme d&apos.entiers. Par
exemple, 100% est exprim par le nombre 100, 125% par le nombre 125,
etc...

:h2 res=61002.Pages de codes
:p.Les pages de codes (codification nationale des caractres) suivantes
sont valides&colon.

:table cols='4 60' rules=both frame=box.
:row.:c.037     :c.Brsilien / Portugais / Anglais Amricain (EBCDIC)
:row.:c.273     :c.Autrichien / Allemand (EBCDIC)
:row.:c.274     :c.Belge (EBCDIC ancien)
:row.:c.277     :c.Danois / Norvgien (EBCDIC)
:row.:c.278     :c.Finnois / Sudois (EBCDIC)
:row.:c.280     :c.Italien (EBCDIC)
:row.:c.282     :c.Portugais (EBCDIC ancien)
:row.:c.284     :c.Espagnol (EBCDIC)
:row.:c.285     :c.Anglais (EBCDIC)
:row.:c.297     :c.Franais (EBCDIC)
:row.:c.437     :c.tats-Unis (IBM PC)
:row.:c.500     :c.Belge / International (EBCDIC)
:row.:c.813     :c.Grec
:row.:c.819     :c.Multilingue (ISO-8859/1)
:row.:c.850     :c.Multilingue (Latin 1)
:row.:c.852     :c.Slave (Latin2)
:row.:c.855     :c.Serbie / Montenegro / Macdonie / Bulgarie
:row.:c.857     :c.Turc
:row.:c.860     :c.Portugais
:row.:c.861     :c.Islandais
:row.:c.862     :c.Hbreu
:row.:c.863     :c.Franais Canadien
:row.:c.864     :c.Arabe
:row.:c.865     :c.Danois / Norvgien
:row.:c.866     :c.Russie
:row.:c.869     :c.Grec
:row.:c.870     :c.Tchcoslovaque / Hongrois / Polonais / Yougoslave (EBCDIC)
:row.:c.871     :c.Islandais (EBCDIC)
:row.:c.874     :c.Tha
:row.:c.915     :c.Bulgarie / Macdoine
:row.:c.932     :c.Japonais (Shift JIS X-0208)
:row.:c.934     :c.Coren
:row.:c.936     :c.Chinois simplifi
:row.:c.938     :c.Chinois traditionnel
:row.:c.942     :c.Japonais (SAA)
:row.:c.944     :c.Coren (SAA)
:row.:c.946     :c.Chinois simplifi (SAA)
:row.:c.948     :c.Chinois traditionnel (SAA)
:row.:c.949     :c.Coren (Shift KSC 5601)
:row.:c.950     :c.Chinois traditionnel (Big5)
:row.:c.1004    :c.Publication
:row.:c.1026    :c.Turc (EBCDIC)
:row.:c.1200    :c.Unicode
:row.:c.1250    :c.Windows, Latin-2 (Europe de l&apos.Est)
:row.:c.1251    :c.Windows, Cyrillique
:row.:c.1252    :c.Windows, Multilingual (ANSI)
:row.:c.1253    :c.Windows, Grec
:row.:c.1254    :c.Windows, Turc
:row.:c.1255    :c.Windows, Hebreu
:row.:c.1256    :c.Windows, Arabe
:etable.

:note.Toutes les pages de codes ne sont pas disponibles sur tous les
systmes.

:h2 res=61003.Interface de modules d&apos.extension
:p.Le gestionnaire d&apos.extensions inventorie, au dmarrage d&apos.Escriba,
les bibliothques lies dynamiquement (DLL) prsentes dans le rpertoire
d&apos.installation. Les fonctions :hp2.Identify:ehp2.,
:hp2.ProductName:ehp2., :hp2.ProductVersion:ehp2.,
:hp2.ProductInformation:ehp2. et :hp2.ProductConfigure:ehp2. sont
recherches dans chaque DLL. Si toutes ces fonctions sont prsentes, la
bibliothque est suppose tre un module d&apos.extension pour Escriba.

:p.Les prototypes de fonctions pour le langage C sont&colon.

:font facename=Courier size=13x8.:lm margin=6.:sl compact.
:li.char* APIENTRY Identify ( void ) ;
:li.BOOL  APIENTRY SetLanguage ( char *Language ) ;
:li.char* APIENTRY ProductName ( void ) ;
:li.int   APIENTRY ProductVersion ( void ) ;
:li.void  APIENTRY ProductInformation ( HWND Owner ) ;
:li.int   APIENTRY ProductConfigure ( int MaxPages, char Names[][64], char MajorTabs[][32], char MinorTabs[][32], PFNWP Processors[], HMODULE Libraries[], int DialogIDs[] ) ;
:esl.:lm margin=1.:font facename=default.

:p.La fonction :hp2.Identify:ehp2. retourne une chane ASCIIZ
caractristique du type d&apos.extension. Les types suivants sont
actuellement dfinis&colon.
:link reftype=hd res=61004."ISPELLER":elink.
,
:link reftype=hd res=61005."IMPORT/EXPORT":elink.
and
:link reftype=hd res=61006."GRAPHICIMPORT":elink..

:p.La fonction :hp2.SetLanguage:ehp2. permet  Escriba de configurer
la langue utilise par le module. Le nom de la langue est pass en
paramtre. Par exemple, le paramtre  utiliser pour le franais
est :hp1.Fran&cc.ais:ehp1..

:p.La fonction :hp2.ProductName:ehp2. retourne une chane ASCIIZ
permettant d&apos.identifier l&apos.extension dans le menu :hp1.Infos
produit:ehp1.. Ce nom ne doit pas comporter de numro de version.

:p.La fonction :hp2.ProductVersion:ehp2. retourne un nombre entier
qui reprsente le numro de version multipli par 100. Ce nombre
est aussi utilis dans le menu :hp1.Infos produit:ehp1..

:p.La fonction :hp2.ProductInformation:ehp2. affiche une bote de dialogue
contenant le nom complet du module, le numro de version et la date,
ainsi que les informations concernant l&apos.auteur et les droits. Cette
fonction est appele quand l&apos.utilisateur choisit le module dans le
menu :hp1.Infos produit:ehp1..

:p.La fonction :hp2.ProductConfigure:ehp2. retourne les informations
ncessaires  la construction du dialogue :hp1.Configuration des
extensions:ehp1.. Cette fonction, si elle est prsente, doit retourner
le nombre de pages du bloc-notes de configuration dont a besoin le
module. Pour chaque page demande, la fonction doit retourner un numro
de page, un texte d&apos.onglet principal ou secondaire (l&apos.un ou l&apos.autre),
une fonction de traitement du dialogue, une poigne
(:hp1.handle:ehp1.) de bibliothque de ressources et un identificateur
de ressource pour le masque du dialogue.

:h3 res=61004.Interface ISpeller
:p.Le module :hp2.ISPELLER:ehp2. a t dvelopp  partir du programme GNU
ISPELL version 3.1.18, et est donc gratuit et disponible avec le code
source. Le copyright appartient  Pace Willisson et Geoff Kuenning.
ISPELLER n&apos.est qu&apos.un habillage d&apos.ISPELL, sous la forme d&apos.une
bibliothque OS/2 (DLL). ISPELLER ne peut pas utiliser une autre version
3.1.x de ISPELL ventuellement prsente sur votre systme, mais
:hp2.peut:ehp2. utiliser les fichiers dictionnaires. Pour cela, ajoutez
la commande :hp2.SET ISPELL=chamin:ehp2. dans votre fichier CONFIG.SYS,
:hp1.chemin:ehp1. tant le nom complet du rpertoire o se trouvent les
dictionnaires ISPELL. Les modules ISPELLER.DLL et BUILDHAS.EXE doivent
aussi tre copis dans ce rpertoire.

:p.En plus des fonctions de modules d&apos.extension dj dcrites, ISpeller
fournit les fonctions suivantes&colon.

:font facename=Courier size=13x8.:lm margin=6.:sl compact.
:li.void  APIENTRY Speller_SetHome ( char *Path ) ;
:li.char* APIENTRY Speller_DefaultDictionary ( void ) ;
:li.int   APIENTRY Speller_OpenDictionary ( char *Path ) ;
:li.void  APIENTRY Speller_CloseDictionary ( ) ;
:li.BOOL  APIENTRY Speller_Ready ( ) ;
:li.int   APIENTRY Speller_BuildWord ( char* (*APIENTRY GetPtr)(void *Object,long *Offset,long Delta), void *Object, char *Word, long *Start, long *End, long *Next ) ;
:li.int   APIENTRY Speller_FindWord ( char *Word ) ;
:li.int   APIENTRY Speller_FindReplacements ( char *Word, int ListSize, int EntrySize, void *List, int *EasyCount ) ;
:li.int   APIENTRY Speller_Accept ( char *Word ) ;
:li.int   APIENTRY Speller_Insert ( char *Word ) ;
:li.int   APIENTRY Speller_UnCaps ( char *Word ) ;
:esl.:lm margin=1.:font facename=default.

:p.Si vous dsirez savoir ce que font ces fonctions, et comment elles le
font, n&apos.hsitez pas  consulter le code source.

:h3 res=61005.Interface de module d&apos.import/export de document
:p.Les modules de type :hp2.IMPORT/EXPORT:ehp2. sont utiliss pour lire
et crire des fichiers dans des formats diffrent de celui utilis
par Escriba.

:p.En plus des fonctions de base des modules d&apos.extension, les modules
d&apos.import/export fournissent les fonctions suivantes&colon.
:font facename=Courier size=13x8.:lm margin=6.:sl compact.
:li.char* APIENTRY QueryFileType ( void ) ;
:li.char* APIENTRY QueryWildcard ( void ) ;
:li.BOOL  APIENTRY Filter ( char *Name, char *Type ) ;
:li.BOOL  APIENTRY Verify ( HWND Owner, char *Name ) ;
:li.void* APIENTRY Import ( HWND Owner, char *Name, long *Size ) ;
:li.BOOL  APIENTRY Export ( HWND Owner, char *Name, void *Text, long Size ) ;
:esl.:lm margin=1.:font facename=default.

:p.La fonction :hp2.QueryFileType:ehp2. retourne un type de fichier
(comme :hp1.Escriba:ehp1. ou :hp1.Texte brut:ehp1.) qui sera affich
dans la liste de types de fichiers du dialogue d&apos.ouverture de fichier.

:p.La fonction :hp2.QueryWildcard:ehp2. retourne une spcification de
fichier (comme :hp1.*.Txt:ehp1.) qui sera utilise dans le champ
:hp1.Nom de fichier:ehp1. du dialogue d&apos.ouverture de fichier quand le
type correspondant sera choisi.

:p.La fonction :hp2.Filter:ehp2. est appele lors du remplissage de la
liste de fichiers du dialogue d&apos.ouverture de fichier, et dtermine si un
nom de fichier doit tre ou non affich dans la liste. Il s&apos.agit d&apos.un
test rapide du nom et du type du fichier, pas d&apos.un test du contenu du
fichier.

:p.La fonction :hp2.Verify:ehp2. est utilise pour vrifier la nature
du contenu du fichier. Le test doit tre rapide, mais plus approfondi
que celui effectu par la fonction :hp2.Filter:ehp2..

:p.La fonction :hp2.Import:ehp2. charge un document en mmoire, le
convertit au format natif d&apos.Escriba, et retourne un pointeur sur le
texte. La fonction Import doit allouer dynamiquement la mmoire pour le
texte. Escriba librera cette mmoire quand elle ne sera plus
ncessaire.

:p.La fonction :hp2.Export:ehp2. sauvegarde un fichier document. Un
pointeur sur le texte au format Escriba est pass en paramtre, la
fonction Export se charge de le convertir et de l&apos.crire dans le
fichier spcifi.

:h3 res=61006.Interface de module d&apos.importation graphique
:p.Les modules de type :hp2.GRAPHICIMPORT:ehp2. sont utiliss pour
importer des images graphiques dans un document, en convertissant ces
images au format bitmap d&apos.OS/2.

:p.En plus des fonctions de base des modules d&apos.extension, les
modules d&apos.importation graphique fournissent les fonctions
suivantes&colon.

:font facename=Courier size=13x8.:lm margin=6.:sl compact.
:li.char*   APIENTRY QueryFileType ( void ) ;
:li.char*   APIENTRY QueryWildcard ( void ) ;
:li.BOOL    APIENTRY Filter ( char *Name, char *Type ) ;
:li.BOOL    APIENTRY Verify ( HWND Owner, char *Name ) ;
:li.HBITMAP APIENTRY GraphicImport ( HWND Owner, char *Name ) ;
:esl.:lm margin=1.:font facename=defau.

:p.La fonction :hp2.QueryFileType:ehp2. retourne un type de fichier
(comme :hp1.Bitmap:ehp1. ou :hp1.Mtafichier:ehp1.) qui sera affich
dans la bote de dialogue d&apos.ouverture d&apos.un fichier graphique,
dans la liste des types.

:p.La fonction :hp2.QueryWildcard:ehp2. retourne une spcification de
fichier (comme :hp1.*.Txt:ehp1.) qui sera utilise dans le champ
:hp1.Nom de fichier:ehp1. du dialogue d&apos.ouverture de fichier
graphique quand le type correspondant sera choisi.

:p.La fonction :hp2.Filter:ehp2. est appele lors du remplissage de la
liste de fichiers du dialogue d&apos.ouverture de fichier graphique, et
dtermine si un nom de fichier doit tre ou non affich dans la liste.
Il s&apos.agit d&apos.un test rapide du nom et du type du fichier, pas
d&apos.un test du contenu du fichier.

:p.La fonction :hp2.Verify:ehp2. est utilise pour vrifier la nature
du contenu du fichier. Le test doit tre rapide, mais plus approfondi
que celui effectu par la fonction :hp2.Filter:ehp2..

:p.La fonction :hp2.GraphicImport:ehp2. charge un graphique en mmoire,
le convertit au format bitmap natif d&apos.OS/2, et retourne la poigne
(:hp1.handle:ehp1.) du bitmap.

:euserdoc.
