/*******************************************************************************
    Maul developer API

    THIS FILE <MAULCLASS.H> MAY PLACED IN A PUBLIC ARCHIVE
    PUBLIC DATA

    This Version:- V3.05-07.1.6Ge

    (c) Copyright 1998 to 2006 Peter Koller. All rights reserved
*******************************************************************************/
/*******************************************************************************
	Shortform definition for including in resource files
*******************************************************************************/
#ifndef MAUL_WINDOW_CLASSES
#define MAUL_WINDOW_CLASSES

#ifdef __OS2__		//if compiling for os2

#define 	IDS_SMALLFONT           128  //"8.Helv"


/**** Additional dialog id's, the rest are in PMSTDDLG.H (#define INCL_WINSTDFILE) ****/
#define DID_SAMPLE_STAT			269   /* Sample image for my open/save dialog */
#define DID_SAMPLE_K1			270   /* erasable item - 'Preview:' text*/
#define DID_SAMPLE_K2			271   /* erasable item - groupbox around sample image */
#define DID_SAMPLE_PRIOR		272   /* erasable item - prior sample image */
#define DID_SAMPLE_NEXT			273   /* erasable item - next sample image */
#define DID_SEARCH_PB			274   /* Search button */
#define DID_STOP_PB				275   /* Stop button */

#define DID_SAVE_PB				DID_OK				// Delete stylesheet
#define DID_DELETE_PB			DID_STOP_PB			// Delete stylesheet
#define DID_STYLES_GB			DID_SAMPLE_K2		// Groupbox with title around listbox
#define DID_STYLES_LB			DID_FILES_LB		// List stylesheets
#define DID_SHOWALL_PB			DID_SAMPLE_PRIOR	// Checkbox, show all styles
#define DID_DEFAULT_CK			DID_SEARCH_PB   	// erasable item - use style as default
#define DID_CLEAR_CK		    DID_SAMPLE_K1		// erasable item - clear default style

#endif //os2

/*******************************************************************************
    Handler button ID's
*******************************************************************************/
#define     IDWIN_FRAMEBUTTON       150
#define     IDWIN_CONTENTSBUTTON    151
#define     IDWIN_BACKGROUNDBUTTON  152
#define     IDWIN_BORDERBUTTON      153

/*******************************************************************************
    Default Menu ID's
*******************************************************************************/
#define FIRST_BBAR_ID   300
#ifdef _WIN32		//if compiling for windows
#define FIRST_STAT_ID	3
#endif
#ifdef __OS2__		//if compiling for os2
#define FIRST_STAT_ID   400
#endif

#define FIRST_MENU_ID   800

#define MENU_FILELIST_LIM   100


/******************************************************************************
    Button and status bar structures and definitions
******************************************************************************/
#define FLYINGHELP_STRLEN   255

#define BUTTON_SMGAP	1
#define BUTTON_DEFGAP	3
#define BUTTON_BIGGAP	10

#ifdef _WIN32		//if compiling for windows
#define BUTTON_HEIGHT	11
#define BUTTON_WIDTH	11
#define BUTTON_BASE 	17
#define TOPBTN_BASE 	2
#endif
#ifdef __OS2__		//if compiling for os2
#define BUTTON_HEIGHT   13
#define BUTTON_WIDTH    16
#define BUTTON_BASE     2
#define TOPBTN_BASE     17
#endif

/*******************************************************************************
    Status bar default window class
*******************************************************************************/
#ifdef __OS2__		//if compiling for os2
#define     WC_STATUSITEM           "MaulStats"
#endif
#define SS_NOBORDER         0x4000L

/*******************************************************************************
	Rotary control window class
*******************************************************************************/
#define		WC_MAULROTARY			"MaulRotary"

//mp1 = FIXED orient, mp2 = 0, return 0 if failed
#define		MROM_SETORIENT			WM_MSGFREE
//mp1 = 0, mp2 = 0, return 0
#define		MROM_GETORIENT			(WM_MSGFREE + 1)
//mp1 = TRUE if sweep, mp2 = 0, return 0
#define		MROM_SETSWEEPMODE		(WM_MSGFREE + 2)


//as WM_COMMAND or WM_CONTROL: notifycode = SHORT2FROMMP(mp1), (HWND)mp2
#define		MRON_ORIENTCHANGED		1
#define		MRON_SETCAPTURE			2
#define		MRON_RELEASECAPTURE		3

/*******************************************************************************
    Colour table allows colour tables to be edited
*******************************************************************************/
#define		WC_COLORTABLE			"MaulColtab"

//mp1 = PULONG pColtable, mp2 = ULONG pnEntries, (bitmap colour table)
#define		MCTM_SETTABLE			WM_MSGFREE
//mp1 = PULONG* pColtable, mp2 = PULONG pnEntries, (bitmap colour table)
#define		MCTM_GETTABLE			(WM_MSGFREE + 1)
//mp1 = PULONG pEntry, mp2 = PULONG pnEntry, (bitmap colour table)
#define		MCTM_GETSEL				(WM_MSGFREE + 2)
//mp1 = ULONG Entry, mp2 = ULONG nEntry, (bitmap colour table)
#define		MCTM_SETSEL				(WM_MSGFREE + 3)

//as WM_COMMAND or WM_CONTROL: notifycode = SHORT2FROMMP(mp1), (HWND)mp2
#define		MCTN_ENTRYCHANGED		1
#define		MCTN_CLICKED			2
#define		MCTN_DOUBLECLICKED		3


/*******************************************************************************
    Other defined Window Classes
*******************************************************************************/
//works like a normal image button with some novel twists
#define     WC_MAULBUTTON           "MaulButton"
//if this button style is set, the global flat button mode is ignored
#define		MBS_NOGROUPEFFECTS      0x8000L

//a WM_CONTROL message is sent when WC_MAULBUTTON gets a WM_BUTTON2UP message
//mp1 = (id, BN_2CLICKED), mp2 = HWND of button
#define     BN_2CLICKED           	8

//Colour foreground/background select item
#define     WC_COLORITEM            "MaulColor"
//Colour wheel item
#define     WC_COLORWHEEL           "MaulCWheel"

//notify codes returned in WM_CONTROL
#define COLN_FGSELECT   2			//also for WC_COLORWHEEL
#define COLN_BGSELECT   3			//also for WC_COLORWHEEL
#define COLN_SWAP       4			//not for WC_COLORWHEEL
#define COLN_FGREFRESH  5			//not for WC_COLORWHEEL
#define COLN_BGREFRESH  6			//not for WC_COLORWHEEL

//WC_COLORITEM Set colours mp1 == colour (index or truecolour)
#define COLM_SETFGCOL   WM_MSGFREE			//set foreground
#define COLM_SETBGCOL   (WM_MSGFREE + 1)	//set background

//WC_COLORITEM Set colours mp1 = PCOLPAIR, mp2 = 0
//WC_COLORITEM Get colours mp1 = 0, mp2 = PCOLPAIR
//you can do both at the same time, the fetch precedes the set
#define COLM_SETCOLOR   (WM_MSGFREE + 2)
#define COLM_GETCOLOR   (WM_MSGFREE + 2)

//WC_COLORITEM can be:-
//0 = NONE
//QCOLOR_SINGLEFG = foreground only
//QCOLOR_SINGLEBG = background only
//(QCOLOR_SINGLEFG | QCOLOR_SINGLEBG) = both
#define COLM_SETFLAGS   (WM_MSGFREE + 3)

//duplicates WM_SETWINDOWPARAMS
#define COLM_SETPARMS   (WM_MSGFREE + 4)

//colour listbox
#define     WC_COLORLIST            "MaulCList"

//repaint listbox mp1 = colour, mp2 = TRUE to allow colour tolerancing  
#define		MCLIST_REPAINT			WM_MSGFREE

//notify codes returned in WM_CONTROL, both followed by LN_SELECT.
//LN_SELECT, use LM_QUERYITEMHANDLE to get colour
#define CLSTN_FGCOL     (WM_MSGFREE + 1)
#define CLSTN_BGCOL     (WM_MSGFREE + 2)


/*******************************************************************************


	Colour query flags


*******************************************************************************/
/*******************************************************************************
    Flags for WM_QCOLOR, MAUL_SETCOLOR
*******************************************************************************/
#define QCOLOR_DEFAULT      0       /* Default flags */
#define QCOLOR_SINGLEFG     1       /* Select/set single foreground color only */
#define QCOLOR_SINGLEBG     2       /* Select/set single background color only */

/**** WM_QCOLOR only ****/
#define QCOLOR_THREADED		0x4000	/* Threaded dialog returns immediately, updates via MAUL_SETCOLOR */
#define QCOLOR_NOWHEEL		0x8000	/* Do not use colour wheel, must also set QCOLOR_SINGLEFG or QCOLOR_SINGLEBG */

/*******************************************************************************
    Flags for Accelerator Tables

valid key definitions are:-

VK_LBUTTON			No accelerator key
VK_BACK				backspace key
VK_SPACE			space bar
VK_PRIOR			page up
VK_NEXT				page down
VK_END				end
VK_HOME				home
VK_LEFT				left arrow
VK_UP				up arrow
VK_RIGHT			right arrow
VK_DOWN				down arrow
VK_INSERT			insert key	(usually locked in some way)
VK_DELETE			delete key	(usually locked in some way)
VK_F2 to VK_F11		Function keys F1 to F11
+ and -				plus and minus keys
/ and \				forward slash and backslash
0 to 9				0 to 9 (numbers)
A to Z 				A to Z (uppercase only)

Modifiers
FVIRTKEY 								press character
FVIRTKEY | FCONTROL						press Ctrl+character
FVIRTKEY | FCONTROL | FSHIFT			press Ctrl+Shift+character
FVIRTKEY | FALT							avoid using these for shortcut keys
FVIRTKEY | FALT | FSHIFT				press Alt+Shift+character
FVIRTKEY | FCONTROL | FALT				press Ctrl+Alt+character (do not use Ctrl+Alt+Del)
FVIRTKEY | FCONTROL | FALT | FSHIFT		press Ctrl+Alt+Shift+character (do not use Ctrl+Alt+Shift+Del either)
*******************************************************************************/
//virtual key definitions for (ACCENTRY).fVirt
#ifndef _WIN32
#define	FVIRTKEY	0x01
#define	FSHIFT		0x04
#define	FCONTROL	0x08
#define	FALT		0x10
//virtual key definitions for (ACCENTRY).key
#define	VK_LBUTTON	VK_BUTTON1
#define	VK_BACK		VK_BACKSPACE
#define	VK_NEXT		VK_PAGEDOWN
#define	VK_PRIOR	VK_PAGEUP
#endif

#define	ACCLOCK_LOCK		1	/* locked, no user modification */
#define	ACCLOCK_LOCKAPPEND	2	/* locked, user may add another entry */


/*******************************************************************************
    common message ids's
*******************************************************************************/
#define IDST_EMPTYOBJECT       	71

/*******************************************************************************
    End - Window Classes
*******************************************************************************/
#endif
