.******************************************************************************
.*  Maul Publisher Metafile Handler Help File
.*   Peter Koller 2000, All Rights Reserved
.******************************************************************************
:userdoc.
:title. Maul Metafile Handler Help
:docprof toc=1234.
:h1 res=1 id=intro.About Maul Metafile Handler
:i1 id=all.About Maul Metafile Handler
:p.:artwork name='metahand.bmp' runin.:font facename='Tms Rmn' size=24x24.
:hp2.Maul Default Metafile Handler:ehp2.
:font facename=default.
:p.
.br
.br
:p.:hp2.Overview of the Maul Metafile Handler:ehp2.
:p.Use this handler to put metafiles into frames. Metafiles are vector graphics files specific to OS/2.
Many OS/2 applications can copy a metafile version of data to the clipboard.
:p.The Maul metafile handler uses the OS/2 metafile format to display metafiles.
:p.Most OS/2 applications that need to deal with vector graphics will be able to generate metafiles,
either by using the printer buffer, or by direct exportation.
:p.You can import metafiles matching the OS/2 metafile standard. Once imported, you can scale, rotate,
and mirror metafiles. This handler will process metafile data in order to implement colour separations.
:p.Although it is possible to preview OS/2 metafiles, it is not possible to import all metafiles.
New Metafiles made from several metafiles grouped in a set of frames may not display properly. This
is a consequence of the way that OS/2 metafiles function, but if you know a work-around please get in
touch.
:p.This handler provides two techniques to find a metafile boundary, by finding drawing limits, and
by reading the page size stored in the metafile data. Under some circumstances the page boundaries are
more precise than the drawing limits.
:p.To obtain more help from here, select 'Options' then 'Contents' on the menu in this
help window. You will then get a list of help contents to guide you further. Alternatively, you can
press the 'Index' button below for an index.
:p.:hp2.Notices:ehp2.
:p.Created by Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
:p. 1999 Peter Koller, Maison Anglais. All Rights Reserved.
:p.For details of the Licence Agreement, please see the copyright notice provided in
Maul Publishers main manual.
.br
.br
.******************************************************************************
.*
.*
.*
.*  Menu Item Help
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  Edit Menu
.******************************************************************************
:h1 res=8 id=8 global.The Metafile handler edit menu
:i1 id=edit.The Metafile handler edit menu
:p.The metafile handler edit menu contains the basic edit menu items one would expect to find in any editor,
plus a few specific ones for metafiles.
:p.These include&colon.-
:ul.
:li.How to :link reftype=hd res=10.cut:elink. metafiles.
:li.How to :link reftype=hd res=11.copy:elink. metafiles.
:li.How to :link reftype=hd res=12.paste:elink. metafiles.
:li.How to :link reftype=hd res=31.load:elink. a metafile.
:li.How to :link reftype=hd res=13.clear:elink. metafiles.
:li.How to set a :link reftype=hd res=54.metafile style:elink..
:li.How to :link reftype=hd res=14.remove:elink. the metafile handler from a frame.
:eul.
:lm margin=1.
.*******************************************************************************
:h2 res=10 id=10 global.Cut metafile to clipboard
:i2 refid=edit.Cut metafile to clipboard
:p.Select this menu item to copy the metafile to the clipboard. The metafile is then destroyed.
:p.The cut command can be executed by using the Shift + Delete keys.
.br
.br
.*******************************************************************************
:h2 res=11 id=11 global.Copy metafile to clipboard
:i2 refid=edit.Copy metafile to clipboard
:p.Select this menu item to copy the metafile to the clipboard. The metafile is not destroyed.
:p.The copy command can be executed by using the Control + Insert keys.
.br
.br
.*******************************************************************************
:h2 res=12 id=12 global.Paste metafile from clipboard
:i2 refid=edit.Paste metafile from clipboard
:p.Select this menu item to paste a metafile from the clipboard into the frame.
Any existing metafile is deleted.
:p.The paste command can be executed by using the Shift + Insert keys.
.br
.br
.*******************************************************************************
:h2 res=13 id=13 global.Clear metafile
:i2 refid=edit.Clear metafile
:p.Select this menu item to delete the metafile.
:p.The metafile is not copied to the clipboard.
:p.The clear command can be executed by using the Delete key.
.br
.br
.*******************************************************************************
:h2 res=54 id=54 global.Save metafile style
:i2 refid=edit.Save metafile style
:p.:hp2.Set a metafile style:ehp2.
:p.Use the 'Edit'->'Set metafile style' menu to apply a metafile style. If you select the small
button to the right of the menu item, the available metafile styles are listed. If you select
one of the listed styles, that style becomes the default for the 'Set metafile style' menu item.
:p.:hp2.Save metafile style:ehp2.
:p.If you have a metafile with a particular style, you can save that style.
:p.Metafile styles include everything except the metafile locking offset and the metafile itself.
If you need a style that also sets the metafile, use the frame styles in the frame handler.
:p.The styles are saved as style sheets in the user path. To see what the current user path
is set to, look at the 'Global style settings' in the Options menu.
:p.Styles are saved as common stylesheets. To find out more about these, please read the
Common Stylesheets section of Maul Publishers main manual.
.br
.br
.*******************************************************************************
:h2 res=14 id=14 global.Remove metafile handler from frame
:i2 refid=edit.Remove metafile handler from frame
:p.Select this menu item to destroy the metafile in the frame, and remove the metafile handler
from the frame. Once you have done this you can add a different handler to the frame in place
of the default metafile handler.
.br
.br
.******************************************************************************
.*  Metafile Menu
.******************************************************************************
:h1 res=20 id=20 global.The Metafile handler metafile menu
:i1 id=meta.The Metafile handler metafile menu
:p.The metafile handler metafile menu contains the specific edit menu items related to metafiles.
:p.These include&colon.-
:ul.
:li.How to use the :link reftype=hd res=23.original metafile size:elink..
:li.How to maintain the :link reftype=hd res=24.metafile aspect ratio:elink..
:li.How to :link reftype=hd res=25.lock the metafile:elink. position.
:li.How to change the :link reftype=hd res=27.metafile image limits:elink..
:li.How to :link reftype=hd res=22.scale:elink. metafiles.
:li.How to :link reftype=hd res=21.rotate:elink. metafiles.
:li.How to :link reftype=hd res=26.crop:elink. a frame to match the metafile size.
:li.How to save a :link reftype=hd res=54.metafile style:elink..
:eul.
:lm margin=1.
.br
.br
.*******************************************************************************
:h2 res=23 id=23 global.Use original metafile size
:i2 refid=meta.Use original metafile size
:p.The metafile handler uses two scaling methods. The first is that the metafile is
scaled to the smallest rectangle that can contain the frame. Any scaling that is then performed
using the :link reftype=hd res=22.Scale Picture:elink. dialog is in addition
to this initial scaling.
:p.You can choose not to perform this initial scaling by clicking on the 'Use original
metafile size' menu item. Other scaling and rotation is unaffected.
.br
.br
.*******************************************************************************
:h2 res=24 id=24 global.Maintain metafile aspect ratio
:i2 refid=meta.Maintain metafile aspect ratio
:p.The metafile handler uses two scaling methods. The first is that the metafile is
scaled to the smallest rectangle that can contain the frame.
:p.By selecting the 'Maintain metafile aspect ratio' menu item, the original aspect ratio is preserved
during this initial scaling.
:p.Any scaling that is then performed using the :link reftype=hd res=22.Scale Picture:elink.
dialog can still alter the aspect ratio.
.br
.br
.*******************************************************************************
:h2 res=25 id=25 global.Lock metafile position
:i2 refid=meta.Lock metafile position
:p.If you lock the metafile position, you can alter the frame to crop your image. Make sure your image is in the right
place, because if you subsequently unlock the image, it will jump to the object centre.
:p.A locked metafile cannot be moved, but can still be scaled and rotated. If you wish to be able to move the image within
a polygon, do not use this mode, but use manual scaling to adjust the image size as required. You will then be able to
move the image by altering the object centre. You can alter the object centre by using the frame handler.
:p.The locked mode enables the 'Use original metafile size' menu item as well as the 'Maintain metafile aspect ratio' menu
item, and rescales the metafile so that the actual size of the metafile does not appear to change. When you come to adjust
the scale of a locked metafile, you may find that the scale factors have changed completely. If you unlock the metafile,
the function attempts to restore the original scale factors.
.br
.br
.*******************************************************************************
:h2 res=27 id=27 global.Scale to metafile page
:i2 refid=meta.Scale to metafile page
:p.Enable this mode to scale the metafile according to it's original page size, rather than to
the metafile drawing limits. Some metafiles fit more perfectly into the page boundaries than
into the drawing limits.
:p.The reason for this is as follows&colon.-
:ul.
:li.The originating application may be painting beyond the edge of a clipping rectangle.
:li.The original image may have empty areas where no painting occurred, yet the image may
need to contain these blank areas.
:eul.
:p.
.br
.br
.*******************************************************************************
:h2 res=22 id=22 global.Scale Picture
:i2 refid=meta.Scale Picture
:p.Use the 'Scale Picture...' dialog to alter the scaling of a metafile. Scaling is a graphics transform
that is performed independently from other scaling factors. The scaling dialog allows you to scale
and mirror pictures.
:p.Use the entryfields to type in the height and width of the required scale factors in percent. For
convenience, use the buttons provided to add and subtract a factor of 50%. Negative scaling factors invert or
mirror the image.
:p.The dialog also provides two sliders to alter the scaling factors over a total range of 100%.
:p.Any changes are shown in the sample image. This sample can only give a guide to aspect ratios when scaling
is greater than 100%. The image is always shrunk to remain within the sample window.
:p.Press 'Apply' to apply the changes to the metafile, and 'Exit' to exit the dialog when you are finished.
.br
.br
.*******************************************************************************
:h2 res=21 id=21 global.Rotate Picture
:i2 refid=meta.Rotate Picture
:p.Picture orientation is made up of the sum of frame orientation and metafile orientation.
By default the metafile orientation is 0.
:p.Normally, if the frame is orientated to zero, the metafile is orientated to 0, which
results in a normally orientated metafile.
:p.If you rotate the frame, the metafile will also rotate. The actual metafile angle is shown
as a status string within the rotate dialog. You can use the spin button or enter the
required angle to change the :hp1.relative:ehp1. orientation between the metafile and the frame.
:p.Click on 'Apply' to apply the new metafile angle, and 'Exit' to exit the dialog when you are finished.
.br
.br
.*******************************************************************************
:h2 res=26 id=26 global.Crop Frame
:i2 refid=meta.Crop Frame
:p.You can crop any frame to the current image. Once the frame has been cropped, the image may re-scale yet again in
order to fit the new minimum rectangle that can contain the new frame size. This very much depends on the complexity
of the frame being cropped. The frame will not alter it's basic shape, but it's overall height and width are
recalculated to fit the metafile image.
:p.By selecting the menu item, the metafile handler will recalculate the size of the frame required to hold the
image, and will then resize the frame to match the size of the image.
.br
.br
.******************************************************************************
.*
.*
.*  Other information
.*
.*
.******************************************************************************

.******************************************************************************
.*  Import Metafiles
.******************************************************************************
:h1 res=31 id=31 global.Importing Pictures
:i1 id=import.Importing Pictures
:p.Use the import dialog to import metafile pictures into the default metafile handler.
:p.:hp2.Where to find metafiles:ehp2.
:p.When OS/2 first appeared, metafiles were rare beasts indeed. Nowadays, the situation is not much better.
There is a metafile supplied with OS/2 called 'AAAAA.MET'. You can find it in the ?&colon.os2\bitmaps directory.
:p.Fortunately, metafiles have a considerable role to play in OS/2. Nowadays a lot of applications that use
vector graphics can create OS/2 metafiles. Most of these can be imported and used within Maul. Such applications
range from spreadsheets to drawing packages, and include Maul itself&colon.-
:ul.
:li.Switch to the frame handler.
:li.Select a frame, or a grouped set of frames.
:li.Copy the frames to the clipboard.
:li.Switch to the metafile handler, or any application that handles metafile data.
:li.Paste the frame image back in as a metafile.
:eul.
.br
.br
.******************************************************************************
.*  Keys help
.******************************************************************************
:h1 res=60 id=60 global.Help with keyboard keys
:i1 id=keys.Help with keyboard keys
:p.The following keys are available with this handler. The most common keys are listed, but keys specific to other
handlers are not listed. Select a frame and handler you require information on, and then try keys help again.
:p.If no frame is selected, the main keys help for Maul Publisher is shown.
:p.:hp2.General key usage:ehp2.
:ol.
:li.:hp2.Menu selection:ehp2.
:dl compact tsize=16.
:dt.Alt+E:dd.Edit menu
:dt.Alt+F:dd.File menu
:dt.Alt+H:dd.Help menu
:dt.Alt+O:dd.Options menu
:dt.Alt+P:dd.Page menu
:dt.Alt+U:dd.Undo menu
:dt.Alt+V:dd.View menu
:dt.Alt+W:dd.Switch to (switch list)
:edl.
:li.:hp2.File menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+N:dd.New file
:dt.Ctrl+O:dd.Open file...
:dt.Ctrl+I:dd.Import...
:dt.Ctrl+X:dd.Export...
:dt.Ctrl+S:dd.Save file
:dt.Ctrl+A:dd.Save file as...
:dt.Ctrl+R:dd.Print file...
:edl.
:li.:hp2.Page menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+P:dd.Print page setup...
:dt.Ctrl+M:dd.Margins and grids...
:dt.Ctrl+Shift+M:dd.Use master page..
:dt.Ctrl+T:dd.Save/delete master page
:dt.Alt+Shift+Del:dd.Copy a page
:dt.Alt+Shift+Ins:dd.Paste a page
:dt.Ctrl+Shift+I:dd.Insert a page
:dt.Ctrl+Shift+J:dd.Insert new first page
:dt.Ctrl+Shift+D:dd.Delete a page
:dt.Alt+G:dd.Goto page
:dt.Ctrl+Shift+N:dd.Next page
:dt.Ctrl+Shift+P:dd.Previous page
:edl.
:li.:hp2.View menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+1:dd.Printer Page view
:dt.Ctrl+2:dd.Page view
:dt.Ctrl+3:dd.Fit width
:dt.Ctrl+4:dd.Actual size
:dt.Ctrl+Plus:dd.Zoom in
:dt.Ctrl+Minus:dd.Zoom out
:dt.Ctrl+F:dd.Frame edit mode
:dt.Ctrl+C:dd.Contents edit mode
:dt.Ctrl+G:dd.Background edit mode
:dt.Ctrl+B:dd.Border edit mode
:edl.
:li.:hp2.Undo menu:ehp2.
:dl compact tsize=16.
:dt.Alt+Backspace:dd.Undo last action
:dt.Ctrl+Backspace:dd.Redo last action
:dt.Ctrl+U:dd.Undo list...
:edl.
:li.:hp2.Options menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+Shift+R:dd.Printer setup...
:dt.Ctrl+E:dd.Snap enable
:dt.Ctrl+Shift+S:dd.Snap settings...
:edl.
:li.:hp2.Help menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+H:dd.Help contents
:dt.Ctrl+Shift+H:dd.Help index
:dt.Ctrl+K:dd.Keys help
:dt.Ctrl+L:dd.List all handlers
:dt.Ctrl+Z:dd.About...
:edl.
:eol.
:p.:hp2.Metafile handler key usage:ehp2.
:ol.
:li.:hp2.Edit menu:ehp2.
:dl compact tsize=16.
:dt.Shift+Delete:dd.Cut metafile
:dt.Ctrl+Insert:dd.Copy metafile
:dt.Shift+Insert:dd.Paste metafile
:dt.Delete:dd.Clear metafile
:dt.Alt+Delete:dd.Remove metafile handler
:edl.
:li.:hp2.Metafile menu:ehp2.
:dl compact tsize=16.
:dt.U:dd.Use original metafile size
:dt.M:dd.Maintain metafile aspect ratio
:dt.P:dd.Lock metafile position
:dt.S:dd.Scale metafile...
:dt.O:dd.Rotate metafile...
:edl.
:eol.
:euserdoc.
