/******************************************************************************
    Frame handler resources
    (c)Peter Koller 1998
******************************************************************************/
#ifndef FRAMEHAND_RESOURCES
#define FRAMEHAND_RESOURCES

#define     PROF_STYLESHEET     ",ssh"
#define     PROF_LOADIMG        ",loadstyle"
#define     DEF_STYLESHEET      "*"
#define     EXT_STYLESHEET		".ssh"

/*******************************************************************************
    RCDATA descriptions
*******************************************************************************/
#define IDACC_DEFLTKEYS         40

/*******************************************************************************
    Help
*******************************************************************************/

/*******************************************************************************
    bitmaps
*******************************************************************************/
#define IDBMP_BACKGND       1000
#define IDBMP_COLOFILL      1001
#define IDBMP_PATTERNF      1002
#define IDBMP_ORIENTATION   1008
#define IDBMP_OFFSET	    1009

#define IDBMP_PLAINFILL     1003
#define IDBMP_FLATFILL      1004
#define IDBMP_ARCFILL       1005
#define IDBMP_CIRCLEFILL    1006
#define IDBMP_RECTFILL    	1007
#define IDBMP_FIGFILL    	1010

/*******************************************************************************
   Local Strings
*******************************************************************************/
#define IDS_LANGLIBRARY     16  /* "bgndhand.lng" */

/*******************************************************************************
   Strings
*******************************************************************************/
#define IDS_HELPLIBRARY     17  /* "bgndhand.hlp" */
#define IDS_HELPWINTITLE    18  /* "Maul plain background Help" */
#define IDS_UPDATEBGNDERR   19  /* "Error updating background to V1.10, delete background and start again" */
#define IDS_CLIPBD_ERR      20  /* "Error - failed to save clipboard data" */
#define UNDO_INIT_ID        21  /* "new background" */
#define UNDO_COLOR_ID       22  /* "set background colour" */
#define UNDO_PATTERN_ID     23  /* "set background pattern" */
#define UNDO_PASTE_ID       24  /* "paste background" */
#define UNDO_CUT_ID         25  /* "cut background" */
#define UNDO_CLEAR_ID       26  /* "remove background handler" */
#define UNDO_REFORMAT_ID    27  /* "update background to V1.10" */
#define UNDO_ADDCOLOR_ID    28  /* "edit background colour list" */
#define UNDO_SHADE_ID       29  /* "change background shading mode" */
#define UNDO_ORIENT_ID      30  /* "change background orientation" */
#define UNDO_ADVANCED_ID    31  /* "change background advanced" */
#define UNDO_MODE_ID        32  /* "change other background modes" */
#define	IDS_RUNINPROTO		33	/* "run-in %.2f%%" */
#define	IDS_RUNOUTPROTO		34	/* "run-out %.2f%%" */
#define IDS_SETSTYLE		35  //"set background style"
#define IDS_STYLE_DELETE	36  //"Delete this style sheet"
#define IDS_STYLE_EXISTS	37  //"Style sheet exists, overwrite"
#define UNDO_OFFSET_ID      38  /* "change background offset" */
#define IDS_NOSTYLESHEET	39  //"No stylesheet is selected"

#define IDFH_EDITTASK       40  //"Select background edit tasks"
#define IDFH_FILLSTYLE      41  //"Select background fill style"
#define IDFH_HANDIDENT      42  //"Colour fill handler is active"
#define IDFH_COLOURS        43  //"Set the fill colours"
#define IDFH_PATTERN        44  //"Set the fill pattern"
#define IDFH_QFILLSTYLE     45  //"Set the fill style"
#define IDFH_FILLANGLE      46  //"Set the fill angle"
#define IDFH_FILLOFFSET     47  //"Set the fill offset"
#define IDS_HANDLERTYPE     50  //"Background"
#define IDS_HANDLERNAME     51  //"Background handler"
#define IDS_IMPORTNTYPE     52  //"Background"
#define IDS_IMPORTNNAME     53  //"Import background from clipboard"

//***** copied from language\src\maul\resource.h
#define IDFH_COLORSWATCH    1113  //"Click here for more..."

/*******************************************************************************
    dialogs
*******************************************************************************/
#define HELP_BUTTON             100
#define PATTERN_SELECT_DLG      110
#define PATTERN_SELECT_NONE     111
#define PATTERN_SELECT_1        112
#define PATTERN_SELECT_2        113
#define PATTERN_SELECT_3        114
#define PATTERN_SELECT_4        115
#define PATTERN_SELECT_5        116
#define PATTERN_SELECT_6        117
#define PATTERN_SELECT_7        118
#define PATTERN_SELECT_8        119
#define PATTERN_SELECT_9        120
#define PATTERN_SELECT_10       121
#define PATTERN_SELECT_11       122
#define PATTERN_SELECT_12       123
#define PATTERN_SELECT_13       124
#define PATTERN_SELECT_14       125
#define PATTERN_SELECT_15       126
#define PATTERN_SELECT_16       127

#define SHADING_DLG             130
#define SHADING_ADD             131
#define SHADING_DEL             132
#define SHADING_UP              133
#define SHADING_DOWN            134
#define SHADING_LIST            135
#define SHADING_COLOR          	136
#define SHADING_WHEEL          	137
#define SHADING_COLIST         	138
#define SHADING_SPOTS          	139

#define IDD_ROTATEDLG           140
#define IDD_ROTATEACTUAL        141
#define IDD_ROTATEOBJECT        142
#define IDD_ROTATEENTRY         143
#define IDD_ROTATECONTROL       144

#define	IDD_OFFSETDLG			150
#define	IDD_OFFSETENTRY			151

#define	IDD_ADVSHADEDLG			160
#define	IDD_ADVSHADEXFADE		161
#define	IDD_ADVSHADENORM		162
#define	IDD_ADVSHADECIRCLE		163
#define	IDD_ADVSHADECLOCK		164
#define	IDD_ADVSHADERUNIN		165
#define	IDD_ADVSHADERUNOUT		166
#define	IDD_ADVSHADERINSTAT		167
#define	IDD_ADVSHADEROUTSTAT	168

#define IDD_STYLE_DLG			180
#define IDD_STYLE_ENTRY			181
#define IDD_STYLE_DELETE		182
#define IDD_STYLE_GROUPBOX		183

/*******************************************************************************
    Menus
*******************************************************************************/
#define     BGND_CUT        (FIRST_MENU_ID + 1)
#define     BGND_COPY       (FIRST_MENU_ID + 2)
#define     BGND_PASTE      (FIRST_MENU_ID + 3)
#define     BGND_CLEAR      (FIRST_MENU_ID + 4)

#define     BGND_COLOR      (FIRST_MENU_ID + 5)
#define     BGND_ADVANCED   (FIRST_MENU_ID + 6)
#define     BGND_PATTERN    (FIRST_MENU_ID + 7)
#define     BGND_ORIENT     (FIRST_MENU_ID + 8)
#define     BGND_OFFSET     (FIRST_MENU_ID + 9)
#define     BGND_SAVESTYLE  (FIRST_MENU_ID + 10)
#define     BGND_OVERLAPCUT (FIRST_MENU_ID + 11)

#define PATTERN_MENU_ID		(FIRST_MENU_ID + 20)
#define PATMENU_SELECT_NONE	(PATTERN_MENU_ID + 1)
#define PATMENU_SELECT_1	(PATTERN_MENU_ID + 2)
#define PATMENU_SELECT_2	(PATTERN_MENU_ID + 3)
#define PATMENU_SELECT_3	(PATTERN_MENU_ID + 4)
#define PATMENU_SELECT_4	(PATTERN_MENU_ID + 5)
#define PATMENU_SELECT_5	(PATTERN_MENU_ID + 6)
#define PATMENU_SELECT_6	(PATTERN_MENU_ID + 7)
#define PATMENU_SELECT_7	(PATTERN_MENU_ID + 8)
#define PATMENU_SELECT_8	(PATTERN_MENU_ID + 9)
#define PATMENU_SELECT_9	(PATTERN_MENU_ID + 10)
#define PATMENU_SELECT_10	(PATTERN_MENU_ID + 11)
#define PATMENU_SELECT_11	(PATTERN_MENU_ID + 12)
#define PATMENU_SELECT_12	(PATTERN_MENU_ID + 13)
#define PATMENU_SELECT_13	(PATTERN_MENU_ID + 14)
#define PATMENU_SELECT_14	(PATTERN_MENU_ID + 15)
#define PATMENU_SELECT_15	(PATTERN_MENU_ID + 16)
#define PATMENU_SELECT_16	(PATTERN_MENU_ID + 17)

#define     BGND_MODE_MENU	(FIRST_MENU_ID + 40)
#define     BGND_MODEPLAIN  (BGND_MODE_MENU + 1)
#define     BGND_MODEFLAT   (BGND_MODE_MENU + 2)
#define     BGND_MODEARC    (BGND_MODE_MENU + 3)
#define     BGND_MODECIRCLE (BGND_MODE_MENU + 4)
#define     BGND_MODERECT	(BGND_MODE_MENU + 5)
#define     BGND_MODEFIG	(BGND_MODE_MENU + 6)

#define     BGND_LOADSTYLE  (BGND_MODE_MENU + 7)

/*******************************************************************************
    buttons
*******************************************************************************/
#define     IDB_COLORFILL   FIRST_BBAR_ID
#define     IDB_PATTERNFILL (FIRST_BBAR_ID + 2)
#define     IDB_BGNDMODE    (FIRST_BBAR_ID + 3)
#define     IDB_BGNDORIENT  (FIRST_BBAR_ID + 4)
#define     IDB_BGNDOFFSET  (FIRST_BBAR_ID + 5)

#endif
