/*******************************************************************************
	Tables handler resources
	(c) 2003 Peter Koller, Maison Anglais. All rights reserved.
*******************************************************************************/
#ifndef TABLEHAND_RESOURCES
#define TABLEHAND_RESOURCES

/*******************************************************************************
    pointers
*******************************************************************************/
#define     PROF_STYLESHEET     ",ssh"
#define     PROF_LOADIMG        ",loadstyle"
#define     DEF_STYLESHEET      "*"
#define     EXT_STYLESHEET		".ssh"

#define 	KBCODE_EXTKEY	0x01000000
#define 	KBCODE_CONTEXT	0x20000000
#define 	KBCODE_PREVKEY	0x40000000

#define     SC_ESC          0x01

#define 	WC_TABSRULER		"MaulfftTbr"
#define 	HTP_SPELLCHECK		"SPELLCHECK"
#define		MERGEBASE_ID		'bmxt'

/*******************************************************************************
    RCDATA descriptions
*******************************************************************************/
#define IDACC_DEFLTKEYS         40

/*******************************************************************************
    bitmaps
*******************************************************************************/
#define IDBMP_HANDLER       1000
#define IDBMP_COLOFILL      1001
#define IDBMP_ATOZ		    1002
#define IDBMP_FONTSTAT		1003
#define IDBMP_POSNSTAT		1004

#define IDCUR_NS			1005
#define IDCUR_EW			1006
#define IDPTR_DEFEDIT       1007

/**** text justification ****/
#define IDICO_LFTJUST		1010
#define IDICO_RGTJUST		1011
#define IDICO_CNTJUST		1012
#define IDICO_ALLJUST		1013
#define IDICO_EDITMODE		1014
#define IDICO_TEXTENTRY		1015

#define IDICO_TEXTCOL		1016
#define IDICO_OUTLTXT		1017
#define IDICO_ULINTXT		1018
#define IDICO_STRKTXT		1019
#define IDICO_SUBSTXT		1020
#define IDICO_SUPRTXT		1021
#define IDICO_DROPSHADOW	1022
#define IDICO_REFLOW		1023

/**** Border styles ****/
#define	IDICO_COLINE		1024
#define	IDICO_WIDTH			1025
#define	IDICO_BORDSTYLE		1026
#define IDBMP_BSTYBLANK		1027
#define IDBMP_BSTYHORZ2		1028
#define IDBMP_BSTYVERT2		1029
#define IDBMP_BSTYINTER		1030
#define IDBMP_BSTYNONE		1031
#define IDBMP_BSTYHORZ		1032
#define IDBMP_BSTYVERT		1033
#define IDBMP_BSTYALL		1034
#define IDBMP_BULLET        1035
#define IDBMP_COUNTER       1036

/**** Hatch patterns ****/
#define	IDBMP_LSPLAIN       1040
#define	IDBMP_LSDASH        1041
#define	IDBMP_LSDASHDD      1042
#define	IDBMP_LSDOT         1043
#define	IDBMP_LSDOTDOT      1044
#define	IDBMP_LSDSHDOT      1045
#define	IDBMP_LSSHDASH      1046
#define	IDBMP_LSNONE        1047
#define	IDBMP_LSDOUBLE      1048

#define IDICON_FINDDLG      1050

/**** fill modes ****/
#define IDICO_PLAINFILL     1060
#define IDICO_FLATFILL      1061
#define IDICO_ARCFILL       1062
#define IDICO_CIRCLEFILL    1063
#define IDICO_RECTFILL    	1064
#define IDICO_CHEQUFILL    	1065

#define IDICO_VGNTOP		1067
#define IDICO_VGNMID		1068
#define IDICO_VGNBOT		1069

/**** display modes ****/
/*
#define IDICO_TABLE			2000
#define IDICO_VBARS			2001
#define IDICO_HBARS			2002
#define IDICO_PIE 			2003
#define IDICO_GRAPH			2004
#define IDICO_DIFF			2005
*/
/*******************************************************************************
    add on menu...
*******************************************************************************/

/*******************************************************************************
    edit menu
*******************************************************************************/
//**** FIRST_MENU_ID is defined as 800 in dllinfo.h
#define HAND_CUT            (FIRST_MENU_ID + 1)
#define HAND_COPY           (FIRST_MENU_ID + 2)
#define HAND_PASTE          (FIRST_MENU_ID + 3)
#define HAND_LOAD           (FIRST_MENU_ID + 4)
/**********************************************/
#define HAND_CLEAR          (FIRST_MENU_ID + 5)
/**********************************************/
#define RNG_SELBORDERS      (FIRST_MENU_ID + 6)
#define RNG_SELFILLS		(FIRST_MENU_ID + 7)
#define RNG_SELBITMAPS      (FIRST_MENU_ID + 8)
#define RNG_SELMETAS		(FIRST_MENU_ID + 9)
#define RNG_SELCLIPFR		(FIRST_MENU_ID + 10)
#define RNG_SELTEXT			(FIRST_MENU_ID + 11)
#define RNG_SELALLTYPES     (FIRST_MENU_ID + 12)
/**********************************************/
#define ROWCOL_SELECTALL    (FIRST_MENU_ID + 13)
#define ROWCOL_SETCONTRNG   (FIRST_MENU_ID + 14)
/**********************************************/
#define HAND_INSCLIPART		(FIRST_MENU_ID + 15)
#define HAND_INSTEXT		(FIRST_MENU_ID + 16)
/**********************************************/
#define TXT_EDIT_MENU		(FIRST_MENU_ID + 17)
#define TXT_SELCHAR			(FIRST_MENU_ID + 18)
#define TXT_FLUSH			(FIRST_MENU_ID + 19)
#define TXT_EMBEDDED		(FIRST_MENU_ID + 20)
#define TXT_FOOTNOTE		(FIRST_MENU_ID + 21)
#define TXT_EQUATION		(FIRST_MENU_ID + 22)
#define TXT_CTRLTXT			(FIRST_MENU_ID + 23)
#define TXT_SELMERGE		(FIRST_MENU_ID + 24)
#define TXT_FIND			(FIRST_MENU_ID + 25)
#define TXT_WORDCOUNT		(FIRST_MENU_ID + 26)
#define TXT_SPELLCHK		(FIRST_MENU_ID + 27)
#define TXT_ARTINFO			(FIRST_MENU_ID + 28)
/**********************************************/
#define ROWCOL_SETTABLE     (FIRST_MENU_ID + 29)
/**********************************************/
#define ROWCOL_INSROW       (FIRST_MENU_ID + 30)
#define ROWCOL_DELROW       (FIRST_MENU_ID + 31)
/**********************************************/
#define ROWCOL_INSCOL       (FIRST_MENU_ID + 32)
#define ROWCOL_DELCOL       (FIRST_MENU_ID + 33)
/**********************************************/
#define ROWCOL_RSTROW       (FIRST_MENU_ID + 34)
#define ROWCOL_RSTCOL       (FIRST_MENU_ID + 35)
#define ROWCOL_RSTBOTH      (FIRST_MENU_ID + 36)
/**********************************************/
#define HAND_REMOVE			(FIRST_MENU_ID + 37)
#define HAND_EDITMODE		(FIRST_MENU_ID + 38)
/**********************************************/
#define RANGE_MENU			(FIRST_MENU_ID + 39)
#define TBLSIZE_MENU		(FIRST_MENU_ID + 40)

/**********************************************
second menu
**********************************************/
#define SCND_MENU_ID        850
/**********************************************/
#define POPUP_BORD			(SCND_MENU_ID + 1)
#define BORD_LINES			(SCND_MENU_ID + 2)
#define BORD_WIDTH			(SCND_MENU_ID + 3)
#define BORD_COLOR			(SCND_MENU_ID + 4)
/**********************************************/
#define POPUP_FILL			(SCND_MENU_ID + 5)
#define FILL_COLOR			(SCND_MENU_ID + 6)
#define FILL_ADVANCED		(SCND_MENU_ID + 7)
#define FILL_PATTERN		(SCND_MENU_ID + 8)
#define FILL_ORIENT			(SCND_MENU_ID + 9)
/**********************************************/
#define POPUP_BMP			(SCND_MENU_ID + 10)
#define HAND_ASPLOCKBMP		(SCND_MENU_ID + 11)
#define HAND_SCALEBMP		(SCND_MENU_ID + 12)
/**********************************************/
#define POPUP_META			(SCND_MENU_ID + 13)
#define HAND_ASPLOCKMETA	(SCND_MENU_ID + 14)
#define HAND_SCALEMETA		(SCND_MENU_ID + 15)
/**********************************************/
#define POPUP_CLIPFR		(SCND_MENU_ID + 16)
#define HAND_SCALECLIPFR	(SCND_MENU_ID + 17)
/**********************************************/
#define POPUP_TXT			(SCND_MENU_ID + 18)
#define TXT_ORIENT			(SCND_MENU_ID + 19)
#define TXT_CODEPAGE		(SCND_MENU_ID + 20)
#define TXT_HYPHENATE		(SCND_MENU_ID + 21)
#define TXT_EXTRACT			(SCND_MENU_ID + 22)
#define TXT_PGRAPH			(SCND_MENU_ID + 23)
/**********************************************/
#define TXT_LINE			(SCND_MENU_ID + 24)
#define TXT_TABS			(SCND_MENU_ID + 25)
/**********************************************/
#define TXT_FONT			(SCND_MENU_ID + 26)
#define TXT_COLOR			(SCND_MENU_ID + 27)
#define TXT_KERN			(SCND_MENU_ID + 28)
#define TXT_DROPSHADOW		(SCND_MENU_ID + 29)
/**********************************************/
#define TXT_SUPERSTR		(SCND_MENU_ID + 30)
#define TXT_SUBSTR			(SCND_MENU_ID + 31)
#define TXT_SMARTQUOTE		(SCND_MENU_ID + 32)
#define TXT_BULLET			(SCND_MENU_ID + 33)

/**********************************************
Select chart type dropdown button
**********************************************/
/*#define MODE_MENU_ID        890
#define MODE_TABLE_ID		(MODE_MENU_ID + 1)
#define MODE_VBARS_ID		(MODE_MENU_ID + 2)
#define MODE_HBARS_ID		(MODE_MENU_ID + 3)
#define MODE_PIE_ID 		(MODE_MENU_ID + 4)
#define MODE_GRAPH_ID		(MODE_MENU_ID + 5)
#define MODE_DIFF_ID		(MODE_MENU_ID + 6)
*/
/**********************************************
Text justification dropdown button
**********************************************/
#define JUST_MENU_ID		890
#define IDB_JUST_LEFT		(JUST_MENU_ID + 1)
#define IDB_JUST_RIGHT		(JUST_MENU_ID + 2)
#define IDB_JUST_CTR		(JUST_MENU_ID + 3)
#define IDB_JUST_ALL		(JUST_MENU_ID + 4)
/**********************************************
Fill mode dropdown button
**********************************************/
#define	BGND_MODE_MENU		895
#define	BGND_MODEPLAIN		(BGND_MODE_MENU + 1)
#define	BGND_MODEFLAT		(BGND_MODE_MENU + 2)
#define	BGND_MODEARC		(BGND_MODE_MENU + 3)
#define	BGND_MODECIRCLE		(BGND_MODE_MENU + 4)
#define	BGND_MODERECT		(BGND_MODE_MENU + 5)
#define	BGND_MODECHEQ		(BGND_MODE_MENU + 6)

/**********************************************
Fill pattern dropdown button
**********************************************/
#define PATTERN_MENU_ID		910
#define PATMENU_SELECT_NONE	(PATTERN_MENU_ID + 1)
#define PATMENU_SELECT_1	(PATTERN_MENU_ID + 2)
#define PATMENU_SELECT_2	(PATTERN_MENU_ID + 3)
#define PATMENU_SELECT_3	(PATTERN_MENU_ID + 4)
#define PATMENU_SELECT_4	(PATTERN_MENU_ID + 5)
#define PATMENU_SELECT_5	(PATTERN_MENU_ID + 6)
#define PATMENU_SELECT_6	(PATTERN_MENU_ID + 7)
#define PATMENU_SELECT_7	(PATTERN_MENU_ID + 8)
#define PATMENU_SELECT_8	(PATTERN_MENU_ID + 9)
#define PATMENU_SELECT_9	(PATTERN_MENU_ID + 10)
#define PATMENU_SELECT_10	(PATTERN_MENU_ID + 11)
#define PATMENU_SELECT_11	(PATTERN_MENU_ID + 12)
#define PATMENU_SELECT_12	(PATTERN_MENU_ID + 13)
#define PATMENU_SELECT_13	(PATTERN_MENU_ID + 14)
#define PATMENU_SELECT_14	(PATTERN_MENU_ID + 15)
#define PATMENU_SELECT_15	(PATTERN_MENU_ID + 16)
#define PATMENU_SELECT_16	(PATTERN_MENU_ID + 17) /* 927 */

#define VGNMODE_MENU_ID		930
#define VGNMODE_TOP			931
#define VGNMODE_MIDDLE		932
#define VGNMODE_BOTTOM		933

#define HAND_SETSTYLE       934	/* must be last */
#define HAND_STYLESEL       935	/* must be last */


/*******************************************************************************
    button bar
*******************************************************************************/
//**** FIRST_BBAR_ID is defined as 300 in dllinfo.h
//#define     IDB_MODE_MENU		FIRST_BBAR_ID
#define		IDB_EDITMODE		(FIRST_BBAR_ID + 1)
#define     IDB_TEXTENTRY		(FIRST_BBAR_ID + 2)

#define     IDB_COLORFILL       (FIRST_BBAR_ID + 3)
#define     IDB_PATTERN_MENU	(FIRST_BBAR_ID + 4)
#define     IDB_BGNDMODE		(FIRST_BBAR_ID + 5)

#define     IDB_BORDCOLOR		(FIRST_BBAR_ID + 6)
#define     IDB_BORDWIDTH		(FIRST_BBAR_ID + 7)
#define     IDB_BORDMODE		(FIRST_BBAR_ID + 8)

#define     IDC_FONTSEL			(FIRST_BBAR_ID + 9)
#define     IDC_FONTSTYLE		(FIRST_BBAR_ID + 10)
#define     IDC_FONTSIZE		(FIRST_BBAR_ID + 11)
#define     IDB_JUST_MENU		(FIRST_BBAR_ID + 12)
#define     IDB_TXTCOLOR		(FIRST_BBAR_ID + 13)
#define     IDB_OUTLTXT			(FIRST_BBAR_ID + 14)
#define     IDB_ULINTXT			(FIRST_BBAR_ID + 15)
#define     IDB_STRKTXT			(FIRST_BBAR_ID + 16)
#define     IDB_SUBSTXT			(FIRST_BBAR_ID + 17)
#define     IDB_SUPRTXT			(FIRST_BBAR_ID + 18)
#define     IDB_DROPSHADOW		(FIRST_BBAR_ID + 19)
#define     IDB_REFLOW			(FIRST_BBAR_ID + 20)
#define     IDB_VGNMODE			(FIRST_BBAR_ID + 21)
#define 	IDB_BULLET			(FIRST_BBAR_ID + 22)
#define 	IDB_COUNTER			(FIRST_BBAR_ID + 23)

/*******************************************************************************
    status bar
*******************************************************************************/
#define     IDS_HANDIDENT   FIRST_STAT_ID
#define     IDS_TABRANGE    (FIRST_STAT_ID + 1)
#define     IDS_TXTFLAGS    (FIRST_STAT_ID + 2)
#define     IDS_FONTINFO    (FIRST_STAT_ID + 3)

/*******************************************************************************
    help table
*******************************************************************************/
/*******************************************************************************
    string defs
*******************************************************************************/
#define IDS_HELPWINTITLE		16  //"Maul tables handler help"
#define IDS_HELPLIBRARY			17  //"tblhand.hlp"
#define	IDS_HANDMENU			18	//"&Cell styles"
#define IDS_HANDLERTYPE0     	20  //"Tables"
#define IDS_HANDLERTYPE1     	21  //"Tables (*.tbl)"
#define IDS_HANDLERTYPE2     	22  //"Tables (*.csv;*.csl)"
#define IDS_HANDLERTYPE3     	23  //"Tables (*.tbl)"
#define IDS_HANDLERTYPE4     	24  //"Tables FFTXT mergebase hookproc"
#define IDS_HANDLERNAME0		25  //"Tables handler"
#define IDS_HANDLERNAME1		26  //"Import Maul tables"
#define IDS_HANDLERNAME2		27  //"Import comma separated list"
#define IDS_HANDLERNAME3		28  //"Export Maul tables"
#define IDS_HANDLERNAME4		29  //"Autoincrements the merge database rows"

#define IDS_SETSTYLE			30  //"add handler style data"
#define IDS_STYLE_DELETE		31  //"Delete this style sheet"
#define IDS_STYLE_EXISTS		32  //"Style sheet exists, overwrite"
#define IDS_SCALINGFUNCS		33  //"change table scale"
#define IDS_NOSTYLESHEET		34  //"No stylesheet is selected"

#define IDS_FONTCREATEERROR 	40	//"F1 - font creation failed"
#define IDS_FNTMETRICSERROR 	41	//"F2 - get font metrics failed"
#define IDS_DEADFONTMSG 		42	//"ALMOST FATAL ERROR - Corrupt font, font not found!"
#define IDS_FONTLCIDINVALID 	43 //"Error: Font ID unusable"
#define IDS_FONTLCIDEXCEED		44 //"Error: Font ID out of range"
#define IDS_FONTLCIDINUSE		45 //"Error: Font ID already used"
#define IDS_FONTFINDERROR		46 //"Font not found: using default font"
#define IDS_FONTFULLERROR		47 //"Error: No room for additional fonts"
#define IDS_DEFAULTFONTNAME 	48 //"Helvetica"
#define	IDS_NORMAL				49 //"normal"

#define IDS_ADDFONT 			50	//"add font"
#define IDS_DELFONT 			51	//"delete font"
#define IDS_ADDTEXT 			52	//"add text"
#define IDS_DELTEXT 			53	//"delete text"
#define IDS_FORMATTEXT 			54	//"format text"
#define IDS_NEWTEXT 			55	//"create new text object"
#define IDS_CHANGEPOS 			56	//"text formatting"
#define IDS_CHARTSELMODE		57	//"Select whole table"
#define IDS_TEXTSELMODE			58	//"Select all text"
#define IDS_PASTETEXT 			59	//"change text"
#define IDS_ADDFOOTNT			60	//"insert footnote"
#define IDS_EDITFOOTNT			61	//"change footnote"
#define IDS_ADDEQUATION			62	//"insert equation"
#define IDS_EDITEQUATION		63	//"change equation"

#define IDS_TPOSFORMATSTAT		70  //"L%d%s%d,%s%s"
#define IDS_BLNKFORMATSTAT		71  //"L  %s  ,%s%s",
#define IDS_NULLFORMATCHAR		72  //"."
#define IDS_TABFORMATCHAR		73  //"t"
#define IDS_LOLFORMATCHAR		74  //"*"
#define IDS_DEFFORMATCHAR		75  //":"

#define IDS_CHANGEHYPHEN 		82	//"Change text hyphenation"
#define IDS_WORDCOUNTMSG		84	//"This table contains %d words.\n(%d words in current selection)"
#define IDS_WORDCOUNTTITLE		85	//"Word Count"
#define IDS_SEEK_NOTFOUNDRANGE	86	//"No more items to find in this container."
#define IDS_SEEK_NOTFOUNDTABLE	87	//"No more items to find in this table."
#define IDS_TABLEFINDSTRING		88	//"Find text in table"
#define IDS_TEXTFINDSTRING		89	//"Find text in article"

#define IDS_HANDLERINIT			101 //"create new table"
#define IDS_HANDLERCUT			102 //"cut table items"
#define IDS_HANDLERCOPY			103 //"copy table items"
#define IDS_HANDLERPASTE		104 //"paste table items"
#define IDS_HANDLERCLEAR		105 //"clear table items"
#define IDS_HANDLERREMOVE		106 //"remove handler"

#define IDS_SETCOLWITH			120 //"set column width"
#define IDS_SETROWHEIGHT		121 //"set row height"
#define IDS_ADDCOLUMN			122 //"add column"
#define IDS_REMCOLUMN			123 //"delete column"
#define IDS_ADDROW				124 //"add row"
#define IDS_REMROW				125 //"delete row"
#define IDS_SETROWCOLSIZE		126 //"set width and height"
#define IDS_SETCHARTSIZE		127 //"set chart size"
#define IDS_SETCONTRANGE		128 //"set container range"
#define IDS_DELCONTAINER		129 //"delete container"

#define IDS_UNDOGENERIC         130 //"change article info"
#define IDS_COUNTMODES			131	//"()\0[]\0{}\0<>\0,\0:\0;\0\0"
#define IDS_COUNTSTYLES			132	//"1,2,3,\0a,b,c,\0A,B,C,\0i..iv,v,\0I..IV,V,\0\0"
#define IDS_TEXTMARKERS			133	//"Off+Title 1+Title 2+Title 3+Title 4+Title 5+Title 6+Title 7+Title 8+URL link"
#define IDS_FOOTSTYLES			134	//"1,2,3,\0a,b,c,\0A,B,C,\0i..iv,v,\0I..IV,V,\0Title text\0\0"

#define IDS_SETFILLSTYLE		140 //"set fill style"
#define IDS_SETFILLCOLOR		141 //"set fill color"
#define IDS_SETFILLPATTERN		142 //"set fill pattern"
#define IDS_SETFILLORIENT		143 //"set fill direction"
#define IDS_SETFILLADVANCED		144 //"set fill advanced"

#define IDS_SETBORDSTYLE		150 //"set border style"
#define IDS_SETBORDCOLOR		151 //"set border color"
#define IDS_SETBORDWIDTH		152 //"set border width"

#define IOTEX_LEN				12
#define IOTEX_STRING			56
#define IDS_PLAINEXTENSION		160 //"*.tbl"
#define IDS_IOTPLAIN			162 //"Maul tables (*.tbl)"
#define IDS_EXPORTTITLE 		163 //"Export table"
#define IDS_EXPORTBUTTON		164 //"Export"
#define IDS_IMPORTTITLE 		165 //"Import to table"
#define IDS_IMPORTBUTTON		166 //"Import"
#define IDS_MERGEDATA           167 //"change merge database"
#define IDS_MERGEMENU			168 //"Select &merge data..."
#define IDS_MERGEROW            169 //"change merge row"
#define IDS_PLAINEXTENSION2		170 //"*.csv;*.csl"
#define IDS_IOTPLAIN2			172 //"Comma separated list"
#define IDS_UNKNOWN				173	//"Unknown, Unbekannt"
#define IDS_TEXTQUOTES			174 //"change text quotes"

/*** Core LOL undo strings ***/
#define IDS_TEXTSHEAR			180 //"change text shear"
#define IDS_TEXTDIRN			181 //"change text direction"
#define IDS_TEXTCOLOR			182 //"change text colour"
#define IDS_TEXTSIZE			183 //"change text size"
#define IDS_TEXTKERN			184 //"change text kerning"
#define IDS_CHANGEFONT			185 //"change text font"
#define IDS_TEXTEMPHASIS		186 //"change text emphasis"
#define IDS_TEXTTITLEEXTA		187 //"change text title marker"
#define IDS_CHAREXTRA			188 //"change character spacing"
#define IDS_CHARSTRETCH			189 //"change text stretch"
#define IDS_DROPSHADOW			190 //"change text dropshadow"
#define IDS_SETTABS				191 //"change text tabs"
#define IDS_LINEJUSTIFY 		192	//"change text justification"
#define IDS_LINETYPE			193	//"change text line style"
#define IDS_PARAINDENTS 		194	//"change paragraph style"
#define IDS_VGNALIGN	 		195	//"change text alignment"
#define IDS_FLUSHBREAK			196	//"insert flush break"
#define IDS_EMBEDDED			197	//"insert object"
#define IDS_EMBEDDED_UPD		198	//"update object"
#define IDS_CODEPAGE			199	//"change codepage"

#define IDS_BADCONTROLTEXT		200 //"!bad ctrtxt!"
#define IDS_LIMITERR			201 //"Initial LOL list is corrupted. Fix:- copy text to new selection."
#define IDS_FORMATOVERRUN		202 //">>>"
#define IDS_TEXTERRMSGH 		203 //"Table handler Error!!"
#define IDS_TEXTINFOMSGH		204 //"Information."
#define IDS_TEXTWARNMSGH		205 //"Warning!";
#define IDS_TEXTQUESTMSGH		206 //"What to do...?"
#define IDS_TEXTDEFMSGH 		207 //"Hmmm...";
#define IDS_CLEARCELLFAIL 		208 //"Failed to delete container - stopping";
#define IDS_PASTECELLFAIL 		209 //"Failed to paste container - stopping";
#define IDS_CLERRMAGICID 		210 //"Clipboard data:- incorrect magicid";
#define IDS_CLERRSETDATA 		211 //"Error - failed to set clipboard data"

#define IDS_NEW			 		217 //"new"
#define IDS_CHANGEBULLETS		218 //"change bullet settings"

/*** image strings ***/
#define IDS_LOADBMP		 		220 //"load bitmap";
#define IDS_LOADMETA			221 //"load metafile";
#define IDS_LOCKASPECT			222 //"change image aspect lock"
#define IDS_SCALEIMAGE			223 //"change image scale"
#define	IDS_EMBEDINSERT			224 //"Insert object"
#define	IDS_EMBEDUPDATE			225	//"Object settings"
#define	IDS_OKBUTTON			226	//"&Ok"
#define	IDS_CANCELBUTTON		227 //"&Cancel"
#define IDS_LOADFRAMES			228 //"load frames"

/*** text dialog strings ***/
#define IDS_FONTSAMPLE			230 //"AaBbCcDd"
#define IDS_SHEARSAMPLE 		231 // "SHEARshear"
#define IDS_EXTRASAMPLE			232 //"WAVESwaves"
#define IDS_STRETCHSAMPLE		233 //"STRETCHstretch"

#define IDFH_EDITTASKS			243 //"Select table editing tasks"
#define IDFH_TABLEOPTS			244 //"Select cell styles"

#define IDS_CTRLTXTSDATIME		251 //"Date Time - standard"
#define IDS_CTRLTXTADATIME		252 //"Date Time - alternate"
#define IDS_CTRLTXTMAULDATE		253 //"Date - Maul defined long"
#define IDS_CTRLTXTSLDATE		254 //"Date - standard long"
#define IDS_CTRLTXTALDATE		255 //"Date - alternate long"
#define IDS_CTRLTXTSSDATE		256 //"Date - standard short"
#define IDS_CTRLTXTASDATE		257 //"Date - alternate short"

#define IDS_CTRLTXTSTIME		263 //"Time - standard format"
#define IDS_CTRLTXTATIME		264 //"Time - alternate format"

/*** status bar strings ***/
#define IDFH_MODEMENU			400	//"What's this for?"
#define IDFHS_HANDIDENT			401	//"Table handler is active"
#define IDFHS_TABRANGE			402 //"Shows selected table range"
#define	IDFHS_FONTINFO			403 //"Shows currently selected font"
#define IDFH_FILLCOLOR			404	//"Fill colour"
#define IDFH_FILLPATTERN		405	//"Fill pattern"
#define IDFH_FILLSTYLE			406	//"Fill style"
#define IDFH_BORDCOLOR			410	//"Border colour"
#define IDFH_BORDWIDTH			411	//"Border width"
#define IDFH_BORDSTYLE			412	//"Border style"
#define IDFH_TEXTENTRY			420	//"Text edit mode"
#define IDFH_TEXTJUST			421	//"Text justification
#define IDFH_SELFONT			430	//"Select a font"
#define IDFH_SELFONTSZ			431	//"Select a font size"
#define	IDFH_TYPEFONTSZ			432	//"Enter a font size"
#define IDFH_SELFONTSTYLE		433	//"Select a font style"
#define IDFH_LISTBOX			440	//"Select from list"
#define IDFH_TEXTCOLOR			441  //"Set text colour"
#define IDFH_SELOUTLINE 		442  //"Outlined (hollow) text"
#define IDFH_SELUNLINE			443  //"Underlined text"
#define IDFH_SELSTRUCKOUT		444  //"Struck out text"
#define IDFH_SUPERSCR			445  //"Select Superscript"
#define IDFH_SUBSCRIPT			446  //"Select Subscript"
#define IDFH_DROPSHADOW 		447  //"Dropshadow text"
#define IDFH_REFLOWALL			448  //"Reflow all the text"
#define IDFH_VGNMENU			449  //"Set vertical text alignment"
#define IDFHS_SHOWSSTATUS		450  //"Shows cursor position, status"
#define	IDFH_BULLET	    		451 //"Select bullet list mode"
#define	IDFH_COUNTER	    	452 //"Select numeric list mode"

#define IDFH_EDITMODEINS		700	//"Insert new container"
#define IDFH_EDITMODEOVR		701	//"Edit current container"

/*** Container name strings ***/
#define IDS_CONTSTRINGBMP		800	//"Bitmap"
#define IDS_CONTSTRINGBORD		801	//"Border"
#define IDS_CONTSTRINGFILL		802	//"Fill"
#define IDS_CONTSTRINGENTRY		803	//"Generic Entry"
#define IDS_CONTSTRINGMETA		804	//"Windows Metafile"
#define IDS_CONTSTRINGMETAOS2	805	//"OS/2 Metafile"
#define IDS_CONTSTRINGFFTXT		806	//"Text"
#define IDS_CONTSTRINGCLIPRF	807	//"Frameset"

#define IDS_CONTSTRING			810	//"container(s)"
#define IDS_CUTSTRING			811	//"&Cut "
#define IDS_COPYSTRING			812	//"&Copy "
#define IDS_CLEARSTRING			813	//"&Clear "
#define IDS_PASTESTRING			814	//"&Paste "
#define IDS_SETSTRING			815	//"&Set "
#define IDS_STYLESTRING			816	//"style"
#define IDS_LANGORDER			817	//"123"

#define IDS_ITEMANY				820	//"any "
#define IDS_ITEMBMP				821	//"bitmap "
#define IDS_ITEMBORD			822	//"border "
#define IDS_ITEMFILL			823	//"fill "
#define IDS_ITEMENTRY			824	//"spare "
#define IDS_ITEMMETA			825	//"metafile "
#define IDS_ITEMMETAOS2			826	//"OS/2 metafile "
#define IDS_ITEMTEXT			827	//"text "
#define IDS_ITEMCLIPRF			828	//"frames "

//***** copied from language\src\maul\resource.h
#define IDFH_COLORSWATCH    1113  //"Click here for more..."

//#define IDFH_TEXT

/*******************************************************************************
    Dialogs
*******************************************************************************/
#define IDD_HELPBUTTON          100
#define IDD_RESETBUTTON         101
#define IDD_REFRESHBUTTON       102
#define IDD_SAVEBUTTON			103

#define PATTERN_SELECT_DLG      110
#define PATTERN_SELECT_NONE		111
#define PATTERN_SELECT_1		112
#define PATTERN_SELECT_2		113
#define PATTERN_SELECT_3		114
#define PATTERN_SELECT_4		115
#define PATTERN_SELECT_5		116
#define PATTERN_SELECT_6		117
#define PATTERN_SELECT_7		118
#define PATTERN_SELECT_8		119
#define PATTERN_SELECT_9		120
#define PATTERN_SELECT_10		121
#define PATTERN_SELECT_11		122
#define PATTERN_SELECT_12		123
#define PATTERN_SELECT_13		124
#define PATTERN_SELECT_14		125
#define PATTERN_SELECT_15		126
#define PATTERN_SELECT_16		127

#define SHADING_DLG             130
#define SHADING_ADD             131
#define SHADING_DEL             132
#define SHADING_UP              133
#define SHADING_DOWN            134
#define SHADING_LIST            135
#define SHADING_COLOR          	136
#define SHADING_WHEEL          	137
#define SHADING_COLIST         	138
#define SHADING_SPOTS          	139

#define IDD_ROTATEDLG           140
#define IDD_ROTATEACTUAL        141
#define IDD_ROTATEOBJECT        142
#define IDD_ROTATEENTRY         143
#define IDD_ROTATECONTROL       144

#define WIDTH_DLG				150
#define WIDTH_ENTRY				151
#define WIDTH_HELP				152
#define WIDTH_STAT				153

#define	IDD_ADVSHADEDLG			160
#define	IDD_ADVSHADEXFADE		161
#define	IDD_ADVSHADENORM		162
#define	IDD_ADVSHADECIRCLE		163
#define	IDD_ADVSHADECLOCK		164
#define	IDD_ADVSHADERUNIN		165
#define	IDD_ADVSHADERUNOUT		166
#define	IDD_ADVSHADERINSTAT		167
#define	IDD_ADVSHADEROUTSTAT	168

#define IDD_STYLE_DLG			170
#define IDD_STYLE_ENTRY			171
#define IDD_STYLE_DELETE		172
#define IDD_STYLE_GROUPBOX		173

#define IDD_FONTSUBSDLG			179

/** Font selection notebook dialogs **/
#define IDD_FONTDLG             400
#define IDD_FONTSUBDLG          401
#define IDD_ATTRSUBDLG          402
#define IDD_SPACESUBDLG       	403
#define IDD_SHEARSUBDLG         404

#define IDD_FONTSAMPLE          405
#define IDD_FONTPRIOR			406
#define IDD_FONTNEXT			407

#define IDD_FONTNAME            410
#define IDD_FONTSTYLE			411
#define IDD_FONTSIZE            412

#define IDD_FONTBOLD            414
#define IDD_FONTITALIC          415
#define IDD_FONTOUTLINE         416
#define IDD_FONTUNDERLINE       417
#define IDD_FONTSTRIKEOUT       418

#define IDD_EXTRASPSLIDER       420
#define IDD_EXTRASPENTRY        421
#define IDD_CHARWIDTHSLIDER     422
#define IDD_CHARWIDTHENTRY      423

#define IDD_SHEARACTUAL         425
#define IDD_SHEARVERTICE        426
#define IDD_SHEARENTRY          427
#define IDD_SHEARCONTROL        428
#define IDD_SHEARSAMPLE         429

/** end - Font selection notebook dialogs **/

#define IDD_PARAGRAPHDLG		200
#define IDD_PARAGRAPHLEAD		201
#define IDD_PARAGRAPHLEADSTAT	202
#define IDD_PARAGRAPHFSTLIND	203
#define IDD_PARAGRAPHFSTRIND	204
#define IDD_PARAGRAPHCOMLIND	205
#define IDD_PARAGRAPHCOMRIND	206
#define IDD_PARAICPYLEFT		207
#define IDD_PARAICPYDOWN		208

#define IDD_LINEDLG 			210
#define IDD_LINEJUSTLEFT		211
#define IDD_LINEJUSTRIGHT		212
#define IDD_LINEJUSTCENTER		213
#define IDD_LINEJUSTFULL		214
#define IDD_LINELEADING 		215
#define IDD_LINEVTOP 			216
#define IDD_LINEVMIDDLE 		217
#define IDD_LINEVBOTTOM 		218

#define IDD_TABSDLG 			220
#define IDD_TABSRULE			221
#define IDD_TABSSCROLL			222
#define IDD_TABSWIPE			223
#define IDD_TABSRESET			224

#define IDD_CTRLTXTDLG          232
#define IDD_CTRLTXTNBK          233
#define IDD_CTRLTXTPAGE1        234			//page numbers
#define IDD_CTRLTXTPAGE2        235			//counters
#define IDD_CTRLTXTPAGE3        236			//merge data
#define IDD_CTRLTXTPAGE4        237			//date & time
#define IDD_CTRLTXTPAGE5        238			//file & path
#define IDD_CTRLTXTPAGE6        239			//language

#define IDD_CTRLTXTPAGE         243
#define IDD_CTRLTXTNPAGES       244

#define IDD_CTRLTXTCOUNTER      245
#define IDD_CTRLTXTPSHCNT       246
#define IDD_CTRLTXTPOPCNT	    247
#define IDD_CTRLTXTLEFTBK       248
#define IDD_CTRLTXTRIGHTBK      249
#define IDD_CTRLTXTCNTMODE      250
#define IDD_CTRLTXTCNTSTYLE     251

#define IDD_CTRLTXTBULLET       252
#define IDD_CTRLTXTBLEFT        253
#define IDD_CTRLTXTBRIGHT       254
#define IDD_CTRLTXTBLEVEL       255

#define IDD_CTRLTXTMERGE        256
#define IDD_CTRLTXTMRGLIST      257

#define IDD_CTRLTXTDATE         258
#define IDD_CTRLTXTYEAR         259
#define IDD_CTRLTXTMONTH        260
#define IDD_CTRLTXTDAY          261
#define IDD_CTRLTXTWKDAY        262
#define IDD_CTRLTXTTIME         263
#define IDD_CTRLTXTHOURS        264
#define IDD_CTRLTXTMINS         265
#define IDD_CTRLTXTSECS         266
#define IDD_CTRLTXTPLAIN        267

#define IDD_CTRLTXTDLIST        268
#define IDD_CTRLTXTTLIST        269
#define IDD_CTRLTXTORDAY        270

#define IDD_CTRLTXTFILE         271
#define IDD_CTRLTXTPATH         272

#define IDD_CTRLTXTLANG         273
#define IDD_CTRLTXTLANGEN       274

#define IDD_TITLEXDLG			280
#define IDD_TITLEXSPIN			281
#define IDD_TITLEXSTATUS		282
#define IDD_TITLEXENTRY 		283
#define IDD_TITLEXURL 		    284

#define IDD_CHARDIRNDLG			290
#define IDD_CHARDIRLEFT			291
#define IDD_CHARDIRRIGHT		292
#define IDD_CHARDIRTOP			293
#define IDD_CHARDIRBOTTOM		294
#define IDD_CHARDIRSTROKEDN		295
#define IDD_CHARDIRSTROKEUP		296

#define	IDD_EQUATIONDLG			300
#define	IDD_EQUATIONENTRY		301
#define	IDD_EQUATIONSTATUS		302
#define	EQUATION_FIELDLENGTH	1024

#define IDD_BULLETDLG			310
#define IDD_BULLETDLG1			311
#define IDD_BULLETDLG2			312
#define IDD_BULLETISTAT			313
#define IDD_BULLETNONE			314
#define IDD_BULLETSELECT		315
#define IDD_BULLETDEFLT			316
#define IDD_BULLETSAMPLE		IDD_FONTSAMPLE
#define IDD_BULLETSCROLL		317

#define IDD_FERR_DLG			320
#define IDD_FERR_FUNC			321
#define IDD_FERR_FAMILY 		322
#define IDD_FERR_FONT			323
#define IDD_FERR_BTN			324
#define IDD_FERR_SEL			325
#define IDD_FERR_CPG			326
#define IDD_FERR_TYPE			327
#define IDD_FERR_USE			328
#define IDD_FERR_LCID			329
#define IDD_FERR_ERRID			330

#define IDD_BORDERDLG			340
#define IDD_BORDERSTYLE			341
#define IDD_BORDERLINES			342
#define IDD_BORDERRIGHT			343
#define IDD_BORDERBOTTOM		344
#define IDD_BORDEROVERLAY		345

#define IDD_CHARTSZDLG			350
#define IDD_CHARTCOLS			351
#define IDD_CHARTROWS			352

#define IDD_DROPSHADOWDLG       360
#define IDD_DROPSROTATECTRL     361
#define IDD_DROPSROTATEENTR     362
#define IDD_DROPSDISTENTRY      363
#define IDD_DROPSENABLE         364
#define IDD_DROPSCOLOR          365
#define IDD_DROPSWHEEL          366
#define IDD_DROPSCOLIST         367
#define IDD_DROPSSPOTS          368

#define IDD_CODEPAGEDLG			370
#define IDD_CODEPAGENBK			371
#define IDD_CODEPAGE1			372
#define IDD_CODEPAGE2			373
#define IDD_LANGUAGELIST		374
#define IDD_CODEPAGELIST		375
#define IDD_CODEPAGE3			376
#define IDD_CODEPAGEDOS			300
#define IDD_CODEPAGEWIN			301
#define IDD_CODEPAGEGPI			302

#define IDD_SCALEDLG            380
#define IDD_SCALEXENTRY         381
#define IDD_SCALEXUP            382
#define IDD_SCALEXDOWN          383
#define IDD_SCALEXSLIDER        384
#define IDD_SCALEYENTRY         385
#define IDD_SCALEYUP            386
#define IDD_SCALEYDOWN          387
#define IDD_SCALEYSLIDER        388
#define IDD_SCALESAMPLE         389
#define IDD_SCALELOCK           390
#define IDD_SCALEBIGX           391
#define IDD_SCALEBIGY           392

#define IDD_SEARCHDLG			500    /*** Search Dialog	   ***/
#define IDD_SEARCHFIELD 		501    /* Entry Field			 */
#define IDD_CHALLBUTTON 		502    /* Push Button			 */
#define IDD_CASEBUTTON			503    /* Checkbox				 */
#define IDD_RVRSBUTTON			504    /* Checkbox				 */
#define IDD_CHANGEFIELD 		505    /* Entry Field			 */
#define IDD_FINDITEM			506    /* Static Text			 */
#define IDD_CHANGEITEM			507    /* Static Text			 */
#define IDD_FINDBUTTON			508    /* Push Button			 */
#define IDD_CHGFNDBUTTON		509    /* Push Button			 */
#define IDD_CHANGEBUTTON		510    /* Push Button			 */

#define IDD_IMPORTDLG			550

#define IDD_EMBED_DLG			640
#define IDD_EMBEDNBK          	641

#define IDD_EMBED_DLG1			660
#define IDD_EMBED_DLG2			661
#define IDD_EMBED_DLG3			662

#define IDD_EMBED_OFFS			642
#define IDD_EMBED_SIZE			643
#define IDD_EMBED_DEFSZ			644
#define IDD_EMBED_FIT			645
#define IDD_EMBED_FLOW			646
#define IDD_EMBED_NONE			647

#define IDD_EMBED_LMARG			648
#define IDD_EMBED_RMARG			649
#define IDD_EMBED_TMARG			650
#define IDD_EMBED_BMARG			651

#define IDD_EMBED_BMP			652
#define IDD_EMBED_MET			653
#define IDD_EMBED_FOB			654
#define IDD_EMBED_PASTE			655
#define IDD_EMBED_LOAD			656
#define IDD_EMBED_CATALOG		657

#define IDD_KERNDLG				670
#define IDD_KERNENABLE			671

#define IDD_SELCHARDLG			690
#define IDD_SELCHARLIST			691
#define IDD_SELCHARSCROLL		692
#define IDD_SELCHARSPIN			693

#define IDD_MERGEDLG2			719
#define IDD_MERGEDLG			720
#define IDD_MERGELOAD			721
#define IDD_MERGESAVE			722
#define IDD_MERGECLEAR			723
#define IDD_MERGELIST			724
#define IDD_MERGEINC			725

#define IDD_EDITCONTRDLG		740
#define IDD_EDITCONTRLIST		741
#define IDD_EDITCONTRTOP		742
#define IDD_EDITCONTRBOT		743
#define IDD_EDITCONTRLEFT		744
#define IDD_EDITCONTRRIGHT		745
#define IDD_EDITCONTRALTL		746
#define IDD_EDITCONTRALTR		747

#define IDD_POPUPDLG			750
#define IDD_POPUPMSG			751

#define IDD_ARTICLEDLG			760
#define IDD_ARTICLENAME			761
#define IDD_ARTICLAUTH			762
#define IDD_ARTICLDATE			763
#define IDD_ARTICLDEST			764
#define IDD_ARTICLINFO			765

#define IDD_FOOTNOTEDLG			800
#define IDD_FOOTNOTETITLE		801
#define IDD_FOOTNOTEBODY		802

/**** new stuff****/

#define IDD_PCBARDIALOG 		230
#define IDD_PERCENTBAR			231

#endif
