/******************************************************************************
    Frame handler resources
    (c)Peter Koller 1998
******************************************************************************/
#ifndef FRAMEHAND_RESOURCES
#define FRAMEHAND_RESOURCES

#define     PROF_STYLESHEET     ",ssh"
#define     PROF_LOADIMG        ",loadstyle"
#define     PROF_RESUME         "resume"
#define     DEF_STYLESHEET      "*"
#define     EXT_STYLESHEET		".ssh"

#define     WC_TABSRULER        "MaulfftTbr"
#define     HTP_SPELLCHECK      "SPELLCHECK"
#define		MERGEBASE_ID		'bmxt'

#define     SC_ESC          0x01

/*******************************************************************************
    pointers
*******************************************************************************/
#define IDPTR_IBEAM         10
#define IDPTR_CHAIN         11
#define IDPTR_STDTAB        12
#define IDPTR_NUMTAB        13
#define IDPTR_KILLTAB       14
#define IDPTR_DEFEDIT       15
#define IDPTR_ANCHOR        16

/*******************************************************************************
    RCDATA descriptions
*******************************************************************************/
#define IDACC_DEFLTKEYS		40

/*******************************************************************************
    bitmaps
*******************************************************************************/
#define IDBMP_BOLDTXT       1000
#define IDBMP_ITALTXT       1001
#define IDBMP_OUTLTXT       1002
#define IDBMP_ULINTXT       1003
#define IDBMP_STRKTXT       1004
#define IDBMP_SUPRTXT       1005
#define IDBMP_SUBSTXT       1006
#define IDBMP_LFTJUST       1007
#define IDBMP_RGTJUST       1008
#define IDBMP_CNTJUST       1009
#define IDBMP_ALLJUST       1010
#define IDBMP_IBEAM         1011
#define IDBMP_COLORFILL     1012
#define IDBMP_CHAINLNK      1013
#define IDBMP_CHAINUNL      1014
#define IDBMP_REFLOW        1015
#define IDBMP_DROPSHADOW    1016
#define IDBMP_FONT          1017
#define IDBMP_LINKSTAT      1018
#define IDBMP_POSNSTAT      1019
#define IDBMP_POSNRED       1020
#define IDBMP_POSNGREEN     1021

#define IDBMP_WINGSTAMP     1022

#define IDICON_FINDDLG      1023

#define IDBMP_ANCHOR        1024
#define IDBMP_BULLET        1025
#define IDBMP_COUNTER       1026

/*******************************************************************************
    add on char menu
*******************************************************************************/

/*******************************************************************************
    edit menu
*******************************************************************************/
#define HAND_REMOVE         (FIRST_MENU_ID + 1)
#define TXT_CUT             (FIRST_MENU_ID + 2)
#define TXT_COPY            (FIRST_MENU_ID + 3)
#define TXT_PASTE           (FIRST_MENU_ID + 4)
#define TXT_LOADFILE        (FIRST_MENU_ID + 5)
/** **/
#define TXT_CLEAR           (FIRST_MENU_ID + 6)
/** **/
#define TXT_SELECTALL       (FIRST_MENU_ID + 7)
#define TXT_DESELECTALL     (FIRST_MENU_ID + 8)
/** **/
/** **/
#define TXT_SELCHAR			(FIRST_MENU_ID + 9)
#define TXT_FLUSH			(FIRST_MENU_ID + 10)
#define TXT_EMBEDDED		(FIRST_MENU_ID + 11)
#define TXT_ANCHOR			(FIRST_MENU_ID + 12)
#define TXT_FOOTNOTE		(FIRST_MENU_ID + 13)
#define TXT_CTRLTXT 		(FIRST_MENU_ID + 14)
#define TXT_SELMERGE		(FIRST_MENU_ID + 15)
/** **/
#define TXT_FIND            (FIRST_MENU_ID + 16)
#define TXT_WORDCOUNT       (FIRST_MENU_ID + 17)
#define TXT_SPELLCHK		(FIRST_MENU_ID + 18)
#define TXT_ARTINFO			(FIRST_MENU_ID + 19)
/** **/
#define TXT_LINKMODE        (FIRST_MENU_ID + 20)
#define TXT_ULNKMODE        (FIRST_MENU_ID + 21)
#define TXT_BREAKLINK       (FIRST_MENU_ID + 22)
/** **/

/** Second menu **/
#define TXT_ORIENT			(FIRST_MENU_ID + 24)
#define TXT_CODEPAGE		(FIRST_MENU_ID + 25)
#define TXT_NOWIDOWS		(FIRST_MENU_ID + 26)
#define TXT_DIRECTION		(FIRST_MENU_ID + 27)
#define TXT_EXCLUDEWHT		(FIRST_MENU_ID + 28)
/** **/
#define TXT_PGRAPH			(FIRST_MENU_ID + 29)
/** **/
#define TXT_LINE			(FIRST_MENU_ID + 30)
#define TXT_TABS			(FIRST_MENU_ID + 31)
/** **/
#define TXT_FONT			(FIRST_MENU_ID + 32)
#define TXT_COLOR			(FIRST_MENU_ID + 33)
#define TXT_KERN			(FIRST_MENU_ID + 34)
#define TXT_DROPSHADOW		(FIRST_MENU_ID + 35)
#define TXT_BULLET			(FIRST_MENU_ID + 36)
/** **/
#define TXT_LOLLIST 		(FIRST_MENU_ID + 37)
/** **/
#define TXT_SUPERSTR		(FIRST_MENU_ID + 38)
#define TXT_SUBSTR			(FIRST_MENU_ID + 39)
/** **/
#define TXT_EXTRACT 		(FIRST_MENU_ID + 40)
/** **/
#define TXT_ALLTITLES		(FIRST_MENU_ID + 41)
#define TXT_ALLFTNOTES		(FIRST_MENU_ID + 42)
/** **/
#define TXT_SETSTYLE		(FIRST_MENU_ID + 43)

#define TXT_BGCOLOR 		(FIRST_MENU_ID + 44)
#define TXT_MULTI			(FIRST_MENU_ID + 45)
#define TXT_REVERSE 		(FIRST_MENU_ID + 46)
#define TXT_HYPHENATE 		(FIRST_MENU_ID + 47)
#define TXT_SMARTQUOTE 		(FIRST_MENU_ID + 48)

#define SCND_MENU_ID        (FIRST_MENU_ID + 50)
#define THRD_MENU_ID        (FIRST_MENU_ID + 51)
#define FOUR_MENU_ID        (FIRST_MENU_ID + 52)

#define TXT_STYLESEL		(FIRST_MENU_ID + 60)

/*******************************************************************************
    button bar
*******************************************************************************/
#define     IDC_FONTSEL     FIRST_BBAR_ID
#define 	IDC_FONTSTYLE	(FIRST_BBAR_ID + 1)
#define 	IDC_FONTSIZE	(FIRST_BBAR_ID + 2)
#define 	IDB_ULINTXT 	(FIRST_BBAR_ID + 3)
#define 	IDB_OUTLTXT 	(FIRST_BBAR_ID + 4)
#define 	IDB_STRKTXT 	(FIRST_BBAR_ID + 5)
#define 	IDB_SUPRTXT 	(FIRST_BBAR_ID + 6)
#define 	IDB_SUBSTXT 	(FIRST_BBAR_ID + 7)
#define 	IDB_LFTJUST 	(FIRST_BBAR_ID + 8)
#define 	IDB_RGTJUST 	(FIRST_BBAR_ID + 9)
#define 	IDB_CNTJUST 	(FIRST_BBAR_ID + 10)
#define 	IDB_ALLJUST 	(FIRST_BBAR_ID + 11)
#define 	IDB_COLORFILL	(FIRST_BBAR_ID + 12)
#define 	IDB_CHAINLNK	(FIRST_BBAR_ID + 13)
#define 	IDB_CHAINUNL	(FIRST_BBAR_ID + 14)
#define 	IDB_REFLOW		(FIRST_BBAR_ID + 15)
#define 	IDB_DROPSHADOW	(FIRST_BBAR_ID + 16)
#define 	IDB_ANCHOR		(FIRST_BBAR_ID + 17)
#define 	IDB_BULLET		(FIRST_BBAR_ID + 18)
#define 	IDB_COUNTER		(FIRST_BBAR_ID + 19)

/*******************************************************************************
    status bar
*******************************************************************************/
#define     IDS_HANDIDENT   FIRST_STAT_ID
#define     IDS_FLAGINFO    (FIRST_STAT_ID + 1)
#define     IDS_FONTINFO    (FIRST_STAT_ID + 2)
#define     IDS_LINKAGE     (FIRST_STAT_ID + 3)
#define     IDS_TESTMSG     (FIRST_STAT_ID + 4)


/*******************************************************************************
    help table
*******************************************************************************/

/*******************************************************************************
    string defs
*******************************************************************************/
#define IDS_HELPWINTITLE        16  //"Maul text handler help"
#define IDS_HELPLIBRARY 		17	//"txthand.hlp"
#define IDS_NEWTEXTWIN			18	//"new text window"
#define IDS_DELETEHAND			19	//"Remove text handler from frame"
#define IDS_ADDFONT 			20	//"add font"
#define IDS_DELFONT 			21	//"delete font"
#define IDS_CHANGEFONT			22	//"change font"
#define IDS_ADDTEXT 			23	//"add text"
#define IDS_DELTEXT 			24	//"delete text"
#define IDS_CUTTEXT 			25	//"cut text"
#define IDS_PASTETEXT			26	//"paste text"
#define IDS_TEXTSIZE			27	//"change text size"
#define IDS_TEXTCOLOR			28	//"change text colour"
#define IDS_TEXTANGLE			29	//"change text angle"
#define IDS_LINETYPE			30	//"change text line style"
#define IDS_PARAINDENTS 		31	//"change paragraph style"
#define IDS_LINEJUSTIFY 		32	//"change justification"
#define IDS_CHANGEPOS			33	//"text formatting"
#define IDS_TEXTSHEAR			34	//"change text shear"
#define IDS_FONTCREATEERROR 	35	//"F1 - font creation failed"
#define IDS_FNTMETRICSERROR 	36	//"F2 - get font metrics failed"
#define IDS_TEXTEMPHASIS		37	//"change text emphasis"
#define IDS_TEXTTITLEEXTA		38	//"change text title marker"
#define IDS_CHAREXTRA			39	//"change character spacing"
#define IDS_TEXTDIRN			40	//"change text direction"
#define IDS_BOUNDARYFINDERROR	41	//"B1 - boundary determination failed"
#define IDS_CHARSTRETCH 		42	//"change character stretch width"
#define IDS_TEXTSTYLESHEET		43	//"apply text stylesheet"
#define IDS_CHAINAVAILABLE		44	//"Available"
#define IDS_CHAINLINKED 		45	//"linked"
#define IDS_CHAINCUROBJ 		46	//"From object #%d in %d"
#define IDS_CHAINNOTAVAIL 		47	//"Not available"
#define IDS_DEADFONTMSG 		48	//"ALMOST FATAL ERROR - Corrupt font, font not found!"
#define IDS_SETTABS 			49	//"change tab settings"
#define IDS_MOVECHAINSTRT		50	//"move chain data"
#define IDS_SEEK_NOTFOUND		51	//"Search string not found!"
#define IDS_BGCOLOR 			52	//"change background colour"
#define IDS_MULTISTRK			53	//"change text repeat mode"
#define IDS_EXCLUSION			54	//"change text boundary whitespace"
#define IDS_UPDATEVERSION		55	//"change text to version 4"
#define IDS_SEGMENTID			56	//"change wingtext start segment"
#define IDS_FFTEXTTABS			57	//"&FFText tabs..."
#define IDS_REVERSESTRK 		58	//"change text reverse mode"
#define IDS_TEXTSCALING 		59	//"change text scale"
#define IDS_DROPSHADOW			60	//"change text dropshadow"
#define IDS_FLUSHBREAK			61	//"insert flush break"
#define IDS_EMBEDDED			62	//"insert object"
#define IDS_EMBEDDED_UPD		63	//"update object"
#define	IDS_OKBUTTON			64	//"&Ok"
#define	IDS_CANCELBUTTON		65  //"&Cancel"
#define IDS_TEXTKERN			66	//"change text kerning"
#define IDS_LIMITERR			67	//"Initial LOL list is corrupted, copy text and remove & reselect handler to fix!"
#define IDS_HANDMENU			68	//"Ch&aracter"
#define IDS_TEXTQUOTES			69	//"change text quotes"

#define IDS_CHAINERROR1			70  //"E1, already in use"
#define IDS_CHAINERROR2         71  //"E2, cannot use borders"
#define IDS_CHAINERROR4 		72	//"E3, chain not editable"
#define IDS_CHAINERROR5 		73	//"E4, chain corrupt!"
#define IDS_CHANGEHYPHEN 		74	//"Change text hyphenation"
#define IDS_WIDOWFLAG			75	//"change orphan/widow settings"
#define IDS_LINKINSERT			76	//"linked: insert"
#define IDS_LINKADD				77	//"none: add"
#define IDS_ADDFOOTNT			78	//"insert footnote"
#define IDS_EDITFOOTNT			79	//"change footnote"

/*** command.c ***/
#define IDS_WORDCOUNTMSG		80	//"This article contains %d words."
#define IDS_WORDCOUNTTITLE		81	//"Word Count"
/*** ctrlmgr.c ***/
#define IDS_BADCONTROLTEXT		82	//"!bad ctrtxt!"
/*** dialog.c ***/
//replace parm: max string size = 16
#define IDS_PAGEREPLACEPARM 	83	//"$(PAGE)"
#define IDS_LEVELREPLACEPARM	84	//"$(LEVEL)"
#define IDS_TABREPLACEPARM		85	//"$(TAB)"

#define IDS_STYLEEXISTMSG		86	//"Style sheet exists, overwrite"
#define IDS_STYLEDELETEMSG		87	//"Delete this style sheet"
#define IDS_FONTSAMPLE			88	//"AaBbCcDd"
#define IDS_SHEARSAMPLE 		89	//"SHEARshear"
#define IDS_EXTRASAMPLE 		90	//"WAVESwaves"
#define IDS_STRETCHSAMPLE		91	//"STRETCHstretch"
#define IDS_LOLLISTFONTMSG		92	//"Font, %s em="
#define IDS_LOLLISTFBOLD		93	//"B"
#define IDS_LOLLISTFITAL		94	//"I"
#define IDS_LOLLISTFUNDLN		95	//"U"
#define IDS_LOLLISTFOUTLN		96	//"O"
#define IDS_LOLLISTFSTRKOUT 	97	//"S"
#define IDS_LOLLISTPARAMSG		98	//"Paragraph, lead:%gpt, 1st_left:%gpt, 1st_right:%gpt, left:%gpt, right:%gpt"
#define IDS_LOLLISTCOLORMSG 	99	//"Colour, %.8X "
#define IDS_LOLLISTFONTSZMSG	100	//"Fontsize %g points"
#define IDS_LOLLISTDIRNLEFT 	101	//"Direction, left to right"
#define IDS_LOLLISTDIRNRIGHT	102	//"Direction, right to left"
#define IDS_LOLLISTDIRNUP		103 //"Direction, bottom to top"
#define IDS_LOLLISTDIRNDOWN 	104 //"Direction, top to bottom"
#define IDS_LOLLISTDIRNUNKN 	105 //"Direction, unknown"
#define IDS_LOLLISTSHEARMSG 	106 //"Shear, %g"
#define IDS_LOLLISTDROPSMSG 	107 //"Dropshadow, %g%%, %g"
#define IDS_LOLLISTTABSMSG		108 //"Tablist, %d tabs"
#define IDS_LOLLISTCTRLTXTMSG	109 //"Control Text, type:- "
#define IDS_LOLLISTCTFULLDATE	110 //"full date"
#define IDS_LOLLISTCTYEAR		111 //"year"
#define IDS_LOLLISTCTMONTH		112 //"month"
#define IDS_LOLLISTCTDAY		113 //"day"
#define IDS_LOLLISTCTWKDAY		114 //"day of week"
#define IDS_LOLLISTCTFULLTIME	115 //"time"
#define IDS_LOLLISTCTHOURS		116 //"hours"
#define IDS_LOLLISTCTMINS		117 //"minutes"
#define IDS_LOLLISTCTSECS		118 //"seconds"
#define IDS_LOLLISTCTFILE		119 //"filename"
#define IDS_LOLLISTCTPATH		120 //"filepath"
#define IDS_LOLLISTCTPAGE		121 //"page"
#define IDS_LOLLISTCTNPAGES 	122 //"number of pages"
#define IDS_LOLLISTEMPHSUBSC	123 //"Emphasis, subscript"
#define IDS_LOLLISTEMPHSUPER	124 //"Emphasis, superscript"
#define IDS_LOLLISTEMPHNONE 	125 //"Emphasis, none"
#define IDS_LOLLISTTITLEMSG 	126 //"Title, level %d"
#define IDS_LOLLISTKERNMSG		127 //"Char Kerning, %g points"
#define IDS_LOLLISTSTRETCHMSG	128 //"Char Stretch, %g points"
#define IDS_LOLLISTUNKNOWN		129 //"Unknown LOL, id = %d, len = %d"
#define IDS_NONE 				130 //"none"
#define	IDS_EMBEDINSERT			131 //"Insert object"
#define	IDS_EMBEDUPDATE			132	//"Object settings"
#define	IDS_FOOTNOTEINSERT		133 //"Insert footnote"
#define	IDS_FOOTNOTEUPDATE		134	//"Edit footnote"
#define IDS_LOLLISTTRKMSG		135 //"Char Spacing, %g %%"
#define IDS_CHARDIRN            136 //"change char direction"
#define IDS_MERGEDATA           137 //"change merge database"
#define IDS_CODEPAGE			138 //"change text codepage"
#define	IDS_MERGEFILTER			139 //"Comma separated list\0*.csv;*.csl\0All files\0*.*\0"
#define IDS_MERGEROW            140 //"change merge row"
#define IDS_UNDOGENERIC         141 //"change article info"
#define IDS_NOSTYLESHEET		142  //"No stylesheet is selected"

#define IDS_COUNTMODES			143	//"()\0[]\0{}\0<>\0,\0:\0;\0\0"
#define IDS_COUNTSTYLES			144	//"1,2,3,\0a,b,c,\0A,B,C,\0i..iv,v,\0I..IV,V,\0\0"
#define IDS_TEXTMARKERS			145	//"Off+Title 1+Title 2+Title 3+Title 4+Title 5+Title 6+Title 7+Title 8+URL link"
#define IDS_FOOTSTYLES			146	//"1,2,3,\0a,b,c,\0A,B,C,\0i..iv,v,\0I..IV,V,\0Title text\0\0"
#define IDS_NEW			 		147 //"new"
#define IDS_CHANGEBULLETS		148 //"change bullet settings"

/*** edit .c ***/
#define IDS_TPOSFORMATSTAT		150 //"L%d%s%d,%s%s"
#define IDS_BLNKFORMATSTAT		151 //"L  %s  ,%s%s",
#define IDS_NULLFORMATCHAR		152 //"."
#define IDS_TABFORMATCHAR		153 //"t"
#define IDS_LOLFORMATCHAR		154 //"*"
#define IDS_DEFFORMATCHAR		155 //":"
#define IDS_PRIORLINKSTAT		156 //"<"
#define IDS_NEXTLINKSTAT		157 //">"
#define IDS_BOTHLINKSTAT		158 //"<>"
#define IDS_CLIPBOARDERROR		159 //"Error - failed to save clipboard data"

#define IDS_HANDLERTYPE0     	170  //"FFTXT Text"
#define IDS_HANDLERTYPE1     	171  //"Wingstamp express"
#define IDS_HANDLERTYPE2     	172  //"Plain text (*.fft, *.txt)"
#define IDS_HANDLERTYPE3     	173  //"Plain text (*.fft, *.txt)"
#define IDS_HANDLERTYPE4     	174  //"FFTXT mergebase hookproc"
#define IDS_HANDLERNAME0		175  //"Text handler"
#define IDS_HANDLERNAME1		176  //"Text along borders handler"
#define IDS_HANDLERNAME2		177  //"Import native text formats"
#define IDS_HANDLERNAME3		178  //"Export native text formats"
#define IDS_HANDLERNAME4		179  //"Autoincrements the merge database rows"

/*** fontenum.c ***/
#define IDS_FONTLCIDINVALID 	190 //"Error: Font ID unusable"
#define IDS_FONTLCIDEXCEED		191 //"Error: Font ID out of range"
#define IDS_FONTLCIDINUSE		192 //"Error: Font ID already used"
#define IDS_FONTFINDERROR		193 //"Font not found: using default font"
#define IDS_FONTFULLERROR		194 //"Error: No room for additional fonts"
#define IDS_DEFAULTFONTNAME 	195 //"Arial"
#define	IDS_NORMAL				196 //"normal"

/*** format.c ***/
/*** genfim.c ***/
/*** import.c ***/
#define IOTEX_LEN				8
#define IOTEX_STRING			56
#define IDS_FFTXTEXTENSION		200 //"*.ftx"
#define IDS_PLAINEXTENSION		201 //"*.txt"
#define IDS_IOTFFTXT			202 //"FFTXT (*.ftx)"
#define IDS_IOTPLAIN			203 //"Text (*.txt)"
#define IDS_EXPORTTITLE 		204 //"Export text"
#define IDS_EXPORTBUTTON		205 //"Export"
#define IDS_IMPORTTITLE 		206 //"Import text"
#define IDS_IMPORTBUTTON		207 //"Import"
#define IDS_AUTHORNAME			208 //"By %s"
#define IDS_UNKNOWN				209 //"Unbekannt"
/*** lolmgr.c ***/
/*** message.c ***/
#define IDS_TEXTERRMSGH 		210 //"Texthandler Error!!"
#define IDS_TEXTINFOMSGH		211 //"Information."
#define IDS_TEXTWARNMSGH		212 //"Warning!";
#define IDS_TEXTQUESTMSGH		213 //"What to do...?"
#define IDS_TEXTDEFMSGH 		214 //"Hmmm...";
/*** paint.c ***/
//max len = 10
#define IDS_FORMATOVERRUN		220 //">>>"

#define IDS_CTRLTXTSDATIME		221 //"Date Time - standard"
#define IDS_CTRLTXTADATIME		222 //"Date Time - alternate"
#define IDS_CTRLTXTMAULDATE		223 //"Date - Maul defined long"
#define IDS_CTRLTXTSLDATE		224 //"Date - standard long"
#define IDS_CTRLTXTALDATE		225 //"Date - alternate long"
#define IDS_CTRLTXTSSDATE		226 //"Date - standard short"
#define IDS_CTRLTXTASDATE		227 //"Date - alternate short"

#define IDS_CTRLTXTSTIME		233 //"Time - standard format"
#define IDS_CTRLTXTATIME		234 //"Time - alternate format"

#define IDS_LOLLISTLANGUAGE		238 //"language"
#define IDS_LOLLISTLANGUEN  	239 //"language - in english"

/*** paintsrv.c ***/
/*** profile.c ***/
/*** spellmgr.c ***/
/*** txthand.c ***/
#define IDS_OFFSTRING			243 //"off"
#define IDS_MERGEMENU			244 //"Select ~merge data..."
#define IDS_TEXTOBJMENU			245 //"~Text options"
#define IDS_NEWOBJSTAT			246 //"[Default settings for new objects]"
#define IDS_DEFQUOTES			247 //"~Intelligent text quotes"
#define IDS_DEFORPHANS			248 //"~Suppress orphans/widows"

/*** wingedit.c ***/
/*** winghand.c ***/
/*** wingpnt.c ***/

#define IDFH_CSELSTYLE			250 //"Current font style"
#define IDFH_CSELFONT			251 //"Currently selected font"
#define IDFH_CSELSIZE			252 //"Edit with this font size"
#define IDFH_EDITTASKS			253 //"Select text editing tasks"
#define IDFH_TEXTOPTS			254 //"Select text options"
#define IDFH_TEXTFONTCOLS		255 //"Select text font colours"
#define IDFH_SELFONT			256 //"Select a font"
#define IDFH_SELFONTSZ			257 //"Select a font size"
#define IDFH_SELFONTSTYLE		258 //"Select a font style"
#define IDFH_SELOUTLINE 		259 //"Outlined (hollow) text"
#define IDFH_SELUNLINE			260  //"Underlined text"
#define IDFH_SELSTRUCKOUT		261  //"Struck out text"
#define IDFH_LEFTJUST			262  //"Left justify text"
#define IDFH_RIGHTJUST			263  //"Right justify text"
#define IDFH_CTRJUST			264  //"Center text"
#define IDFH_FULLJUST			265  //"Fully justify text"
#define IDFH_LINKTO 			266  //"Link to another frame"
#define IDFH_UNLINK 			267  //"Unlink this frame"
#define IDFH_REFLOWALL			268  //"Reflow all the text"
#define IDFH_SUPERSCR			269  //"Select Superscript"
#define IDFH_SUBSCRIPT			270  //"Select Subscript"
#define IDFH_SHOWSFONT			271  //"Shows currently selected font"
#define IDFH_SHOWSSTATUS		272  //"Shows cursor position, status"
#define IDFH_SHOWLINKAGE		273  //"Linkage indicator"
#define IDFH_TEXTHANDLER		274  //"The plain text handler is active"
#define IDFH_DROPSHADOW 		275  //"Dropshadow text"
#define IDFH_LISTBOX			276  //"Select from list"
#define	IDS_REFORMATALL         277 //"~Mark all frames to reformat text"
#define	IDS_REFORMATMSG         278 //"Mark all frames as invalid and force a repaint in order to recalculate and reformat everything"

#define	IDS_ADDANCHOR	        286 //"insert anchored frame(s)"
#define	IDS_EDITANCHOR	        287 //"change anchored frame options"
#define	IDS_CLRANCHOR	        288 //"remove anchor"
#define	IDS_ANCHORSTATSET	    289 //"Select anchor"
#define	IDS_ANCHORSTATCLR	    290 //"Anchor is set %x%x"
#define	IDS_ANCHORUSETHIS	    291 //"~Get this anchor"
#define	IDS_ANCHORSETTHIS	    292 //"~Use anchor:- %x%x"
#define	IDFH_ANCHOR	    		293 //"Anchor frame to paragraph"
#define	IDFH_BULLET	    		294 //"Select bullet list mode"
#define	IDFH_COUNTER	    	295 //"Select numeric list mode"

/*******************************************************************************
    Dialogs
*******************************************************************************/
#define IDD_HELPBUTTON          100
#define IDD_SAVEBUTTON          101
#define IDD_RESETBUTTON         102

#define IDD_ROTATEDLG           110
#define IDD_ROTATEACTUAL        111
#define IDD_ROTATEOBJECT        112
#define IDD_ROTATEENTRY         113
#define IDD_ROTATECONTROL       114

#define IDD_STYLE_DLG           120
#define IDD_STYLE_ENTRY         121
#define IDD_STYLE_DELETE        122

#define IDD_PARAGRAPHDLG		130
#define IDD_PARAGRAPHLEAD		131
#define IDD_PARAGRAPHLEADSTAT	132
#define IDD_PARAGRAPHFSTLIND	133
#define IDD_PARAGRAPHFSTRIND	134
#define IDD_PARAGRAPHCOMLIND	135
#define IDD_PARAGRAPHCOMRIND	136
#define IDD_PARAGRAPHBULLIND	137
#define IDD_PARAGRAPHDROPCAP	138
#define IDD_PARAGRAPHDROPSIZE	139
#define IDD_PARAGRAPHDROPOFFS	140
#define IDD_PARAGRAPHDROPXCL	141
#define IDD_PARAICPYLEFT		142
#define IDD_PARAICPYDOWN		143

#define IDD_WLINEDLG            149
#define IDD_LINEDLG             150
#define IDD_LINEJUSTLEFT        151
#define IDD_LINEJUSTRIGHT       152
#define IDD_LINEJUSTCENTER      153
#define IDD_LINEJUSTFULL        154
#define IDD_LINELEADING         155
#define IDD_LINETILTWEDGE       156

/** Font selection notebook dialogs **/
#define IDD_FONTDLG             160
#define IDD_FONTSUBDLG          161
#define IDD_ATTRSUBDLG          162
#define IDD_SPACESUBDLG       	163
#define IDD_SHEARSUBDLG         164

#define IDD_FONTSAMPLE          165
#define IDD_FONTPRIOR			166
#define IDD_FONTNEXT			167

#define IDD_FONTNAME            170
#define IDD_FONTSTYLE			171
#define IDD_FONTSIZE            172

#define IDD_FONTBOLD            174
#define IDD_FONTITALIC          175
#define IDD_FONTOUTLINE         176
#define IDD_FONTUNDERLINE       177
#define IDD_FONTSTRIKEOUT       178

#define IDD_EXTRASPSLIDER       180
#define IDD_EXTRASPENTRY        181
#define IDD_CHARWIDTHSLIDER     182
#define IDD_CHARWIDTHENTRY      183

#define IDD_SHEARACTUAL         185
#define IDD_SHEARVERTICE        186
#define IDD_SHEARENTRY          187
#define IDD_SHEARCONTROL        188
#define IDD_SHEARSAMPLE         189

/** end - Font selection notebook dialogs **/


#define IDD_TABSDLG             200
#define IDD_TABSRULE            201
#define IDD_TABSSCROLL          202
#define IDD_TABSWIPE            203
#define IDD_TABSRESET           204

#define IDD_CHAINDLG            210
#define IDD_CHAINSTATS          211
#define IDD_CHAINDLGII          214
#define IDD_CHAINFROMGRP        215
#define IDD_CHAINPRIOR          216
#define IDD_CHAINNEXT           217

#define IDD_TITLEXDLG           220
#define IDD_TITLEXSPIN          221
#define IDD_TITLEXSTATUS        222
#define IDD_TITLEXURL		    223

#define IDD_PCBARDIALOG         230
#define IDD_PERCENTBAR          231

#define IDD_CTRLTXTDLG          232
#define IDD_CTRLTXTNBK          233
#define IDD_CTRLTXTPAGE1        234			//page numbers
#define IDD_CTRLTXTPAGE2        235			//counters
#define IDD_CTRLTXTPAGE3        236			//merge data
#define IDD_CTRLTXTPAGE4        237			//date & time
#define IDD_CTRLTXTPAGE5        238			//file & path
#define IDD_CTRLTXTPAGE6        239			//language

#define IDD_CTRLTXTPAGE         243
#define IDD_CTRLTXTNPAGES       244

#define IDD_CTRLTXTCOUNTER      245
#define IDD_CTRLTXTPSHCNT       246
#define IDD_CTRLTXTPOPCNT	    247
#define IDD_CTRLTXTLEFTBK       248
#define IDD_CTRLTXTRIGHTBK      249
#define IDD_CTRLTXTCNTMODE      250
#define IDD_CTRLTXTCNTSTYLE     251

#define IDD_CTRLTXTBULLET       252
#define IDD_CTRLTXTBLEFT        253
#define IDD_CTRLTXTBRIGHT       254
#define IDD_CTRLTXTBLEVEL       255

#define IDD_CTRLTXTMERGE        256
#define IDD_CTRLTXTMRGLIST      257

#define IDD_CTRLTXTDATE         258
#define IDD_CTRLTXTYEAR         259
#define IDD_CTRLTXTMONTH        260
#define IDD_CTRLTXTDAY          261
#define IDD_CTRLTXTWKDAY        262
#define IDD_CTRLTXTTIME         263
#define IDD_CTRLTXTHOURS        264
#define IDD_CTRLTXTMINS         265
#define IDD_CTRLTXTSECS         266
#define IDD_CTRLTXTPLAIN        267

#define IDD_CTRLTXTDLIST        268
#define IDD_CTRLTXTTLIST        269
#define IDD_CTRLTXTORDAY        270

#define IDD_CTRLTXTFILE         271
#define IDD_CTRLTXTPATH         272

#define IDD_CTRLTXTLANG         273
#define IDD_CTRLTXTLANGEN       274

#define IDD_DEFTABSDLG          278
#define IDD_DEFTABSENTRY        279

#define IDD_HYPHOPTDLG 			280 	/*** Hyph Options Dlg  ***/
#define IDD_HYPHOPTNONE			281
#define IDD_HYPHOPTGENERIC		282

#define IDD_GTITLEDLG           290
#define IDD_GTITLESPIN          291
#define IDD_GTITLEPAGEENTRY     292
#define IDD_GTITLEPAGEFRONT     293
#define IDD_GTITLEPAGEBACK      294
#define IDD_GTITLENOPAGE        295
#define IDD_GTITLEINDENT        296
#define IDD_GTITLENOINDENT      297
#define IDD_GTITLESTYLE1        300
#define IDD_GTITLESTYLE2        301
#define IDD_GTITLESTYLE3        302
#define IDD_GTITLESTYLE4        303
#define IDD_GTITLESTYLE5        304
#define IDD_GTITLESTYLE6        305
#define IDD_GTITLESTYLE7        306
#define IDD_GTITLESTYLE8        307

#define IDD_BULLETDLG			310
#define IDD_BULLETDLG1			311
#define IDD_BULLETDLG2			312
#define IDD_BULLETISTAT			313
#define IDD_BULLETNONE			314
#define IDD_BULLETSELECT		315
#define IDD_BULLETDEFLT			316
#define IDD_BULLETSAMPLE		IDD_FONTSAMPLE
#define IDD_BULLETSCROLL		317

#define IDD_FERR_DLG            320
#define IDD_FERR_FUNC           321
#define IDD_FERR_FAMILY         322
#define IDD_FERR_FONT           323
#define IDD_FERR_BTN            324
#define IDD_FERR_SEL            325
#define IDD_FERR_CPG            326
#define IDD_FERR_TYPE           327
#define IDD_FERR_USE            328
#define IDD_FERR_LCID           329
#define IDD_FERR_ERRID          330

#define IDD_LOLLIST             400
#define IDD_LOLLISTBOX          401

#define IDD_SEARCHDLG           500    /*** Search Dialog      ***/
#define IDD_SEARCHFIELD         501    /* Entry Field            */
#define IDD_CHALLBUTTON         502    /* Push Button            */
#define IDD_CASEBUTTON          503    /* Checkbox               */
#define IDD_RVRSBUTTON          504    /* Checkbox               */
#define IDD_CHANGEFIELD         505    /* Entry Field            */
#define IDD_FINDITEM            506    /* Static Text            */
#define IDD_CHANGEITEM          507    /* Static Text            */
#define IDD_FINDBUTTON          508    /* Push Button            */
#define IDD_CHGFNDBUTTON        509    /* Push Button            */
#define IDD_CHANGEBUTTON        510    /* Push Button            */

#define IDD_EXCLUDEDLG          520
#define IDD_EXCLUDEENTRY        521

#define IDD_ORIGIN_DLG          522
#define IDD_ORIGIN_CTRL         523

#define IDD_UPCHAINDLG          530
#define IDD_UPCHAINEDIT         531
#define IDD_UPCHAINLINK         532

#define IDD_DROPSHADOWDLG       540
#define IDD_DROPSROTATECTRL     541
#define IDD_DROPSROTATEENTR     542
#define IDD_DROPSDISTENTRY      543
#define IDD_DROPSENABLE         544
#define IDD_DROPSCOLOR          545
#define IDD_DROPSWHEEL          546
#define IDD_DROPSCOLIST         547
#define IDD_DROPSSPOTS          548

#define IDD_FONTSUBSDLG			600

#define IDD_EMBED_DLG			640
#define IDD_EMBEDNBK          	641

#define IDD_EMBED_DLG1			660
#define IDD_EMBED_DLG2			661
#define IDD_EMBED_DLG3			662

#define IDD_EMBED_OFFS			642
#define IDD_EMBED_SIZE			643
#define IDD_EMBED_DEFSZ			644
#define IDD_EMBED_FIT			645
#define IDD_EMBED_FLOW			646
#define IDD_EMBED_NONE			647

#define IDD_EMBED_LMARG			648
#define IDD_EMBED_RMARG			649
#define IDD_EMBED_TMARG			650
#define IDD_EMBED_BMARG			651

#define IDD_EMBED_BMP			652
#define IDD_EMBED_MET			653
#define IDD_EMBED_FOB			654
#define IDD_EMBED_PASTE			655
#define IDD_EMBED_LOAD			656
#define IDD_EMBED_CATALOG		657

#define IDD_KERNDLG				670
#define IDD_KERNENABLE			671

#define IDD_SELCHARDLG			690
#define IDD_SELCHARLIST			691
#define IDD_SELCHARSCROLL		692
#define IDD_SELCHARSPIN			693

#define IDD_CHARDIRNDLG			700
#define IDD_CHARDIRLEFT			701
#define IDD_CHARDIRRIGHT		702
#define IDD_CHARDIRTOP			703
#define IDD_CHARDIRBOTTOM		704
#define IDD_CHARDIRSTROKEDN		705
#define IDD_CHARDIRSTROKEUP		706

#define IDD_MERGEDLG2			719
#define IDD_MERGEDLG			720
#define IDD_MERGELOAD			721
#define IDD_MERGESAVE			722
#define IDD_MERGECLEAR			723
#define IDD_MERGELIST			724
#define IDD_MERGEINC			725
#define IDD_MERGEINCSZ			726

#define IDD_CODEPAGEDLG			740
#define IDD_CODEPAGENBK			741
#define IDD_CODEPAGE1			742
#define IDD_CODEPAGE2			743
#define IDD_LANGUAGELIST		744
#define IDD_CODEPAGELIST		745
#define IDD_CODEPAGE3			746
#define IDD_CODEPAGEDOS			300
#define IDD_CODEPAGEWIN			301
#define IDD_CODEPAGEGPI			302

#define IDD_POPUPDLG			750
#define IDD_POPUPMSG			751

#define IDD_ARTICLEDLG			760
#define IDD_ARTICLENAME			761
#define IDD_ARTICLAUTH			762
#define IDD_ARTICLDATE			763
#define IDD_ARTICLDEST			764
#define IDD_ARTICLINFO			765

#define IDD_ANCHORDLG			780
#define IDD_ANCHORSTATS			781
#define IDD_ANCHORLEFT			782
#define IDD_ANCHORCENTER		783
#define IDD_ANCHORRIGHT			784
#define IDD_ANCHORMANUAL		785
#define IDD_ANCHORFLOW			786
#define IDD_ANCHORFLUSH			787
#define IDD_ANCHORREMOVE		788
#define IDD_ANCHORCOPY			789

#define IDD_FOOTNOTEDLG			800
#define IDD_FOOTNOTETITLE		801
#define IDD_FOOTNOTEBODY		802

#define IDD_GETFOOTDLG			820
#define IDD_GETFOOTTITLE		821
#define IDD_GETFOOTBODY			822
#define IDD_GETFOOTLST			823
#define IDD_GETFOOTLST2			824
#define IDD_GETFOOTTABS			825
#define IDD_GETFOOTTABBUDDY		826
#define IDD_GETFOOTITTL			827
#define IDD_GETFOOTITXT			828
#define IDD_GETFOOTSELECT		829
#define IDD_GETFOOTCNT			830
#define IDD_GETFOOTUP			831
#define IDD_GETFOOTDOWN			832

#endif
