/*
	WordWrap.cmd
	WordWrap v1.61 (c) 2001,2003 by Don K Eitner

	Reformats text files and reflows them to a line length you specify.
	Also can output as basic HTML for use with web browsers.

	This code is neither supported nor under warranty.  Feel free to
	examine and modify this script for your own purposes.  See the
	included readme.txt for additional information.
*/

/* Initialize Rexx utility functions */
CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs

/* Setup ANSI codes for display properties */
CALL AnsiSetup

/* Set initial global variables */
OutLine = ''
OutFile = ''
Version = 1.61
Template = 'template.html'

/* Get substitutions file from source directory, no current directory */
PARSE SOURCE . . SourceFile
TheDir = Filespec('D', SourceFile)||Filespec('P', SourceFile)
SubsFile = TheDir||'substitute.txt'
SubDelim = ','

/* Find out what the user wants us to do */
PARSE ARG CmdLine
CALL ParseInput

/* Now that we know what the user wants us to do, let's do it */

SELECT
	WHEN Margin < 0 THEN   /* We cannot do this */
		DO
			SAY LRed||'Line length must be a whole number greater than or equal to zero.'||Non
			EXIT
		END
	WHEN Margin = 0 THEN   /* Only reformat, don't wrap lines */
		DO
			CALL Prep
			CALL Reformat
		END
	OTHERWISE   /* Reformat and wrap lines */
		DO
			CALL Prep
			CALL Reformat
			CALL Wrap
		END
END

CALL CleanUp

EXIT


AnsiSetup:

	Esc=d2c(27)d2c(91)

	/* Attributes */
	Hig=Esc'1m'
	Non=Esc'0m'

	/* Foreground Colors */
	Bla=Esc'30m'
	Red=Esc'31m'
	Gre=Esc'32m'
	Bro=Esc'33m'
	Blu=Esc'34m'
	Pur=Esc'35m'
	Tur=Esc'36m'
	Whi=Esc'37m'
	LBla=Hig||Bla
	LRed=Hig||Red
	LGre=Hig||Gre
	LBro=Hig||Bro
	LBlu=Hig||Blu
	LPur=Hig||Pur
	LTur=Hig||Tur
	LWhi=Hig||Whi

	/* Background Colors */
	BBla=Esc'40m'
	BRed=Esc'41m'
	BGre=Esc'42m'
	BBro=Esc'43m'
	BBlu=Esc'44m'
	BCya=Esc'45m'
	BTur=Esc'46m'
	BWhi=Esc'47m'

RETURN


ParseInput:

	IF CmdLine = '' THEN
		CALL GiveHelp

	DO WHILE CmdLine <> ''
		PARSE VAR CmdLine CL1 CmdLine
		IF Left(CL1, 1) = '/' | Left(CL1, 1) = '-' THEN
			DO
				CL1 = Translate(CL1)
				SELECT
					WHEN Substr(CL1, 2) = 'M' THEN   /* set output line length */
						DO
							PARSE VAR CmdLine CL1 CmdLine
							Margin = CL1
							IF (DATATYPE(Margin) <> 'NUM') THEN
								DO
									SAY LRed||'You must provide a line length (in # of characters).'||Non
									EXIT
								END
						END
					WHEN Substr(CL1, 2) = 'F' THEN   /* get output format */
						DO
							PARSE VAR CmdLine CL1 CmdLine
							OutForm = Translate(CL1)
						END
					WHEN Substr(CL1, 2) = 'E' THEN   /* select end-of-line character */
						DO
							PARSE VAR CmdLine CL1 CmdLine
							EOL = Translate(CL1)
						END
					WHEN Substr(CL1, 2) = 'I' THEN   /* get input file name */
						DO
							IF Left(CmdLine, 1) = '"' THEN
								DO
									PARSE VAR CmdLine WITH '"' CL1 '"' CmdLine
									InFile = CL1
								END
							ELSE
								DO
									PARSE VAR CmdLine CL1 CmdLine
									InFile = CL1
								END
						END
					WHEN Substr(CL1, 2) = 'O' THEN   /* get output file name */
						DO
							IF Left(CmdLine, 1) = '"' THEN
								DO
									PARSE VAR CmdLine WITH '"' CL1 '"' CmdLine
									OutFile = CL1
								END
							ELSE
								DO
									PARSE VAR CmdLine CL1 CmdLine
									OutFile = CL1
								END
						END
					WHEN (Substr(CL1, 2) = 'V') | (Substr(CL1, 2) = 'VERSION') THEN   /* show program version */
						DO
							SAY Version
							EXIT
						END
					OTHERWISE
						CALL GiveHelp
				END
			END
		ELSE
			DO
				CALL GiveHelp
				EXIT
			END
	END

	IF Datatype(Margin) <> 'NUM' THEN
		Margin = 0

	SELECT
		WHEN EOL = 'UNIX' | EOL = 'LF' | EOL = '0A' THEN
			DO
				EOL2 = 'UNIX'
				EOL = '0a'x
			END
		WHEN EOL = 'DOS' | EOL = 'CRLF' | EOL = '0D0A' THEN
			DO
				EOL2 = 'DOS'
				EOL = '0d0a'x
			END
		WHEN EOL = 'MAC' | EOL = 'CR' | EOL = '0D' THEN
			DO
				EOL2 = 'MAC'
				EOL = '0d'x
			END
		OTHERWISE
			EOL = '0d0a'x
	END

RETURN


GiveHelp:

	CALL SysCls
	SAY LTur||'WordWrap' Version '(c) 2003 by Don Eitner'||Non
	SAY
	SAY LGre||'Usage:'||Non
	SAY 'WordWrapPM is a graphical front-end which is invoked by double clicking its'
	SAY 'icon on the desktop or by typing: WordWrapPM'
	SAY
	SAY 'WordWrap is a command line program which is invoked by typing:'
	SAY '  WordWrap -I InFile [-O OutFile] [-M Margin] [options]'
	SAY
	SAY 'InFile and OutFile must be enclosed with quotation marks if the filenames'
	SAY 'contain spaces.'
	SAY
	SAY 'Margin must be an integer.  Margin of 0 creates single-line paragraphs with no'
	SAY 'word wrapping; good for importing to a word processor program.'
	SAY
	SAY LGre||'Available Options:'||Non
	SAY '  -F = specify output format as TEXT (default) or HTML'
	SAY '  -E = specify output type as DOS (default), UNIX or Macintosh'
	SAY '       To output for OS/2, DOS or Win, use /E DOS or /E CRLF or /E 0d0a'
	SAY '       To output for UNIX, use /E UNIX or /E LF or /E 0a'
	SAY '       To output for Macintosh, use /E MAC or /E CR or /E 0d'
	SAY '  -V = show wordwrap version'
	SAY '  -? = show this help screen'

EXIT


Prep:

	/* Prepare work files */
	X = Lastpos('.', InFile)
	IF X > 0 THEN
		DO
			TempFile = SysTempFileName(Substr(InFile, 1, X-1)||'.???', '?')
               say 'tempfile will be:' TempFile
			IF OutFile = '' THEN
				OutFile = Substr(InFile, 1, X-1)||'.out'
		END
	ELSE
		DO
			TempFile = SysTempFileName(InFile||'.???', '?')
               say 'tempfile will be:' TempFile
			IF OutFile = '' THEN
				OutFile = InFile||'.out'
		END

	/* Delete temporary file if it exists so we don't keep any old junk */
	rc = Stream(TempFile, 'c', 'QUERY EXISTS')
	IF rc <> '' THEN
		CALL SysFileDelete TempFile

	/* Backup original file to temporary directory for safety, be sure it exists first */
	rc = Stream(InFile, 'c', 'QUERY EXISTS')
	IF rc = '' THEN
		DO
			SAY LRed||'Input file'||Non InFile LRed||'was not found.'||Non
			EXIT
		END
	ELSE
		DO
			SAY LBlu||'*' LTur||'Backing up' LBro||InFile LTur||'to /temp directory'||Non
			CALL SysMkDir 'temp'
			'@copy "'||InFile||'" temp'
		END

RETURN


Reformat:

	/* Open the input file, report any errors */
	rc = Stream(InFile, 'c', 'OPEN')
	IF rc <> 'READY:' THEN
		DO
			SAY 'Input file cannot be opened. Error was' rc
			EXIT
		END
	ELSE
		/* Remove extraneous spaces from input file and concatenate lines */
		SAY LBlu||'*' LTur||'Reformatting' LBro||InFile LTur||'to' LBro||TempFile||Non

	/* Open the temporary output file, report any errors */
	rc = Stream(TempFile, 'c', 'OPEN')
	IF rc <> 'READY:' THEN
		DO
			SAY 'Temporary file cannot be opened. Error was' rc
			EXIT
		END

	SELECT
		WHEN OutForm = 'HTML' THEN
			DO
				/* work with the template header */
				rc = Stream(Template, 'c', 'QUERY EXISTS')
				IF rc <> '' THEN
					DO
						rc = Stream(Template, 'c', 'OPEN')
						DO WHILE Lines(Template) > 0
							ThisLine = Linein(Template, , 1)
							IF ThisLine = '[OUTPUT]' THEN
								LEAVE
							ThisLine = ThisLine||EOL
							CALL CharOut TempFile, ThisLine
						END
					END
				ELSE
					DO
						HTMLHead = '<html>'||EOL||'<head>'||EOL||'<title>'||OutFile||'</title>'||EOL||'<body>'||EOL||EOL
						CALL CharOut TempFile, HTMLHead
					END
			END
		OTHERWISE
			NOP
	END

	/* Enable character substitution */
	Num = 0
	DO WHILE Lines(SubsFile) > 0
		SubLine = Linein(SubsFile, , 1)
		IF Length(SubLine) > 0 THEN
			DO
				Num = Num + 1
				Sub.Num.1 = Pun(SubLine, SubDelim, 1)
				Sub.Num.1 = Substr(Sub.Num.1, 2, Length(Sub.Num.1)-2)
				Sub.Num.2 = Pun(SubLine, SubDelim, 2)
				Sub.Num.2 = Substr(Sub.Num.2, 2, Length(Sub.Num.2)-2)
			END
	END

	/* Read in the input file line by line */
	DO WHILE Lines(InFile) > 0
		Inline = Linein(InFile,,1)

		/* Perform character substitution */
		DO X = 1 TO Num
			DO FOREVER
				Y = Pos(Sub.X.1, Inline)
				Len = Length(Sub.X.1)
				IF Y > 0 THEN
					DO
						A = Substr(Inline, 1, Y - 1)
						B = Substr(Inline, Y + Len)
						Inline = A||Sub.X.2||B
					END
				ELSE
					LEAVE
			END
		END

		/* If input line already contains basic HTML code, strip it out */
		IF Translate(Left(Inline, 3)) = '<P>' THEN
			Inline = Substr(Inline, 4)

		Inline = Space(Inline)
		OutLine = OutLine||' '||Inline
		DROP Inline

		X = Pos('  ',OutLine)
		IF X > 0 THEN
			DO
				A = Substr(OutLine, 1, X - 1)
				A = Space(A)
				OutLine = Substr(OutLine, X + 2)
				SELECT
					WHEN OutForm = 'HTML' THEN
						A = '<p>'||A||'</p>'||EOL||EOL
					OTHERWISE
						A = A||EOL||EOL
				END
				CALL CharOut TempFile, A
			END
	END

	/* Close the input file */
	rc = Stream(InFile, 'c', 'CLOSE')

	OutLine = Space(OutLine)

	SELECT
		WHEN OutForm = 'HTML' THEN
			DO
				rc = Stream(Template, 'c', 'QUERY EXISTS')
				IF rc <> '' THEN
					DO
						OutLine = '<p>'||OutLine||'</p>'
						/* work with the template footer */
						DO WHILE Lines(Template) > 0
							ThisLine = Linein(Template, , 1)
							ThisLine = ThisLine||EOL
							CALL CharOut TempFile, ThisLine
						END
						rc = Stream(Template, 'c', 'CLOSE')
					END
				ELSE
					DO
						HTMLFoot = EOL||EOL||'</body>'||EOL||'</html>'
						OutLine = '<p>'||OutLine||'</p>'||HTMLFoot
						CALL CharOut TempFile, OutLine
					END
			END
		OTHERWISE
			CALL CharOut TempFile, OutLine
	END

	/* Close the temporary input file */
	rc = Stream(TempFile, 'c', 'CLOSE')

RETURN


Wrap:

	/* Delete output file if it exists so we don't keep any old junk */
	rc = Stream(OutFile, 'c', 'QUERY EXISTS')
	IF rc <> '' THEN
		CALL SysFileDelete OutFile

	/* Open the temporary input file, report any errors */
	rc = Stream(TempFile, 'c', 'OPEN')
	IF rc <> 'READY:' THEN
		DO
			SAY 'Temporary file cannot be opened. Error was' rc
			EXIT
		END

	/* Open the output file, report any errors */
	rc = Stream(OutFile, 'c', 'OPEN')
	IF rc <> 'READY:' THEN
		DO
			SAY 'Output file cannot be opened. Error was' rc
			EXIT
		END

	OutLine = ''

	/* Wrap single line paragraphs to specified margin width */
	SAY LBlu||'*' LTur||'Word wrapping' LBro||TempFile LTur||'to' LBro||OutFile||Non
	DO WHILE Lines(TempFile) > 0
		Inline = Linein(TempFile,,1)
		IF Inline = '' THEN
			ITERATE
		OutLine = ''
		IF Length(Inline) > Margin THEN
			DO
				First = 1
				DO UNTIL First >= Length(Inline)
					A = Substr(Inline, First, Margin + 1)
					Blank = Lastpos(' ', A)
					IF Blank = 0 THEN
						DO
							Inline = Inline||' '
							Blank = Pos(' ', Inline, First) - First + 1
						END
					Last = Blank - 1
					A = Substr(Inline, First, Last)
					A = Space(A)
					OutLine = OutLine||A||EOL
					First = First + Blank
				END
				OutLine = OutLine||EOL
			END
		ELSE
			OutLine = OutLine||InLine||EOL||EOL
		CALL CharOut OutFile, OutLine
	END

	/* Close the temporary input file */
	rc = Stream(TempFile, 'c', 'CLOSE')

	/* Close the output file */
	rc = Stream(OutFile, 'c', 'CLOSE')

RETURN


CleanUp:

	/* Clean up after ourselves */
	IF \ (Margin > 0) THEN
		DO
			SAY LBlu||'*' LTur||'Renaming' LBro||TempFile LTur||'to' LBro||OutFile||Non
			CALL SysFileDelete OutFile
			'@ren "'||TempFile||'" "'||OutFile||'"'
		END
	ELSE
		DO
			SAY LBlu||'*' LTur||'Cleaning up directory'||Non
			CALL SysFileDelete TempFile
		END

RETURN


Puns: Procedure

	PARSE ARG String, Delim
	CALL Split String, Delim

RETURN Substring.0


Pun: Procedure

	PARSE ARG String, Delim, Word
	CALL Split String, Delim

RETURN Substring.Word


Delpun: Procedure

	PARSE ARG String, Delim, Word, Length
	CALL Split String, Delim
	DO X = Word TO (Word - 1 + Length)
		Substring.X = ''
	END
	DO Y = 1 TO Substring.0
		IF Substring.Y = '' THEN
			ITERATE
		IF String = '' THEN
			String = Substring.Y
		ELSE
			String = String||Delim||Substring.Y
	END

RETURN String


Split:

	PARSE ARG String, Delim
	Num = 0
	DO WHILE String <> ''
		Num = Num + 1
		Stop = Pos(Delim, String)
		IF Stop = 0 THEN
			Stop = Length(String)+1
		Substring.Num = Substr(String, 1, Stop-1)
		String = Substr(String, Stop+1)
	END
	Substring.0 = Num

	IF Delim = ',' | Delim = ';' | Delim = ':' THEN
		DO X = 1 TO Substring.0
			Substring.X = Strip(Substring.X,b,'"')
		END

RETURN

