/*  rexx-program generating a Write&Set folder and
    program objects with Wordstar file association,
    pointing to WSformat and WSedit
    Author: Martin Vieregg, Germany, 12/2002, 6/2003, 1/2005
*/

Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
Call SysLoadFuncs

CurrentDir = directory()

say "German language (press Y or N and then ENTER) "
say "Deutsche Sprache (drcken Sie J oder N und EINGABETASTE) "
pull YesNo
if  ((YesNo = "Y") | (YesNo = "y") | (YesNo = "J") | (YesNo = "j") ) then 
  German = TRUE
else
  German = FALSE

rc = SysOpenObject("<WSAssocFolder>", ICON, TRUE)

if (rc = 1) then DO
  if (German = TRUE) then DO
    say "Der Programmordner Write&Set ist schon vorhanden."
    say "Sollen die Write&Set Objekte gelscht werden ? (drcken Sie J oder N) "
  END
  else DO
    say "The Write&Set association folder already exists."
    say "Do you want to delete all these WPS Objects ? (press Y or N) "
  END
  pull Contin
  if  ((Contin = "N") | (Contin = "n")) then EXIT

if (German = TRUE) then 
"del deutsch.txt"
else
"del english.txt"  
  Call Destroy "<WSreadmeShadow>"
  Call Destroy "<WSwsformatShadow>"
  Call Destroy "<WSwsformatHelp>"
  Call Destroy "<WSwseditHelp>"
  Call Destroy "<WSlessonsShadow>"
  Call Destroy "<WSwsformat>"
  Call Destroy "<WSwseditform>"
  Call Destroy "<WSwseditunform>"
  Call Destroy "<WSwsedit>"
  Call Destroy "<WSFolderShadow>"
  Call Destroy "<WSTemplateShadow>"
  Call Destroy "<WSAssocFolder>"
  "@pause"
  exit
END

if (German = TRUE) then DO
  say "Geben Sie bitte das WSformat Verzeichnis ein"
  say "oder EINGABETASTE wenn Verzeichnis "CurrentDir"\WSformat"
END
ELSE DO
  say "Please enter the WSformat directory"
  say "or RETURN if the directory is "CurrentDir"\WSformat"
END
pull WSformatDir
if (WSformatDir = "") then
  WSformatDir = CurrentDir"\WSformat"
if (German = TRUE) then DO
  say "Geben Sie bitte das WSedit Verzeichnis ein"
  say "oder EINGABETASTE wenn Verzeichnis "CurrentDir"\WSedit"
END
ELSE DO
  say "Please enter the WSedit directory"
  say "or RETURN if the directory is "CurrentDir"\WSedit"
END
pull WSeditDir
if (WSeditDir = "") then
  WSeditDir = CurrentDir"\WSedit"
say
if (German = TRUE) then 
  say "Das WSedit Verzeichnis lautet:"
else
  say "The WSedit executable file is:"
"@dir "WSeditDir"\WSedit.exe /f"
if (German = TRUE) then 
  say "Das WSformat Verzeichnis lautet:"
else
  say "The WSformat executable file is:"
"@dir "WSformatDir"\WSformat.exe /f"

if (German = TRUE) then DO


Call SysCreateObject "WPFolder", "Write&Set", "<WP_DESKTOP>",,
"OBJECTID=<WSAssocFolder>;;"

Call SysCreateObject "WPProgram", "WSedit unformatiert", "<WSAssocFolder>",,
"OBJECTID=<WSwseditunform>;EXENAME="WSeditDir"\WSedit.EXE;ICONFILE="CurrentDir"\InstData\WSedit.ICO;ASSOCFILTER=*.WS;"

Call SysCreateObject "WPProgram", "WSedit", "<WP_DESKTOP>",,
"OBJECTID=<WSwsedit>;EXENAME="WSeditDir"\WSedit.EXE;ICONFILE="CurrentDir"\InstData\WSedit.ICO;STARTUPDIR="CurrentDir";"

Call SysCreateObject "WPProgram", "WSedit formatiert", "<WSAssocFolder>",,
"OBJECTID=<WSwseditform>;EXENAME="WSeditDir"\WSedit.EXE;ICONFILE="CurrentDir"\InstData\formated.ICO;ASSOCFILTER=*.FMT,*.FUN,*.TOC,*.TAF;"

Call SysCreateObject "WPProgram", "WSformat", "<WSAssocFolder>",,
"OBJECTID=<WSwsformat>;EXENAME="WSformatDir"\WSformat.EXE;ICONFILE="CurrentDir"\InstData\WSformat.ICO;ASSOCFILTER=*.WS,*.TXT;STARTUPDIR="CurrentDir";"

Call SysCreateObject "WPShadow", "WSformat", "<WP_DESKTOP>",,
"OBJECTID=<WSwsformatShadow>;SHADOWID=<WSwsformat>;"

Call SysCreateObject "WPShadow", "liesmich.txt", "<WSAssocFolder>",,
"OBJECTID=<WSreadmeShadow>;SHADOWID="CurrentDir"\liesmich.txt;"

Call SysCreateObject "WPProgram", "WSedit Hilfe", "<WSAssocFolder>",,
"OBJECTID=<WSwseditHelp>;EXENAME=VIEW.EXE;PARAMETERS="WSeditDir"\wsedit-g.hlp;"

Call SysCreateObject "WPProgram", "WSformat Hilfe", "<WSAssocFolder>",,
"OBJECTID=<WSwsformatHelp>;EXENAME=VIEW.EXE;PARAMETERS="WSformatDir"\wsfdoc-g.hlp;"

Call SysCreateObject "WPShadow", "Tutorial", "<WSAssocFolder>",,
"OBJECTID=<WSlessonsShadow>;SHADOWID="CurrentDir"\Tutorial_Deutsch;"

Call SysCreateObject "WPShadow", "Programm-Ordner", "<WSAssocFolder>",,
"OBJECTID=<WSFolderShadow>;SHADOWID="CurrentDir";"

Call SysCreateObject "WPShadow", "Vorlagen-Ordner", "<WSAssocFolder>",,
"OBJECTID=<WSTemplateShadow>;SHADOWID="CurrentDir"\Template_Deutsch;"

"copy InstData\Deutsch.txt"

END
ELSE DO

Call SysCreateObject "WPFolder", "Write&Set", "<WP_DESKTOP>",,
"OBJECTID=<WSAssocFolder>;;"

Call SysCreateObject "WPProgram", "WSedit unformatted", "<WSAssocFolder>",,
"OBJECTID=<WSwseditunform>;EXENAME="WSeditDir"\WSedit.EXE;ICONFILE="CurrentDir"\InstData\WSedit.ICO;ASSOCFILTER=*.WS;"

Call SysCreateObject "WPProgram", "WSedit formatted", "<WSAssocFolder>",,
"OBJECTID=<WSwseditform>;EXENAME="WSeditDir"\WSedit.EXE;ICONFILE="CurrentDir"\InstData\formated.ICO;ASSOCFILTER=*.FMT,*.FUN,*.TOC,*.TAF;"

Call SysCreateObject "WPProgram", "WSedit", "<WP_DESKTOP>",,
"OBJECTID=<WSwsedit>;EXENAME="WSeditDir"\WSedit.EXE;ICONFILE="CurrentDir"\InstData\WSedit.ICO;STARTUPDIR="CurrentDir";"

Call SysCreateObject "WPProgram", "WSformat", "<WSAssocFolder>",,
"OBJECTID=<WSwsformat>;EXENAME="WSformatDir"\WSformat.EXE;ICONFILE="CurrentDir"\InstData\WSformat.ICO;ASSOCFILTER=*.WS,*.TXT;"

Call SysCreateObject "WPShadow", "WSformat", "<WP_DESKTOP>",,
"OBJECTID=<WSwsformatShadow>;SHADOWID=<WSwsformat>;STARTUPDIR="CurrentDir";"

Call SysCreateObject "WPShadow", "readme.txt", "<WSAssocFolder>",,
"OBJECTID=<WSreadmeShadow>;SHADOWID="CurrentDir"\readme.txt;"

Call SysCreateObject "WPProgram", "WSedit Help", "<WSAssocFolder>",,
"OBJECTID=<WSwseditHelp>;EXENAME=VIEW.EXE;PARAMETERS="WSeditDir"\wsedit-e.hlp;"

Call SysCreateObject "WPProgram", "WSformat Help", "<WSAssocFolder>",,
"OBJECTID=<WSwsformatHelp>;EXENAME=VIEW.EXE;PARAMETERS="WSformatDir"\wsfdoc-g.hlp;"

Call SysCreateObject "WPShadow", "Tutorial", "<WSAssocFolder>",,
"OBJECTID=<WSlessonsShadow>;SHADOWID="CurrentDir"\Tutorial_English;"

Call SysCreateObject "WPShadow", "Program Folder", "<WSAssocFolder>",,
"OBJECTID=<WSFolderShadow>;SHADOWID="CurrentDir";"

Call SysCreateObject "WPShadow", "Template Folder", "<WSAssocFolder>",,
"OBJECTID=<WSTemplateShadow>;SHADOWID="CurrentDir"\Template_English;"

"copy InstData\English.txt"

END


Call SysOpenObject "<WSAssocFolder>", ICON, TRUE

"pause"

exit

Destroy:
if SysDestroyObject(ARG(1)) then DO
  if (German = TRUE) then DO
    say "lschen von "ARG(1)" OK"
  END
  else DO
    say "deleting "ARG(1)" OK"
  END
END
else DO
  if (German = TRUE) then DO
    say "lschen von "ARG(1)" fehlgeschlagen"
  END
  else DO
    say "deleting "ARG(1)" failed"
  END
END
return
