/****
   REXX   O2.CMD [XYOS2SHL.ZIP]  R.J.Holmgren  6/3/96
   Start OS/2 [DOS|WIN3x] process from XyWrite

   Non-STARTOS2 command line switches:
   /E                       Turn ECHO ON during execution
   /H                       Halt before exiting shell
   /L:launch_process_title  optional "title" of process|object Launched
   /L:"launch proc title"     ditto
   /P:exit_process_title    On-the-fly "ExitProc" definition for PMSW.EXE
   /P:"exit process title"    ditto
   /R                       Execute as REXX script, not batch commands
****/

                              /* Load RexxUtil */
if RxFuncQuery("SysLoadFuncs") then do
  call RxFuncAdd "SysLoadFuncs","RexxUtil","SysLoadFuncs"
  call SysLoadFuncs
  end

                              /* Set|Verify filenames */
BootDrive=''
if length(BootDrive)=0 then call Help
IniFile=BootDrive||':\OS2\MDOS\O2.INI'
SwitchFile=BootDrive||':\OS2\MDOS\PMSW.EXE'
currdir=directory()

linein(IniFile,1,0)           /* (Re)Set Read/Write Position */
if lines(IniFile)=0 then call Help

args=linein(IniFile)          /* Read O2.INI */
ucargs=translate(args)
Command=linein(IniFile)

x=stream(IniFile,'C','close') /* Destroy O2.INI */

                              /* Read user input (O2 args) */
hold=0; if pos('/H',ucargs)>0 then hold=1

if pos('/E',ucargs)>0 then '@echo on'
else '@echo off'

rexxon=0; if pos('/R',ucargs)>0 then rexxon=1

backon=0; if pos('/B',ucargs)>0 then backon=1

exitprocon=1; if pos('/O',ucargs)>0 then exitprocon=0

ObjProc=''
x=pos('/L:',ucargs)
if x>0 then do
  x1=pos('/L:"',ucargs)
  if x=x1 then do
    ObjProc=substr(args,x+4)
    x=pos('"',ObjProc)
    end
  else do
    ObjProc=substr(args,x+3)
    x=pos(' ',ObjProc)
    end
  if x>0 then ObjProc=substr(ObjProc,1,x-1)
  end

ExitProc=''
x=pos('/P:',ucargs)
if x>0 then do
  x1=pos('/P:"',ucargs)
  if x=x1 then do
    ExitProc=substr(args,x+4)
    x=pos('"',ExitProc)
    end
  else do
    ExitProc=substr(args,x+3)
    x=pos(' ',ExitProc)
    end
  if x>0 then ExitProc=substr(ExitProc,1,x-1)
  end

quot=""""
dr=''
dirs=''
dirs1=''
fn=''
pause=1

Command=strip(Command)        /* Strip leading+trailing spaces */
TmpCmnd=Command

x=pos('CALL ',translate(TmpCmnd))  /* Get drive/dir/filename of Command */
if x=1 then TmpCmnd=substr(TmpCmnd,x+5)
x=pos(' ',TmpCmnd)
if x>0 then TmpCmnd=substr(TmpCmnd,1,x-1)
if TmpCmnd='' then call Help

object=0                      /* Is "Command" an <objectID>? 0=No 1=Yes */
x=pos('<',TmpCmnd)
x1=pos('>',TmpCmnd)
if x=1&x1=length(TmpCmnd) then object=1

if object=0 then do           /* Set drive/dir/filename if command */
  verify=stream(TmpCmnd,'C','query exists')
  if Verify\='' then do
    dr=filespec("drive",TmpCmnd)
    dirs=filespec("path",TmpCmnd)
    dirs1=dirs
    if length(dirs)>1 then dirs1=left(dirs,length(dirs)-1)
    fn=filespec("name",TmpCmnd)
    end
  end

if object=1 then do           /* Open object */
  rc=SysSetObjectData(TmpCmnd,"OPEN=DEFAULT")  /* Open object */

  if rc=1 then do
    if ObjProc=''&backon=0&exitprocon=0 then do
      call SysSetObjectData TmpCmnd,"OPEN=DEFAULT" /* Try(!) to get Focus*/
      call SysFileDelete IniFile
      exit
      end
    end
  else do
    say "Open failed:  "||TmpCmnd              /* If OPEN failed */
    say "Hit key to quit..."
    call SysGetKey 'noecho'
    pause=2
    end
  end

if object=0 then do           /* Execute command */
  if dr\='' then dr
  if dirs1\='' then 'cd' dirs1
  rc=0
  if rexxon=1&fn\=RUNCMD.CMD then do
    interpret Command         /* If Rexx */
    end
  else Command                /* Otherwise */
  if rc>1&rc\=255 then do
    say
    say '	Exit code: '||fn
    call charout ,'	>>RC='||rc||'<<	Hit any key to continue . . . '
    call SysGetKey 'noecho'
    pause=2
    say
    say
    end
  if fn=RUNCMD.CMD then call SysFileDelete TmpCmnd
  end

if ObjProc\=''&backon=0 then do
  SwitchFile' *'ObjProc'*'    /*Get Focus*/
  call SysSleep 1
  SwitchFile' *'ObjProc'*'    /*Some PMs need extra loadtime */
    say 'Focusing on "*'ObjProc'*"; Ctrl-C aborts...'
    do forever
      call SysSleep 1
      SwitchFile' *'ObjProc'* /R'   /* Is app "focus-able"? */
      if rc\=1 then leave
      end
  end

call callit
call SysFileDelete IniFile
exit

return

HELP:
  say
  say 'O2.CMD [XYOS2SHL.ZIP]  R.J.Holmgren  6/3/96'
  say 'Execute|Open OS/2 commands|objects from XyWrite Word Processor'
  say
  say 'Run INSTALL.CMD to install Xy-OS/2 Shell.'
  say 'O2.CMD is initiated by XPL (U2) program "O2.PM";'
  say '  O2.CMD is !NOT! run directly from the OS/2 command line.'
  exit
RETURN

CALLIT:
x1=pos('/C',ucargs)
if hold=1&pause=1&object=0 then call HoldOn         /* Don't pause twice */
if ExitProc\='' then 'call '||BootDrive||':\OS2\MDOS\SW.CMD '||ExitProc
if x1=0&object=0 then call directory currdir
RETURN

HOLDON:
  call charout ,'-- Hit any key to SWitch to 'quot||ExitProc||quot
  if x1>0 then call charout ,' (and kill this process)'
  call charout ,' --'
  call SysGetKey 'noecho'
RETURN

