/********************************************************************/

/*                                                                  */

/* (C) Copyright IBM UK Ltd. 1996                                   */

/*                                                                  */

/* PDUMP - Example of DosDumpProcess usage.                         */

/*                                                                  */

/* Force a process dump of the current process.                     */

/* Richard Moore 14th Februrary                                     */

/* Version 1.0                                                      */

/*                                                                  */

/* Syntax PDUMP                                                     */

/*                                                                  */

/*                                                                  */

/********************************************************************/





#define INCL_DOSMISC  



#include <os2.h>

#include <conio.h>

#include <stdio.h>

#include <string.h>

#include <stdlib.h>

#include "apis.h"          /* include this if not using the toolkit for Warp E-Server */



/*************************************************************************************/

/*                                                                                   */

/* Purpose:                                                                          */

/*                                                                                   */

/* DosDumpProcess initiates a process dump from a specified process. This may be used*/

/* as part an error handling routine to gather information about an error that may   */

/* be analysed later, using the OS2 System Dump Formatter.                           */

/*                                                                                   */

/* Configuration of Process Dump may be done using the PDUMPSYS, PDUMPUSR and        */

/* PROCDUMP commands.                                                                */

/*                                                                                   */

/*************************************************************************************/



/*************************************************************************************/

/*                                                                                   */

/*                       Prototype definition for DosDumpProcess                     */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/*     APIRET  APIENTRY DosDumpProcess(ULONG Flag, ULONG Drive, PID Pid);            */

/*                                                                                   */

/*************************************************************************************/



/*************************************************************************************/

/*                                                                                   */

/*                       Parameters to DosDumpProcess                                */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/* Flag: Specifies the function to be performed;                                     */

/*       DDP_DISABLEPROCDUMP     0x00000000L        disable process dumps            */

/*       DDP_ENABLEPROCDUMP      0x00000001L        enable process dumps             */

/*       DDP_PERFORMPROCDUMP     0x00000002L        perform process dump             */

/*                                                                                   */

/* Drive: The ASCII character for the drive on which process dump files are to be    */

/*        created. This is required only with with DDP_ENABLEPROCDUMP.               */

/*        Note: Use the PROCDUMP command to fully customise the drive and path.      */

/*                                                                                   */

/* Pid: The process to be dumpped. 0L specified the current process, otherwise a     */

/*      a valid process id must be specified.                                        */

/*      Note: use the PDUMPUSR command to specify what information will be dumpped.  */

/*      Use the PROCDUMP SET command to customise options per process and in         */

/*      particulary to specify whether child or parent process will be dumped.       */

/*      This parameter is only actioned with DDP_PERFORMPROCDUMP.                    */

/*                                                                                   */

/*************************************************************************************/



/*************************************************************************************/

/*                                                                                   */

/* DosDumpProcess returns the following return codes:                                */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/* 87      ERROR_INVALID_PARAMETER                                                   */

/*                                                                                   */

/*************************************************************************************/



/*************************************************************************************/

/*                                                                                   */

/* Remarks.                                                                          */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/* For maximum flexibility the use of DosDumpProcess should be limited to the        */

/* DDP_PERFORMPROCDUMP function. This allows the user to specify whether Process     */

/* Dump should be enabled through use of the PROCDUMP command.                       */

/*                                                                                   */

/* The use may customise Process Dump competely though use of the PDUMPUSR, PDUMPSYS */

/* and PROCDUMP commands. For further information see PROCDUMP.DOC in the            */

/* OS2\SYSTEM\RAS directory.                                                         */

/*                                                                                   */

/* Note: Process dump has been greatly enhanced from Warp 3 fix pack 35 and Warp 4   */

/* fix pack 10.                                                                      */

/*                                                                                   */

/*************************************************************************************/



int main (int argc, char *argv[], char *envp[])

{



   APIRET rc;



   /* Take a process dump - leave drive specification as specified by the user in the     */

   /* PROCDUMP command. If the user has not enabled process dump using PROCDUMP ON then   */

   /* ERROR_INVALID_PARAMETER is returned.                                                */





   rc=DosDumpProcess(DDP_PERFORMPROCDUMP,0L,0L);

   if (rc!=0) {

      printf("DosDumpProcess returned:%u\n",rc);

      return rc;

   } /* endif */



   return 0;



}



