/* An example of a Modal Design. It creates a Main Window, and then a
   Child Dialog. Since the Child is MODAL and we specify that window to
   RXDLG when doing an Operation with user interaction, then the user
   is limited to interacting with that window until RXDLG returns.
*/

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE

/* =============== Create "Main Window" ================= */
/* First Group is RADIO */
RXTYPE.1 = 'RADIO'

/* Use of a control in this group causes RXDLG to return. Also let RXDLG
    label the controls with numbers */
RXFLAGS.1 = 'END|NUMBERED'

/* Only need to specify Groupbox (or null string if none) because of NUMBERED */
RXLABEL.1 = 'Pick one'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '16 4 0'

/* Initially select button 1 */
RXVAL.1 = '1'

/* Position */
RXX.1 = 7
RXY.1 = 6

/* Default size and position (also gives us sizing and max button) */
RXWIN1 = ''

RXDLG 1 '"Main Window"' 'RXWIN1' 'RESULT'




/* ================== Create "Child 1" dialog ================== */
/* First Group is PUSH */
RXTYPE.1 = 'PUSH'

/* Use of a control in this group causes RXDLG to return */
RXFLAGS.1 = 'END'

/* Labels for each button, and Groupbox */
RXLABEL.1 = 'One|Two|Three|Four|Choices'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '4 2 0'

/* Default choice for PushButton is nothing */
RXVAL.1 = ''

/* Position */
RXX.1 = 7
RXY.1 = 6

RXWIN2 = '190 108 8 8'

/* Set MODAL, so when we wake up, it will be this window that caused
   RXDLG to return (ie, Main window will not have been allowed to be used) */
RXDLG 1 '"Child 1"' 'RXWIN2' 'MODAL|RESULT'

/* Do user interaction. Because we specified a window, and its MODAL,
   the user is limited to interacting with this window */
RXDLG '"Child 1"' /* No Operation means Operation 0 */

/* RXWIND now specifies which window woke us up. Because we specified MODAL,
   then it must have been "Child 1" which caused RXDLG to return. The window
   is no longer there because we didn't specify NOCLOSE for Child 1 */
RXSAY '"'RXWIND'" woke us up.'

/* Did user press ESC or click on the CLOSE ICON? Note that we haven't set
    the KEYS flag of any window, so we don't need to check for particular
    negative values of RXID because the only 2 we ever receive here are
    for the ESC key and CLOSE ICON */
IF RXID < 0 THEN DO
   RXSAY '"'RXWIND'" aborted.'
END

/* Did user press the ENTER key while the window had the focus?
   Note that we haven't setup a timeout, nor set the KEYS flag
   of any window, so we don't need to check RXSUBID. It's always
   going to be 10 (ie, ENTER) here if RXID is 0 */
IF RXID = 0 THEN DO
   RXSAY 'Pressed ENTER on "'RXWIND'".'
END

/* If RXID is greater than 0, then this is the Group #, and RXSUBID is the
   Control # (within that group), of the control that caused RXDLG to
   return. NOTE: The first control within the first group (for this dialog) has a
  Group # and Control # of 1 */
IF RXID > 0 THEN DO
    RXSAY 'Group #'RXID', Control #'RXSUBID' ended "'RXWIND'" dialog.'
END

/* At this point, we could call RXDLG with no parameters to let the user
   interact with Main Window. But let's just end */
EXIT


/* ========================== Done ========================== */

FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
